/*
Copyright (C) 2007-2018 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*reads triangles of current model*/
void readmodel(char *numefis){
int i,j1,j2,j3,nrfaces,nvert;
float *x,*y,*z;

readtok(numefis,"f");

nvert=tkgetint();
nrfaces=tkgetint();

if(!(x=(float *)malloc((nvert+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc((nvert+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(z=(float *)malloc((nvert+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}

for(i=1;i<=nvert;i++){
  x[i]=tkgetfloat(); y[i]=tkgetfloat(); z[i]=tkgetfloat();
} /*aflat coordonatele punctelor*/

for(i=0;i<nrfaces;i++){
  tkgetword(); /*sarit peste "f"*/
  j1=tkgetint(); j2=tkgetint(); j3=tkgetint();
  mod3addtri(x[j1],y[j1],z[j1],x[j2],y[j2],z[j2],x[j3],y[j3],z[j3]);
}

free(x);free(y);free(z);
freetok();
}


/*reads colours of triangles*/
void readcolor(char *numefis,float mr,float mg,float mb){
  int j,w,colors,fstart,fend,fred,fgreen,fblue;
  /*fstart, fend - first and last triangle with color(fred,fgreen,fblue)*/

readtok(numefis,"fullbright");

colors=tkgetint();
for(j=0;j<colors;j++){
  fstart=tkgetint(); fend=tkgetint();
  fred=(int)(mr*(float)tkgetint()); fgreen=(int)(mg*(float)tkgetint()); fblue=(int)(mb*(float)tkgetint());
  if(fred>255){fred=255;}
  if(fgreen>255){fgreen=255;}
  if(fblue>255){fblue=255;}
  mod3setcolor(fstart-1,fend-1,fred,fgreen,fblue);
}

w=tkgetword();
if(w==1){ /*fullbright*/
  colors=tkgetint();
  for(j=0;j<colors;j++){
    fstart=tkgetint(); fend=tkgetint();
    mod3setfullbr(fstart-1,fend-1);
  }
}

freetok();
}


/*visibility (backface culling)*/
void readvis(char *numefis){
  int j,w,points,fstart,fend;
  float x,y,z;

readtok(numefis,"v:i");

points=tkgetint();
for(j=0;j<points;j++){
  fstart=tkgetint(); fend=tkgetint();
  w=tkgetword();
  x=tkgetfloat(); y=tkgetfloat(); z=tkgetfloat();
  switch(w){
    case 1: mod3setvis(fstart-1,fend-1,'v',x,y,z); break;
    case 2: mod3setvis(fstart-1,fend-1,'i',x,y,z); break;
    default: break;
  }
}

freetok();
}


/*function which reads the reference points and geom types of an object*/
void readref(objgeom *rep,char *numefis){
  int i,ngeom,s;

readtok(numefis,"box:cyl:sph:trim");

ngeom=tkgetint();
if(ngeom>=(MAXGEOM-1)){printf("File '%s' - too many geoms\r\n",numefis); exit(1);}

rep->nref=2*ngeom; /*number of reference points*/

for(i=0;i<ngeom;i++){
  s=tkgetword();

  switch(s){
    case 1: rep->gtip[i]='b'; /*box*/
      rep->lx[i]=tkgetfloat();
      rep->ly[i]=tkgetfloat();
      rep->lz[i]=tkgetfloat();
      rep->x[2*i]=tkgetfloat();
      rep->y[2*i]=tkgetfloat();
      rep->z[2*i]=tkgetfloat();
      rep->x[2*i+1]=tkgetfloat();
      rep->y[2*i+1]=tkgetfloat();
      rep->z[2*i+1]=tkgetfloat();
      break;

    case 2: rep->gtip[i]='c'; /*cylinder*/
      rep->lx[i]=tkgetfloat(); /*radius*/
      rep->ly[i]=tkgetfloat(); /*length*/
      rep->x[2*i]=tkgetfloat();
      rep->y[2*i]=tkgetfloat();
      rep->z[2*i]=tkgetfloat();
      rep->x[2*i+1]=tkgetfloat();
      rep->y[2*i+1]=tkgetfloat();
      rep->z[2*i+1]=tkgetfloat();
      break;

    case 3: rep->gtip[i]='s'; /*sphere*/
      rep->lx[i]=tkgetfloat(); /*radius*/
      rep->x[2*i]=tkgetfloat();
      rep->y[2*i]=tkgetfloat();
      rep->z[2*i]=tkgetfloat();
      rep->x[2*i+1]=tkgetfloat();
      rep->y[2*i+1]=tkgetfloat();
      rep->z[2*i+1]=tkgetfloat();
      break;

    case 4: rep->gtip[i]='t'; /*triangle mesh*/
      rep->ttip[i]=tkgetint(); /*type*/
      rep->x[2*i]=tkgetfloat();
      rep->y[2*i]=tkgetfloat();
      rep->z[2*i]=tkgetfloat();
      rep->x[2*i+1]=tkgetfloat();
      rep->y[2*i+1]=tkgetfloat();
      rep->z[2*i+1]=tkgetfloat();
      break;

    default: break;
  }
}

freetok();
}


/*function which reads the vehicle; must be called AFTER readtrack()
nrtyp,nrobt - number of object types and objects given by readtrack()*/
gameobj *readvehicle(char *numefis,gameobj *objs,int *nrtyp,int *nrobt,vhc *car){
  char s[32];
  int i,j,k,nto,nob,w; /*number of object types and number of objects*/
  float tx,ty,tz,len; /*initial translations*/

  dMatrix3 rotmt; /*also rotation matrix*/

nto=*nrtyp;
nob=*nrobt;

car->tjflag=0; /*no trailer yet*/

readtok(numefis,"objtypes:objects:power:accel:brake:spring:damper:friction:trjoint:camera:box:cyl:sph");

while((w=tkgetword())){
  switch(w){
    case 1: (*nrtyp)+=tkgetint();
      if(!(refglob=(objgeom *)realloc(refglob,(*nrtyp)*sizeof(objgeom)))){printf("Out of memory\r\n"); exit(1);}
      for(i=nto;i<(*nrtyp);i++){
        tkgetstring(s); /*file with triangles*/
        if(i!=addmod3d()){printf("readvehicle(): wrong model number\r\n"); exit(1);}
        readmodel(s);
        eval_mod(i);
          tkgetstring(s); /*file with colors*/
          readcolor(s,1.0,1.0,1.0);
        tkgetstring(s); /*file with reference points*/
        readref(&refglob[i],s);
          tkgetstring(s); /*file with data for backface culling*/
          readvis(s);
      }
      break;

    case 2: car->nob=tkgetint();
      nob+=car->nob; (*nrobt)=nob;
      if(!(objs=(gameobj *)realloc(objs,nob*sizeof(gameobj)))){printf("Out of memory\r\n"); exit(1);}
      for(i=(nob-car->nob);i<nob;i++){
        objs[i].otyp=nto-1+tkgetint();
        if(objs[i].otyp>=(*nrtyp)){
          printf("readvehicle(): no object type '%d'\r\n",objs[i].otyp+1-nto);exit(1);
        }
        if(i!=addobj3d(objs[i].otyp)){printf("readvehicle(): wrong object number\r\n"); exit(1);}
        objs[i].nref=refglob[objs[i].otyp].nref;
        objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0; /*position*/
        objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
        objs[i].vx[2]=objs[i].vx[3]=0;
        objs[i].vy[1]=objs[i].vy[3]=0;
        objs[i].vz[1]=objs[i].vz[2]=0; /*rotation*/

        k=i-nob+car->nob; /*0...(car->nob - 1)*/
        car->oid[k]=i;
        car->ofc[k]=tkgetint();
        switch(k){
          case 0: if(car->ofc[k]!=1){printf("readvehicle(): '%s' - function of first object must be 1\r\n",numefis); exit(1);}
                  break;
          case 1: if(car->ofc[k]==1){printf("readvehicle(): '%s' - function of 2nd object must not be 1\r\n",numefis); exit(1);}
                  break;
          default: if(car->ofc[k]<=2){printf("readvehicle(): '%s' - function of (>2nd) object must be > 2\r\n",numefis); exit(1);}
                  break;
        }
        /*^object's function; 1-car; 2-trailer; 3,4,5,6-car wheel; 7-trailer wheel*/
        tx=tkgetfloat();
        ty=tkgetfloat();
        tz=tkgetfloat();
        translat(&objs[i],tx,ty,tz);
        /*translated and rotated object; set geometry parameters*/

        for(j=0;j<objs[i].nref;j++){
          objs[i].xref[j]=refglob[objs[i].otyp].x[j];
          objs[i].yref[j]=refglob[objs[i].otyp].y[j];
          objs[i].zref[j]=refglob[objs[i].otyp].z[j];
        }

        for(j=0;j<(objs[i].nref/2);j++){
          switch(refglob[objs[i].otyp].gtip[j]){
            case 'b': objs[i].gid[j]=dCreateBox(0,refglob[objs[i].otyp].lx[j],refglob[objs[i].otyp].ly[j],refglob[objs[i].otyp].lz[j]);
                      break;
            case 'c': objs[i].gid[j]=dCreateCCylinder(0,refglob[objs[i].otyp].lx[j],refglob[objs[i].otyp].ly[j]);
                      break;
            case 's': objs[i].gid[j]=dCreateSphere(0,refglob[objs[i].otyp].lx[j]);
                      break;
            default: printf("Unknown geometry '%c'\r\n",refglob[objs[i].otyp].gtip[j]); exit(1);
          }
        }
        /*^set geometry parameters*/
        car->bid[k]=dBodyCreate(wglob);
        if(car->ofc[k] > 2){dBodySetFiniteRotationMode(car->bid[k],1);} /*for wheels*/
        w=tkgetword();
        switch(w){
          case 11: len=tkgetfloat(); /*mass*/
                   car->mass0[k]=pow(len,0.67);
                   tx=tkgetfloat();
                   ty=tkgetfloat();
                   tz=tkgetfloat(); /*box lengths*/
                   dMassSetBoxTotal(&(car->mass[k]),len,tx,ty,tz);
                   dBodySetMass(car->bid[k],&(car->mass[k]));
                   dBodySetPosition(car->bid[k],objs[i].vx[0],objs[i].vy[0],objs[i].vz[0]);
                   rotmt[0]=1; rotmt[1]=0; rotmt[2]=0; rotmt[3]=0;
                   rotmt[4]=0; rotmt[5]=1; rotmt[6]=0; rotmt[7]=0;
                   rotmt[8]=0; rotmt[9]=0; rotmt[10]=1; rotmt[11]=0;
                   dBodySetRotation(car->bid[k],rotmt);
                   break;
          case 13: len=tkgetfloat(); /*mass*/
                   car->mass0[k]=pow(len,0.67);
                   tx=tkgetfloat(); /*sphere radius*/
                   dMassSetSphereTotal(&(car->mass[k]),len,tx);
                   dBodySetMass(car->bid[k],&(car->mass[k]));
                   dBodySetPosition(car->bid[k],objs[i].vx[0],objs[i].vy[0],objs[i].vz[0]);
                   rotmt[0]=1; rotmt[1]=0; rotmt[2]=0; rotmt[3]=0;
                   rotmt[4]=0; rotmt[5]=1; rotmt[6]=0; rotmt[7]=0;
                   rotmt[8]=0; rotmt[9]=0; rotmt[10]=1; rotmt[11]=0;
                   dBodySetRotation(car->bid[k],rotmt);
                   break;
          default: if(s[0]){printf("Error: '%s' - geometry not recognized\r\n",numefis);exit(1);}
        }
        /*^set mass parameters*/
      }
      break;

    case 3: car->power=tkgetfloat();
            break;

    case 4: car->accel=tkgetfloat();
            break;

    case 5: car->brake=tkgetfloat();
            break;

    case 6: car->spring=tkgetfloat();
            break;

    case 7: car->damper=tkgetfloat();
            break;

    case 8: car->mu=tkgetfloat();
            break;

    case 9: tx=tkgetfloat();
            ty=tkgetfloat();
            tz=tkgetfloat();
            if(car->ofc[1]!=2){printf("Error: '%s' - trailer joint without trailer\r\n",numefis);exit(1);}
            if(car->tjflag==1){printf("Error: '%s' - only one such joint allowed\r\n",numefis);exit(1);}
            car->tjflag=1;
            car->tjid=dJointCreateUniversal(wglob,0);
            dJointAttach(car->tjid,car->bid[0],car->bid[1]);
            dJointSetUniversalAnchor(car->tjid,tx,ty,tz);
            dJointSetUniversalAxis1(car->tjid,1.0,0.0,0.0);
            dJointSetUniversalAxis2(car->tjid,0.0,1.0,0.0);
            dJointSetUniversalParam(car->tjid,dParamLoStop,-2.094);
            dJointSetUniversalParam(car->tjid,dParamHiStop,2.094);
            break;

    case 10: car->camh=tkgetfloat();
             car->camd=tkgetfloat();
             break;

    default: break;
  }
}
freetok();

/*attach geoms to bodies*/
for(i=0;i < car->nob;i++){
  k=car->oid[i];
  for(j=0;j<(objs[k].nref/2);j++){
    dGeomSetBody(objs[k].gid[j],car->bid[i]);
    dGeomSetOffsetPosition(objs[k].gid[j],objs[k].xref[2*j],objs[k].yref[2*j],objs[k].zref[2*j]);
  }
}

/*set joints*/
car->nj=0; /*number of permanent joints*/
for(i=0;i < car->nob;i++){
  if(car->ofc[i] > 2){
    k=0; if(car->ofc[i]==7){k=1;}
    car->jid[car->nj]=dJointCreateHinge2(wglob,0);
    car->bkm[car->nj]=dJointCreateAMotor(wglob,0); /*brake motor*/
    car->jfc[car->nj]=car->ofc[i];
    dJointAttach(car->jid[car->nj],car->bid[k],car->bid[i]);
    dJointAttach(car->bkm[car->nj],car->bid[k],car->bid[i]);
    dJointSetHinge2Anchor(car->jid[car->nj],objs[car->oid[i]].vx[0],objs[car->oid[i]].vy[0],objs[car->oid[i]].vz[0]);
    dJointSetHinge2Axis1(car->jid[car->nj],1,0,0);
    dJointSetHinge2Axis2(car->jid[car->nj],0,1,0);
      dJointSetHinge2Param(car->jid[car->nj],dParamLoStop,-0.001);
      dJointSetHinge2Param(car->jid[car->nj],dParamHiStop,0.001); /*for axis 1*/
    dJointSetAMotorNumAxes(car->bkm[car->nj],1);
    dJointSetAMotorAxis(car->bkm[car->nj],0,2,0,1,0);
    dJointSetAMotorParam(car->bkm[car->nj],dParamVel,0);
    dJointSetAMotorParam(car->bkm[car->nj],dParamFMax,0.01*car->brake);
    (car->nj)++;
  }
}
/*^set joints*/

return objs;
}


dReal vert1glob[12]={0,-12.732,0,0,0,12.5,0.02,0,0,5.10,17.80,0},
      vert2glob[12]={0,12.732,0,0,0,-12.5,0.02,0,0,-5.10,17.80,0},
      vert3glob[12]={0,-25.465,0,0,0,12.5,0.02,0,0,9.61,14.50,0},
      vert4glob[12]={0,25.465,0,0,0,-12.5,0.02,0,0,-9.61,14.50,0};
dTriIndex indexlglob[3]={0,1,2},
          indexrglob[3]={0,2,1}; /*global variables used by the function below*/
dTriMeshDataID tridglob[5];

/*function which reads the track; nrobt - number of objects*/
gameobj *readtrack(char *numefis,int *nrobt,int *nrtyp){
  char s[32]; /*a word*/
  int i,j,w,
    nto=0,nob=0, /*number of object types and number of objects; nob=(*nrobt) */
    bred=130,bgreen=160,bblue=200; /*default background color*/
  gameobj *objs=NULL;
  float tx,ty,tz,rx,ry,rz, /*initial translations and rotations of the object*/
    fred=1.0,fgreen=1.0,fblue=1.0, /*color multiplication factors*/
    ix,jx,kx,
    iy,jy,ky,
    iz,jz,kz, /*rotation matrix (temporary)*/
    len,
    amb=0.5,hd=0.5,dir=0.5,dx=0.5,dy=0.5,dz=0.5;
  dMatrix3 rotmt; /*also rotation matrix*/

tridglob[1]=dGeomTriMeshDataCreate();
tridglob[2]=dGeomTriMeshDataCreate();
tridglob[3]=dGeomTriMeshDataCreate();
tridglob[4]=dGeomTriMeshDataCreate();
dGeomTriMeshDataBuildSimple(tridglob[1],vert1glob,3,indexlglob,3);
dGeomTriMeshDataBuildSimple(tridglob[2],vert2glob,3,indexrglob,3);
dGeomTriMeshDataBuildSimple(tridglob[3],vert3glob,3,indexlglob,3);
dGeomTriMeshDataBuildSimple(tridglob[4],vert4glob,3,indexrglob,3);
/*data for triangle meshes used at curved road elements*/

readtok(numefis,"objtypes:objects:background:clfactors:ambient:headlight:directional:lightdir");

while((w=tkgetword())){
  switch(w){
    case 3: bred=tkgetint(); bgreen=tkgetint(); bblue=tkgetint();
            setbgcolor(bred,bgreen,bblue);
            break;

    case 4: fred=tkgetfloat(); fgreen=tkgetfloat(); fblue=tkgetfloat();
            break;

    case 1: (*nrtyp)=nto=tkgetint();
      if(!(refglob=(objgeom *)malloc((nto)*sizeof(objgeom)))){printf("Out of memory\r\n"); exit(1);}
      for(i=0;i<nto;i++){
        tkgetstring(s); /*file with triangles*/
        if(i!=addmod3d()){printf("readtrack(): wrong model number\r\n"); exit(1);}
        readmodel(s);
        eval_mod(i);
          tkgetstring(s); /*file with colors*/
          readcolor(s,fred,fgreen,fblue);
        tkgetstring(s); /*file with reference points*/
        readref(&refglob[i],s);
          tkgetstring(s); /*file with data for backface culling*/
          readvis(s);
      }
      break;

    case 2: (*nrobt)=nob=tkgetint();
      if(!(objs=(gameobj *)malloc((nob)*sizeof(gameobj)))){printf("Out of memory\r\n"); exit(1);}
      for(i=0;i<nob;i++){
        objs[i].otyp=tkgetint() - 1;
        if(objs[i].otyp>=nto){
          printf("readtrack(): there is no object type '%d'\r\n",objs[i].otyp);exit(1);
        }
        if(i!=addobj3d(objs[i].otyp)){printf("readtrack(): wrong object number\r\n"); exit(1);}
        objs[i].nref=refglob[objs[i].otyp].nref;
        objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0;
        objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
        objs[i].vx[2]=objs[i].vx[3]=0;
        objs[i].vy[1]=objs[i].vy[3]=0;
        objs[i].vz[1]=objs[i].vz[2]=0;
        for(j=0;j<objs[i].nref;j++){
          objs[i].xref[j]=refglob[objs[i].otyp].x[j];
          objs[i].yref[j]=refglob[objs[i].otyp].y[j];
          objs[i].zref[j]=refglob[objs[i].otyp].z[j];
        }
        tx=tkgetfloat();
        ty=tkgetfloat();
        tz=tkgetfloat();
        rz=tkgetfloat();
        ry=tkgetfloat();
        rx=tkgetfloat();
        rotatz(&objs[i],0,0,rz);
        rotaty(&objs[i],0,0,ry);
        rotatx(&objs[i],0,0,rx);
        translat(&objs[i],tx,ty,tz);
        objs[i].cat=tkgetint();
        objs[i].mu=tkgetfloat(); /*friction*/
        /*translated and rotated object; set geometry parameters*/
        for(j=0;j<(objs[i].nref/2);j++){
          switch(refglob[objs[i].otyp].gtip[j]){
            case 'b': objs[i].gid[j]=dCreateBox(0,refglob[objs[i].otyp].lx[j],refglob[objs[i].otyp].ly[j],refglob[objs[i].otyp].lz[j]);
                      break;
            case 'c': objs[i].gid[j]=dCreateCCylinder(0,refglob[objs[i].otyp].lx[j],refglob[objs[i].otyp].ly[j]);
                      break;
            case 's': objs[i].gid[j]=dCreateSphere(0,refglob[objs[i].otyp].lx[j]);
                      break;
            case 't': objs[i].gid[j]=dCreateTriMesh(0,tridglob[refglob[objs[i].otyp].ttip[j]],0,0,0);
                      break;
            default: printf("Unknown geometry '%c'\r\n",refglob[objs[i].otyp].gtip[j]); exit(1);
          }

          dGeomSetPosition(objs[i].gid[j],objs[i].xref[2*j],objs[i].yref[2*j],objs[i].zref[2*j]);
          kx=objs[i].xref[2*j+1]-objs[i].xref[2*j];
          ky=objs[i].yref[2*j+1]-objs[i].yref[2*j];
          kz=objs[i].zref[2*j+1]-objs[i].zref[2*j];
          len=sqrt(kx*kx+ky*ky+kz*kz);
          kx/=len; ky/=len; kz/=len;
          /*beam or column?*/
          len=sqrt(ky*ky+kz*kz); /*(horizontal length)/(length)*/
            if(len<1e-5){ /*column*/
              jx=0; jy=0; jz=-1;
            }
            else{ /*beam*/
              jx=0; jy=kz; jz=-ky;
              len=sqrt(jx*jx+jy*jy+jz*jz);
              jx/=len; jy/=len; jz/=len;
            }
            ix=jy*kz-jz*ky;
            iy=jz*kx-jx*kz;
            iz=jx*ky-jy*kx; /*calculated local system*/
            rotmt[0]=ix; rotmt[1]=jx; rotmt[2]=kx; rotmt[3]=0;
            rotmt[4]=iy; rotmt[5]=jy; rotmt[6]=ky; rotmt[7]=0;
            rotmt[8]=iz; rotmt[9]=jz; rotmt[10]=kz; rotmt[11]=0;
            dGeomSetRotation(objs[i].gid[j],rotmt);
        } /*^set geometry parameters*/
      }
      break;

    case 5: amb=tkgetfloat(); break;

    case 6: hd=tkgetfloat(); break;

    case 7: dir=tkgetfloat(); break;

    case 8: dx=tkgetfloat(); dy=tkgetfloat(); dz=tkgetfloat();
            break;

    default: break;
  }
}
freetok();

len=sqrt(dx*dx+dy*dy+dz*dz);
dx/=len;
dy/=len;
dz/=len; /*normalized light direction*/
setlight3d(amb,hd,dir,dx,dy,dz);

return objs;
}


void setgraph3dobjs(gameobj *objs,int n0,int nob){
  int i;
  float pos[3],rot[9];

for(i=n0;i<nob;i++){
  pos[0]=objs[i].vx[0];
  pos[1]=objs[i].vy[0];
  pos[2]=objs[i].vz[0];
  rot[0]=objs[i].vx[1]-objs[i].vx[0]; rot[1]=objs[i].vx[2]-objs[i].vx[0]; rot[2]=objs[i].vx[3]-objs[i].vx[0];
  rot[3]=objs[i].vy[1]-objs[i].vy[0]; rot[4]=objs[i].vy[2]-objs[i].vy[0]; rot[5]=objs[i].vy[3]-objs[i].vy[0];
  rot[6]=objs[i].vz[1]-objs[i].vz[0]; rot[7]=objs[i].vz[2]-objs[i].vz[0]; rot[8]=objs[i].vz[3]-objs[i].vz[0];
  setobj3dpos(i,pos);
  setobj3drot(i,rot);
}
}
