/*
Copyright (C) 2007-2018 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

typedef struct _objgeom{
  int nref; /*number of reference points*/
  float x[MAXREF];
  float y[MAXREF];
  float z[MAXREF]; /*coordinates of the reference points*/
  char gtip[MAXGEOM]; /*type of geom - 'b', 'c', 's', 't' (box, cylinder, sphere, triangle mesh)*/
  int ttip[MAXGEOM]; /*type of triangle mesh - 1-left 45; 2-right 45; 3-left 22.5; 4-right 22.5*/
  float lx[MAXGEOM]; /*geometry parameters; for cyl. - lx = radius, ly = length;*/
  float ly[MAXGEOM]; /*for sphere - lx = radius; for box - lx = lx, ly = ly, lz = lz.*/
  float lz[MAXGEOM];
} objgeom; /*geometry parameters for an object type <-> 3d model*/


typedef struct _gameobj{
  int otyp; /*number of object type*/
  int nref; /*number of reference points - max. MAXREF*/
  float vx[4];/*directions of local axes in global coordinates - v[1]=i, v[2]=j, v[3]=k*/
  float vy[4];/*and origin of local system, in global coord. - v[0]*/
  float vz[4];
  float xref[MAXREF];
  float yref[MAXREF];
  float zref[MAXREF]; /*coordinates of the reference points in global coordinates*/
  int cat; /*category*/
  dGeomID gid[MAXGEOM]; /*geoms for collision; axis z of geom[i] is defined by
                         (x[i*2-1],y[i*2-1],z[i*2-1]) and (x[i*2],y[i*2],z[i*2])*/
  float mu; /*friction*/
} gameobj; /*3d game object <-> 3d object*/


typedef struct _vhc{
  int nob; /*number of objects in vehicle*/
  int nj; /*number of permanent joints*/
  int ncj; /*number of contact joints*/

  int oid[16]; /*number of object (rendering and collision) in 'objglob'*/
  float mass0[16];
  dMass mass[16];
  dBodyID bid[16];
  dJointID jid[16]; /*permanent joints*/
  dJointID bkm[16]; /*brake motors*/

  int jfc[16]; /*function of object attached to joint (see 'ofc' below)*/
  int ofc[16]; /*object function: 1-car; 2-trailer; 3-motor wheel; 4-steering wheel;
                    5-motor and steering wheel; 6-passive wheel; 7-trailer wheel*/
  dJointID cjid[16]; /*contact joints*/

  short int tjflag; /*0-no trailer joint; 1-trailer joint*/
  dJointID tjid; /*trailer joint*/

  float accel;
  float brake; /*acceleration and brake torques/wheel*/
  float spring;
  float damper; /*suspension coefficients*/
  float mu; /*friction*/
  float power; /*kW*/

  float camh;
  float camd; /*camera position*/
} vhc; /*vehicle*/

objgeom *refglob; /*array with geometry parameters of object types*/
dWorldID wglob; /*world for ODE*/
