/*
Copyright (C) 2013 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "graphics/graphics.h"

#define MAXPOINTS 10000
#define MAXTRI 10000

int npoints=0,ntri=0,*node;
float *x,*y;

void addbranch(int n1,int n2,float d,float tt){
  float x0,y0,xl3,yl3,xl4,yl4,st,ct,s,c,len;
  int n3,n4;
if((n1>=npoints)||(n2>=npoints)){printf("addbranch(); only %d nodes\r\n",npoints); exit(1);}

s=y[n2]-y[n1]; c=x[n2]-x[n1]; len=sqrt(s*s+c*c);
s/=len; c/=len;

st=sin(tt); ct=cos(tt);
xl3=d*ct-0.5f*len*st*st; yl3=d*st+0.5f*len*st*ct;
xl4=d*ct+0.5f*len*st*st; yl4=d*st-0.5f*len*st*ct;

n3=npoints++; n4=npoints++;
x0=0.5f*(x[n1]+x[n2]); y0=0.5f*(y[n1]+y[n2]);
x[n3]=x0+c*xl3-s*yl3; y[n3]=y0+s*xl3+c*yl3;
x[n4]=x0+c*xl4-s*yl4; y[n4]=y0+s*xl4+c*yl4;

node[3*ntri]=n1; node[3*ntri+1]=n2; node[3*ntri+2]=n4; ntri++;
node[3*ntri]=n1; node[3*ntri+1]=n3; node[3*ntri+2]=n4; ntri++;
}

void gtree(int n1,int n2,float d,float tt1,float tt2,float rc,int nb,int lev){
  int i;
  float tt,dtt;

if(lev==0){return;}

dtt=(tt2-tt1)/((float)nb-1.0f);
for(i=0;i<nb;i++){
  tt=tt1+(float)i*dtt;
  addbranch(n1,n2,d,tt);
  gtree(npoints-2,npoints-1,rc*d,tt1,tt2,rc,nb,lev-1);
}
}

int main(){
  int i;
  float pi=3.1415927;

if(!(x=(float *)malloc(MAXPOINTS*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc(MAXPOINTS*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(node=(int *)malloc(3*MAXTRI*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}

initgraph(640,480,0,"tree");

npoints=2;
x[0]=70; y[0]=75; x[1]=75; y[1]=70;

gtree(0,1,100.0,pi*0.35,pi*0.65,0.9,4,5);

for(i=0;i<ntri;i++){
  dlineabs(x[node[3*i]],y[node[3*i]],x[node[3*i+1]],y[node[3*i+1]]);
  dlineabs(x[node[3*i]],y[node[3*i]],x[node[3*i+2]],y[node[3*i+2]]);
  dlineabs(x[node[3*i+1]],y[node[3*i+1]],x[node[3*i+2]],y[node[3*i+2]]);
  display(); pause(5);
}

getch();

closegraph();
free(x); free(y); free(node);
return 0;
}
