/*
Copyright (C) 2013 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define MAXPOINTS 10000
#define MAXTRI 10000

int npoints=0,ntri=0,*node,nbr;
float *x,*y,*z,ttmin,ttmax;


/*initialize random numbers*/
void inrnd(){
  int i,t,r;
t=time(NULL); if(t<0){t=-t;} t=t%16384;
for(i=1;i<=t;i++){r=rand();}
}

float frand01(float min,float max){
  int r;
r=rand(); r%=100000;
return (min+(float)r*1.0e-5f*(max-min));
}


void addbranch(int n1,int n2,float d,float tt){
  float x0,y0,xl3,yl3,xl4,yl4,st,ct,s,c,len;
  int n3,n4;
if((n1>=npoints)||(n2>=npoints)){printf("addbranch(); only %d nodes\r\n",npoints); exit(1);}

s=y[n2]-y[n1]; c=x[n2]-x[n1]; len=sqrt(s*s+c*c);
s/=len; c/=len;

st=sin(tt); ct=cos(tt);
xl3=d*ct-0.5f*len*st*st; yl3=d*st+0.5f*len*st*ct;
xl4=d*ct+0.5f*len*st*st; yl4=d*st-0.5f*len*st*ct;

n3=npoints++; n4=npoints++;
x0=0.5f*(x[n1]+x[n2]); y0=0.5f*(y[n1]+y[n2]);
x[n3]=x0+c*xl3-s*yl3; y[n3]=y0+s*xl3+c*yl3;
x[n4]=x0+c*xl4-s*yl4; y[n4]=y0+s*xl4+c*yl4;

node[3*ntri]=n1; node[3*ntri+1]=n2; node[3*ntri+2]=n4; ntri++;
node[3*ntri]=n1; node[3*ntri+1]=n3; node[3*ntri+2]=n4; ntri++;
}

void gtree(int n1,int n2,float d,float tt1,float tt2,float rc,int nb,int lev){
  int i;
  float tt,dtt;

if(lev==0){return;}

dtt=(tt2-tt1)/((float)nb-1.0f);
tt=tt1;
for(i=0;i<nb;i++){
  addbranch(n1,n2,frand01(0.5*d,d),tt);
  gtree(npoints-2,npoints-1,rc*d,frand01(ttmin,ttmin+0.3*(ttmax-ttmin)),frand01(ttmax-0.3*(ttmax-ttmin),ttmax),0.9,frand01(0.0,1.0)*nbr,lev-1);
  tt+=dtt*frand01(0.5,1.5);
}
}

int main(){
  int i,j,n0,nlev,npl;
  float pi=3.1415927,bd,bw,bh,brl,tt,dtt;
  FILE *f;

if(!(x=(float *)malloc(MAXPOINTS*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc(MAXPOINTS*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(z=(float *)malloc(MAXPOINTS*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(node=(int *)malloc(3*MAXTRI*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}

inrnd();

printf("Number of branches: "); scanf("%d",&nbr);
printf("Number of levels: "); scanf("%d",&nlev);
printf("Min. angle: "); scanf("%f",&ttmin); ttmin*=(pi/180.0);
printf("Max. angle: "); scanf("%f",&ttmax); ttmax*=(pi/180.0);
printf("Base diameter: "); scanf("%f",&bd);
printf("Base height: "); scanf("%f",&bh);
printf("Branch length: "); scanf("%f",&brl);
printf("Branch width: "); scanf("%f",&bw);
printf("Number of planes: "); scanf("%d",&npl);

npoints=4*npl+1; ntri=6*npl;

tt=0.0; dtt=pi/npl;

for(i=0;i<(2*npl);i++){
  x[2*i]=0.5*bd*cos(tt); y[2*i]=0.0; z[2*i]=0.5*bd*sin(tt);
  x[2*i+1]=0.5*bd*cos(tt); y[2*i+1]=bh; z[2*i+1]=0.5*bd*sin(tt);
  tt+=dtt;
}
x[4*npl]=0.0; y[4*npl]=bh+0.5*bd; z[4*npl]=0.0;

for(i=0;i<(2*npl-1);i++){
  node[9*i]=2*i; node[9*i+1]=2*i+2; node[9*i+2]=2*i+3;
  node[9*i+3]=2*i; node[9*i+4]=2*i+1; node[9*i+5]=2*i+3;
  node[9*i+6]=2*i+1; node[9*i+7]=2*i+3; node[9*i+8]=4*npl;
}
node[9*i]=2*i; node[9*i+1]=0; node[9*i+2]=1;
node[9*i+3]=2*i; node[9*i+4]=2*i+1; node[9*i+5]=1;
node[9*i+6]=2*i+1; node[9*i+7]=1; node[9*i+8]=4*npl;

bd=bw;

for(i=0;i<npl;i++){
  n0=npoints;
  x[npoints]=-0.5*bd; y[npoints]=bh; npoints++;
  x[npoints]=0.5*bd; y[npoints]=bh; npoints++;
  gtree(n0,n0+1,brl,ttmin,ttmax,0.9,nbr,nlev);
  for(j=n0;j<npoints;j++){
     z[j]=x[j]*sin(tt);
     x[j]*=cos(tt);
  }
  tt+=dtt;
}

if(!(f=fopen("tree.geo","w"))){printf("Could not open 'tree.geo'\r\n"); exit(1);}
fprintf(f,"%d %d\r\n",npoints,ntri);
for(i=0;i<npoints;i++){
  fprintf(f,"%1.4f %1.4f %1.4f\r\n",y[i],x[i],z[i]);
}
for(i=0;i<ntri;i++){
  fprintf(f,"f %d %d %d\r\n",1+node[3*i],1+node[3*i+1],1+node[3*i+2]);
}
fclose(f);

if(!(f=fopen("tree.col","w"))){printf("Could not open 'tree.col'\r\n"); exit(1);}
fprintf(f,"1\r\n%d %d 120 70 20\r\n",1,ntri);
fclose(f);

if(!(f=fopen("tree.cld","w"))){printf("Could not open 'tree.cld'\r\n"); exit(1);}
fprintf(f,"1\r\n%d %d i %1.1f 0.0 0.0\r\n",1,6*npl,0.5*bh);
fclose(f);

free(x); free(y); free(z); free(node);
return 0;
}
