/*
Copyright (C) 2007-2018 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXTKLEN 32

typedef union _tkvalue{
  char s[MAXTKLEN];
  int ival;
  float fval;
} tkvalue;

typedef struct _tkstr{
  int type; /*0-positive integer,1-word,2-real,3-?*/
  int line;
  tkvalue val;
  struct _tkstr *next;
} tkstr; /*token*/


tkstr **FGLOB_tok,**FGLOB_crtok;
int FGLOB_tkal=-1;
char **FGLOB_crfile,**FGLOB_word;


tkstr *addtkstr(tkstr *tok0){
  tkstr *tok1;
  if(!(tok1=(tkstr *)malloc(sizeof(tkstr)))){printf("addtkstr(): Out of memory\r\n"); exit(1);}
  tok0->next=tok1;
  tok1->next=0;
  return tok1;
}

void freetok(){
  tkstr *tok0,*tok1;
  tok0=FGLOB_tok[FGLOB_tkal]; tok1=tok0->next;
  while(tok1){
    free(tok0); tok0=tok1; tok1=tok0->next;
  } free(tok0);

  free(FGLOB_crfile[FGLOB_tkal]); free(FGLOB_word[FGLOB_tkal]);

  FGLOB_tkal--;

  if(FGLOB_tkal==-1){free(FGLOB_tok); free(FGLOB_crtok); free(FGLOB_crfile); free(FGLOB_word);}
}



/*ret.1 if delimiter,0 if not*/
int chkdel(char c){
  if((c==' ')||(c=='\r')||(c=='\n')||(c=='\t')){return 1;}else{return 0;}
}

/*ret.1 if letter,0 if not*/
int chkletter(char c){
  if(((c>='a')&&(c<='z'))||((c>='A')&&(c<='Z'))){return 1;}else{return 0;}
}

/*ret.1 if digit,0 if not*/
int chkdigit(char c){
  if((c>='0')&&(c<='9')){return 1;}else{return 0;}
}

/*checks for positive integer*/
int chkint(char *s){
  int i=0;
  while(s[i]){
    if(!chkdigit(s[i])){return 0;}
    i++;
  }
  return 1;
}

/*checks for floating point number*/
int chkfloat(char *s){
  int i=0,nrp=0,nre=0,pp=-1,pe=256;
  if(s[i]=='-'){i++;}
  while(s[i]){
    if((!chkdigit(s[i]))&&(s[i]!='.')&&(s[i]!='e')){
      return 0;
    }else{
      if(s[i]=='.'){
        pp=i; nrp++; if(nrp>1){return 0;}
      }else{
        if(s[i]=='e'){
          pe=i; nre++; if(nre>1){return 0;}
          if(s[i+1]=='-'){i++;}
        }
      }
      i++;
    }
  }
  if(pe>pp){return 1;}else{return 0;}
}

int chkword(char *s){
  int i=0;
  while(s[i]){
    if(!chkletter(s[i])){return 0;}
    i++;
  }
  return 1;
}

int readtok(const char *filename,const char *word){
  char a0;
  int i,line;
  tkstr *tok0;
  FILE *f;

if(FGLOB_tkal==-1){
  if(!(FGLOB_tok=(tkstr **)malloc(16*sizeof(tkstr *)))){printf("readtok(): Out of memory\r\n"); exit(1);}
  if(!(FGLOB_crtok=(tkstr **)malloc(16*sizeof(tkstr *)))){printf("readtok(): Out of memory\r\n"); exit(1);}
  if(!(FGLOB_crfile=(char **)malloc(16*sizeof(char *)))){printf("readtok(): Out of memory\r\n"); exit(1);}
  if(!(FGLOB_word=(char **)malloc(16*sizeof(char *)))){printf("readtok(): Out of memory\r\n"); exit(1);}
}

FGLOB_tkal++;

if(!(FGLOB_tok[FGLOB_tkal]=(tkstr *)malloc(sizeof(tkstr)))){printf("readtok(): Out of memory\r\n"); exit(1);}
if(!(FGLOB_crfile[FGLOB_tkal]=(char *)malloc(32*sizeof(char)))){printf("readtok(): Out of memory\r\n"); exit(1);}
if(!(FGLOB_word[FGLOB_tkal]=(char *)malloc(256*sizeof(char)))){printf("readtok(): Out of memory\r\n"); exit(1);}

if(!(f=fopen(filename,"r"))){printf("readtok(): Could not open '%s'\r\n",filename); exit(1);}
strcpy(FGLOB_crfile[FGLOB_tkal],filename);
strcpy(FGLOB_word[FGLOB_tkal],word); strcat(FGLOB_word[FGLOB_tkal],":");

FGLOB_crtok[FGLOB_tkal]=FGLOB_tok[FGLOB_tkal];

FGLOB_tok[FGLOB_tkal]->val.s[0]='\0'; FGLOB_tok[FGLOB_tkal]->type=-1; FGLOB_tok[FGLOB_tkal]->next=0;

tok0=FGLOB_tok[FGLOB_tkal];
i=0;
line=1;
while(!feof(f)){
  a0=getc(f);
  if((!chkdel(a0))&&(!feof(f))){
    if(i==0){
      tok0=addtkstr(tok0); tok0->type=3; tok0->val.s[i]=a0; tok0->line=line; i++;
    }else{
      if(i>(MAXTKLEN-2)){
        printf("File '%s', line %d: word too long\r\n",filename,line); freetok(); return 0;
      }else{
        tok0->val.s[i]=a0; i++;
      }
    }
  }else{
    if(i>0){
      tok0->val.s[i]='\0'; i=0;
      if(chkword(tok0->val.s)){
        tok0->type=1;
      }else{
        if(chkint(tok0->val.s)){
          tok0->type=0;
          tok0->val.ival=atoi(tok0->val.s);
        }else{
          if(chkfloat(tok0->val.s)){
            tok0->type=2;
            tok0->val.fval=atof(tok0->val.s);
          }
        }
      }
    }
    if(a0=='\n'){line++;}
  }
}

fclose(f);
return 1;
}

void printtok(){
  tkstr *tok;
  tok=FGLOB_crtok[FGLOB_tkal];
  if(tok==0){
    printf("NULL pointer");
  }else{
    switch(tok->type){
      case 0: printf("integer, %d",tok->val.ival); break;
      case 1: printf("word, '%s'",tok->val.s); break;
      case 2: printf("floating point, %1.4e",tok->val.fval); break;
      default: printf("unknown type, '%s'",tok->val.s); break;
    }
  }
}

int getwordn(char *s){
  int i=0,j,k;
  char *word,w[MAXTKLEN];

word=FGLOB_word[FGLOB_tkal];

while(s[i]){
  if((s[i]>='A')&&(s[i]<='Z')){
    s[i]+=('a'-'A');
  }
  i++;
}

i=0; j=0; k=0;
while(word[i]){
  if(word[i]!=':'){
    w[j]=word[i]; j++;
  }else{
    if(j>0){
      k++; w[j]='\0';
      if(strcmp(w,s)==0){return k;}
      j=0;
    }
  }
  i++;
}

return 0;
}

int tkgetint(){
  if(FGLOB_tkal==-1){printf("tkgetint(): call readtok() first\r\n"); exit(1);}
  if(FGLOB_crtok[FGLOB_tkal]){
    FGLOB_crtok[FGLOB_tkal]=FGLOB_crtok[FGLOB_tkal]->next;
    if(FGLOB_crtok[FGLOB_tkal]){
      if((FGLOB_crtok[FGLOB_tkal]->type)==0){
        return FGLOB_crtok[FGLOB_tkal]->val.ival;
      }else{
        printf("File '%s', line %d: integer expected, found:\r\n",FGLOB_crfile[FGLOB_tkal],FGLOB_crtok[FGLOB_tkal]->line);
        printtok(); printf("\r\n");
        freetok(); exit(1);
      }
    }else{
      printf("File '%s': integer expected, found end of file (2)\r\n",FGLOB_crfile[FGLOB_tkal]);
      freetok(); exit(1);
    }
  }else{
    printf("File '%s': integer expected, found end of file (1)\r\n",FGLOB_crfile[FGLOB_tkal]);
    freetok(); exit(1);
  }
return 0;
}

float tkgetfloat(){
  if(FGLOB_tkal==-1){printf("tkgetfloat(): call readtok() first\r\n"); exit(1);}
  if(FGLOB_crtok[FGLOB_tkal]){
    FGLOB_crtok[FGLOB_tkal]=FGLOB_crtok[FGLOB_tkal]->next;
    if(FGLOB_crtok[FGLOB_tkal]){
      if((FGLOB_crtok[FGLOB_tkal]->type)==2){
        return FGLOB_crtok[FGLOB_tkal]->val.fval;
      }else{
        if((FGLOB_crtok[FGLOB_tkal]->type)==0){
          return (float)FGLOB_crtok[FGLOB_tkal]->val.ival;
        }else{
          printf("File '%s', line %d: floating point number expected, found:\r\n",FGLOB_crfile[FGLOB_tkal],FGLOB_crtok[FGLOB_tkal]->line);
          printtok(); printf("\r\n");
          freetok(); exit(1);
        }
      }
    }else{
      printf("File '%s': floating point number expected, found end of file (2)\r\n",FGLOB_crfile[FGLOB_tkal]);
      freetok(); exit(1);
    }
  }else{
    printf("File '%s': floating point number expected, found end of file (1)\r\n",FGLOB_crfile[FGLOB_tkal]);
    freetok(); exit(1);
  }
return 0.0;
}

/*returns word number, according to getwordn()*/
int tkgetword(){
  int wn;
  if(FGLOB_tkal==-1){printf("tkgetword(): call readtok() first\r\n"); exit(1);}
  if(FGLOB_crtok[FGLOB_tkal]){
    FGLOB_crtok[FGLOB_tkal]=FGLOB_crtok[FGLOB_tkal]->next;
    if(FGLOB_crtok[FGLOB_tkal]){
      if((FGLOB_crtok[FGLOB_tkal]->type)==1){
        wn=getwordn(FGLOB_crtok[FGLOB_tkal]->val.s);
        if(wn>0){
          return wn;
        }else{
          printf("File '%s', line %d: word '%s' not recognized\r\n",FGLOB_crfile[FGLOB_tkal],FGLOB_crtok[FGLOB_tkal]->line,FGLOB_crtok[FGLOB_tkal]->val.s);
          freetok(); exit(1);
        }
      }else{
        printf("File '%s', line %d: word expected, found:\r\n",FGLOB_crfile[FGLOB_tkal],FGLOB_crtok[FGLOB_tkal]->line);
        printtok(); printf("\r\n");
        freetok(); exit(1);
      }
    }else{
      return 0;
    }
  }else{
    printf("File '%s': word expected, found end of file (1)\r\n",FGLOB_crfile[FGLOB_tkal]);
    printf("Maybe tkgetword() was called again after it returned 0?\r\n");
    freetok(); exit(1);
  }
return 0;
}

void tkgetstring(char *s){
  if(FGLOB_tkal==-1){printf("tkgetstring(): call readtok() first\r\n"); exit(1);}
  if(FGLOB_crtok[FGLOB_tkal]){
    FGLOB_crtok[FGLOB_tkal]=FGLOB_crtok[FGLOB_tkal]->next;
    if(FGLOB_crtok[FGLOB_tkal]){
      strcpy(s,FGLOB_crtok[FGLOB_tkal]->val.s);
    }else{
      s[0]='\0'; return;
    }
  }else{
    printf("File '%s': string expected, found end of file (1)\r\n",FGLOB_crfile[FGLOB_tkal]);
    printf("Maybe tkgetstring() was called again after it returned 0?\r\n");
    freetok(); exit(1);
  }
}
