/*
Copyright (C) 2007-2018 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

int initgraph(unsigned int width,unsigned int height,int fullscr,const char *title);
void closegraph();
void setcolor(unsigned char red,unsigned char green,unsigned char blue);
void setcolrnb(float f);
void setbgcolor(unsigned char red,unsigned char green,unsigned char blue);
void clearscreen();
void display();
void scroll(int dy);
void dpoint(int x,int y);
void dlinerel(int x,int y);
void dlrspec(int dx,int dy,int n);
void drectangle(int x,int y);
void dchar(char c,int x,int y,int bgr);
void setchrsize(int i,int j);
void dtext(char *tx,int x,int y,int bgr);
void dtextscroll(char *tx,int x,int y,int bgr);
void dlineabs(float x1,float y1,float x2,float y2);
void dtriangle(float x1,float y1,float x2,float y2,float x3,float y3);
void dcircle(float x0,float y0,float r);
void ddisc(float x0,float y0,float r);
void setpos(int x,int y);
void printw(const char *format, ...);
void printws(const char *format, ...);

void pause(int p);
char getch_graph();
char getch();
void scanw(const char *format, ...);
void scanws(const char *format, ...);

int addmod2d();
void freemod2d();
void addpoint2d(float x,float y);
void addline2d(unsigned int p1,unsigned int p2);
void addtriangle2d(unsigned int p1,unsigned int p2,unsigned int p3,float col);
void drawmod2d(unsigned int nmod,float x0,float y0,float scale,float ang);
void evmod2d(unsigned int n1,unsigned int n2,float *xmin,float *ymin,float *scale);
void drmod2dauto(unsigned int nmod);

void setvoice(unsigned int v,float freq,float vol);

void freetok();
int readtok(const char *filename,const char *word);
void printtok();
int tkgetint();
float tkgetfloat();
int tkgetword();
void tkgetstring(char *s);

void setlight3d(float amb,float hd,float dir,float dx,float dy,float dz);
int initgraph3d(float fov,float zmin,float zmax);
void closegraph3d();
int addmod3d();
void mod3addtri(float x1,float y1,float z1,float x2,float y2,float z2,float x3,float y3,float z3);
void mod3setcolor(unsigned int tr1,unsigned int tr2,float red,float green,float blue);
void mod3setfullbr(unsigned int tr1,unsigned int tr2);
void mod3setvis(unsigned int tr1,unsigned int tr2,char vis,float xv,float yv,float zv);
void freemod3d();
int readmod3d(const char *fname);
int rdmod3d3f(const char *fgeo,const char *fcol,const char *fcld);
float eval_mod(unsigned int i);
void setobj3dmod(unsigned int i,unsigned int nmod);
void setobj3dpos(int i,float *pos);
void setobj3drot(int i,float *rot);
void setobj3dscale(unsigned int i,float scale);
void setcampos(float *pos);
void setcamrot(float *rot);
int addobj3d(unsigned int nmod);
void freeobj3d();
int drawobj3d(unsigned int nob);
int drawobj3all();
void transobj3d(int i,float x,float y,float z);
void transcam(float x,float y,float z);
void trlsobj3d(int i,float x,float y,float z);
void trlscam(float x,float y,float z);
void rotZobj3d(int i,float tt);
void rotZcam(float tt);
void rotYobj3d(int i,float tt);
void rotYcam(float tt);
void rotXobj3d(int i,float tt);
void rotXcam(float tt);
void rotABobj3d(int i,float dx,float dy,float dz,float tt);
void rotABcam(float dx,float dy,float dz,float tt);

void drawfog3d(float zfog,float zmax);
void drawbkg3d(float zmax);

float *getobj3dpos(int i);
float *getcampos();
float *getobj3drot(int i);
float *getcamrot();

void clfactors(float fred,float fgreen,float fblue);
