/*
Copyright (C) 2025 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>

int main(){
  int i,j,k,ns;
  float *x,*y,*z,l,dl,dheight;
  FILE *f1;

l=500.0; dl=10.0;
printf("Side length = %1.1f\r\n",l);
printf("Nr. of elements/side: ");
scanf("%d",&ns); ns+=2;

if(!(x=(float *)malloc((ns+1)*(ns+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc((ns+1)*(ns+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(z=(float *)malloc((ns+1)*(ns+1)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}

for(i=0;i<=ns;i++){
  for(j=0;j<=ns;j++){
    if((i==0)||(i==ns)||(j==0)||(j==ns)){
      x[i*(ns+1)+j]=20.0;
      y[i*(ns+1)+j]=-l-dl+((l+dl)/ns)*i*2;
      z[i*(ns+1)+j]=-l-dl+((l+dl)/ns)*j*2;
    }else{
      x[i*(ns+1)+j]=0.0;
      y[i*(ns+1)+j]=-l+(l/(ns-2))*(i-1)*2;
      z[i*(ns+1)+j]=-l+(l/(ns-2))*(j-1)*2;
    }
  }
}

for(k=0;k<=1;k++){
switch(k){
  case 0:
    if(!(f1=fopen("bigtri.geo","w"))){printf("Could not open 'bigtri.geo'\r\n"); exit(1);}
    dheight=0.0;
    break;
  case 1:
    if(!(f1=fopen("bigtri2.geo","w"))){printf("Could not open 'bigtri2.geo'\r\n"); exit(1);}
    dheight=0.03;
    break;
  default: printf("?!?\r\n"); exit(1);
}
fprintf(f1,"%d %d\r\n",(ns+1)*(ns+1),2*ns*ns);
for(i=0;i<=ns;i++){
  for(j=0;j<=ns;j++){
    fprintf(f1,"%1.3f %1.2f %1.2f\r\n",x[i*(ns+1)+j]+dheight,y[i*(ns+1)+j],z[i*(ns+1)+j]);
  }
}
for(i=0;i<ns;i++){
  for(j=0;j<ns;j++){
    fprintf(f1,"f %d %d %d\r\n",i+1+j*(ns+1),i+2+j*(ns+1),i+1+j*(ns+1)+ns+1);
    fprintf(f1,"f %d %d %d\r\n",i+2+j*(ns+1),i+1+j*(ns+1)+ns+1,i+1+j*(ns+1)+ns+2);
  }
}
fclose(f1);
}

if(!(f1=fopen("bigtri.col","w"))){printf("Could not open 'bigtri.col'\r\n"); exit(1);}

fprintf(f1,"%d\r\n",2*ns*ns);
for(i=0;i<ns;i++){
  for(j=0;j<ns;j++){
    fprintf(f1,"%d %d %d %d %d\r\n",i*(ns*2)+2*j+1,i*(ns*2)+2*j+1,20+rand()%5,150+rand()%10,20+rand()%5);
    fprintf(f1,"%d %d %d %d %d\r\n",i*(ns*2)+2*j+2,i*(ns*2)+2*j+2,20+rand()%5,150+rand()%10,20+rand()%5);
  }
}


fclose(f1);

free(x); free(y); free(z);
return 0;
}
