/*program for eliminating triangles with colour (red,green,blue) from 3D element*/
#include <stdio.h>
#include <stdlib.h>


int main(int argc,char *argv[]){
  int red=252,green=252,blue=84,
    nvert,nobj,nobj1, /*nobj1 - reduced number of elements*/
    *a,*b,*c, /*nodes of element*/
    *rd,*gr,*bl, /*colours of element*/
    el1,el2,nel, /*nel - number of colour declarations*/
    i,j;
  float *x,*y,*z;
  char s[4];
  FILE *f;

if(argc!=3){
  printf("Wrong number of parameters\r\nExample: %s file.geo file.col\r\n",argv[0]);
  exit(1);
}

if(!(f=fopen(argv[1],"r"))){printf("Could not open %s\r\n",argv[1]); exit(1);}
  fscanf(f,"%d %d",&nvert,&nobj);
  if(!(x=(float *)malloc(nvert*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
  if(!(y=(float *)malloc(nvert*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
  if(!(z=(float *)malloc(nvert*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
  if(!(a=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
  if(!(b=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
  if(!(c=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
  if(!(rd=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
  if(!(gr=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
  if(!(bl=(int *)malloc(nobj*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}

  for(i=0;i<nvert;i++){
    fscanf(f,"%f %f %f",x+i,y+i,z+i); /*x+i = &x[i]*/
  }
  for(i=0;i<nobj;i++){
    fscanf(f,"%s %d %d %d",s,a+i,b+i,c+i); /*a+i = &a[i]*/
  }
fclose(f);

if(!(f=fopen(argv[2],"r"))){printf("Could not open %s\r\n",argv[2]); exit(1);}
  fscanf(f,"%d",&nel);

  for(i=0;i<nel;i++){
    fscanf(f,"%d %d",&el1,&el2);
    fscanf(f,"%d %d %d",rd+el1-1,gr+el1-1,bl+el1-1);
    for(j=el1;j<el2;j++){
      rd[j]=rd[el1-1];
      gr[j]=gr[el1-1];
      bl[j]=bl[el1-1];
    }
  }
fclose(f);

nobj1=0;
for(i=0;i<nobj;i++){
  if((rd[i]!=red)||(gr[i]!=green)||(bl[i]!=blue)){
    a[nobj1]=a[i]; b[nobj1]=b[i]; c[nobj1]=c[i];
    rd[nobj1]=rd[i]; gr[nobj1]=gr[i]; bl[nobj1]=bl[i];
    nobj1++;
  }
}

if(!(f=fopen("new.geo","w"))){printf("Could not open 'new.geo'\r\n"); exit(1);}
  fprintf(f,"%d %d\r\n",nvert,nobj1);
  for(i=0;i<nvert;i++){
    fprintf(f,"%1.3f %1.3f %1.3f\r\n",x[i],y[i],z[i]);
  }
  for(i=0;i<nobj1;i++){
    fprintf(f,"%s %d %d %d\r\n",s,a[i],b[i],c[i]);
  }
fclose(f);

if(!(f=fopen("new.col","w"))){printf("Could not open 'new.col'\r\n"); exit(1);}
  fprintf(f,"%d\r\n",nobj1);

  for(i=0;i<nobj1;i++){
    fprintf(f,"%d %d %d %d %d\r\n",i+1,i+1,rd[i],gr[i],bl[i]);
  }
fclose(f);

free(x); free(y); free(z); free(a); free(b); free(c);
free(rd); free(gr); free(bl);
return 0;
}
