/*
Copyright (C) 2007-2018 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "../grconfig.h"
#include "../graphics.h"

#if SOUND == 1

extern SDL_AudioStream *RGLOB_stream;
extern SDL_AudioSpec *RGLOB_spec;
extern float RGLOB_userdata[20];
float RGLOB_x_sin[4]={0.0f,0.0f,0.0f,0.0f};

float sinrd(){
  unsigned int r;
  float x;
r=rand(); r&=255;
x=0.00784f*r-1.0f;
return x;
}

/*audio function for SDL, called from display in graph2d.c*/
void SDLCALL MyAudioCallback(void *userdata,SDL_AudioStream *stream,int additional_amount,int total_amount){
  int i,j,freq,sza;
  float dx[4],pi2,pi2f,a,*usrd;

sza=sizeof(a);
freq=(int)RGLOB_spec->freq;
usrd=(float *)userdata; /*userdata=RGLOB_userdata*/
pi2=6.283185f;
pi2f=pi2/freq;

for(i=0;i<4;i++){dx[i]=pi2f*usrd[i<<1];}

for(i=0;i<additional_amount;i++){
  a=0.0f;
  for(j=0;j<3;j++){
    RGLOB_x_sin[j]+=dx[j];
    if(RGLOB_x_sin[j]>pi2){RGLOB_x_sin[j]-=pi2;}
    a+=0.25f*usrd[(j<<1)+1]*sin(RGLOB_x_sin[j]);
  }
  a+=0.25f*usrd[7]*sinrd();

  SDL_PutAudioStreamData(stream,&a,sza); /*stream=RGLOB_stream*/
}
if(total_amount<additional_amount){printf("Error: total_amount<additional_amount\n");}
}

void setvoice(unsigned int v,float freq,float vol){
  if(v<4){
    if(freq<10.0f){freq=10.0f;} /*min.10Hz*/
    if(freq>5000.0f){freq=5000.0f;} /*max.5000Hz*/
    if(vol<0.0f){vol=0.0f;}
    if(vol>1.0f){vol=1.0f;}
    RGLOB_userdata[v<<1]=freq;
    RGLOB_userdata[(v<<1)+1]=vol;
  }else{printf("setvoice(): Voice %d not exist\r\n",v);}
}

#else

void setvoice(unsigned int v,float freq,float vol){printf("setvoice() requires '#define SOUND 1'\r\n");}

#endif
