/*
Copyright (C) 2007-2023 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define CC "gcc" /*can be g++*/
#define CPU "k8" /*can be pentium2, pentium3, core2 etc.*/
#define SSE "-mfpmath=sse" /*for pentium2 use -mfpmath=387*/
#define PKGC "pkg-config" /*can be pkgconf and is only needed for SDL3*/


int main(){
  int selgr,selp,sound,bpp,dpix;
  char sls[10],sdlpath[128],sdlpc[80]; /*sdlpc only for SDL3*/
  FILE *f;

if(!(f=fopen("grconfig.h","w"))){printf("Could not open 'grconfig.h'\n"); exit(1);}

printf("Graphical output:\n1. SDL 1\n2. SDL 2\n3. SDL 3\n4. No SDL (write BMP file)\n");
printf("Select option (1...4): "); scanf("%d",&selgr);

sound=0;
if((selgr==1)||(selgr==2)||(selgr==3)){
  printf("Bits per pixel (16/32): "); scanf("%d",&bpp);
  printf("Sound? (y/n): "); scanf("%s",sls);
}

if((bpp!=16)&&(bpp!=32)){bpp=32;}
printf("%d bits per pixel, ",bpp);

switch(sls[0]){
  case 'y':
  case 'Y': sound=1; printf("sound\n"); break;
  default: sound=0; printf("no sound\n"); break;
}

printf("Large (double) pixels for 3D graphics? (y/n): "); scanf("%s",sls);

switch(sls[0]){
  case 'y':
  case 'Y': dpix=1; printf("2x2 pixels\n"); break;
  default: dpix=0; break;
}

switch(selgr){
  case 1: fprintf(f,"#define SDLVER 1\n#define SOUND %d\n#include <SDL.h>\n",sound);
    printf("Path to sdl-config:\r\n1. sdl-config\r\n2. Other\r\n");
    scanf("%d",&selp);
    switch(selp){
      case 1: strcpy(sdlpath,"sdl-config"); break;
      case 2:
      default: printf("Path (ex.: /opt/local/SDL/bin/sdl-config): "); scanf("%s",sdlpath); break;
    }
    break;
  case 2: fprintf(f,"#define SDLVER 2\n#define SOUND %d\n#include <SDL.h>\n",sound);
    printf("Path to sdl2-config:\r\n1. sdl2-config\r\n2. Other\r\n");
    scanf("%d",&selp);
    switch(selp){
      case 1: strcpy(sdlpath,"sdl2-config"); break;
      case 2:
      default: printf("Path (ex.: /opt/local/SDL2/bin/sdl2-config): "); scanf("%s",sdlpath); break;
    }
    break;
  case 3: fprintf(f,"#define SDLVER 3\n#define SOUND %d\n#include <SDL3/SDL.h>\n#include <SDL3/SDL_main.h>\n",sound);
    printf("Path to sdl3.pc for %s:\r\n1. sdl3\r\n2. Other\r\n",PKGC);
    scanf("%d",&selp);
    switch(selp){
      case 1: strcpy(sdlpath,"pkg-config sdl3"); break;
      case 2:
      default: printf("Path (ex.: /opt/local/SDL3/lib64/pkgconfig/sdl3.pc): ");
      scanf("%s",sdlpc);
      sprintf(sdlpath,"%s %s",PKGC,sdlpc);
      break;
    }
    break;
  case 4:
  default: bpp=32; fprintf(f,"#define SDLVER 0\n#define SOUND 0\n"); break;
}

fprintf(f,"#define BITSPERPIXEL %d\n",bpp);

fprintf(f,"\n#if SDLVER==0\n\n");
  if(sizeof(char)==1){
    fprintf(f,"#define Sint8 char\n#define Uint8 unsigned char\n");
  }else{
    printf("Error: sizeof(char) not 1\n"); exit(1);
  }

  if(sizeof(short int)==2){
    fprintf(f,"#define Sint16 short int\n#define Uint16 unsigned short int\n");
  }else{
    if(sizeof(int)==2){
      fprintf(f,"#define Sint16 int\n#define Uint16 unsigned int\n");
    }else{
      printf("Error: 16 bit integer not found\n"); exit(1);
    }
  }

  if(sizeof(int)==4){
    fprintf(f,"#define Sint32 int\n#define Uint32 unsigned int\n");
  }else{
    if(sizeof(long int)==4){
      fprintf(f,"#define Sint32 long int\n#define Uint32 unsigned long int\n");
    }else{
      printf("Error: 32 bit integer not found\n"); exit(1);
    }
  }
fprintf(f,"\n#endif\n");

fprintf(f,"\n#define DOUBLEPIX %d\n/*1 - large pixels; 0 - normal pixels*/\n",dpix);
fprintf(f,"\n#define ASPCOR 0\n/*1 - aspect correction; 0 - no aspect correction (WIDTHFACTOR ignored)*/\n");
fprintf(f,"\n#define WIDTHFACTOR 0.78125\n/*0.78125 recommended for monitor with 1024x600 resolution, set at 800x600\n(if the video driver doesn't support 1024x600)*/\n");

printf("'grconfig.h' written\n");
fclose(f);

if(!(f=fopen("comp","w"))){printf("Could not open 'comp'\n"); exit(1);}

switch(selgr){
  case 1:
  case 2:
  case 3:
    fprintf(f,"CFLAGS=\"`%s --cflags` -O3 -fomit-frame-pointer -ffast-math -funsafe-math-optimizations -march=%s %s -Wall -W\";\nLIBS=\"`%s --libs` -lm -ldl\";\n",sdlpath,CPU,SSE,sdlpath);
    break;
  case 4:
  default:
    fprintf(f,"CFLAGS=\"-O3 -fomit-frame-pointer -ffast-math -funsafe-math-optimizations -march=%s %s -Wall -W\";\nLIBS=\"-lm -ldl\";\n",CPU,SSE);
    break;
}

if((selgr==1)||(selgr==2)||(selgr==4)){ /*SDL 1, 2 or no SDL*/
  fprintf(f,"CC=%s;\n\n$CC -c graph2d.c $CFLAGS;\n$CC -c sound.c $CFLAGS;\n$CC -c graph3d.c $CFLAGS;\n$CC -c readfile.c -Wall -W;\n",CC);
}else{ /*SDL 3*/
  fprintf(f,"CC=%s;\n\n$CC -c forsdl3/graph2d.c $CFLAGS;\n$CC -c forsdl3/sound.c $CFLAGS;\n$CC -c forsdl3/graph3d.c $CFLAGS;\n$CC -c readfile.c -Wall -W;\n",CC);
}

fclose(f);

if(!(f=fopen("../comp","w"))){printf("Could not open '../comp'\n"); exit(1);}

switch(selgr){
  case 1:
  case 2:
  case 3:
    fprintf(f,"CFLAGS=\"`%s --cflags` -O3 -fomit-frame-pointer -ffast-math -funsafe-math-optimizations -march=%s %s -Wall -W\";\nLIBS=\"`%s --libs` -lm -ldl\";\n",sdlpath,CPU,SSE,sdlpath);
    break;
  case 4:
  default:
    fprintf(f,"CFLAGS=\"-O3 -fomit-frame-pointer -ffast-math -funsafe-math-optimizations -march=%s %s -Wall -W\";\nLIBS=\"-lm -ldl\";\n",CPU,SSE);
    break;
}

fprintf(f,"\nCC=%s;\n\nGRFILES=\"graphics/graph2d.o graphics/sound.o graphics/graph3d.o graphics/readfile.o\"\n\n$CC -c src/$1.c $CFLAGS;\n\n$CC $GRFILES $1.o -o $1 $LIBS;\n\nrm *.o;\n",CC);

fclose(f);

printf("Now run './comp FILE' to compile src/FILE.c\r\n");

return 0;
}
