/*
Copyright (C) 2014-2023 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


/*functions for reading file START*/
#define MAXWLG 100

/*functie care returneaza 1 daca i se transmite un caracter de delimitare si 0 daca nu*/
int verdel(char s){
char a[6]={' ','\r','\n','\t',':'};
int i,sem=0;
  for(i=0;i<=4;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;
}


/*functie care returneaza 1 daca i se transmite o litera mica si 0 daca nu*/
int vercrl(char s){
char a[28]={'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z'};
int i,sem=0;
  for(i=0;i<=25;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;
}


/*functie care returneaza 1 daca i se transmite o cifra sau '.' si 0 daca nu*/
int vercrcf(char s){
char a[13]={'0','1','2','3','4','5','6','7','8','9','.'};
int i,sem=0;
  for(i=0;i<=10;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;
}


/*functie care se uita sa vada ce e un sir de caractere: intreg(0), cuvant(1), real(2) sau altceva(3) ...*/
int detsir(char *s){
int i=1,sem=3,crp=0; /*crp - variabila pentru numarat punctele*/
  if(vercrl(s[0])){sem=1; /*adica daca primul caracter e o litera*/
    while((!verdel(s[i]))&&s[i]){if(!vercrl(s[i])){sem=3;return sem;} i++;}
  return sem;}
    if((vercrcf(s[0]))||(s[0]=='-')){sem=2; /*adica daca primul caracter e o cifra*/
	if(s[0]=='.'){crp++;}
      while((!verdel(s[i]))&&s[i]){
	if(s[i]=='.'){crp++;}
	if(!vercrcf(s[i])){sem=3;return sem;} i++;
      }if((crp>=2)||((crp==1)&&(i==1))){sem=3;return sem;}
    if((!crp)&&(s[0]!='-')){sem=0;}
    return sem;}
return sem;
}


/*functie care citeste un cuvant s din fisierul fis; lincr - linia curenta*/
int fisgetw(FILE *fis,char *s,int *lincr){
int i,sem=0;
  static int sem2=0;if(sem2){(*lincr)++;sem2=0;}
s[0]=getc(fis);if(s[0]=='\n'){(*lincr)++;}
  while((!(feof(fis)))&&(verdel(s[0]))){s[0]=getc(fis);if(s[0]=='\n'){(*lincr)++;}}
  /*sarit peste caracterele de dinaintea cuvantului*/
i=1;
  while((!(feof(fis)))&&(i<MAXWLG)&&(!verdel(s[i-1])))
  {s[i]=getc(fis);i++;} if(!verdel(s[i-1])){sem=1;}
  if(s[i-1]=='\n'){sem2=1;} s[i-1]='\0';
return sem;
} /*1 daca s-a depasit lungimea maxima a cuvantului sau sfarsitul fisierului si 0 daca nu*/


/*for readcolor()*/
int identcom(char *s){
if(strcmp(s,"numvert")==0){return 1;}
if(strcmp(s,"numsurf")==0){return 2;}
if(strcmp(s,"texture")==0){return 3;}
return 0;
}


int fgetwnum(FILE *fis){
int sem;
static int lincr=1;
char s[MAXWLG];

sem=fisgetw(fis,s,&lincr);

return identcom(s);
}


/*skip n words from file*/
void fskipw(FILE *fis,int n){
int i,sem;
static int lincr=1;
char s[MAXWLG];

for(i=1;i<=n;i++){sem=fisgetw(fis,s,&lincr);}
}
/*functions for reading file END*/


typedef struct _texture{
char name[101];
int red;
int green;
int blue;
} texture;


/*initialize random numbers*/
void inrnd()
{int i,t,r;
t=time(NULL); if(t<0){t=-t;} t=t%16384;
for(i=1;i<=t;i++){
  r=rand();
}
}


int irand1()
{int a;
a=rand();
a=70+a%140;
return a;}


int main(int argc,char *argv[])
{char s[MAXWLG];
int i,j,
    nrvert0=0,nrvert=0,nrtr0=0,nrtr=0,dn, /*nr. of vertices and triangles*/
    **n,nt=0,
    nrcol=0,tc1[10000],tc2[10000],
    nrtex=0; /*nr. of textures*/
float *x,*y,*z;
texture tex[10000];
FILE *f1,*fgeo,*fcol;



inrnd();
tc1[1]=1; /*first coloured triangle*/

if(!(x=(float *)malloc(sizeof(float)))){printf("Out of memory\r\n");exit (1);}
if(!(y=(float *)malloc(sizeof(float)))){printf("Out of memory\r\n");exit (1);}
if(!(z=(float *)malloc(sizeof(float)))){printf("Out of memory\r\n");exit (1);}

if(!(n=(int **)malloc(256*sizeof(int *)))){printf("Out of memory\r\n");exit (1);}

for(i=0;i<256;i++){
  if(!(n[i]=(int *)malloc(sizeof(int)))){printf("Out of memory\r\n");exit (1);}
}

if(argc!=2){printf("Wrong format; example:\r\n%s model1.acc\r\n",argv[0]); exit(1);}

strcpy(s,argv[1]);
if(!(f1=fopen(s,"r"))){printf("Could not open file '%s'\r\n",s); exit(1);}


while(!feof(f1)){
  i=0;
  while((i!=3)&&(!feof(f1))){i=fgetwnum(f1);} /*3-textures*/
  if(i!=3){break;}
  nrtex++;
  fscanf(f1,"%s",tex[nrtex].name);
  tex[nrtex].red=irand1();
  tex[nrtex].green=irand1();
  tex[nrtex].blue=irand1();
  for(j=1;j<=(nrtex-1);j++){
    if(strcmp(tex[j].name,tex[nrtex].name)==0){
      tex[nrtex]=tex[j];
    }
  }

  i=0;
  while((i!=1)&&(!feof(f1))){i=fgetwnum(f1);} /*1-vertices*/
  if(i!=1){break;}
  fscanf(f1,"%d",&dn);
  nrvert0=nrvert; nrvert+=dn;
  nrcol+=1; /*colours*/
  if(!(x=(float *)realloc(x,(nrvert+1)*sizeof(float)))){printf("Out of memory\r\n");exit (1);}
  if(!(y=(float *)realloc(y,(nrvert+1)*sizeof(float)))){printf("Out of memory\r\n");exit (1);}
  if(!(z=(float *)realloc(z,(nrvert+1)*sizeof(float)))){printf("Out of memory\r\n");exit (1);}
  for(i=nrvert0+1;i<=nrvert;i++){
    fscanf(f1,"%f %f %f",&z[i],&x[i],&y[i]); fskipw(f1,3);
  }

  while(((fgetwnum(f1))!=2)&&(!feof(f1))){;} /*2-triangles*/
  fscanf(f1,"%d",&dn);
  nrtr0=nrtr; nrtr+=dn;
  for(i=0;i<256;i++){
    if(!(n[i]=(int *)realloc(n[i],(nrtr+1)*sizeof(int)))){printf("Out of memory\r\n");exit (1);}
  }
  for(i=nrtr0+1;i<=nrtr;i++){
    fskipw(f1,5); /*skip 5 words*/
    fscanf(f1,"%d",&(n[0][i])); nt+=(n[0][i]-2);
    /*printf("refs=%d, nt=%d\r\n",n[0][i],nt);*/
    for(j=1;j<=n[0][i];j++){
      fscanf(f1,"%d",&(n[j][i])); n[j][i]+=(nrvert0+1); fskipw(f1,8);
    }
  }
  tc2[nrcol]=nt; tc1[nrcol+1]=nt+1; /*colours*/
}

fclose(f1); /*read input file*/

if(!(fgeo=fopen("out.geo","w"))){printf("Could not open file 'out.geo'\r\n"); exit(1);}

fprintf(fgeo,"%d %d\r\n",nrvert,nt);

for(i=1;i<=nrvert;i++){
  fprintf(fgeo,"%1.4f %1.4f %1.4f\r\n",x[i],y[i],z[i]);
}

for(i=1;i<=nrtr;i++){
  for(j=1;j<=(n[0][i]-2);j++){
    fprintf(fgeo,"f %d %d %d\r\n",n[j][i],n[j+1][i],n[j+2][i]);
  }
}

fclose(fgeo); /*wrote geometry file*/


if(!(fcol=fopen("out.col","w"))){printf("Could not open file 'out.col'\r\n"); exit(1);}

fprintf(fcol,"%d\r\n",nrcol);

for(i=1;i<=nrcol;i++){
  fprintf(fcol,"%d %d %d %d %d\r\n",tc1[i],tc2[i],tex[i].red,tex[i].green,tex[i].blue);
}

fclose(fcol);

printf("nrcol=%d, nrtex=%d\r\n'out.geo' and 'out.col' written\r\n",nrcol,nrtex);

free(x); free(y); free(z);
for(i=0;i<256;i++){free(n[i]);}
free(n);
return 0;}
