/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "string.h"
#include "SDL.h"
#include "time.h"
#include "config.h"

#if CLBITS==16
  #include "geo16.h"
#elif CLBITS==24
  #include "geo32.h"
#elif CLBITS==32
  #include "geo32.h"
#endif

#include "objf.h"
#include "trans.h"
#include "odis.h"
#include "faces.h"
#include "interp.h"
#include "game.h"

int main()
{char numefis[MAXWLG];

int i,quit=0,
    t0frame; /*t0frame - moment when image starts to be displayed*/


SDL_Event event;
SDL_Surface *screen;
/* Open the audio device */


pixcol backcol; /*background color*/
REALN  zfog,zmax; /*zfog,zmax - distanta de la care incepe ceatza, respectiv de la care nu se mai vede nimic*/

sgob *objs; /*objects*/
int nob,nto; /*number of objects and of object types*/

REALN tframe=0,xan=0,/*tframe-time necessary for display; xan-number of displayed images*/
      timp,dstr; /*total time, distance traveled*/

/*for game*/
REALN dtz,drx, /*translation and rotation*/
      vtz,vrx,vrxmax,vrxmr, /*linear and rot. speed*/
      atz,arx,arxmax,arxmr, /*lin. and rot. acceleration*/
      pin,pmax,acg=0, /*thrust, maximum thrust, gravity thrust(for slopes)*/
      drg,bkf,bkfmax, /*drag coefficient, brake force*/
      mass, /*vehicle mass*/
      vrot3,vrot4, /*rot. speed of level 3 and 4 objects*/
      destrx=0,destry=0,destrz=0, /*translations returned by roadcheck()*/
      desroty=0,desrotz=0, /*rotations returned by roadcheck()*/
      carspeed=0; /*m:s*/
int turn, /*-1: left; 0: no turn; 1: right*/
    roadsw, /*information about position on road*/
    dmode, /*1: forward; -1: backward;*/
    ncars=0; /*number of cars on each side of the road*/
/*for game^*/


zfog=49;
zmax=50; /*visibility (m)*/

strcpy(numefis,"tracks/track5");

objs=citfiscom(numefis,&nob,&nto,&backcol,&ncars,&carspeed); /*read objects from file*/

objs=trafpath(objs,&nob,0,ncars,'a'); /*initialize traffic*/

for(i=1;i<=nob;i++){if(objs[i].lev>0){translat(&objs[i],0,0,-0.30);}}
/*otherwise, we would be teleported to the other end right at the start*/

printf("\r\n");



/*Initialize SDL*/
if(SDL_Init(SDL_INIT_VIDEO)<0){printf("Couldn't initialize SDL: %s\n", SDL_GetError());SDL_Quit();return 0;}
/*Initialize display*/
screen=SDL_SetVideoMode(SCREENWIDTH,SCREENHEIGHT,CLBITS,SDL_FULLSCREEN);
if(screen == NULL){printf("Couldn't set requested video mode: %s\n",SDL_GetError());SDL_Quit();return 0;}
printf("Set %dx%dx%d\n",(screen->pitch)/(screen->format->BytesPerPixel),SCREENHEIGHT,screen->format->BitsPerPixel);
/*Set window title*/
SDL_WM_SetCaption("simple3d", "simple3d");
/* Enable Unicode translation */
SDL_EnableUNICODE(1);
/*SDL initialized*/



timp=0,dstr=0; /*pornit cronometru*/


vtz=0; vrx=0; atz=0; arx=0; pin=0; bkf=0;
dtz=0; drx=0;
pmax=1000; /*N*/
drg=0.5;
bkfmax=1200; /*N*/
mass=1000; /*kg*/
vrxmax=0.1;
arxmax=vrxmax;
turn=0;
vrot3=1.57;
vrot4=0.5;
dmode=1; /*forward*/


while(!quit){

/*t0frame=clock();*/
t0frame=SDL_GetTicks();
xan++;

for(i=4;i<=nob;i++){
  if(objs[i].lev>0){
    if(objs[i].lev==3){
      rotab(&objs[i],objs[i].vx[0],objs[i].vy[0],objs[i].vz[0],objs[i].vx[3],objs[i].vy[3],objs[i].vz[3],vrot3*tframe);
    }
    if(objs[i].lev==4){
      rotab(&objs[i],objs[objs[i].mob].vx[0],objs[objs[i].mob].vy[0],objs[objs[i].mob].vz[0],objs[objs[i].mob].vx[1],objs[objs[i].mob].vy[1],objs[objs[i].mob].vz[1],vrot4*tframe);
    }
    translat(&objs[i],0,0,-dtz);
    rotatx(&objs[i],0,0,drx);
  }
}

trafpath(objs,&nob,(timp-tframe)*carspeed,0,'r'); /*traffic*/

/*car-road interaction*/
roadsw=roadcheck(objs,nob,&destrx,&destry,&destrz,&desroty,&desrotz,&acg,tframe,dstr,vtz);

acg*=dmode;

switch(roadsw){
  case 1: drg=1.32; break;
  case 0: drg=200; break;
  case -1: drg=1000; break;
  default: break;
}

for(i=4;i<=nob;i++){
  if(objs[i].lev>0){
    translat(&objs[i],destrx,destry,destrz);
    rotatz(&objs[i],0,0,desrotz);
    rotaty(&objs[i],0,0,desroty);}
  }
/*end of car-road interaction*/


rotatz(&objs[1],objs[1].vx[0],objs[1].vy[0],vrx*15); /*move steering wheel*/
rotatz(&objs[2],objs[2].vx[0],objs[2].vy[0],vtz*0.0565); /*move speed indicator*/

odis(screen,objs,nob,backcol,zfog,zmax); /*display image*/

rotatz(&objs[1],objs[1].vx[0],objs[1].vy[0],-vrx*15); /*move steering wheel back*/
rotatz(&objs[2],objs[2].vx[0],objs[2].vy[0],-vtz*0.0565); /*move speed indicator back*/


atz=(pin+mass*acg-drg*vtz*vtz-bkf-500)/mass;

if(vtz<2.7){vrxmr=vrxmax; arxmr=arxmax;}
else{
  vrxmr=vrxmax/(0.37*vtz);
  arxmr=arxmax/(0.37*vtz);
}

switch(turn){
  case 0: if(vrx>0){arx=-arxmr*1.5;}else{if(vrx<0){arx=arxmr*1.5;}else{arx=0;}}
          if(fabs(vrx)<2.25*tframe*arx){arx=0; vrx=0;}
          break;
  case -1: if(vrx>-vrxmr){arx=-arxmr; if(vrx>0){arx*=1.5;}}else{arx=0;}
           break;
  case 1: if(vrx<vrxmr){arx=arxmr; if(vrx<0){arx*=1.5;}}else{arx=0;}
          break;
  default: break;
}

vtz+=atz*tframe; if(vtz<0){vtz=0;}
vrx+=arx*tframe;

if(vrx>vrxmr){vrx=vrxmr;}
if(vrx<-vrxmr){vrx=-vrxmr;}

dtz=dmode*vtz*tframe; drx=dmode*vrx*vtz*tframe;


while(SDL_PollEvent(&event)){
switch(event.type){

case SDL_KEYDOWN:
	switch(event.key.keysym.sym){

		case SDLK_LCTRL: pin=pmax;
		             break;

		case SDLK_LALT: bkf=bkfmax*(1+vtz*vtz*5e-4);
		             break;

		case SDLK_LEFT: turn=-1;
		             break;

		case SDLK_RIGHT: turn=1;
		             break;

		case SDLK_LSHIFT: if(vtz==0){dmode=-dmode;
		               rotatz(&objs[3],objs[3].vx[0],objs[3].vy[0],3.1416*dmode);
		             }
		             break;

		case SDLK_SPACE: quit=1;

		default: break;
	} break;
case SDL_KEYUP:
	switch(event.key.keysym.sym){

		case SDLK_LCTRL: pin=0;
		             break;

		case SDLK_LALT: bkf=0;
		             break;

		case SDLK_LEFT: if(turn==-1){turn=0;}
		             break;

		case SDLK_RIGHT: if(turn==1){turn=0;}
		             break;

		default: break;
	} break;

case SDL_QUIT: quit=1;

default: break;
}
}
/*tframe=(REALN)(clock()-t0frame)/CLOCKS_PER_SEC;*/
tframe=(REALN)(SDL_GetTicks()-t0frame)/1000;
timp+=tframe; dstr+=(dtz*dmode);
}


printf("\r\nDistance: %1.2f km\r\nTime: %1.2f seconds\r\n",dstr/1000,timp);
printf("Average speed: %1.2f km/h\r\n",3.6*dstr/timp);
printf("Average framerate: %1.2f f/s\r\n\r\n",xan/timp);


SDL_Quit();

for(i=1;i<=nto;i++){free(fceglob[i]);}
free(fceglob); free (refglob); free(objs);


trafpath(objs,&nob,0,0,'f'); /*traffic*/

/* printf("Press ENTER: ");getchar();printf("\r\n"); */

return 0;}


