/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/*function which displays the objcts which are closer than zmax
lx,ly,lz - light on x,y,z; nob - total number of objects
obdis - displayed objects
number of displayed objects is returned*/
void odis(SDL_Surface *screen,sgob *objs,int nob,pixcol backcol,REALN zfog,REALN zmax)
{int i,j,focal;
unsigned int width,height;
unsigned long int area;
static int sem=0,nrfm=0; /*number of triangles for which memory has been allocated*/
static tria *face,*facedisp; /*triangles and displayed triangles in global system*/
static REALN *distmin; /*Zbuffer*/
int nrfaces,nrdisp,crf; /*number of triangles and of displayed triangles, current triangle*/

REALN tgh,tgv,zmin;
REALN x,y,z,ix,iy,iz,jx,jy,jz,kx,ky,kz; /*temporary variables for transformations*/

width=SCREENWIDTH;
height=SCREENHEIGHT;
focal=width/(2*tan(FOV*0.008726646));

area=(width+1)*(height+1);

tgh=(REALN)width/(2*(REALN)focal);
tgv=(REALN)height/(2*(REALN)focal);

zmin=1e-3;

if(!sem){
  if(!(distmin=(REALN *)malloc(area*sizeof(REALN)))){printf("Out of memory");}
  if(!(face=(tria *)malloc(11*sizeof(tria)))){printf("Out of memory");}
  if(!(facedisp=(tria *)malloc(22*sizeof(tria)))){printf("Out of memory");}
  nrfm=1; sem=1;}

nrfaces=0;
crf=0;
for(i=1;i<=nob;i++){
  if((objs[i].ycen-objs[i].radius)>(objs[i].zcen+objs[i].radius)*tgh){goto NEXT;}
  if((objs[i].ycen+objs[i].radius)<(objs[i].zcen+objs[i].radius)*(-tgh)){goto NEXT;}
  if((objs[i].xcen-objs[i].radius)>(objs[i].zcen+objs[i].radius)*tgv){goto NEXT;}
  if((objs[i].xcen+objs[i].radius)<(objs[i].zcen+objs[i].radius)*(-tgv)){goto NEXT;}
  if(((objs[i].zcen-objs[i].radius)<zmax)&&((objs[i].zcen+objs[i].radius)>0)){
    nrfaces+=objs[i].nfa;
    if(nrfaces>nrfm){
      nrfm=nrfaces;
      if(!(face=(tria *)realloc(face,(nrfm+10)*sizeof(tria)))){printf("Out of memory");}
      if(!(facedisp=(tria *)realloc(facedisp,(2*nrfm+20)*sizeof(tria)))){printf("Out of memory");}
    }

    ix=objs[i].vx[1]-objs[i].vx[0];
    jx=objs[i].vx[2]-objs[i].vx[0];
    kx=objs[i].vx[3]-objs[i].vx[0];
      iy=objs[i].vy[1]-objs[i].vy[0];
      jy=objs[i].vy[2]-objs[i].vy[0];
      ky=objs[i].vy[3]-objs[i].vy[0];
        iz=objs[i].vz[1]-objs[i].vz[0];
        jz=objs[i].vz[2]-objs[i].vz[0];
        kz=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/

    for(j=1;j<=objs[i].nfa;j++){
      face[j+crf]=fceglob[objs[i].otyp][j]; /*added triangles*/
        x=fceglob[objs[i].otyp][j].x1;
        y=fceglob[objs[i].otyp][j].y1;
        z=fceglob[objs[i].otyp][j].z1;
      face[j+crf].x1=objs[i].vx[0]+x*ix+y*jx+z*kx;
      face[j+crf].y1=objs[i].vy[0]+x*iy+y*jy+z*ky;
      face[j+crf].z1=objs[i].vz[0]+x*iz+y*jz+z*kz;
        x=fceglob[objs[i].otyp][j].x2;
        y=fceglob[objs[i].otyp][j].y2;
        z=fceglob[objs[i].otyp][j].z2;
      face[j+crf].x2=objs[i].vx[0]+x*ix+y*jx+z*kx;
      face[j+crf].y2=objs[i].vy[0]+x*iy+y*jy+z*ky;
      face[j+crf].z2=objs[i].vz[0]+x*iz+y*jz+z*kz;
        x=fceglob[objs[i].otyp][j].x3;
        y=fceglob[objs[i].otyp][j].y3;
        z=fceglob[objs[i].otyp][j].z3;
      face[j+crf].x3=objs[i].vx[0]+x*ix+y*jx+z*kx;
      face[j+crf].y3=objs[i].vy[0]+x*iy+y*jy+z*ky;
      face[j+crf].z3=objs[i].vz[0]+x*iz+y*jz+z*kz; /*updated positions of triangles*/
    }
    crf=nrfaces;
  }
NEXT: ;}

backcol.bright=SDL_MapRGB(screen->format,backcol.red,backcol.green,backcol.blue);
/*determined displayed color of the background*/

nrdisp=fclip(face,nrfaces,zmin,facedisp,zmax,tgh,tgv);

displaysdl(screen,facedisp,nrdisp,distmin,width,height,focal,backcol,zfog,zmax);

}
