/*
Copyright (C) 2005-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/*
solves system [A]{x} = {vlt} where almost all elements in [A] (aij) are 0;
elements different from 0 must be arranged as follows (for p=5):
    a[1]=0    a[2]=0    a[3]=a11  a[4]=a12   a[5]=a13
    a[6]=0    a[7]=a21  a[8]=a22  a[9]=a23  a[10]=a24
   a[11]=a31       a32       a33       a34        a35
         a42       a43       a44       a45        a46
etc. etc.
x - unknowns
n - number of equations
vlt - right hand side
*/
double wvsistem(double *a,double *vlt,double *x,int p,int n)
{int i,j,k,wit,wi,lcmax,area,tmp;
double *b,*vl,
       rap,det=1,tmpd,
       medmax, /*suma patrate elemente pe linia lcmax*/
       mmmax; /*a[i,i]^2/med1,a[lcmax,i]^2/medmax*/

p=(p+1)/2;
wit=2*p-1;  /*numar coloane matrice intrare*/
wi=3*p-2;  /*numar coloane matrice pe care o sa se lucreze*/

area=n*wi;
if(!(b=(double *)malloc((area+1)*sizeof(double)))){printf("Out of memory");return 0;}
if(!(vl=(double *)malloc((n+1)*sizeof(double)))){printf("Out of memory");return 0;}

/*copiaza variabilele de intrare ca sa nu se modifice cele originale*/
for(i=1;i<=n;i++){vl[i]=vlt[i];
	for(j=1;j<=wit;j++){
	b[(i-1)*wi+j]=a[(i-1)*wit+j];
	}
		for(j=wit+1;j<=wi;j++){
		b[(i-1)*wi+j]=0;
		}
}
/*terminat copiat variabile*/


  for(i=1;i<=(n-1);i++){
  lcmax=i; mmmax=0;
    for(j=0;j<=(p-1);j++){
    medmax=0;
      if((i+j)<=n){
        for(k=1;k<=wi;k++){
          medmax+=(b[(i+j-1)*wi+k]*b[(i+j-1)*wi+k]);
        }
        if(mmmax<b[(i+j-1)*wi+p-j]*b[(i+j-1)*wi+p-j]/medmax){
          mmmax=b[(i+j-1)*wi+p-j]*b[(i+j-1)*wi+p-j]/medmax;lcmax=i+j;
        }
      }
    }

    if(lcmax!=i){
	  for(j=lcmax-i+1;j<=(2*p+lcmax-i-1);j++){
		tmpd=b[(i-1)*wi+j];
		b[(i-1)*wi+j]=b[(lcmax-1)*wi+j-lcmax+i];
		b[(lcmax-1)*wi+j-lcmax+i]=tmpd;
	  }
	  tmpd=vl[i];
	  vl[i]=vl[lcmax];
	  vl[lcmax]=tmpd;
    } /*schimbat pivot*/

      tmp=i+p-1;if(tmp>n){tmp=n;}
	for(k=i+1;k<=tmp;k++){
	rap=b[(k-1)*wi+p-k+i]/b[(i-1)*wi+p];
	  for(j=p;j<=(3*p-2);j++){
	   b[(k-1)*wi+j-k+i]-=rap*b[(i-1)*wi+j];
	  }vl[k]-=rap*vl[i];
	}
  }

  for(i=n;i>=2;i--){

      tmp=i-2*(p-1);if(tmp<1){tmp=1;}
	for(k=i-1;k>=tmp;k--){
	  rap=b[(k-1)*wi+p-k+i]/b[(i-1)*wi+p];
	    b[(k-1)*wi+p-k+i]-=rap*b[(i-1)*wi+p];
		vl[k]-=rap*vl[i];
	}x[i]=vl[i]/b[(i-1)*wi+p];det*=b[(i-1)*wi+p];

  } x[1]=vl[1]/b[p];det*=b[p];

free(b);free(vl);

return det;
}


/*interpolation with cubic spline functions of y=f(x); y[i]=f(x[i]);
for interval i: y=a[i]x^3 + b[i]x^2 + c[i]x + d[i]*/
void sinterp(double *x,double *y,int n,double *a,double *b,double *c,double *d)
{int i;
double *ca,*cm,*vtl,*h;

if(!(ca=(double *)malloc((3*(n+1)+1)*sizeof(double)))){printf("Out of memory");}
if(!(cm=(double *)malloc((n+2)*sizeof(double)))){printf("Out of memory");}
if(!(vtl=(double *)malloc((n+2)*sizeof(double)))){printf("Out of memory");}
if(!(h=(double *)malloc((n+2)*sizeof(double)))){printf("Out of memory");}

for(i=0;i<=(n-1);i++){
  h[i]=x[i+1]-x[i];
}

ca[1]=0; ca[2]=1; ca[3]=0; vtl[1]=0;

for(i=1;i<=(n-1);i++){
  ca[3*i+1]=h[i-1]/6;
  ca[3*i+2]=(h[i-1]+h[i])/3;
  ca[3*i+3]=h[i]/6;
  vtl[i+1]=(y[i+1]-y[i])/h[i]-(y[i]-y[i-1])/h[i-1];
}

ca[3*n+1]=0; ca[3*n+2]=1; ca[3*n+3]=0; vtl[n+1]=0;

wvsistem(ca,vtl,cm,3,n+1);

for(i=0;i<=n;i++){cm[i]=cm[i+1];}

for(i=0;i<=(n-1);i++){
  a[i+1]=(cm[i+1]-cm[i])/(6*h[i]);
  b[i+1]=(3*cm[i]*x[i+1]-3*cm[i+1]*x[i])/(6*h[i]);
  c[i+1]=(3*cm[i+1]*x[i]*x[i]-3*cm[i]*x[i+1]*x[i+1])/(6*h[i])+(y[i+1]-y[i])/h[i]+(cm[i]-cm[i+1])*h[i]/6;
  d[i+1]=(cm[i]*x[i+1]*x[i+1]*x[i+1]-cm[i+1]*x[i]*x[i]*x[i])/(6*h[i])+(x[i+1]*y[i]-x[i]*y[i+1])/h[i]+(x[i]*cm[i+1]-x[i+1]*cm[i])*h[i]/6;
}

free(ca); free(cm); free(vtl); free(h);
}
