/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


/*function which calculates the trajectories of traffic vehicles
n+1 - number of points
disttr - distance from point 0
points: (x[0],y[0])...(x[n],y[n])*/
sgob *trafpath(sgob *objs,int *nrobt,double disttr,int ncs,char flag)
{static double **a,**b,**c,**d,totdist=0;
static int sem=0,n=1,fl1=1,ncars=0; /*fl1 - first lev. 1 object*/
int i,j,k,nob,
    tnt=2; /*total number of trajectories*/
double ix,iy,iz,jx,jy,jz,kx,ky,kz,x0,y0,z0, /*parameters for the local system of the first lev.1 object, in the global system*/
       *ox,*oy,*oz,*rfx,*rfy,*rfz, /*syst. origins and ref. points of objects*/
       *jlx,*jly,*jlz,
       *ds,
       dax=1.25,
       dst1,dst2,
       lnj,lnk,
       trix,triy,triz,
       trjx,trjy,trjz,
       trkx,trky,trkz,
       trx0,try0,trz0,
       dist;

nob=*nrobt;

if(flag=='r'){

  ix=objs[fl1].vx[1]-objs[fl1].vx[0];
  jx=objs[fl1].vx[2]-objs[fl1].vx[0];
  kx=objs[fl1].vx[3]-objs[fl1].vx[0];
    iy=objs[fl1].vy[1]-objs[fl1].vy[0];
    jy=objs[fl1].vy[2]-objs[fl1].vy[0];
    ky=objs[fl1].vy[3]-objs[fl1].vy[0];
      iz=objs[fl1].vz[1]-objs[fl1].vz[0];
      jz=objs[fl1].vz[2]-objs[fl1].vz[0];
      kz=objs[fl1].vz[3]-objs[fl1].vz[0]; /*unit vectors of the local axes in global system*/
  x0=objs[fl1].vx[0];
  y0=objs[fl1].vy[0];
  z0=objs[fl1].vz[0]; /*origin of local system of the first l.1 obj.*/

  for(k=1;k<=tnt;k++){
    for(i=1;i<=ncars;i++){
      dist=disttr+(i-0.8+0.8*cos(i))*totdist/(ncars+1);
      if(dist>=totdist){dist=dist-totdist*floor(dist/totdist);}

      j=(int)(dist/10)+1;

      trx0=a[(k-1)*3+1][j]*dist*dist*dist+b[(k-1)*3+1][j]*dist*dist+c[(k-1)*3+1][j]*dist+d[(k-1)*3+1][j];
      try0=a[(k-1)*3+2][j]*dist*dist*dist+b[(k-1)*3+2][j]*dist*dist+c[(k-1)*3+2][j]*dist+d[(k-1)*3+2][j];
      trz0=a[(k-1)*3+3][j]*dist*dist*dist+b[(k-1)*3+3][j]*dist*dist+c[(k-1)*3+3][j]*dist+d[(k-1)*3+3][j];
        trkx=3*a[(k-1)*3+1][j]*dist*dist+2*b[(k-1)*3+1][j]*dist+c[(k-1)*3+1][j];
        trky=3*a[(k-1)*3+2][j]*dist*dist+2*b[(k-1)*3+2][j]*dist+c[(k-1)*3+2][j];
        trkz=3*a[(k-1)*3+3][j]*dist*dist+2*b[(k-1)*3+3][j]*dist+c[(k-1)*3+3][j];
          trjx=0;
          trjy=trkz;
          trjz=-trky;
        lnj=sqrt(trjx*trjx+trjy*trjy+trjz*trjz);
        lnk=sqrt(trkx*trkx+trky*trky+trkz*trkz);
          trjx/=lnj; trjy/=lnj; trjz/=lnj;
          trkx/=lnk; trky/=lnk; trkz/=lnk;
            trix=trjy*trkz-trjz*trky;
            triy=trjz*trkx-trjx*trkz;
            triz=trjx*trky-trjy*trkx;

      j=nob+(k-3)*ncars+i;

      objs[j].vx[0]=x0+trx0*ix+try0*jx+trz0*kx;
      objs[j].vy[0]=y0+trx0*iy+try0*jy+trz0*ky;
      objs[j].vz[0]=z0+trx0*iz+try0*jz+trz0*kz;

        objs[j].vx[1]=objs[j].vx[0]+trix*ix+triy*jx+triz*kx;
        objs[j].vy[1]=objs[j].vy[0]+trix*iy+triy*jy+triz*ky;
        objs[j].vz[1]=objs[j].vz[0]+trix*iz+triy*jz+triz*kz;
          objs[j].vx[2]=objs[j].vx[0]+trjx*ix+trjy*jx+trjz*kx;
          objs[j].vy[2]=objs[j].vy[0]+trjx*iy+trjy*jy+trjz*ky;
          objs[j].vz[2]=objs[j].vz[0]+trjx*iz+trjy*jz+trjz*kz;
            objs[j].vx[3]=objs[j].vx[0]+trkx*ix+trky*jx+trkz*kx;
            objs[j].vy[3]=objs[j].vy[0]+trkx*iy+trky*jy+trkz*ky;
            objs[j].vz[3]=objs[j].vz[0]+trkx*iz+trky*jz+trkz*kz;

            objs[j].xcen=objs[j].vx[0];
            objs[j].ycen=objs[j].vy[0];
            objs[j].zcen=objs[j].vz[0];
    }
  }

return objs;}


if(!sem){ sem=1;

  /*add cars to list of objects*/
  ncars=ncs; /*number of cars on each side of the road*/
  if(!(objs=(sgob *)realloc(objs,(nob+2*ncars+1)*sizeof(sgob)))){printf("Out of memory");}
  for(i=nob+1;i<=(nob+2*ncars);i++){
    objs[i].otyp=26+(i%7)%3; /*lines 26,27,28 in the track file*/
      objs[i].nref=refglob[objs[i].otyp].nref;
      objs[i].nfa=refglob[objs[i].otyp].nfa;
        objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0;
        objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
        objs[i].vx[2]=objs[i].vx[3]=0;
        objs[i].vy[1]=objs[i].vy[3]=0;
        objs[i].vz[1]=objs[i].vz[2]=0;
          for(j=1;j<=objs[i].nref;j++){
            objs[i].xref[j]=refglob[objs[i].otyp].x[j];
            objs[i].yref[j]=refglob[objs[i].otyp].y[j];
            objs[i].zref[j]=refglob[objs[i].otyp].z[j];
          }
        eval_obj(fceglob[objs[i].otyp],&objs[i]);
        objs[i].radius*=2;
      objs[i].lev=5;
      objs[i].mob=0;
  }
  nob=nob+2*ncars;
  *nrobt=nob;
  /*added cars to list of objects*/

  if(!(a=(double **)malloc((tnt*3+1)*sizeof(double *)))){printf("Out of memory");}
  if(!(b=(double **)malloc((tnt*3+1)*sizeof(double *)))){printf("Out of memory");}
  if(!(c=(double **)malloc((tnt*3+1)*sizeof(double *)))){printf("Out of memory");}
  if(!(d=(double **)malloc((tnt*3+1)*sizeof(double *)))){printf("Out of memory");}

  while(objs[fl1].lev!=1){fl1++;}
  while(objs[fl1+n].lev==1){n++;} /*number of intervals for interpolation*/

  for(j=1;j<=tnt;j++){
    for(i=1;i<=3;i++){
      if(!(a[i+3*(j-1)]=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
      if(!(b[i+3*(j-1)]=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
      if(!(c[i+3*(j-1)]=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
      if(!(d[i+3*(j-1)]=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
    }
  }

  if(!(ox=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
  if(!(oy=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
  if(!(oz=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
    if(!(rfx=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
    if(!(rfy=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
    if(!(rfz=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}
      if(!(jlx=(double *)malloc((n+4)*sizeof(double)))){printf("Out of memory");}
      if(!(jly=(double *)malloc((n+4)*sizeof(double)))){printf("Out of memory");}
      if(!(jlz=(double *)malloc((n+4)*sizeof(double)))){printf("Out of memory");}
  if(!(ds=(double *)malloc((n+3)*sizeof(double)))){printf("Out of memory");}

        ix=objs[fl1].vx[1]-objs[fl1].vx[0];
        jx=objs[fl1].vx[2]-objs[fl1].vx[0];
        kx=objs[fl1].vx[3]-objs[fl1].vx[0];
          iy=objs[fl1].vy[1]-objs[fl1].vy[0];
          jy=objs[fl1].vy[2]-objs[fl1].vy[0];
          ky=objs[fl1].vy[3]-objs[fl1].vy[0];
            iz=objs[fl1].vz[1]-objs[fl1].vz[0];
            jz=objs[fl1].vz[2]-objs[fl1].vz[0];
            kz=objs[fl1].vz[3]-objs[fl1].vz[0]; /*unit vectors of the local axes in global system*/
        x0=objs[fl1].vx[0]*ix+objs[fl1].vy[0]*iy+objs[fl1].vz[0]*iz;
        y0=objs[fl1].vx[0]*jx+objs[fl1].vy[0]*jy+objs[fl1].vz[0]*jz;
        z0=objs[fl1].vx[0]*kx+objs[fl1].vy[0]*ky+objs[fl1].vz[0]*kz; /*origin of local system of the first l.1 obj.*/

  for(i=1;i<=n;i++){
    j=fl1+i-1;
    ox[i]=-x0+objs[j].vx[0]*ix+objs[j].vy[0]*iy+objs[j].vz[0]*iz;
    oy[i]=-y0+objs[j].vx[0]*jx+objs[j].vy[0]*jy+objs[j].vz[0]*jz;
    oz[i]=-z0+objs[j].vx[0]*kx+objs[j].vy[0]*ky+objs[j].vz[0]*kz;
      rfx[i]=-x0+objs[j].xref[1]*ix+objs[j].yref[1]*iy+objs[j].zref[1]*iz;
      rfy[i]=-y0+objs[j].xref[1]*jx+objs[j].yref[1]*jy+objs[j].zref[1]*jz;
      rfz[i]=-z0+objs[j].xref[1]*kx+objs[j].yref[1]*ky+objs[j].zref[1]*kz;
        jlx[i]=(objs[j].vx[2]-objs[j].vx[0])*ix+(objs[j].vy[2]-objs[j].vy[0])*iy+(objs[j].vz[2]-objs[j].vz[0])*iz;
        jly[i]=(objs[j].vx[2]-objs[j].vx[0])*jx+(objs[j].vy[2]-objs[j].vy[0])*jy+(objs[j].vz[2]-objs[j].vz[0])*jz;
        jlz[i]=(objs[j].vx[2]-objs[j].vx[0])*kx+(objs[j].vy[2]-objs[j].vy[0])*ky+(objs[j].vz[2]-objs[j].vz[0])*kz;
  }
  jlx[n+1]=jlx[n];
  jly[n+1]=jly[n];
  jlz[n+1]=jlz[n];

  rfx[0]=ox[1];
  rfy[0]=oy[1];
  rfz[0]=oz[1];

  for(i=2;i<=n;i++){
    dst1=(ox[i]-rfx[i-1])*(ox[i]-rfx[i-1])+(oy[i]-rfy[i-1])*(oy[i]-rfy[i-1])+(oz[i]-rfz[i-1])*(oz[i]-rfz[i-1]);
    dst2=(rfx[i]-rfx[i-1])*(rfx[i]-rfx[i-1])+(rfy[i]-rfy[i-1])*(rfy[i]-rfy[i-1])+(rfz[i]-rfz[i-1])*(rfz[i]-rfz[i-1]);

    if(dst1>dst2){
      rfx[i]=ox[i];
      rfy[i]=oy[i];
      rfz[i]=oz[i];
        jlx[i]=-jlx[i];
        jly[i]=-jly[i];
        jlz[i]=-jlz[i];
    }
  }

  /*add 1 more point at each end of the track*/
  for(i=n;i>=0;i--){
    rfx[i+1]=rfx[i]; rfy[i+1]=rfy[i]; rfz[i+1]=rfz[i];
    jlx[i+1]=jlx[i]; jly[i+1]=jly[i]; jlz[i+1]=jlz[i];
  }
  rfx[0]=2.5*rfx[1]-1.5*rfx[2];
  rfy[0]=2.5*rfy[1]-1.5*rfy[2];
  rfz[0]=2.5*rfz[1]-1.5*rfz[2];
    rfx[n+2]=2.5*rfx[n+1]-1.5*rfx[n];
    rfy[n+2]=2.5*rfy[n+1]-1.5*rfy[n];
    rfz[n+2]=2.5*rfz[n+1]-1.5*rfz[n];
      jlx[n+2]=jlx[n+1]; jlx[n+3]=jlx[n+1]; jlx[1]=jlx[2];
      jly[n+2]=jly[n+1]; jly[n+3]=jly[n+1]; jly[1]=jly[2];
      jlz[n+2]=jlz[n+1]; jlz[n+3]=jlz[n+1]; jlz[1]=jlz[2];
      n+=2;
  /*added 1 more point at each end of the track*/

  for(i=0;i<=n;i++){ds[i]=10*i;} totdist=ds[n];

  for(i=0;i<=n;i++){
    ox[i]=rfx[i]+dax*jlx[i+1];
    oy[i]=rfy[i]+dax*jly[i+1];
    oz[i]=rfz[i]+dax*jlz[i+1];
  }
  sinterp(ds,ox,n,a[1],b[1],c[1],d[1]);
  sinterp(ds,oy,n,a[2],b[2],c[2],d[2]);
  sinterp(ds,oz,n,a[3],b[3],c[3],d[3]);

  for(i=0;i<=n;i++){
    ox[n-i]=rfx[i]-dax*jlx[i+1];
    oy[n-i]=rfy[i]-dax*jly[i+1];
    oz[n-i]=rfz[i]-dax*jlz[i+1];
  }
  sinterp(ds,ox,n,a[4],b[4],c[4],d[4]);
  sinterp(ds,oy,n,a[5],b[5],c[5],d[5]);
  sinterp(ds,oz,n,a[6],b[6],c[6],d[6]);

  free(ox); free(oy); free(oz);
  free(rfx); free(rfy); free(rfz);
  free(jlx); free(jly); free(jlz);
  free(ds);

return objs;}


if(flag=='f'){
  for(i=1;i<=(3*tnt);i++){
    free(a[i]); free(b[i]); free(c[i]); free(d[i]);
  }
  free(a); free(b); free(c); free(d);
}


return objs;}


/*oc - current object*/
void teleport(sgob *objs,int nob,int oc)
{int i,to=1;
REALN ix1,iy1,iz1,jx1,jy1,jz1,kx1,ky1,kz1,
      ix2,iy2,iz2,jx2,jy2,jz2,kx2,ky2,kz2,
      xg,yg,zg,xl,yl,zl,
      destrx,destry,destrz,
      tt,sintt,costt;

    i=oc;
    ix1=objs[i].vx[1]-objs[i].vx[0];
    jx1=objs[i].vx[2]-objs[i].vx[0];
    kx1=objs[i].vx[3]-objs[i].vx[0];
      iy1=objs[i].vy[1]-objs[i].vy[0];
      jy1=objs[i].vy[2]-objs[i].vy[0];
      ky1=objs[i].vy[3]-objs[i].vy[0];
        iz1=objs[i].vz[1]-objs[i].vz[0];
        jz1=objs[i].vz[2]-objs[i].vz[0];
        kz1=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/
    xg=-objs[i].vx[0];
    yg=-objs[i].vy[0];
    zg=-objs[i].vz[0];
    xl=xg*ix1+yg*iy1+zg*iz1;
    yl=xg*jx1+yg*jy1+zg*jz1;
    zl=xg*kx1+yg*ky1+zg*kz1;

while((objs[to].otyp!=21)||(to==oc)){to++; if(to>=nob){return;}} /*target object*/

    i=to;
    ix2=objs[i].vx[1]-objs[i].vx[0];
    jx2=objs[i].vx[2]-objs[i].vx[0];
    kx2=objs[i].vx[3]-objs[i].vx[0];
      iy2=objs[i].vy[1]-objs[i].vy[0];
      jy2=objs[i].vy[2]-objs[i].vy[0];
      ky2=objs[i].vy[3]-objs[i].vy[0];
        iz2=objs[i].vz[1]-objs[i].vz[0];
        jz2=objs[i].vz[2]-objs[i].vz[0];
        kz2=objs[i].vz[3]-objs[i].vz[0];

destrx=-objs[to].vx[0]+objs[oc].vx[0];
destry=-objs[to].vy[0]+yl*jy2+0.30*ky2;
destrz=-objs[to].vz[0]+yl*jz2+0.30*kz2;

costt=kx1*kx2+ky1*ky2+kz1*kz2;
sintt=jx1*kx2+jy1*ky2+jz1*kz2;
tt=atan(sintt/costt);
if(costt>0){tt+=3.1416;}

for(i=1;i<=nob;i++){
  if(objs[i].lev>0){
    translat(&objs[i],destrx,destry,destrz);
    rotatx(&objs[i],0,0,tt);
  }
}

}


/*car-road interaction*/
int roadcheck(sgob *objs,int nob,REALN *destrx,REALN *destry,REALN *destrz,REALN *desroty,REALN *desrotz,REALN *acg,REALN tframe,REALN dstr,REALN vtz)
{int i,vret=-1,collision=0;;
REALN yrefl,zrefl,ang=0,yrad=0,zmax,dst,sintt=0,costt=0, /*for curved track sections - 5,6,7,8*/
      ix,iy,iz,jx,jy,jz,kx,ky,kz,
      kmx,kmy,kmz,l,m,n,
      xg,yg,zg,xl,yl,zl,
      dstxlc=0,dsrmax=0,dstylc=0,dstzlc=0,
      val=1.2; /*distance from vehicle to road (for simplification, vehicle is considered to be a point)*/

l=7;
if(vtz<l){m=vtz/l;}else{m=1/(0.3*vtz+1-0.3*l);}

for(i=1;i<=nob;i++){
    if((objs[i].lev==5)&&(fabs(objs[i].vx[0])<15)&&(fabs(objs[i].vy[0])<15)&&(fabs(objs[i].vz[0])<15)){
    ix=objs[i].vx[1]-objs[i].vx[0];
    jx=objs[i].vx[2]-objs[i].vx[0];
    kx=objs[i].vx[3]-objs[i].vx[0];
      iy=objs[i].vy[1]-objs[i].vy[0];
      jy=objs[i].vy[2]-objs[i].vy[0];
      ky=objs[i].vy[3]-objs[i].vy[0];
        iz=objs[i].vz[1]-objs[i].vz[0];
        jz=objs[i].vz[2]-objs[i].vz[0];
        kz=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/
    xg=-objs[i].vx[0];
    yg=-objs[i].vy[0];
    zg=-objs[i].vz[0];
    xl=xg*ix+yg*iy+zg*iz;
    yl=xg*jx+yg*jy+zg*jz;
    zl=xg*kx+yg*ky+zg*kz;

    if((xl>objs[i].xmin)&&(yl>objs[i].ymin)&&(zl>objs[i].zmin)&&(xl<objs[i].xmax)&&(yl<objs[i].ymax)&&(zl<objs[i].zmax)){
      switch(objs[i].otyp){
        case 21: teleport(objs,nob,i); break;
        default: collision=1; break;
      }
    }
  }
}

for(i=1;i<=nob;i++){
  if((objs[i].lev==1)&&(fabs(objs[i].vx[0])<30)&&(fabs(objs[i].vy[0])<30)&&(fabs(objs[i].vz[0])<30)){
    switch(objs[i].otyp){
      case 4:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 29:
        ix=objs[i].vx[1]-objs[i].vx[0];
        jx=objs[i].vx[2]-objs[i].vx[0];
        kx=objs[i].vx[3]-objs[i].vx[0];
          iy=objs[i].vy[1]-objs[i].vy[0];
          jy=objs[i].vy[2]-objs[i].vy[0];
          ky=objs[i].vy[3]-objs[i].vy[0];
            iz=objs[i].vz[1]-objs[i].vz[0];
            jz=objs[i].vz[2]-objs[i].vz[0];
            kz=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/
        xg=-objs[i].vx[0];
        yg=-objs[i].vy[0];
        zg=-objs[i].vz[0];
        xl=xg*ix+yg*iy+zg*iz;
        yl=xg*jx+yg*jy+zg*jz;
        zl=xg*kx+yg*ky+zg*kz;
        if((zl>-0.01)&&(zl<10.01)&&(yl>-11.0)&&(yl<11.0)){
          dstxlc=val-xl+zl*refglob[objs[i].otyp].x[1]/refglob[objs[i].otyp].z[1];
          if(collision){dstxlc+=0.6;}
          (*destrx)=-dstxlc*ix;
          (*destry)=-dstxlc*iy;
          (*destrz)=-dstxlc*iz;

          kmx=objs[i].xref[1]-objs[i].vx[0];
          kmy=objs[i].yref[1]-objs[i].vy[0];
          kmz=objs[i].zref[1]-objs[i].vz[0];
          l=jy*kmz-jz*kmy;
          m=jz*kmx-jx*kmz;
          n=jx*kmy-jy*kmx;
          (*desrotz)=-atan(m/l);
          (*desroty)=atan(n/sqrt(m*m+l*l));
          dsrmax=fabs(*desrotz);
          if(fabs(*desroty)>dsrmax){dsrmax=fabs(*desroty);}
          if(dsrmax>0.4*tframe){
            dsrmax=0.4*tframe/dsrmax;
            (*desrotz)*=dsrmax;
            (*desroty)*=dsrmax;
          }

          (*acg)=-10*iz; /*extra acceleration caused by force of gravity*/

            if((yl>-3.0)&&(yl<3.0)){vret=1;}else{
              if((yl>-4.3)&&(yl<4.3)){vret=0;}else{
                vret=-1;
                if(yl<=-4.3){dstylc=-4.3-yl;}else{dstylc=4.3-yl;}
                (*destrx)-=dstylc*jx;
                (*destry)-=dstylc*jy;
                (*destrz)-=dstylc*jz;
              }
            }

            if(collision){vret=-1;}

            if((dstxlc>-1.5)&&(dstxlc<1.5)){return vret;}
        }
      break;

      default: break;
    }
  }
}

for(i=1;i<=nob;i++){
  if((objs[i].lev==1)&&(fabs(objs[i].vx[0])<30)&&(fabs(objs[i].vy[0])<30)&&(fabs(objs[i].vz[0])<30)){
    switch(objs[i].otyp){
      case 5:
      case 6:
      case 7:
      case 8:
        ix=objs[i].vx[1]-objs[i].vx[0];
        jx=objs[i].vx[2]-objs[i].vx[0];
        kx=objs[i].vx[3]-objs[i].vx[0];
          iy=objs[i].vy[1]-objs[i].vy[0];
          jy=objs[i].vy[2]-objs[i].vy[0];
          ky=objs[i].vy[3]-objs[i].vy[0];
            iz=objs[i].vz[1]-objs[i].vz[0];
            jz=objs[i].vz[2]-objs[i].vz[0];
            kz=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/
        xg=-objs[i].vx[0];
        yg=-objs[i].vy[0];
        zg=-objs[i].vz[0];
        xl=xg*ix+yg*iy+zg*iz;
        yl=xg*jx+yg*jy+zg*jz;
        zl=xg*kx+yg*ky+zg*kz;

        switch(objs[i].otyp){
          case 5: ang=0.4142; yrad=-25.465; break;
          case 6: ang=1.0; yrad=-12.732; break;
          case 7: ang=-0.4142; yrad=25.465; break;
          case 8: ang=-1.0; yrad=12.732; break;
          default: break;
        }
        yrefl=refglob[objs[i].otyp].y[1];
        zrefl=refglob[objs[i].otyp].z[1];
        zmax=zrefl+(yl-yrefl)*ang;

        if((zl>-0.01)&&(zl<zmax+0.01)&&(yl>-15.0)&&(yl<15.0)){
          dstxlc=val-xl+zl*refglob[objs[i].otyp].x[1]/refglob[objs[i].otyp].z[1];
          if(collision){dstxlc+=0.6;}
          (*destrx)=-dstxlc*ix;
          (*destry)=-dstxlc*iy;
          (*destrz)=-dstxlc*iz;

          l=ix;
          m=iy;
          n=iz;
          (*desrotz)=-atan(m/l);
          (*desroty)=atan(n/sqrt(m*m+l*l));
          dsrmax=fabs(*desrotz);
          if(fabs(*desroty)>dsrmax){dsrmax=fabs(*desroty);}
          if(dsrmax>0.4*tframe){
            dsrmax=0.4*tframe/dsrmax;
            (*desrotz)*=dsrmax;
            (*desroty)*=dsrmax;
          }

          (*acg)=-10*iz; /*extra acceleration caused by force of gravity*/

          dst=sqrt(zl*zl+(yl-yrad)*(yl-yrad))-fabs(yrad); /*distance from middle of road*/

            if((dst>-3.0)&&(dst<3.0)){vret=1;}else{
              if((dst>-4.3)&&(dst<4.3)){vret=0;}else{
                vret=-1;
                costt=(yl-yrad)/(dst+fabs(yrad));
                sintt=zl/(dst+fabs(yrad));
                if(dst<=-4.3){dstylc=(-4.3-dst)*costt; dstzlc=(-4.3-dst)*sintt;}else
                             {dstylc=(4.3-dst)*costt; dstzlc=(4.3-dst)*sintt;}
                (*destrx)-=(dstylc*jx+dstzlc*kx);
                (*destry)-=(dstylc*jy+dstzlc*ky);
                (*destrz)-=(dstylc*jz+dstzlc*kz);
              }
            }

            if(collision){vret=-1;}

            if((dstxlc>-1.5)&&(dstxlc<1.5)){return vret;}
        }
      break;

      default:break;
    }
  }
}

if(collision){vret=-1;}

return vret;}


/*functie dintzi fierastrau*/
REALN sind(REALN x){
const REALN pi=3.1415926536;
x=(x/(2*pi)-floor(x/(2*pi)))*2*pi;
if(x<pi){return 1;}else{return -1;}
return 0;}

