/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/*functie care returneaza 1 daca i se transmite un caracter de delimitare si 0 daca nu*/
int verdel(char s)
{char a[6]={' ','\r','\n','\t',':'};
int i,sem=0;
  for(i=0;i<=4;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;}


/*functie care returneaza 1 daca i se transmite o litera mica si 0 daca nu*/
int vercrl(char s)
{char a[28]={'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z'};
int i,sem=0;
  for(i=0;i<=25;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;}


/*functie care returneaza 1 daca i se transmite o cifra sau '.' si 0 daca nu*/
int vercrcf(char s)
{char a[13]={'0','1','2','3','4','5','6','7','8','9','.'};
int i,sem=0;
  for(i=0;i<=10;i++){
    if(s==a[i]){sem=1;break;}
  }
return sem;}


/*functie care se uita sa vada ce e un sir de caractere: intreg(0), cuvant(1), real(2) sau altceva(3) ...*/
int detsir(char *s)
{int i=1,sem=3,crp=0; /*crp - variabila pentru numarat punctele*/
  if(vercrl(s[0])){sem=1; /*adica daca primul caracter e o litera*/
    while((!verdel(s[i]))&&s[i]){if(!vercrl(s[i])){sem=3;return sem;} i++;}
  return sem;}
    if((vercrcf(s[0]))||(s[0]=='-')){sem=2; /*adica daca primul caracter e o cifra*/
	if(s[0]=='.'){crp++;}
      while((!verdel(s[i]))&&s[i]){
	if(s[i]=='.'){crp++;}
	if(!vercrcf(s[i])){sem=3;return sem;} i++;
      }if((crp>=2)||((crp==1)&&(i==1))){sem=3;return sem;}
    if((!crp)&&(s[0]!='-')){sem=0;}
    return sem;}
return sem;}


/*functie care citeste un cuvant s din fisierul fis; lincr - linia curenta*/
int fisgetw(FILE *fis,char *s,int *lincr)
{int i,sem=0;
  static int sem2=0;if(sem2){(*lincr)++;sem2=0;}
s[0]=getc(fis);if(s[0]=='\n'){(*lincr)++;}
  while((!(feof(fis)))&&(verdel(s[0]))){s[0]=getc(fis);if(s[0]=='\n'){(*lincr)++;}}
  /*sarit peste caracterele de dinaintea cuvantului*/
i=1;
  while((!(feof(fis)))&&(i<MAXWLG)&&(!verdel(s[i-1])))
  {s[i]=getc(fis);i++;} if(!verdel(s[i-1])){sem=1;}
  if(s[i-1]=='\n'){sem2=1;} s[i-1]='\0';
return sem;} /*1 daca s-a depasit lungimea maxima a cuvantului sau sfarsitul fisierului si 0 daca nu*/


/*functie care gaseste numarul de ordine al comenzii*/
int identcom(char *s)
{if(strcmp(s,"objtypes")==0){return 1;} /*pt. declarat nr. de tipuri de obiecte*/
 if(strcmp(s,"objects")==0){return 2;} /*pt. declarat nr. de obiecte*/
 if(strcmp(s,"background")==0){return 3;}
 if(strcmp(s,"clfactors")==0){return 4;}
 if(strcmp(s,"traffic")==0){return 5;}
 if(strcmp(s,"bkgfile")==0){return 6;}
 return 0;}


/*functie care afiseaza un mesaj de eroare si iese din program daca e cazul*/
void afermex(char *numefis,int lincr,char *s,int cdvr)
{/*cdvr - conditie de verificare (0-intreg,1-cuvant,2-real)*/
if((cdvr==0)&&(detsir(s)!=0)){printf("Error: '%s' line %d - integer expected, got '%s'\r\n",numefis,lincr,s);exit(1);}
if((cdvr==1)&&(detsir(s)!=1)){printf("Error: '%s' line %d - word expected, got '%s'\r\n",numefis,lincr,s);exit(1);}
if((cdvr==2)&&(detsir(s)!=2)&&(detsir(s)!=0)){printf("Error: '%s' line %d - number expected, got '%s'\r\n",numefis,lincr,s);exit(1);}
}


/*functie care afla numarul de triunghiuri*/
int findnf(char *numefis)
{int nvert,nrfaces;
FILE *fis;
char s[MAXWLG]; int err,lincr=0;

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}


err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nvert=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nrfaces=atoi(s);

fclose(fis);
return nrfaces;}


/*functie care afla coordonatele varfurilor triunghiurilor*/
void faces(tria *face,char *numefis)
{int err,lincr=0,i,j,nrfaces,nvert;
FILE *fis;
REALN *x,*y,*z;
char s[MAXWLG];

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}


err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nvert=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nrfaces=atoi(s);

if(!(x=(REALN *)malloc((nvert+1)*sizeof(REALN)))){printf("Out of memory");}
if(!(y=(REALN *)malloc((nvert+1)*sizeof(REALN)))){printf("Out of memory");}
if(!(z=(REALN *)malloc((nvert+1)*sizeof(REALN)))){printf("Out of memory");}

for(i=1;i<=nvert;i++){
err=fisgetw(fis,s,&lincr); x[i]=atof(s);
err=fisgetw(fis,s,&lincr); y[i]=atof(s);
err=fisgetw(fis,s,&lincr); z[i]=atof(s);
} /*aflat coordonatele punctelor*/

for(i=1;i<=nrfaces;i++){
  err=fisgetw(fis,s,&lincr); /*sarit peste "f"*/
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); j=atoi(s);

    face[i].x1=x[j];face[i].y1=y[j];face[i].z1=z[j];
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); j=atoi(s);

    face[i].x2=x[j];face[i].y2=y[j];face[i].z2=z[j];
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); j=atoi(s);

    face[i].x3=x[j];face[i].y3=y[j];face[i].z3=z[j];

  face[i].red=255;
  face[i].green=200;
  face[i].blue=0;

  face[i].cull=0; /*no culling if not specified*/
}

free(x);free(y);free(z);
fclose(fis);}


/*functie care coloreaza triunghiurile
*bred,*bgreen,*bblue - culoarea fundalului*/
void readcolor(tria *face,int nrfaces,char *numefis)
{int i,j,colors,fstart,fend,fred,fgreen,fblue; /*colors - numar de culori*/
/*fstart si fend - primul, respectiv ultimul triunghi cu culoarea(fred,fgreen,fblue)*/
FILE *fis;
char s[MAXWLG]; int err,lincr=0;

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}

err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); colors=atoi(s);


for(i=1;i<=nrfaces;i++){face[i].red=255;face[i].green=255;face[i].blue=255;}

for(j=1;j<=colors;j++){
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); fstart=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); fend=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); fred=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); fgreen=atoi(s);
err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); fblue=atoi(s);

  for(i=fstart;i<=fend;i++){
    face[i].red=fred;
    face[i].green=fgreen;
    face[i].blue=fblue;
  }
}

fclose(fis);
}


/*function which reads the number of reference points of an object*/
int findnref(char *numefis)
{int nref; /*number of reference points*/
FILE *fis;
char s[MAXWLG]; int err,lincr=0;

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}

err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nref=atoi(s);

  if(nref>=(MAXREF-1)){printf("File '%s' - too many reference points",numefis);exit(1);}

fclose(fis);
return nref;}


/*function which reads the reference points of an object*/
void readref(REALD *xr,REALD *yr,REALD *zr,char *numefis)
{int i,nref; /*number of reference points*/
FILE *fis;
char s[MAXWLG]; int err,lincr=0;

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}

err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nref=atoi(s);

  if(nref>=(MAXREF-1)){printf("File '%s' - too many reference points",numefis);exit(1);}

  for(i=1;i<=nref;i++){
    err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); *(xr+i)=atof(s);
    err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); *(yr+i)=atof(s);
    err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); *(zr+i)=atof(s);

  }

fclose(fis);
}


/*order vertices, so triangles can be culled correctly*/
void ordercl(tria *face,char *numefis)
{int i,j,nrcmd,nf1,nf2;
REALN x,y,z,dx,dy,dz,a,b,c,d,prodscal,tmp;
char vis; /*'v'-visible from (x,y,z); 'i'-not visible*/
FILE *fis;
char s[MAXWLG]; int err,lincr=0;

if(!(fis=fopen(numefis,"r"))){printf("File '%s' could not be open\r\n",numefis);exit(1);}

err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nrcmd=atoi(s);


for(i=1;i<=nrcmd;i++){

  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nf1=atoi(s);
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); nf2=atoi(s);
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,1); vis=s[0];
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); x=atof(s);
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); y=atof(s);
  err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); z=atof(s);

  for(j=nf1;j<=nf2;j++){
    findplan(face,j,&a,&b,&c,&d);
     dx=face[j].x1-x;
     dy=face[j].y1-y;
     dz=face[j].z1-z;
    prodscal=a*dx+b*dy+c*dz;
    switch(vis){
      case 'v': face[j].cull=1;
        if(prodscal<0){
          tmp=face[j].x1; face[j].x1=face[j].x2; face[j].x2=tmp;
          tmp=face[j].y1; face[j].y1=face[j].y2; face[j].y2=tmp;
          tmp=face[j].z1; face[j].z1=face[j].z2; face[j].z2=tmp;
        } break;

      case 'i': face[j].cull=1;
        if(prodscal>=0){
          tmp=face[j].x1; face[j].x1=face[j].x2; face[j].x2=tmp;
          tmp=face[j].y1; face[j].y1=face[j].y2; face[j].y2=tmp;
          tmp=face[j].z1; face[j].z1=face[j].z2; face[j].z2=tmp;
        } break;

      default: break;
    }
  }
}

fclose(fis);
}


/*function which finds the center and size of the object*/
void eval_obj(tria *face,sgob *objs)
{int i,nrfaces;
REALD xmin,xmax,ymin,ymax,zmin,zmax,lenx,leny,lenz;

nrfaces=objs->nfa;

xmin=xmax=face[1].x1;
ymin=ymax=face[1].y1;
zmin=zmax=face[1].z1;

for(i=1;i<=nrfaces;i++){
if(xmin>face[i].x1){xmin=face[i].x1;}
if(xmin>face[i].x2){xmin=face[i].x2;}
if(xmin>face[i].x3){xmin=face[i].x3;}
if(xmax<face[i].x1){xmax=face[i].x1;}
if(xmax<face[i].x2){xmax=face[i].x2;}
if(xmax<face[i].x3){xmax=face[i].x3;}

if(ymin>face[i].y1){ymin=face[i].y1;}
if(ymin>face[i].y2){ymin=face[i].y2;}
if(ymin>face[i].y3){ymin=face[i].y3;}
if(ymax<face[i].y1){ymax=face[i].y1;}
if(ymax<face[i].y2){ymax=face[i].y2;}
if(ymax<face[i].y3){ymax=face[i].y3;}

if(zmin>face[i].z1){zmin=face[i].z1;}
if(zmin>face[i].z2){zmin=face[i].z2;}
if(zmin>face[i].z3){zmin=face[i].z3;}
if(zmax<face[i].z1){zmax=face[i].z1;}
if(zmax<face[i].z2){zmax=face[i].z2;}
if(zmax<face[i].z3){zmax=face[i].z3;}
}

lenx=xmax-xmin;
leny=ymax-ymin;
lenz=zmax-zmin;
objs->xcen=(xmax+xmin)/2;
objs->ycen=(ymax+ymin)/2;
objs->zcen=(zmax+zmin)/2;
objs->radius=sqrt(lenx*lenx+leny*leny+lenz*lenz)/2;
objs->xmin=xmin-0.2;
objs->ymin=ymin-0.2;
objs->zmin=zmin-0.2;
objs->xmax=xmax+0.8;
objs->ymax=ymax+0.2;
objs->zmax=zmax+0.2;
}


/*function which reads file *fis; nrob - number of objects*/
sgob *citfiscom(char *numefis,int *nrobt,int *nrtyp,pixcol *backcol,int *ncars,REALN *carspeed)
{int err,lincr=1; /*lincr-linia curenta*/
char s[MAXWLG]; /*un cuvant*/
FILE *fis;
int i,j,
    nto=0,nob=0, /*number of object types and number of objects; nob=(*nrob) */
    bred=130,bgreen=160,bblue=200; /*background color*/
sgob *objs,objtmp;
REALN tx,ty,tz,rx,ry,rz, /*initial translations and rotations of the object*/
      fred=1.0,fgreen=1.0,fblue=1.0; /*color multiplication factors*/

objs=&objtmp; /*ca sa nu "warning"*/


  if(!(fis=fopen(numefis,"r"))){printf("Error: File %s could not be open\r\n",numefis);exit(1);}
s[0]='1';while(s[0]){
	if(!(err=fisgetw(fis,s,&lincr))){afermex(numefis,lincr,s,1);}

	switch(identcom(s)){
	  case 3: err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); bred=atoi(s);
	          err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); bgreen=atoi(s);
	          err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); bblue=atoi(s);
	          break;

	  case 4: err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); fred=atof(s);
	          err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); fgreen=atof(s);
	          err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); fblue=atof(s);
	          break;

	  case 5: err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); (*ncars)=atoi(s);
	          err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); (*carspeed)=atof(s);
	          break;


	  case 1: err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); (*nrtyp)=nto=atoi(s);
	          if(!(fceglob=(tria **)malloc((nto+1)*sizeof(tria *)))){printf("Out of memory");}
	          if(!(refglob=(refpo *)malloc((nto+1)*sizeof(refpo)))){printf("Out of memory");}
	          for(i=1;i<=nto;i++){
	            err=fisgetw(fis,s,&lincr); /*file with triangles*/
	            refglob[i].nfa=findnf(s);
	            if(!(fceglob[i]=(tria *)malloc((refglob[i].nfa+1)*sizeof(tria)))){printf("Out of memory");}
	            faces(fceglob[i],s);
	              err=fisgetw(fis,s,&lincr); /*file with colors*/
	              readcolor(fceglob[i],refglob[i].nfa,s);
	            err=fisgetw(fis,s,&lincr); /*file with reference points*/
	            refglob[i].nref=findnref(s);
	            readref(refglob[i].x,refglob[i].y,refglob[i].z,s);
	              err=fisgetw(fis,s,&lincr); /*file with data for backface culling*/
	              ordercl(fceglob[i],s);
	          }
	          break;

	  case 2: err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); (*nrobt)=nob=atoi(s);
	          if(!(objs=(sgob *)malloc((nob+1)*sizeof(sgob)))){printf("Out of memory");}
	          for(i=1;i<=nob;i++){
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0);
	              objs[i].otyp=atoi(s);
	              if(objs[i].otyp>nto){
	                printf("Error: there is no object type '%d'\r\n",objs[i].otyp);exit(1);
	              }
	              objs[i].nref=refglob[objs[i].otyp].nref;
	              objs[i].nfa=refglob[objs[i].otyp].nfa;
	              objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0;
	              objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
	              objs[i].vx[2]=objs[i].vx[3]=0;
	              objs[i].vy[1]=objs[i].vy[3]=0;
	              objs[i].vz[1]=objs[i].vz[2]=0;
	              for(j=1;j<=objs[i].nref;j++){
	                objs[i].xref[j]=refglob[objs[i].otyp].x[j];
	                objs[i].yref[j]=refglob[objs[i].otyp].y[j];
	                objs[i].zref[j]=refglob[objs[i].otyp].z[j];
	              }
	              eval_obj(fceglob[objs[i].otyp],&objs[i]);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); tx=atof(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); ty=atof(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); tz=atof(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); rz=atof(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); ry=atof(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,2); rx=atof(s);
	              rotatz(&objs[i],0,0,rz);
	              rotaty(&objs[i],0,0,ry);
	              rotatx(&objs[i],0,0,rx);
	              translat(&objs[i],tx,ty,tz);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); objs[i].lev=atoi(s);
	            err=fisgetw(fis,s,&lincr);afermex(numefis,lincr,s,0); objs[i].mob=atoi(s);
	          }
	          break; 
	
	  default: if(s[0]){printf("Error: '%s' line %d - word '%s' not recognized\r\n",numefis,lincr,s);exit(1);}
	}
}
fclose(fis);

for(i=1;i<=nto;i++){
  for(j=1;j<=refglob[i].nfa;j++){
    fceglob[i][j].red*=fred; if(fceglob[i][j].red>255){fceglob[i][j].red=255;}
    fceglob[i][j].green*=fgreen; if(fceglob[i][j].green>255){fceglob[i][j].green=255;}
    fceglob[i][j].blue*=fblue; if(fceglob[i][j].blue>255){fceglob[i][j].blue=255;}
  }
}

backcol->red=bred; backcol->green=bgreen; backcol->blue=bblue;

return objs;}
