#include <stdio.h>
#include <stdlib.h>


void printgr(int *gr){
  int i;

  printf("+-+-+-+-+-+-+-+-+-+\r\n");
  for(i=0;i<81;i++){
    if(gr[i]!=0){printf("|%d",gr[i]);}else{printf("| ");}
    if(i%9==8){printf("|\r\n");}
  }
  printf("+-+-+-+-+-+-+-+-+-+\r\n");
}


int sqcheck(int *gr,int sq,int num){
  int i,j,t1,t2,t3;

  t1=sq/9; /*line*/
  t2=t1*9;
  t3=sq%9; /*col.*/
  for(i=0;i<9;i++){
    if((num==gr[t2+i])&&(i!=t3)){return 0;}
    if((num==gr[i*9+t3])&&(i!=t1)){return 0;}
  }

  t1=(t1/3)*3;
  t2=(t3/3)*3;
  for(i=t1;i<(t1+3);i++){
    for(j=t2;j<(t2+3);j++){
      if((num==gr[i*9+j])&&(sq!=(i*9+j))){return 0;}
    }
  }
  return 1;
}


void sdsolve(int *gr,int sq);

void sdsolve(int *gr,int sq){
  int i;
  if(gr[sq]==0){
    for(i=1;i<=9;i++){
      if(sqcheck(gr,sq,i)){
        gr[sq]=i;
        if(sq<80){
          sdsolve(gr,sq+1);
        }else{
          printgr(gr);
        }
      }
    }
    gr[sq]=0;
  }else{
    if(sq<80){
      sdsolve(gr,sq+1);
    }else{
      printgr(gr);
    }
  }
}


int main(int argc,char *argv[]){
  char a;
  int i,gr[81];
  FILE *f;

  if(argc<2){
    printf("Input file not declared. Example:\r\n");
    printf("%s file\r\n",argv[0]);
    exit(1);
  }

  if(argc>2){printf("Too many parameters\r\n"); exit(1);}

  if(!(f=fopen(argv[1],"r"))){
    printf("File '%s' error\r\n",argv[1]); exit(1);
  }
  i=0;
  while(!feof(f)){
    a=getc(f);
    if((a>='0')&&(a<='9')){gr[i]=a-'0'; i++;}
    if(i==81){break;}
  }
  fclose(f);
  if(i<81){printf("File '%s' too short\r\n",argv[1]); exit(1);}

  printgr(gr);

  sdsolve(gr,0);

  return 0;
}
