/*
Copyright (C) 2013 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


typedef struct _piece{
char col; /*colour: 'b','w','0'*/
char tc; /*type: 'p','n','b','r','q','k','0'*/
int value;
short int flag; /*pawn: 0-can move 2 sq.,1-can be captured en pass.,>=2-else*/
           /*king and rook: 0-can castle,>=1-can not*/
} piece;


typedef struct _pcmove{
short int np; /*(nr. of pieces moved)-1*/
short int start[5]; /*start square*/
short int dest[5]; /*destination square*/
} pcmove;


typedef struct _board{
piece pc[65];
char turn; /*'w'-white to move; 'b'-black to move*/
pcmove mv[256]; /*possible moves*/
int nmoves; /*(nr. of possible moves)-1*/
short int enpas; /*square with pawn which can be killed en pas.*/
} board;


/*initialize random numbers*/
void inrnd()
{int i,t;
t=time(NULL); if(t<0){t=-t;} t=t%16384;
for(i=1;i<=t;i++){
  rand();
}
}


/*random number between a and b*/
int rndl(int a,int b)
{int x;
if(b<a){x=a; a=b; b=x;}
x=rand();
x=a+x%(b-a+1);
return x;}


int tcval(char a)
{
switch(a){
  case 'p': return 1;
  case 'n': return 3;
  case 'b': return 3;
  case 'r': return 5;
  case 'q': return 9;
  case 'k': return 1000;
  default: return 0;
}
} /*returns value of piece*/


int cvletter(char a)
{
switch(a){
  case 'a':
  case '1': return 1;
  case 'b':
  case '2': return 2;
  case 'c':
  case '3': return 3;
  case 'd':
  case '4': return 4;
  case 'e':
  case '5': return 5;
  case 'f':
  case '6': return 6;
  case 'g':
  case '7': return 7;
  case 'h':
  case '8': return 8;
  default: return 1;
}
}


void setboard(board *bd)
{int i;
piece *pc;
pc=&(bd->pc[1]); pc->col='w'; pc->tc='r'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[2]); pc->col='w'; pc->tc='n'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[3]); pc->col='w'; pc->tc='b'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[4]); pc->col='w'; pc->tc='q'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[5]); pc->col='w'; pc->tc='k'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[6]); pc->col='w'; pc->tc='b'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[7]); pc->col='w'; pc->tc='n'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[8]); pc->col='w'; pc->tc='r'; pc->value=tcval(pc->tc); pc->flag=0;
for(i=9;i<=16;i++){
  pc=&(bd->pc[i]); pc->col='w'; pc->tc='p'; pc->value=tcval(pc->tc); pc->flag=0;
}
for(i=17;i<=48;i++){
  pc=&(bd->pc[i]); pc->col='0'; pc->tc='0'; pc->value=tcval(pc->tc); pc->flag=0;
}
for(i=49;i<=56;i++){
  pc=&(bd->pc[i]); pc->col='b'; pc->tc='p'; pc->value=tcval(pc->tc); pc->flag=0;
}
pc=&(bd->pc[57]); pc->col='b'; pc->tc='r'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[58]); pc->col='b'; pc->tc='n'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[59]); pc->col='b'; pc->tc='b'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[60]); pc->col='b'; pc->tc='q'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[61]); pc->col='b'; pc->tc='k'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[62]); pc->col='b'; pc->tc='b'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[63]); pc->col='b'; pc->tc='n'; pc->value=tcval(pc->tc); pc->flag=0;
pc=&(bd->pc[64]); pc->col='b'; pc->tc='r'; pc->value=tcval(pc->tc); pc->flag=0;

bd->turn='w';
bd->enpas=0;
}


/*check whether a piece of colour other than col can move to square n1,
assuming n1 is empty*/
int checkthr(board *bd,int n1,char col)
{int j,n2,i1,j1,i2,j2,di,dj;
  i1=(n1-1)/8+1; j1=(n1-1)%8+1;
  for(j=1;j<=4;j++){ /*check for tower or queen*/
    switch(j){
      case 1: di=0; dj=1; break;
      case 2: di=0; dj=-1; break;
      case 3: di=1; dj=0; break;
      case 4: di=-1; dj=0; break;
      default: di=0; dj=0; break;
    }
    i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
    while(((bd->pc[n2].col)!=col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
      if((bd->pc[n2].col)!='0'){
        if(((bd->pc[n2].col)==col)||(((bd->pc[n2].tc)!='r')&&((bd->pc[n2].tc)!='q'))){break;}
        if(((bd->pc[n2].tc)=='r')||((bd->pc[n2].tc)=='q')){return 1;}
      }
      i2+=di; j2+=dj; n2=(i2-1)*8+j2;
    }
  }
  for(j=1;j<=4;j++){ /*check for bishop or queen*/
    switch(j){
      case 1: di=1; dj=1; break;
      case 2: di=1; dj=-1; break;
      case 3: di=-1; dj=1; break;
      case 4: di=-1; dj=-1; break;
      default: di=0; dj=0; break;
    }
    i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
    while(((bd->pc[n2].col)!=col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
      if((bd->pc[n2].col)!='0'){
        if(((bd->pc[n2].col)==col)||(((bd->pc[n2].tc)!='b')&&((bd->pc[n2].tc)!='q'))){break;}
        if(((bd->pc[n2].tc)=='b')||((bd->pc[n2].tc)=='q')){return 1;}
      }
      i2+=di; j2+=dj; n2=(i2-1)*8+j2;
    }
  }
  for(j=1;j<=8;j++){ /*check for horse*/
    switch(j){
      case 1: di=1; dj=2; break;
      case 2: di=1; dj=-2; break;
      case 3: di=-1; dj=2; break;
      case 4: di=-1; dj=-2; break;
      case 5: di=2; dj=1; break;
      case 6: di=2; dj=-1; break;
      case 7: di=-2; dj=1; break;
      case 8: di=-2; dj=-1; break;
      default: di=0; dj=0; break;
    }
    i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
    if(((bd->pc[n2].col)!=col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
      if((bd->pc[n2].col)!='0'){
        if(((bd->pc[n2].tc)=='n')){return 1;}
      }
    }
  }
  for(j=1;j<=8;j++){ /*check for sultan*/
    switch(j){
      case 1: di=1; dj=1; break;
      case 2: di=1; dj=0; break;
      case 3: di=1; dj=-1; break;
      case 4: di=0; dj=-1; break;
      case 5: di=-1; dj=-1; break;
      case 6: di=-1; dj=0; break;
      case 7: di=-1; dj=1; break;
      case 8: di=0; dj=1; break;
      default: di=0; dj=0; break;
    }
    i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
    if(((bd->pc[n2].col)!=col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
      if((bd->pc[n2].col)!='0'){
        if(((bd->pc[n2].tc)=='k')){return 1;}
      }
    }
  }
  for(j=1;j<=2;j++){ /*check for pawn*/
    if(col=='b'){switch(j){
      case 1: di=-1; dj=1; break;
      case 2: di=-1; dj=-1; break;
      default: di=0; dj=0; break;
    }}
    if(col=='w'){switch(j){
      case 1: di=1; dj=1; break;
      case 2: di=1; dj=-1; break;
      default: di=0; dj=0; break;
    }}
    i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
    if(((bd->pc[n2].col)!=col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
      if((bd->pc[n2].col)!='0'){
        if(((bd->pc[n2].tc)=='p')){return 1;}
      }
    }
  }
return 0;
}


void printthr(board *bd,char col)
{int i,j;
for(i=8;i>=1;i--){
  for(j=1;j<=8;j++){
    printf("%d ",checkthr(bd,(i-1)*8+j,col));
  } printf("\r\n");
}
}


/*finds all possible moves*/
void findmoves(board *bd)
{int i,j,i1,j1,i2,j2,n1,n2,di,dj;
piece *pc;
pcmove *mv;

bd->nmoves=-1; /*first move is 0*/

for(i=1;i<=64;i++){
  pc=&(bd->pc[i]);
  if((pc->col)==(bd->turn)){
    switch(pc->tc){
      case 'p':
        switch(pc->col){
          case 'w':
            if(bd->pc[i+8].tc=='0'){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0; /*1 piece moved*/
              mv->start[0]=i; mv->dest[0]=i+8;
              if(((pc->flag)==0)&&(bd->pc[i+16].tc=='0')){
                (bd->nmoves)++;
                mv=&(bd->mv[bd->nmoves]);
                mv->np=0;
                mv->start[0]=i; mv->dest[0]=i+16;
              }
            }
            if((((i-1)%8+1)>=2)&&(bd->pc[i+7].col=='b')){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0;
              mv->start[0]=i; mv->dest[0]=i+7;
            }
            if((((i-1)%8+1)<=7)&&(bd->pc[i+9].col=='b')){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0;
              mv->start[0]=i; mv->dest[0]=i+9;
            }
            /*en pas.*/
            if((((i-1)%8+1)>=2)&&(bd->pc[i-1].col=='b')&&((bd->enpas)==(i-1))){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=1;
              mv->start[0]=i; mv->dest[0]=i+7;
              mv->start[1]=i; mv->dest[1]=i-1;
            }
            if((((i-1)%8+1)<=7)&&(bd->pc[i+1].col=='b')&&((bd->enpas)==(i+1))){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=1;
              mv->start[0]=i; mv->dest[0]=i+9;
              mv->start[1]=i; mv->dest[1]=i+1;
            }
            /*en pas.^*/
          break; /*moves of white pawn*/

          case 'b':
            if(bd->pc[i-8].tc=='0'){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0;
              mv->start[0]=i; mv->dest[0]=i-8;
              if(((pc->flag)==0)&&(bd->pc[i-16].tc=='0')){
                (bd->nmoves)++;
                mv=&(bd->mv[bd->nmoves]);
                mv->np=0;
                mv->start[0]=i; mv->dest[0]=i-16;
              }
            }
            if((((i-1)%8+1)>=2)&&(bd->pc[i-9].col=='w')){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0;
              mv->start[0]=i; mv->dest[0]=i-9;
            }
            if((((i-1)%8+1)<=7)&&(bd->pc[i-7].col=='w')){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=0;
              mv->start[0]=i; mv->dest[0]=i-7;
            }
            /*en pas.*/
            if((((i-1)%8+1)>=2)&&(bd->pc[i-1].col=='w')&&((bd->enpas)==(i-1))){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=1;
              mv->start[0]=i; mv->dest[0]=i-9;
              mv->start[1]=i; mv->dest[1]=i-1;
            }
            if((((i-1)%8+1)<=7)&&(bd->pc[i+1].col=='w')&&((bd->enpas)==(i+1))){
              (bd->nmoves)++;
              mv=&(bd->mv[bd->nmoves]);
              mv->np=1;
              mv->start[0]=i; mv->dest[0]=i-7;
              mv->start[1]=i; mv->dest[1]=i+1;
            }
            /*en pas.^*/
          break; /*moves of black pawn*/
        }
      break;

      case 'q':
        n1=i; i1=(n1-1)/8+1; j1=(n1-1)%8+1;
        for(j=1;j<=8;j++){
          switch(j){
            case 1: di=1; dj=1; break;
            case 2: di=1; dj=0; break;
            case 3: di=1; dj=-1; break;
            case 4: di=0; dj=-1; break;
            case 5: di=-1; dj=-1; break;
            case 6: di=-1; dj=0; break;
            case 7: di=-1; dj=1; break;
            case 8: di=0; dj=1; break;
            default: di=0; dj=0; break;
          }
          i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
          while(((bd->pc[n2].col)!=pc->col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
            (bd->nmoves)++;
            mv=&(bd->mv[bd->nmoves]);
            mv->np=0;
            mv->start[0]=n1; mv->dest[0]=n2;
            if((bd->pc[n2].col)!='0'){break;}
            i2+=di; j2+=dj; n2=(i2-1)*8+j2;
          }
        }
      break;

      case 'r':
        n1=i; i1=(n1-1)/8+1; j1=(n1-1)%8+1;
        for(j=1;j<=4;j++){
          switch(j){
            case 1: di=0; dj=1; break;
            case 2: di=0; dj=-1; break;
            case 3: di=1; dj=0; break;
            case 4: di=-1; dj=0; break;
            default: di=0; dj=0; break;
          }
          i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
          while(((bd->pc[n2].col)!=pc->col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
            (bd->nmoves)++;
            mv=&(bd->mv[bd->nmoves]);
            mv->np=0;
            mv->start[0]=n1; mv->dest[0]=n2;
            if((bd->pc[n2].col)!='0'){break;}
            i2+=di; j2+=dj; n2=(i2-1)*8+j2;
          }
        }
      break;

      case 'b':
        n1=i; i1=(n1-1)/8+1; j1=(n1-1)%8+1;
        for(j=1;j<=4;j++){
          switch(j){
            case 1: di=1; dj=1; break;
            case 2: di=1; dj=-1; break;
            case 3: di=-1; dj=1; break;
            case 4: di=-1; dj=-1; break;
            default: di=0; dj=0; break;
          }
          i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
          while(((bd->pc[n2].col)!=pc->col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
            (bd->nmoves)++;
            mv=&(bd->mv[bd->nmoves]);
            mv->np=0;
            mv->start[0]=n1; mv->dest[0]=n2;
            if((bd->pc[n2].col)!='0'){break;}
            i2+=di; j2+=dj; n2=(i2-1)*8+j2;
          }
        }
      break;

      case 'n':
        n1=i; i1=(n1-1)/8+1; j1=(n1-1)%8+1;
        for(j=1;j<=8;j++){
          switch(j){
            case 1: di=1; dj=2; break;
            case 2: di=1; dj=-2; break;
            case 3: di=-1; dj=2; break;
            case 4: di=-1; dj=-2; break;
            case 5: di=2; dj=1; break;
            case 6: di=2; dj=-1; break;
            case 7: di=-2; dj=1; break;
            case 8: di=-2; dj=-1; break;
            default: di=0; dj=0; break;
          }
          i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
          if(((bd->pc[n2].col)!=pc->col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
            (bd->nmoves)++;
            mv=&(bd->mv[bd->nmoves]);
            mv->np=0;
            mv->start[0]=n1; mv->dest[0]=n2;
          }
        }
      break;

      case 'k':
        n1=i; i1=(n1-1)/8+1; j1=(n1-1)%8+1;
        for(j=1;j<=8;j++){
          switch(j){
            case 1: di=1; dj=1; break;
            case 2: di=1; dj=0; break;
            case 3: di=1; dj=-1; break;
            case 4: di=0; dj=-1; break;
            case 5: di=-1; dj=-1; break;
            case 6: di=-1; dj=0; break;
            case 7: di=-1; dj=1; break;
            case 8: di=0; dj=1; break;
            default: di=0; dj=0; break;
          }
          i2=i1+di; j2=j1+dj; n2=(i2-1)*8+j2;
          if(((bd->pc[n2].col)!=pc->col)&&(i2>=1)&&(i2<=8)&&(j2>=1)&&(j2<=8)){
            (bd->nmoves)++;
            mv=&(bd->mv[bd->nmoves]);
            mv->np=0;
            mv->start[0]=n1; mv->dest[0]=n2;
          }
        }

        /*king over rook, bottom right*/
        if((checkthr(bd,n1,'w')==0)&&(pc->flag==0)&&(bd->pc[8].flag==0)&&(bd->pc[6].tc=='0')&&(bd->pc[7].tc=='0')&&(checkthr(bd,6,'w')==0)&&(checkthr(bd,7,'w')==0)){
          (bd->nmoves)++;
          mv=&(bd->mv[bd->nmoves]);
          mv->np=1;
          mv->start[0]=n1; mv->dest[0]=7;
          mv->start[1]=8; mv->dest[1]=6;
        }
        /*king over rook, bottom left*/
        if((checkthr(bd,n1,'w')==0)&&(pc->flag==0)&&(bd->pc[1].flag==0)&&(bd->pc[2].tc=='0')&&(bd->pc[3].tc=='0')&&(bd->pc[4].tc=='0')&&(checkthr(bd,3,'w')==0)&&(checkthr(bd,4,'w')==0)){
          (bd->nmoves)++;
          mv=&(bd->mv[bd->nmoves]);
          mv->np=1;
          mv->start[0]=n1; mv->dest[0]=3;
          mv->start[1]=1; mv->dest[1]=4;
        }
        /*king over rook, top right*/
        if((checkthr(bd,n1,'b')==0)&&(pc->flag==0)&&(bd->pc[64].flag==0)&&(bd->pc[62].tc=='0')&&(bd->pc[63].tc=='0')&&(checkthr(bd,62,'b')==0)&&(checkthr(bd,63,'b')==0)){
          (bd->nmoves)++;
          mv=&(bd->mv[bd->nmoves]);
          mv->np=1;
          mv->start[0]=n1; mv->dest[0]=63;
          mv->start[1]=64; mv->dest[1]=62;
        }
        /*king over rook, top left*/
        if((checkthr(bd,n1,'b')==0)&&(pc->flag==0)&&(bd->pc[57].flag==0)&&(bd->pc[58].tc=='0')&&(bd->pc[59].tc=='0')&&(bd->pc[60].tc=='0')&&(checkthr(bd,59,'b')==0)&&(checkthr(bd,60,'b')==0)){
          (bd->nmoves)++;
          mv=&(bd->mv[bd->nmoves]);
          mv->np=1;
          mv->start[0]=n1; mv->dest[0]=59;
          mv->start[1]=57; mv->dest[1]=60;
        }
      break;

    }
  }
}

}


void mkmove(board *bd,pcmove *mv)
{int i;
piece *pc;
for(i=0;i<=(mv->np);i++){
  pc=&(bd->pc[mv->start[i]]);
  bd->pc[mv->dest[i]]=(*pc);
  (bd->pc[mv->dest[i]].flag)++;

  /*pawn promotion*/
  if(((pc->tc)=='p')&&((pc->col)=='w')&&((mv->dest[i])>=57)){
    bd->pc[mv->dest[i]].tc='q'; bd->pc[mv->dest[i]].value=tcval('q');
  }
  if(((pc->tc)=='p')&&((pc->col)=='b')&&((mv->dest[i])<=8)){
    bd->pc[mv->dest[i]].tc='q'; bd->pc[mv->dest[i]].value=tcval('q');
  }
  /*pawn promotion^*/

  /*set en pas. square*/
  bd->enpas=0;
  if(((pc->tc)=='p')&&((pc->col)=='w')&&((mv->dest[i])>=25)&&((mv->dest[i])<=32)&&(pc->flag==0)){
    bd->enpas=mv->dest[i];
  }
  if(((pc->tc)=='p')&&((pc->col)=='b')&&((mv->dest[i])>=33)&&((mv->dest[i])<=40)&&(pc->flag==0)){
    bd->enpas=mv->dest[i];
  }
  /*set en pas. square^*/

  pc->col='0'; pc->tc='0'; pc->value=0; pc->flag=1;
}
if((bd->turn)=='w'){bd->turn='b';}else{bd->turn='w';}
}


/*return 1 if 2 moves are identical and 0 if not*/
int compmv(pcmove *mv1,pcmove *mv2)
{int i;
i=0; /*only first piece checked*/
  if((mv1->start[i])!=(mv2->start[i])){return 0;}
  if((mv1->dest[i])!=(mv2->dest[i])){return 0;}
return 1;
}


/*make move and return 1 if move possible, return 0 if not*/
int txmove(board *bd,char *s)
{int i1,i2,j1,j2;
pcmove mv;
j1=cvletter(s[0]); i1=cvletter(s[1]); j2=cvletter(s[2]); i2=cvletter(s[3]);
mv.np=0;
mv.start[0]=(i1-1)*8+j1;
mv.dest[0]=(i2-1)*8+j2;

findmoves(bd);
i2=0;
for(i1=0;i1<=(bd->nmoves);i1++){
  if(compmv(&mv,&(bd->mv[i1]))==1){mv=bd->mv[i1]; i2=1; break;}
}

if(i2==1){mkmove(bd,&mv);}
return i2;
}


/*print all possible moves*/
void printmoves(board *bd)
{int i,j;
pcmove *mv;
for(i=0;i<=(bd->nmoves);i++){
  printf("%d: ",i);
  mv=&(bd->mv[i]);
  for(j=0;j<=(mv->np);j++){
    printf("%d - %d, ",mv->start[j],mv->dest[j]);
  } printf("\r\n");
}
}


/*shuffle moves*/
void shufmv(board *bd)
{int i,r;
pcmove imove;
for(i=0;i<=(bd->nmoves);i++){
  r=rndl(i,bd->nmoves);
  imove=bd->mv[i];
  bd->mv[i]=bd->mv[r];
  bd->mv[r]=imove;
}
}


/*find good move for colour 'col'*/
int findgmove(board *bd,char col,int level,int val2mtr);

int findgmove(board *bd,char col,int level,int val2mtr)
{int i,val,val2,val2max;
board bd2;

if(level!=0){findmoves(bd);}

if((level==0)||(bd->nmoves==(-1))){
  val2=0; /*becomes 1 if king of colour col is found*/
  for(i=1;i<=64;i++){
    if(((bd->pc[i].col)==col)&&((bd->pc[i].tc)=='k')){val2=1; break;}
  }
  if(val2==0){return(-2*tcval('k'));}
  /*if king not present, return very low value*/

  val=0;
  for(i=1;i<=64;i++){
    if((bd->pc[i].col)==col){val+=(bd->pc[i].value);}
    if(((bd->pc[i].col)!=col)&&((bd->pc[i].col)!='0')){val-=(bd->pc[i].value);}
  }
return val;
}

shufmv(bd);

if(bd->turn==col){val2max=-8*tcval('k');}else{val2max=8*tcval('k');}
for(i=0;i<=(bd->nmoves);i++){
  bd2=(*bd);
  mkmove(&bd2,&(bd2.mv[i]));
  val2=findgmove(&bd2,col,level-1,val2max);
  if(bd->turn==col){
    if(val2>val2max){val2max=val2; bd->mv[(bd->nmoves)+1]=bd->mv[i];}
    if(val2>=val2mtr){break;}
  }else{
    if(val2<val2max){val2max=val2;}
    if(val2<=val2mtr){break;}
  }
}

return val2max;

}


/*the above function checks level moves ahead and does not
give right result if king is lost in <(level-2) moves*/
void findgmv2(board *bd,char col,int level,int val2mtr)
{int val,lev2;
lev2=level;
val=findgmove(bd,col,lev2,val2mtr);
while((val==(-2*tcval('k')))&&(lev2>=3)){
  lev2--;
  val=findgmove(bd,col,lev2,val2mtr);
}
}


/*make move and verify if the king will be captured at the next move
then move not permitted*/
int ismvchk(board *bd,char *s)
{int i1,j1,i2,j2,val;
board bd2;
pcmove mv;

j1=cvletter(s[0]); i1=cvletter(s[1]); j2=cvletter(s[2]); i2=cvletter(s[3]);
mv.np=0;
mv.start[0]=(i1-1)*8+j1;
mv.dest[0]=(i2-1)*8+j2;

bd2=(*bd);
mkmove(&bd2,&mv);
val=findgmove(&bd2,bd2.turn,1,8*tcval('k'));
mkmove(&bd2,&(bd2.mv[(bd2.nmoves)+1]));
val=findgmove(&bd2,bd2.turn,0,8*tcval('k'));
if((bd2.nmoves)==(-1)){
  return 1;
}else{
  if (val==(-2*tcval('k'))){return 1;}else{return 0;}
}
}


/*check check*/
int ischeck(board *bd)
{int i;
for(i=1;i<=64;i++){
  if(((bd->pc[i].tc)=='k')&&((bd->pc[i].col)==(bd->turn))){break;}
}
return checkthr(bd,i,bd->turn);
}


/*check mate*/
int ismate(board *bd)
{int val;
val=findgmove(bd,bd->turn,2,8*tcval('k'));
if (val==(-2*tcval('k'))){return 1;}else{return 0;}
}
