//universally compatible GLUT&openGL  version (compilable for Win, Linux, Mac) - can be readily compiled for each.
//Realistic vehicle simulator with GTA-like and STUNTS-like environment : CSTUNTS by Simon Hasur 
//Very similar to the classic "Terep2" in the simulation of the  carbody-ammortizers-tyres  physical system, and vaguely in appearence, but it adds many more features, although aintaining a minimalist approach... all and only the features necessary to make a cool driving simulation. 
//Physics Note: rigid-body model is used, the seme as in CTruck2D, 3D.


/* 
on Linux systems compile with command: gcc CTruck3D_Simplex.c -lm -lglut -lGLU 
or for the multi-sourcefle version:
gcc main.c vcalc.h game_terrain.c -lm -lglut -lGLU
there's a makefile so... under Linux /Unix systems it's no problem.
*/

/*=====================|SDL CODE BLOCK 1|============================*/
#include <SDL/SDL.h>

// horizional resolution to which to force A, B resolution, typically 320x240
#define WIDTH  620 

// vertical resolution
#define HEIGHT  400 
#define COLDEPTH 16 
// #define SCREEN_DEPTH  8 
SDL_Surface *screen ;

// SUPERSAFE TOOK IT FROM PROFESSIONAL SITE: used for bitmap conversion to RGB value matrix (usual stuff)
Uint32 getpixel( SDL_Surface *surface, int x, int y ) ;




#include <GL/gl.h>
#include <GL/glu.h>

// #include <GL/glut.h>




#include <time.h>
#include <stdio.h>
#include <math.h>

/* include also the string handling library because it is necessary for titles. */
#include <string.h>
#include <stdlib.h>

//==MY=LIBS==OLD=METHOD!!==

// custom car vertec and triangulation reading from file.

// 2 simple short funcitons to read a file and transfer numbers converting to float into an array .
#include "readfile.h" 



#include "game_terrain.h" //this already includes also the vcalc.h for those tructures like 'vect_data' and 'mat3x3'....
// #include "vcalc.h"


const int   A = WIDTH ;  /* length x of a side of the monitor window */
const int   B = HEIGHT ;  /* length y of a side of the monitor window */

float fovv = 0.4 ;

/* position of hero */
double smilzo_x = 1800.0 ;
double smilzo_y = 30.0   ;
double smilzo_z = 1200.0 ;

// char message[60] = "#: WILL RECEIVE INSTRUCTIONS/HELP HERE..." ;

int follow_mode_switch = 1 ; 
int in_vehicle = 1 ;

int gas = 0, s_right = 0 , s_left = 0, gas_reverse = 0 ; // used for main car-handling stuff, to detect simulataneous key-presses.



int ngon_min = 22 ; // NEW: only in multi-vertex versions. IronSmilzo3D:GTA_Military   in pre-release state.



int draw_at_cycle = 2 ;
int draw_cycle = 0 ;





/* a generic polyhedron defined by it's vertexes' positions and a triangulation or tetrahedrization or nothingor whatever */
struct building_def {
int   n_vertexes     ; // remeber to assign it some value befoe using it!!!
	
int   ngonn          ;
float vertexes[8][3] ;
int   polygons[8][4] ;

/* versors of the 3 axes of the reference system with respect to which the vetexes are given*/
float Xc[3], Yc[3], Zc[3] ;
float th, fi, psi ; /*if enriched spherical coordinates are used for dfining orientation, one can give them here... since at some point before startng using the axes, they must heve been given... so... . */	
} ;


#define NBTYPE 5 
 
struct buildings { 
/* various notes: ... */
	int map[300][300] ; // CAREFUL!!! 
        int nbtype ;
	/* box-shaped buildings */
        struct building_def  building[NBTYPE] ; // vertex coordinates: shape definition

        /* utility for oriented-box -shaped things (houses or so...): */
	float Lx[NBTYPE], Ly[NBTYPE], Lz[NBTYPE] ; // (lenghts of each side)/2   
	float th[NBTYPE], fi[NBTYPE] ;
	float frc[NBTYPE] ; // approximative friction coefficient **WHEN VERTEX TOUCHES**, NO THE WHEEL!!!!!.	

        /* cilynders */
	float R ;

	int poscorrect_allowed[NBTYPE] ;
} ;

struct buildings  stunts ; 




void myinit(void) ;

void no_keyhit_glut(void) ;
void init_simulator(void) ;




//AUTO INDEXING CONSTANTS:
//number of polyhedra in simualator progr: in CTruck3D_Simplex, someof these may be just used as 'pictures' or better decorative polyhedra - not physically simulated. 
//the bodies are: tractor car, trailer, biril 1, biril 2 ; the birils are not necessary, you can set nPOLY to 2 and they will not be in game anymore.
#define nPOLY 3    
//number of sides of polyedra in whc cicle (like basketball)'s approx.
#define ngon 100     
//number of springs applied to some vertex pairs.
#define nsprings 1  
// NOT USED IN THIS GAME!!!

//int RPOLY = 1 ; //number of physically simualted polyhedra: the first one must be those which are physically simulated!!! .


/*=============================SIMPLEX PECULIARITY==============================*/
/* number of virtual springs, sorts of pillows that sustan polyhedron. 
ONLY MULTIPLESOF 4!!! SEGDFAULTS MAY HAPPEN OTHERWISE BECAUSE OF... (SEE ELSEWHERE IN CODE) */
#define NPILLOW 12

int pillowvx[NPILLOW][2] = {
/* [n_of_body] [n_of_vertex]*/

/* ON MAIN CAR */
{0,0},
{0,1},
{0,2},
{0,3},

/* ON TRAILER */
{1, 16},
{1, 17},
{1, 18},
{1, 19},

/*ON AIRPLANE */
{2, 30},
{2, 31},
{2, 32},
{2, 33}
} ;


/* pressing the 't' button, that vertex will be highlighted which has cardinal number testindex. */
int testindex = 0 ;
int test_tri = 0 ;

/* triangularisation of car-polthedron */
#define CARTRI 21
#define SUPER_TRI 61

int car_tri[SUPER_TRI][3] = {  //READ FORM EXTERNAL txt FILE.
{ 11 , 18, 19 },  
{ 17, 18, 19 }, 
{ 5, 16, 18 },
{ 5, 9, 18 },
{ 17, 4, 16 },
{ 5, 4, 16 },
{16 , 17, 18 },
{11, 12 , 18 },
{7, 8, 13 },
{7,15,14},
{7,13,14},
{9,13,14},
{19,8,17},
{4,8,17},
{ 8,9,13 },
{4,8,17},
{5,4,8},
{5,8,9},
{9,14,15},
{7,11,21},   // SEGMENT DRAWN AS COLLAPSED TRIANGLE!!!!!!
{15,12,20 }  // SEGMENT DRAWN AS COLLAPSED TRIANGLE!!!!!!
            } ;
/*==============================================================================*/

float car_tricolor[SUPER_TRI][3] = {  //NOT USED, READ FORM EXTERNAL TXT FILE:..
{ 0.9, 0.0, 0.0 },  
{ 0.0, 0.0, 1.0 }, 

{ 0.0, 0.0, 0.5 }, /* right side/door, downer tri */
{ 0.0, 0.0, 0.4 }, /* right side/door, upper tri */

{ 0.1, 0.1, 0.1 }, /* base piece 1*/

{ 0.05, 0.1, 0.1 }, /* base piece 2*/

{0.0 , 0.1, 1.0 },

{0.8, 0.0 , 0.0 }, /*  engine case, right tri */

{0.05, 0.05, 0.05  }, /* left small corner */

{1.0,0.0,0.0},  /*ceiling, right tri*/
{0.95,0.0,0.0}, /*ceiling, left tri*/

{0.0,0.0,0.7}, /* back piece, upper, right tri */


{0.0,0.0,0.5}, /* LEFT SIDE/DOOR TRI 1 */
{0.0,0.0,0.4}, /* LEFT SIDE/DOOR TRI 1 */


{0.0,0.0,0.8 },  /* back piece, upper, left tri */

{0.0,0.0, 0.0}, /* UNKNOWN PIECE */

{0.0,0.0,0.9}, /* back piece, downer, lefter tri  */
{0.0,0.0,9.0}, /* back piece, downer part,  right tri*/
{0.05,0.05,0.05 }, /* small corner, right side*/

{0.0,0.0,0.9},  // SEGMENT 1 DRAWN AS almost COLLAPSED TRIANGLE
{0.0,0.0,0.9}   // SEGMENT 2 DRAWN AS almost COLLAPSED TRIANGLE

} ;



float tra_tricolor[CARTRI][3] = {
{ 0.0, 0.6, 0.6 }, /* non-grafty side upper piece */ 
{ 1.0, 1.0, 1.0 }, /* frafity side TRI 1 */

{ 0.0, 0.2, 0.5 }, /* right side/door, downer tri */
{ 0.0, 0.2, 0.4 }, /* right side/door, upper tri */

{ 0.5, 0.2, 0.2 }, /* ceiling piece 1*/
{ 0.6, 0.2, 0.2 }, /* ceiling piece 2*/

{0.0 , 0.1, 1.0 },

{0.8, 0.0 , 0.0 }, /*  engine case, right tri */

{0.05, 0.05, 0.05  }, /* left small corner */

{1.0,0.0,0.0},  /*ceiling, right tri*/
{0.95,0.0,0.0}, /*ceiling, left tri */

{0.9,0.9,0.9}, /* GRAFITY, upper, right tri */


{0.0,0.0,0.5}, /* LEFT SIDE/DOOR TRI 1 */
{0.0,0.0,0.4}, /* LEFT SIDE/DOOR TRI 1 */


{0.0,0.0,0.8 },  /* back piece, upper, left tri */

{0.0,0.0, 0.0}, /* UNKNOWN PIECE */

{0.0,0.0,0.9}, /* back piece, downer, lefter tri  */
{0.0,0.0,9.0}, /* back piece, downer part,  right tri*/
{0.05,0.05,0.05 }, /* small corner, right side*/

{0.0,0.0,0.9},  // SEGMENT 1 DRAWN AS almost COLLAPSED TRIANGLE
{0.0,0.0,0.9}   // SEGMENT 2 DRAWN AS almost COLLAPSED TRIANGLE

} ;




/* TRAILER */
int tra_tri[CARTRI][3] = {
{ 1 , 2, 3 },  
{ 9, 10, 11 }, // upper GREAFFITY SURFACE TRI
{ 1, 9, 10 },
{ 1, 2, 10 },
{ 2, 10, 11 },
{ 2, 3, 11 },
{ 3, 20, 1 },  //right side downer big piece.

{0, 1 , 9 },   // the attaching point *very* important ! 

{7, 8, 13 },
{7,3,11},  //cappuccetto sopra TRI 1
{7,13,11}, //cappuccetto sopra TRI 2

{12, 9, 11 },  //downer GRAFFITY TRI 1
{20,6,3},
{13,8,11},
{ 8,5,12 },
{ 5, 1, 9 },
{5,4,8},
{5,12,9},
{4,5,6},
{ 7,4,8 },  
{11,12,8 }  
            } ;
/*==============================================================================*/


double std_imp_resist = 49000000.0 ;

int sel_ngon[nPOLY] = { 100, 22, 100 } ; // selective ngon variable.



//maps are all squared; this number says how many units is a side big.
//be just as large as the that of input file otherwise it shits it up. 
#define map_side 300   /*USE THIS*/ 
// #define submap_side 300 


//float nGP = map_side ;
float GPunit = 25.0 ;   /* cm: a multiplier for setting the lenght of a piece  of ground. */    
float SUBunits = 10.0 ; /* in how many pieces a unit of bighmap is subdivivded. */
/* the height samples of 3D map taken at grid intersections. */
// float hmap[map_side][map_side] ;
 float hmap[300][300] ;
// float bighmap[10][10] ;




double Xf, Yf ; // polyhedron-ground collision detection utility variables.   

// long int  tris[n_ground_triangles][3] ;  // [n_ground_traiangles][3] definition of triangular faces of surface; says which elems of 'vex' to get.
int Xi, Yi ;         // polyhedron-ground collision detection utility variables.
int Xi_bef , Yi_bef ;

    





/* SIZE NOT DONE WTH DEFINE!! SOME TIME CORRECT IT!!! */
//struct subterrain  triground[10][10] ;
struct subterrain   gg ; /*the large terrain seen far, not used in game: only as a reference.*/
struct subterrain   mg ;


int tree_map[map_side][map_side] ; // discreet 0-1 sheet. at ehich points is a tree?

/* big texture to apply - overlay gently without replacing the height-sensitive globa colouring - at each 10x10 piece, of which each piece is a 16x16 texured triangle - pair  */
float big_texR[160][160] ;
float big_texG[160][160] ;
float big_texB[160][160] ;


int xlimit = (int) map_side  ;  /* how many elements in 'hmap' matrix's rows -1.    */
int ylimit = (int) map_side  ;  /* how many elements in 'hmap' matrix's columns -1. */







/* define function waitdt_sec(double): */
int waitdt_ms( double  tt_ms ){

  
/* declare variables used specifically to measure time and a normal double */
clock_t  time1 , time2 ;
double dt_ms = 0 ;

/* set the variables according to the time-measurement process */
time1 = clock()   ;  /* REQUEST PROCESSOR TIME, OR LOCAL TIME, NO PROBLEM WHICH. */ 

    while( dt_ms  <  tt_ms ) { /* WAIT: holds the program execution here until tt_sec passers. */  
     
      time2 = clock() ;
      dt_ms = (time2 - time1)/(CLOCKS_PER_SEC/1000.0)  ;
    }
return 1 ;
}  /* end waitdt() function */







void reorient_polyhedra(void) ; /* matrix product/multiplication specialised for reorienting polyhedra in this simualtor.. */

void add_particles( float x, float y, float z, float vx, float vy, float vz, float dft,  int do_add ) ;

void add_tree( float x, float y , float z, int type_n ) ;

void display( float pitch, float head_in, int opt, 
	      float IN_cam_pos[3], float IN_cam_target_dir[3], float IN_cam_up_vector[3], float IN_cam_horiz_ref[3] ) ;




struct mat_3xn    vx_s,   //vertices of each polygon.IMPUT BY USER.
vx_origin, /* the copy of vx_s as it was imput the first time... the 'original' polyhedron. */
vx_mass,   /*IMPUT BY USER: PUT MASS VALUE IN THE 0 ELEMENT!!REST IS lEFT ZERO.*/     
vxFs,  //force vectors on eack vertex.  
vxpos ; //vertexes in 'world-coords'.


//MATRIX STRUCTURE:

struct mat_3x3  s_matrix0  ,  //generic matrix A.
s_matrix1  ,  //generic matrix B.
s_matrix2  ,  //generic matrix C.
TI,        //Inertia Tensor in Body-Coordinates (USER-INPUT CONSTANT)
TIinv,     //Inverse of TI matrix.              (USER-INPUT CONSTANT)
TIwor,     //Inertia Tensor in World_Coordinates
TIworInv,  //Inverse of TIwor matrix.
I  ,   //Identity Matrix.
D  ,   //rotation axis versor.
R1 ,   //change of orientation achieved in dt_game seconds of time.
R  ,   //the excact Rotation matrix of total orientation achieved. (also it's transpose is used).
R_VAR_CAM, //change of orientation of the virtual camera achieved in dt_game seconds of time.
R_CAM    , //the excact Rotation matrix storing the total orientation achieved by virtual camera.
D_CAM ,    //matrix used to rotate camera additionally manually.
coeffmatrix, //matrix of coefficients used in marix equation for finding plane equations for general-rebouncing.
auxmatrix ;   //an auxiliary matrix to use so.



//VECTORIAL QUANTITIES BELONGING ONE TO EACH BODY.
struct vect_data aux_vect, //initialised structure, then take copies....
 // make copies... until ";".
vel ,   //linear velocity - velocity of CM.
vel_pre,  //velocity gained in the previous simualton cycle.
pos ,   //position of the CM.
vvertex , //vertex velocity vector measured from 'world' coordinates. 
vvertexE1 ,
vvertexE2 ,   //for spring motion attenuation....
F_tcm ,   //total Force-vector eventually resulting on CM. 
acc ,     //linear acc.
acc_tot , //the total linear acceleration gained from all influences: rebouncings, springs, external forces.
rotaxis ,   // ('D' as vector) rotation-around_axis versor(lenght = 1.0 ). 
torque ,    //the 'torque' vecotor, The famous one.
torque_tot, //an auxiliary variable used to calc virtual torques deriving from collisions. 
L_advance , //advance in L produced by the torque applied for a small timstep "dft". 
L ,         //Angular Momentum 3D.
ww ,         //to store vang*axisvector for using easier some vector eqauations.
ww_pre ,     //Angular Velocity Vector from the previous sim cycle.
ww_acc_tot ,     //one for each body: ww_acc = (ww - ww_pre)/dft  --> in practice it's the angular acceleration acquired in the whole cycle (reb+spring+externals).
reartyre_axis  ,         //auxiliary varible, mostly used for storing particular rotaitonal axis versors.
terms ,
v_spring,       //virtual spring's original orientation versor(the one given with respecto to the original Polyhedron1).
v_spring_curr[nPOLY],  //virtual spring's oeirnetation versor current. per body....
down_dir ;      //the downward direction of the reference system with respecto to which all the scenerio and alla the stuff is defined and mesured.


//SCALAR QUANTITIES: ONE FOR EACH BODY.SCALARS NOT INT STRUCTURE... SHOULD BE ELIMINATED THIS.
struct scal { double x ; } 
angacc,   //angular acceleration
vang ,    //angular speed of the 3D body around rotaxis versor (polyhedron).
alpha ,   //the variantion of angle concretised in dt time.(vang*dt). 
MASS ;     //the total mass of each body(polyhedron).



//============================================================================================================
int texid[SUPER_TRI] ; 
// USED ONLY TO STORE ID NUMBER TO RECALL... NTRIS is a WORST-CASE CONSIDERATON IN WHICH EACH TRIANGULAR FACE HAS A DIFFRENT TEXTURE. IT IS FILLED AT TEXTURE LOAD-IN AT FIRST CALL TO GLaddpoly......

/* texture abcd side order riplet... tells how texture iage is treched ontriangular face...
so:

c_____d(1,1)
|     |
|     |
|     | 
|_____|
a(0,0) b(1,0)

c(0,1) yes.
see definition below of "texcoord_x[0-3]" and "texcoord_y[0-3]" */

/* tis nevr changes... it's a fixed convention... of cource ocan changeit inthe source cnde here and recomple for havinga different flavour of editor */
/*==vertexes of tex square:===a=b=c=d===========*/
const int texcoord_x[4]  =  { 0,1,0,1 } ; //...x 
const int texcoord_y[4]  =  { 0,0,1,1 } ; //...y

int textures_available ; // this is quite obvious... how many textures are loaded or remdom-genrated... ok.
//============================================================================================================




// put all data types, vectors, 3x3 matrces and 3xn matrices togather in struct:
struct struct_body { struct scal  angacc ;
                     struct scal  vang   ;
                     struct scal  alpha  ;
                     struct scal  MASS   ;
                     struct vect_data aux_vect  ;
                     struct vect_data vel, vel_pre, acc_tot ;
                     struct vect_data pos ;
                     struct vect_data  vvertex ;
                     struct vect_data  F_tcm ,acc ;
                     struct vect_data  rotaxis, ww, ww_pre, ww_acc_tot, torque, torque_tot, L_advance , L, L_pre, reartyre_axis, reartyre_axis_ori ;
                     struct vect_data torque_drv;  // record variation of L due to dive-ahead, something that happens in the interactivity function, so not in manw()....
 		     struct vect_data acc_drv; // acceleration due to dirive ahead, request procesen in interactivity func, so not in mainw() ;

                     struct mat_3xn  vx_s, vx_origin, vx_mass ;
		     int tri[SUPER_TRI][3] ;
		     int face_texid[SUPER_TRI] ;
		     int face_texord[SUPER_TRI][3] ;		     

		     struct mat_3xn  vxFs, imp_resist ;
                     struct mat_3x3  R, R1, D, I ; 
                     struct mat_3x3  TI, TIinv ;
                     struct mat_3x3  TIwor, TIworInv ;
		     struct vect_data  axis_1, axis_2, axis_3, axis1_orig, axis2_orig, axis3_orig ;		
                     } body[nPOLY] 
                     ;  //make a structure containing all body data.




// ===== -TRUCK peculiarity-===============
struct  struct_wheel {
    struct mat_3xn  vx_s, vx_origin ;
    struct mat_3x3  R, R1, D, I ; 

    struct vect_data pos ;
    struct vect_data  axis ,  axis_orig ;

    int stopped ; 	
} ;

struct  struct_wheel    wheel[ NPILLOW ] ;
//=============================================





//SPRINGS STUFF:
//identification of vetrex to which to apply a spring end. int Xi_bef , Yi_bef ;

//SCHEME: END1: n-th body, n-th vertex; END2 ... idem  NOT USED IT HIS GAME!!!

/*
int springvx[nsprings][4]  = {   //separation correcter. 
                             { 0, 6, 1, 0 } // joint pont                                                                                
			     } ;  
*/
			     
			     
double Lo[nsprings]  ;          //natural lenght of each spring
double kspring[nsprings]  = {  0.0                                                                                                                   
                            } ;  //NULL IN DEV STAGE!!!! 
                            
double DL,dist, springF        ; //spring diplacement; dist; spring force.
double springlineVERSOR[3], AUXspringlineVERSOR[3]  ;









/*
int indexPOLY[2]   ;   //for spring calculations
int indexVERTEX[2] ;   //for spring calculations
*/






/*==_TRUCK VERSIN PECULIARITY!!! ==== THE BEST OF ALL CTRUCK SUBVERSIONS !!!== */

//number of articulation rigid arms present in siumulation
#define narms 1

// vincular force equations on/off for articulated body simualtion/rigid articulation simulation.
int LagrangeArticulatedBodies = 1 ;

/*===========================================================================*/


struct vect_data 
terms ,  //known coefficients in addition to the matrix of coefficients used in marix equation for finding plane equations for general-rebouncing.
ba ,     //matrix for Lagrange Multipliers equation for rigid constraints. An utility variable to split up equation.
bb ,     //seme as above.
ra, rb , //vertex vector.
fc ;     //the unknown force vector to be added to the body A and B, found with the LagrangeMultipliers method to handel rigid rotating joints in 3D.

struct mat_3x3 
Aa, //matrix for Lagrange Multipliers equation for rigid constraints. An utility variable to split up equation.
Ab, //seme as above.
Ma, //special auxiliary matrix for lagrange equation to handle easy.
Mb ; //seme as above.



int armvx[narms][4] = {                          
             { 0, 6, 1, 0 }
             };
              // n_body_A, n_vertex ; n_body_B , n_vertex ; 




// UTILITY:
//DUBION IF FOLOAT OF DOBLE.... :)) .
static double pi = 3.1415926 ;   //the "PI" constant's approximation.
static double diam = 45 ;  //for 'circle' approximations only, useful stuff.





/* physics simulation's basic constants: */
/* physics simulation's basic constants: */
float FPS = 50 ; /* CORR number of photograms required in 1 sec (to make a fluent motion picture) */
double best_dt_ms = 0.0 ; /* calculated after making computer speed test: BUT LET IT ZERO BEFORE!!!!!! */

double dft = 0.02   ; // 0.02 oroginally - not enough for vincular dynamics!!

int Xi_bef , Yi_bef ;
long int counter = 1 ;


double g = -981.0  ;   /* grav acceleration. put 0 to test. */
// double g = -0.0  ;   /* grav acceleration. put 0 to test. */


/*costants specific to simplest **AIRPLANE** game. */
double k_visc      = 1200000.5 ; /* some constant deriving form viscosity of air */
double k_visc2     = 500000.5 ; /* some constant deriving form viscosity of air */
double k_visc_rot  = 1000000.0  ; /* some constant deriving form viscosity of air */
double Pforce = 0.0 ; /* Force of the propeller driven by the motor... a propulsion force. */
double vpar, vperp ; // updated at each cycle... part of the super-siplified formulla to give forces to the body 3 in a way to make it fly a bit like a real airplane.

double e = 0.1  ;
double standard_vertex_mass = 20000.0 ;

/* pillow-spring with gidance: approximated car-tyre physical system */
double l_vsp = 80.0 ;  //testing with 110....
double l_c ;
double l_crec[NPILLOW] ;
double k_vspring[NPILLOW] = { 8600000, 8600000, 8600000, 8600000,    8600000, 8600000, 8600000, 8600000,    8600000,8600000,8600000,8600000  } ;  //testing with 6100000 , careful to the measure units used!!
double h_vxvs[NPILLOW] ; /*a small vector storing the distance of each vertex used to do virtualspring sustaining, 
distance form the ground... computed already during collision checks. */
int testpoint_pindex[NPILLOW] ; //seme as the previous one but this store the index which tells in which triangle of the grounf each testpoint stays in.
double norm_vxvs[NPILLOW][3] ; /* read descripiton of it's rule at the GROUND collsision detection procedure. */

//variables for: friction with ground (of bodies).
double fr = 0.4     ;  //friction on tyres
double fr_gro = 0.05 ;  //ground friction when vertex of main body touches.
double normv = 0.0   ;

//variabes for: body reounce from goround, vector equations.
double vnorm ;
double je    ;
double jf    ;

//spring absorbtion constants.
double vdep = 0.0   ;     //part dependent on velocity of oscillation.
double cost = 0.0   ;     //constant frction/absorbtion.
double stre = 0.0 ;     //entire strenght of the combined effect.(it multiplies them so: stre(idep + cost )

/* PUT ZERO TO DEACTIVATE FRICTION IN SPRING MOTION / ABSORBTION AT ALL */
//float stre = 0.0 ;     //entire strenght of the combined effect.(it multiplies them so: stre(idep + cost )

//float drive = 500 ; //the motive tyre-pair drivig torque force.
//float gear1 = 4.1  ; //anglular velocity of tyre allowed by engine breaking. 
double steerang = 0.0 ;

//use more that structure for passing single 3-vectors between functions is also neede:
struct  vect_data
s_vector0  ,  //generic vector A.
s_vector1  ,  //generic vector B.
s_vector2  ,  //generic vector C.
s_vvertex  ,  //that's a 3-vector important for calcs,dot3 and cross prods. 
s_nloc     ,  //auxiliary data transfer
s_nTloc    ,  //auxiliary data transfer  
s_auxvx    ,  //auxiliary stock to make NxM matrix form biggger one 'vx'.
s_sum2     ,  // auxiliary variable to accumulate effect of forces.
s_auxvxF   ,  //END COPY LIST.
s_ww       ,        //to store vang*axisvector for using easier some vector eqauations.
cam_pos        ,    //camera position  (3D visualisation parameter).
cam_up_vector  ,    //camera_up_vector (3D visualisation parameter).
cam_up_vector2 ,      //FOR INTERNAL VIEW IN-CAR!!!
cam_target_dir ,    //vector defining the shooting direction of virtual camera (3D visualisation parameter).
cam_target_dir2,     // only used to allow to rotate fix internal camera.
cam_horiz_ref  ,    //virtual camera's view frustum's parallel-to-horizontal-direction (3D visualisation parameter). 
cam_horiz_ref2 ,        //for internal view INCAR.
standard_up_dir ;   //a sort of standard avarage 'normal vector' to make virtual camera rotate around, when needed ;

//FUNCTION DECLARATIONS, USING STRUCTURES ABOVE DECLARED.

//==MAIN VECTOR CALCULUS AND MATRIX-MATRIX AND MATRIC-VECTOR OPERTAIONS: in vcalc.h, and corresponding vcalc.c  ==







void mainw(void) ;
void process_carhandling_inputs( void ) ;



/*MAKE INERTIA TENSOR AUTOMATICALLY USING VERTEX AND MASS INFORMATION OF EACH POLYHEDRON, PROVIDED BY: 
body[j].vx_origin.matrix[3][n] ,  and  body[j].MASS.x. */

/*Needs also a function to re-set poly so that the O(0,0,0) is the CM. To pass to make_inertia_tensor. That funciton calculates assuming that the CM is in CM(0,0,0).*/
//void set_cm_to_000(void) ; For symmetric figures, obviously no problem.... WHATS THIS???

struct mat_3x3  make_inertia_tensor( struct mat_3xn , struct mat_3xn , int n_vertexs) ;

void deform_poly( struct vect_data  *hit_versor,  double je, struct struct_body *inbody, int i )  ;

double body_rebounce( struct struct_body  *inbody ,  double rx, double ry , double rz,
						     double nx, double ny , double nz,int vx_index, float e, float lat ) ;



void orient_3axes( float *X_axis, float *Y_axis, float *Z_axis,  float theta, float fi, float psi  ) ;


void addtriang_TEXTURED(     float x1, float y1, float z1, 
			     float x2, float y2, float z2, 
			     float x3 ,float y3, float z3, int step, 
				  float color[3] ) ;






// **FUCKIN'** AUXILIAR, EXTERN VARIABLES...
double det ; 
long int row, col, row2, col2 ,i , j, k , nu ;
double sum,sc,disth,auxm2,s, mod, Valpha, VSLbeta, alphaTOT ;
double auxvx[3] ;  //auxiliary stock to make NxM matrix form biggger one 'vx'.
double auxvxF[3];  //foce auxiliary, where no cross rpoduct is used.
double am[3][ngon][nPOLY]    ;  //seme size as 'vx' ;it's just a proc variable.
double UP, DOWN, UPf, DOWNf ;
double auxm[3]  ; //auxiliary vector for temporary selection 'n transcription of elems. 
double auxm4[3][3] ;
double rotm[3][3][nPOLY] ;   //the rotation matrix used in "mmult" updater funciton.


//variables for virtual camera operatins with openGL and map data imput control by user:
float alphaCam = 0.9 ;
float beta = -0.6 ;

float cam_psi = 0.0 ;
float cam_theta = 0.0 ;
float cam_fi = 1.5 ;

float RES_cam_pos[3], RES_cam_target_dir[3], RES_cam_up_vector[3], RES_cam_horiz_ref[3]  ; 
float ds = 1200.0      ;
int woption = 6       ;  //3D view mode index: 1,2,3,4,5.
//stereo vision variables for interactive setup:
float distLR = 8.5    ;  //let it so: be very careful to assign correctrly L-R and not the inverse!!
int drive_mode = -1 ;



float displace_x = 40.0 ; 
float displace_y = 45.0 ;
float displace_z = 60.0 ;




void rtinteractivityfunc( unsigned char input, int x, int y) ;
void keyup_detect( unsigned char input, int x, int y) ;



float aux_texture[10][20] = {
  { 0.7 , 1.0 ,  0.9 , 0.94, 0.92 , 0.91 , 0.91, 0.9 , 0.9 , 0.97, 0.9 , 0.96, 0.87, 0.84, 0.97, 0.91 , 0.91, 1.0 , 1.0 , 0.95},  
  { 0.7 , 0.7 ,  0.7 , 1.0 , 0.93 , 0.94 , 0.92, 0.97, 0.97, 0.8 , 0.93, 0.8 , 0.8 , 0.82, 0.93, 0.84 , 0.92, 0.8 , 0.91, 0.8 },
  { 0.8 , 0.71,  0.75, 0.71, 0.7  , 1.0  , 0.93, 1.0 , 0.9 , 0.9 , 0.8 , 0.95, 0.85, 0.91, 0.9 , 0.91 , 0.93, 1.0 , 0.87, 0.92},
  { 0.8 , 0.77,  0.7 , 0.74, 0.64 , 0.7  , 0.7 , 1.0 , 0.95, 0.8 , 0.9 , 0.97, 0.9 , 0.94, 0.94, 1.0  , 0.8 , 0.97, 1.0 , 0.8 },
  { 0.85, 0.8 ,  0.7 , 0.74, 0.51 , 1.0  , 0.65, 0.7 , 0.7 , 1.0 , 0.95, 0.8 , 0.95, 0.84, 0.81, 1.0  , 0.95, 0.8 , 0.83, 0.9 },
  { 0.8 , 0.7 ,  0.6 , 0.74, 0.64 , 0.61 , 0.75, 0.9 , 0.7 , 0.7 , 0.7 , 1.0 , 0.96, 0.94, 0.84, 0.91 , 0.95, 0.9 , 0.9 , 0.8 },
  { 0.84, 0.8 ,  0.7 , 0.73, 0.71 , 0.78 , 0.56, 0.5 , 0.8 , 0.7 , 0.74, 0.7 , 0.75, 1.0 , 0.91, 0.97 , 0.96, 0.8 , 1.0 , 0.8 },
  { 0.8 , 0.75,  0.6 , 0.73, 0.74 , 0.81 , 0.67, 0.6 , 0.7 , 0.8 , 0.7 , 0.75, 0.7 , 0.73, 0.7 , 1.0  , 0.97, 0.8 , 0.82, 0.9 },
  { 0.81, 0.8 ,  0.8 , 0.73, 0.71 , 0.91 , 0.68, 0.6 , 0.6 , 0.6 , 0.8 , 0.8 , 0.8 , 0.63, 0.71, 0.71 , 0.7 , 1.0 , 0.95, 0.88},
  { 0.65, 0.6 ,  0.7 , 0.73, 0.73 , 0.91 , 0.79, 0.8 , 0.8 , 0.8 , 0.7 , 0.6 , 0.7 , 0.63, 0.78, 0.75 , 0.69, 0.7 , 0.7 , 1.0 }
} ;





void init_simulator() ;




//===main()==================initialise openGL graphycs too =============================
int main(int argc, char** argv)
{  

SDL_Event event ; // a varible used for the real-time interactivity of the game.

//--------------Initialize SDL graphics---------------

    // Slightly different SDL initialization
    if ( SDL_Init(SDL_INIT_VIDEO) != 0 ) {
        printf("Unable to initialize SDL: %s\n", SDL_GetError());
	getchar() ;
    }


    // Enable double-buffering
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    // Create a OpenGL window
    screen = SDL_SetVideoMode(WIDTH, HEIGHT, 8, SDL_OPENGL | 
                                               /* SDL_FULLSCREEN */  SDL_RESIZABLE );
    if(!screen) 
    {
        printf("Couldn't set %dx%d GL video mode: %s\n", WIDTH,
                     HEIGHT, SDL_GetError());
        SDL_Quit();
        exit(2);
    }
    SDL_WM_SetCaption("CSTUNTS by Simon Hasur", "CSTUNTS by Simon Hasur" ) ; 
//-----------------------------------------------------------------

  myinit();

mainw() ; // do 1 test ;



while( 1 ){


/*===============================|SDL's real-time interactivity|=============================*/    
   while(SDL_PollEvent(&event)){  /* Loop until there are no events left on the queue */
          
	  if( event.type == SDL_KEYDOWN ){  /* condition: keypress event detected */
	  printf("Key press detected by SDL functions \n");
	       
	       if(event.key.keysym.sym == SDLK_ESCAPE ||  event.key.keysym.sym == SDLK_q ){
	       printf("ESC KEY PRESSED: PROGRAM TERMINATED");
	       SDL_Quit();
	       exit(1);  /*standard C library function to terminate program execution */
	       }
	       
	       if(event.key.keysym.sym == SDLK_UP    || event.key.keysym.sym == SDLK_w ){	                
		gas = 1; /* move point up by 1 pixel! */         
	       }       
	       else if(event.key.keysym.sym == SDLK_RIGHT || event.key.keysym.sym == SDLK_d ){                  
		s_right = 1 ; /* do what it is meant to do in the game */         
	       }
	       else if(event.key.keysym.sym == SDLK_LEFT  || event.key.keysym.sym == SDLK_a ){	 
               s_left  = 1 ;          
	       }
	       else if( event.key.keysym.sym == SDLK_f ){	 
               rtinteractivityfunc('f',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_r ){	 
               rtinteractivityfunc('r',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_5 ){	 
               rtinteractivityfunc('5',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_6 ){	 
               rtinteractivityfunc('6',0,0) ;          
	       }               
	       else if( event.key.keysym.sym == SDLK_c ){	 
               rtinteractivityfunc('c',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_v ){	 
               rtinteractivityfunc('v',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_k ){ // airplane proulsion off	 
               rtinteractivityfunc('k',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_e ){ // airplane (body[2]....) propulsion on	 
               rtinteractivityfunc('e',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_MINUS ){	 
               rtinteractivityfunc('-',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_COMMA ){	 
               rtinteractivityfunc(',',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_PERIOD ){	 
               rtinteractivityfunc('.',0,0) ;          
	       }    
               else if( event.key.keysym.sym == SDLK_1 ){	 
               rtinteractivityfunc('1',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_m ){	 
               rtinteractivityfunc('m',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_2 ){	 
               rtinteractivityfunc('2',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_3 ){	 
               rtinteractivityfunc('3',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_4 ){	 
               rtinteractivityfunc('4',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_o ){	 
               rtinteractivityfunc('o',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_u ){	 
               rtinteractivityfunc('u',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_l ){	 
               rtinteractivityfunc('l',0,0) ;          
	       }

		else if( event.key.keysym.sym == SDLK_t ){	 
               rtinteractivityfunc('t',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_y ){	 
               rtinteractivityfunc('y',0,0) ;          
	       }             
		else if( event.key.keysym.sym == SDLK_0 ){	 
               rtinteractivityfunc('0',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_s ){	 
               rtinteractivityfunc('s',0,0) ;          
	       }
		else if( event.key.keysym.sym == SDLK_SPACE ){	 
               rtinteractivityfunc(' ',0,0) ;          
	       }
	       else if( event.key.keysym.sym == SDLK_DOWN /*down-pointing arrow button*/  || event.key.keysym.sym == SDLK_z ){	 
               gas_reverse = 1 ;          
	       }
                           
	  	} /* end condition of if-keypress-is-detected */
	 if( event.type == SDL_KEYUP ){

		if(event.key.keysym.sym == SDLK_UP    || event.key.keysym.sym == SDLK_w ){	                 
		gas = 0 ;          
	        }
		else if(event.key.keysym.sym == SDLK_RIGHT || event.key.keysym.sym == SDLK_d ){                  s_right = 0 ; /* do what it is meant to do in the game */         
		}
		else if(event.key.keysym.sym == SDLK_LEFT  || event.key.keysym.sym == SDLK_a ){	 
		s_left  = 0 ;          
		}             
		else if(event.key.keysym.sym == SDLK_DOWN  || event.key.keysym.sym == SDLK_z ){	 
		gas_reverse = 0 ; 
  		} 
	} 

   } // see event-queue
   //--------------------------------------------------------------------



process_carhandling_inputs() ; // do those key-up key-down stuff for keys pressed contemporarily... do it only for important things like gas-and-steering interactive commands, w,a,d that's all. external forces (those put interactively by user by pressing buttons ) are set here. AT END OF MAINW() all is ST 0.0 however... aftr having been applied t bodies, each to his own. .

mainw() ;

// process_carhandling_inputs() ; // MOVED before calling mainw() do those key-up key-down stuff for keys pressed contemporarily... do it only for important things like gas-and-steering interactive commands, w,a,d that's all.
SDL_Delay(best_dt_ms) ;
}

SDL_Quit() ;

return 1 ;
} //END mainGLUT.











double body_rebounce( struct struct_body  *inbody ,  double rx, double ry , double rz,
						     double nx, double ny , double nz,int vx_index, float e, float lat ){

double jelf=0, jel=0 ;
struct vect_data s_nloc, s_nTloc, s_vector1, aux_vect ;

s_nloc.vector[0] = nx ;
s_nloc.vector[1] = ny ;
s_nloc.vector[2] = nz ;


inbody[0].vel_pre = inbody[0].vel ;  //store the velocity vector from fefore collision! It's needed to calculate virtual acceleration if needed!!
inbody[0].L_pre   = inbody[0].L ;



s_vector1.vector[0] = rx ; 
s_vector1.vector[1] = ry ;
s_vector1.vector[2] = rz ;

	//CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
	//FORMULA NORMSPEED. 
	inbody[0].vvertex = vector_sum( 
			    inbody[0].vel, cross( inbody[0].ww,  s_vector1 )
				    ) ;
				    
				    
        //here the friction normal... hard for the terrain triangle is inclined(general case)... we must combine the two infos: normal and vel vector....
	//combine this two infos to get: how much of the speed of the vertex is arallel to the surface of the triangle it is touching?
	//copy velocity vector of vertex into an auxiliary vector to work with easily.
	aux_vect.vector[0] = inbody[0].vvertex.vector[0] ;
	aux_vect.vector[1] = inbody[0].vvertex.vector[1] ; 
	aux_vect.vector[2] = inbody[0].vvertex.vector[2] ;			     			     			     
	//END FORMULA to calculate "vvertex".


	//since the gound is the 'fix' reference system to measure relative velocities end positions, with it we can establish objectively: goes or not. 
	if ( leng_vect3(aux_vect) > 0.1 ){        
	s_nTloc =  cross( s_nloc, cross(s_nloc, aux_vect ) )  ;       //vector measuring the parto of motion parallel-to-surface: 3D....
	s_nTloc =  pscv(s_nTloc, -1.0 ) ;                                                  //invert sense: friction opposes motion's direction!
	} 
	else{ 
	s_nTloc.vector[0] = 0.0 ;
	s_nTloc.vector[1] = 0.0 ;
	s_nTloc.vector[2] = 0.0 ;
	}


	 vnorm = dot3_st( s_nloc , inbody[0].vvertex )  ; //the output is a float  anyway: 'vnorm' is a float, just as is. 				    
	
	
	
	     if (vnorm < 0 ) {
       //REBOUNCE PART:                  
       
	        UP   = -(1.0 + e )*vnorm  ;
                DOWN = 1.0/inbody[0].MASS.x + dot3_st(  cross(s_vector1, s_nloc ) , mat3x3_vect( inbody[0].TIworInv, cross(s_vector1, s_nloc ) ) ) ;
       
                jel = UP/DOWN ;


/*======= deformation and LIMITATION OF imulse BEFORE APLYING IT: ============*/

if( LagrangeArticulatedBodies == 0  && jel > 21000000.0  ){
	

deform_poly( &s_nloc, jel, &inbody[0], vx_index ) ;
jel = 21000000.0 ;
add_particles( inbody[0].pos.vector[0] +  inbody[0].vx_s.matrix[0][vx_index]  , 
	       inbody[0].pos.vector[1] +  inbody[0].vx_s.matrix[1][vx_index]  , 
	       inbody[0].pos.vector[2] +  inbody[0].vx_s.matrix[2][vx_index]  , 

	inbody[0].vvertex.vector[0], 
	/* inbody[0].vvertex.vector[1] */ 50.0 , 
	inbody[0].vvertex.vector[2], dft,  1  ) ;
}
/*=================DEFORMATION END=============================================*/




		//FRICTION PART:       
		//FRICTION PART:       

		if ( fabs(  pow( inbody[0].vvertex.vector[0],2 ) + pow( inbody[0].vvertex.vector[2],2 ) ) > 0.1 ) {  //see if parellely to ground there is relative motion.
		s = 1; 
		} 
		else{
		s = 0 ;
		} //don't play w too small numbers,may cause /0 and INF.
     
	 
	 
       vnorm = s*dot3_st(s_nTloc, inbody[0].vvertex) ;   //we overwrite it, since it's been already used for what it was aimed.
       UPf   = -(0.0 + fr_gro )*vnorm       ;     //careful with adaptation: here, the max restitution is 1.0.  

       DOWNf = 1.0/inbody[0].MASS.x    +  dot3_st(  cross(s_vector1, s_nTloc ) , mat3x3_vect( inbody[0].TIworInv, cross(s_vector1, s_nTloc ) ) )  ;
 
       jelf = lat*(UPf/DOWNf)  ; // if lat = 0 it's NO FRICTION OF ANY KIND 
       
	//the more green component in ground color, the more friction.
	if ( fabs(jelf) > mg.scol[Xi][Yi][1]*380000.0 ){ // if too much ==CHECK!!!==, it becomes dynamic friction and substantially we have lost control over the car!! 
	jelf = (500*jelf)/fabs(jelf) ;   
	}





 		    
// copy other angular momentum and other stuff here!!
   
                           //update linear and angular vel.
                            inbody[0].vel.vector[0] = inbody[0].vel.vector[0] + (jel/inbody[0].MASS.x)*s_nloc.vector[0]  + (s*jelf/inbody[0].MASS.x)*s_nTloc.vector[0] ;
                            inbody[0].vel.vector[1] = inbody[0].vel.vector[1] + (jel/inbody[0].MASS.x)*s_nloc.vector[1]  + (s*jelf/inbody[0].MASS.x)*s_nTloc.vector[1] ;
                            inbody[0].vel.vector[2] = inbody[0].vel.vector[2] + (jel/inbody[0].MASS.x)*s_nloc.vector[2]  + (s*jelf/inbody[0].MASS.x)*s_nTloc.vector[2] ;
       

//=====FOR VINCLAR DYNAMICS=========== 
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
inbody[0].acc_tot    = pscv( vector_sum( inbody[0].vel, pscv( inbody[0].vel_pre, -1.0 ) ) , 1.0/dft )  ;			    
//====================================			    




//extract vector from vector-collection matrix of vertexes: 'j' number of bolyhedron. 'i' number of one of it's vertexes.
aux_vect.vector[0] = rx ;
aux_vect.vector[1] = ry ;
aux_vect.vector[2] = rz ;

//rebounce contribution:
inbody[0].ww = vector_sum( inbody[0].ww ,  mat3x3_vect( inbody[0].TIworInv, cross( aux_vect, pscv( s_nloc  ,jel  ) )  ) ) ; 
inbody[0].ww = vector_sum( inbody[0].ww ,  mat3x3_vect( inbody[0].TIworInv, cross( aux_vect, pscv( s_nTloc ,jelf ) )  ) ) ; 

//update also the angular momentum, since ww chenged: then also angular momentum changes (obvious).
inbody[0].L = mat3x3_vect( inbody[0].TIwor , inbody[0].ww )   ;  


//==FOR===VINCULAR DYNAMICS!=====
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
inbody[0].torque_tot    = pscv( vector_sum( inbody[0].L, pscv( inbody[0].L_pre, -1.0 ) ) , 1.0/dft )  ;	
//================================



//recalc separately vang and rotation-axis versor.
inbody[0].vang.x = leng_vect3( inbody[0].ww ) ;

inbody[0].rotaxis.vector[0] = inbody[0].ww.vector[0] /inbody[0].vang.x  ;
inbody[0].rotaxis.vector[1] = inbody[0].ww.vector[1] /inbody[0].vang.x  ;
inbody[0].rotaxis.vector[2] = inbody[0].ww.vector[2] /inbody[0].vang.x  ;



}

return jel ;

}
//=============================================================================================================





//=============================|apply hit impulse to 1 body: NOT RECIPROCAL!!!1 SINGLE BODY | ==================

void  apply_hit_tobody( struct struct_body  *inbody ,  double rx, double ry , double rz,
						       double nx, double ny , double nz ){

double jel ;

s_nloc.vector[0] = nx ;
s_nloc.vector[1] = ny ;
s_nloc.vector[2] = nz ;


inbody[0].vel_pre = inbody[0].vel ;  //store the velocity vector from fefore collision! It's needed to calculate virtual acceleration if needed!!
inbody[0].L_pre   = inbody[0].L ;


 		    
jel = sqrt (nx*nx + ny*ny + nz*nz ) ;                       

// copy other angular momentum and other stuff here!!
   
                           //update linear and angular vel.
                            inbody[0].vel.vector[0] = inbody[0].vel.vector[0] + (jel/inbody[0].MASS.x)*s_nloc.vector[0] ;
                            inbody[0].vel.vector[1] = inbody[0].vel.vector[1] + (jel/inbody[0].MASS.x)*s_nloc.vector[1] ;
                            inbody[0].vel.vector[2] = inbody[0].vel.vector[2] + (jel/inbody[0].MASS.x)*s_nloc.vector[2] ;
       

//=====FOR VINCLAR DYNAMICS=========== 
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
inbody[0].acc_tot    = pscv( vector_sum( inbody[0].vel, pscv( inbody[0].vel_pre, -1.0 ) ) , 1.0/dft )  ;			    
//====================================			    




//extract vector from vector-collection matrix of vertexes: 'j' number of bolyhedron. 'i' number of one of it's vertexes.
aux_vect.vector[0] = rx ;
aux_vect.vector[1] = ry ;
aux_vect.vector[2] = rz ;

//rebounce contribution:
inbody[0].ww = vector_sum( inbody[0].ww ,  mat3x3_vect( inbody[0].TIworInv, cross( aux_vect, pscv( s_nloc  , jel ) )  ) ); 


//update also the angular momentum, since ww chenged: then also angular momentum changes (obvious).
inbody[0].L = mat3x3_vect( inbody[0].TIwor , inbody[0].ww )   ;  


//==FOR===VINCULAR DYNAMICS!=====
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
inbody[0].torque_tot    = pscv( vector_sum( inbody[0].L, pscv( inbody[0].L_pre, -1.0 ) ) , 1.0/dft )  ;	
//================================



//recalc separately vang and rotation-axis versor.
inbody[0].vang.x = leng_vect3( inbody[0].ww ) ;

inbody[0].rotaxis.vector[0] = inbody[0].ww.vector[0] /inbody[0].vang.x  ;
inbody[0].rotaxis.vector[1] = inbody[0].ww.vector[1] /inbody[0].vang.x  ;
inbody[0].rotaxis.vector[2] = inbody[0].ww.vector[2] /inbody[0].vang.x  ;

}

//=============================================================================================================






void orient_3axes( float *X_axis, float *Y_axis, float *Z_axis,  float theta, float fi, float psi  ){
//check with I matrix if problems arise.
float Xo, Yo, Zo, axis_1[3], axis_2[3], axis_3[3] ;
           

//=====UPDATE AXES of the 3 axes of virtualcamera's reference... =============

float Px, Py, Pz ;
float Qx, Qy, Qz ;

//R:
	axis_1[0] = cos(theta)*sin(fi) ;  
	axis_1[1] = sin(theta)*sin(fi) ; 
	axis_1[2] =            cos(fi) ;  

//P:
	axis_2[0] = -sin(theta)  ;
	axis_2[1] =  cos(theta)  ;
	axis_2[2] =  0.0 ; 

//Q:
	axis_3[0] =  -cos(theta)*cos(fi) ;
	axis_3[1] =  -sin(theta)*cos(fi) ;
	axis_3[2] =              sin(fi) ; 


Px = axis_2[0] ;
Py = axis_2[1] ;
Pz = axis_2[2] ;

Qx = axis_3[0] ;
Qy = axis_3[1] ;
Qz = axis_3[2] ;

// then P and Q must be rotated... by angle "psi" (q[5])

/*
Px =  cos(psi)*axis_2[0] + sin(psi)*axis_3[0] ;
Py =  cos(psi)*axis_2[1] + sin(psi)*axis_3[1] ;
Pz =  cos(psi)*axis_2[2] + sin(psi)*axis_3[2] ;

Qx = -sin(psi)*axis_2[0] + cos(psi)*axis_3[0] ;
Qy = -sin(psi)*axis_2[1] + cos(psi)*axis_3[1] ;
Qz = -sin(psi)*axis_2[2] + cos(psi)*axis_3[2] ;
*/

//=====================END OF AXES REORIENTATION DONE=================================================
 

// -----X axis:-------

	Xo = X_axis[0]  ;
	Yo = X_axis[1]  ;
	Zo = X_axis[2]  ;

//printf("Xo = %3.3f, Yo = %3.3f, Zo = %3.3f \n\n", Xo, Yo, Zo ) ; 

	// alternatively one can use only axes, which at their turn have been rotated, or, say, re-oriented.
	X_axis[0] =   Xo*Px        + Yo*Py         + Zo*Pz;        ;  
	X_axis[1] =   Xo*Qx        + Yo*Qy         + Zo*Qz         ; 
	X_axis[2] =   Xo*axis_1[0] + Yo*axis_1[1]  + Zo*axis_1[2]  ;  
	// OK.
 // printf("Xo = %3.3f, Yo = %3.3f, Zo = %3.3f \n\n", X_axis[0], X_axis[1], X_axis[2] ) ;

// getchar() ;
// -----Y axis:-------

	Xo = Y_axis[0]  ;
	Yo = Y_axis[1]  ;
	Zo = Y_axis[2]  ;

	Y_axis[0] =   Xo*Px        + Yo*Py         + Zo*Pz;        ;  
	Y_axis[1] =   Xo*Qx        + Yo*Qy         + Zo*Qz         ; 
	Y_axis[2] =   Xo*axis_1[0] + Yo*axis_1[1]  + Zo*axis_1[2]  ;  
	// OK.
 


// -----Z axis:-------

	Xo = Z_axis[0]  ;
	Yo = Z_axis[1]  ;
	Zo = Z_axis[2]  ;

	Z_axis[0] =   Xo*Px        + Yo*Py         + Zo*Pz;        ;  
	Z_axis[1] =   Xo*Qx        + Yo*Qy         + Zo*Qz         ; 
	Z_axis[2] =   Xo*axis_1[0] + Yo*axis_1[1]  + Zo*axis_1[2]  ;  
	// OK.
 


        //    }
   


} //END of orient_3axes(...)  function      










void process_carhandling_inputs( void ){


 if ( ( gas == 1 || gas_reverse == 1 ) && in_vehicle == 0 ){
 
 float s = -1.0 ;

	if (gas_reverse == 1 ){
	s = 1.0 ;
	}


			if( follow_mode_switch == 1 ){
			smilzo_x = smilzo_x + s*30.0*cam_target_dir.vector[0] ;
			smilzo_z = smilzo_z + s*30.0*cam_target_dir.vector[2] ;	
			}
			else if( follow_mode_switch == 3 ){
			smilzo_x = smilzo_x + s*10.0*cam_target_dir2.vector[0] ;
			smilzo_z = smilzo_z + s*10.0*cam_target_dir2.vector[2] ;	
			}

 } 

/*============================================================================*/
      if ( ( gas == 1 || gas_reverse == 1 ) && in_vehicle > 0 ){  //drive ahead. but only if thereis contact, tha is , formally, when spring is complressed.

	double force = 130000000.0 ;
	double sign  = 1.0 ;	
/* if fast, give less force to avoid undesired and unrealistic 'impenneta'-  nose-reise. */


	 if( leng_vect3( body[in_vehicle-1].vel ) > 100.0 ){ 
	 force = 160000000.0 ;
	 }
	 if ( gas_reverse == 1 ){
	 force = -force ; // give drive forece in opposite verse.
	 sign = -1.0 ;	
	 }


	if( in_vehicle == 3 ){ // airplane BE CAREFUL VEHICLES ARE NUMBERED 1,2,3 and NOT NOT NOT 0,1,2 
	// force = 0.0 ; // unly ropeller is use of course... it's an airplane... .
	
	body[2].torque_drv.vector[0] = -sign*vpar*9999999.0*body[2].axis_3.vector[0] ;
 	body[2].torque_drv.vector[1] = -sign*vpar*9999999.0*body[2].axis_3.vector[1] ;
	body[2].torque_drv.vector[2] = -sign*vpar*9999999.0*body[2].axis_3.vector[2] ;
	} // Manouveur airplane in flight.


	// printf("DRIVING AHEAD..\n");  
         for( i = 1 ; i < 3 ; i++ ){  /* rear tyre: right side. */            
      
             if ( i == 1  ){  
             force =  force ; /* FORCE X DFT !!!!! WARNING!!!! the impulse given by a press on accelerator botton.  */
             }
         else{
         force = -force ; /* Force X dft !!!!! WARNING!!!! DO NOT MISTAKE HERE!! je is an IMPULSE!! */
         }
       



          if( l_crec[ 4*(in_vehicle-1) + i ] < l_vsp && v_spring_curr[ in_vehicle-1 ].vector[1] < 0.0 /*if car is dupside down, do not give force ... it's not realistic in matter of automoblism, eve if it make sense physically  */ ){
	  int aui ;
	  aui = pillowvx[4*(in_vehicle-1) + i ][1] ;
  //extract vector: this is the RADIUS going form polyheron's CM to the vertex which has touched ground or on which some impulse is excerted!! 
          aux_vect.vector[0] = body[in_vehicle-1].vx_s.matrix[0][ aui ]  + ( l_c )*v_spring_curr[in_vehicle-1].vector[0] ;  //TEST

          aux_vect.vector[1] = body[in_vehicle-1].vx_s.matrix[1][ aui ]  + ( l_c )*v_spring_curr[in_vehicle-1].vector[1] ;  //TEST
          aux_vect.vector[2] = body[in_vehicle-1].vx_s.matrix[2][ aui ]  + ( l_c )*v_spring_curr[in_vehicle-1].vector[2] ;  //TEST: see if  l_c alone  or (lc + diam)....
                                                                       
          //ok taking the parti perpendicular to v_spring_curr but it must be made effective eliminating the perpenducular parto from s_nloc itself!!             
          s_nloc = cross( wheel[ 4*(in_vehicle-1)+i ].axis, v_spring_curr[in_vehicle-1] ) ;
	
       
          //calc linear and angular vel, but do not update anything!!! !!! REMEMBRE THAT THIS USES AN APPLROXIMATE CAR PHYSICS MODEL.
          s_vector0.vector[0] =  (force)*s_nloc.vector[0] ; // OK.
          s_vector0.vector[1] =  (force)*s_nloc.vector[1] ;
          s_vector0.vector[2] =  (force)*s_nloc.vector[2] ;


	body[in_vehicle-1].acc_drv      = vector_sum( body[in_vehicle-1].acc_drv ,  s_vector0 ) ;  //ok. WARNING! -- STARTS 0.0 BUT BOTH SIDES' EFFECT MUST BE ADDED UP!!!
	body[in_vehicle-1].torque_drv   = vector_sum( body[in_vehicle-1].torque_drv  ,  cross( aux_vect, pscv( s_nloc  , force ) )   ) ; // OK.

          }
	 

      }
 


      // sprintf(message,"truck@driver-info:~$ DRIVING AHEAD...") ;                  
      }





if ( s_left == 1 && in_vehicle > 0  ){

	if ( in_vehicle == 3 ){ // VEHICLES ARE NUMBERED 1,2,3 !!! BECAUSE 0 IS on-foot, that is, no vehicle.     
	body[2].torque_drv.vector[0] = -vpar*19999999.0*body[2].axis_1.vector[0] ;
 	body[2].torque_drv.vector[1] = -vpar*19999999.0*body[2].axis_1.vector[1] ;
	body[2].torque_drv.vector[2] = -vpar*19999999.0*body[2].axis_1.vector[2] ;				        
	} // Manouveur airplane in flight.



   if(  steerang < pi/5.0 ){

	if( leng_vect3(body[in_vehicle-1].vel) < 900.0 ){ // car goes slower than 9 [m/sec]
	steerang = steerang + 0.012*pi ;      
	alpha.x = 0.012*pi ; //rotate by a quite small angle, and with "steerang" keep tack of how much total rotation was achieved!.
	}
	else {  // meke steering a bit slower but more precise to prevent turning updside-down
	steerang = steerang + 0.004*pi ;      
	alpha.x = 0.004*pi ; //rotate by a quite small angle, and with "steerang" keep tack of how much total rotation was achieved!.
	}

	//build rotation matrix for that particular case.
	R1.matrix[0][0] =  cos(alpha.x) ; R1.matrix[0][1] = 0.0 ; R1.matrix[0][2] =  sin(alpha.x) ;
	R1.matrix[1][0] =  0.0          ; R1.matrix[1][1] = 1.0 ; R1.matrix[1][2] =  0.0          ;
	R1.matrix[2][0] = -sin(alpha.x) ; R1.matrix[2][1] = 0.0 ; R1.matrix[2][2] =  cos(alpha.x) ;

//aux_vect = mat3x3_vect( R1, aux_vect );
//rotate effectively the originals.

//====DEACTIVATED, WEll' SEE AFTER, THIS IS _TRUCK VERSION========

	wheel[0 + 4*(in_vehicle-1) ].axis_orig = mat3x3_vect( R1, wheel[0 + 4*(in_vehicle-1) ].axis_orig ) ;
	wheel[0 + 4*(in_vehicle-1) ].vx_origin = mat3x3_3xn(  R1, wheel[0 + 4*(in_vehicle-1) ].vx_origin ) ;


	wheel[3 + 4*(in_vehicle-1) ].axis_orig = mat3x3_vect( R1, wheel[3 + 4*(in_vehicle-1) ].axis_orig ) ;
	wheel[3 + 4*(in_vehicle-1) ].vx_origin = mat3x3_3xn(  R1, wheel[3 + 4*(in_vehicle-1) ].vx_origin ) ;
    } // end of if(steerng < ...) conditon.

} 



if ( s_right == 1 && in_vehicle > 0  ){

	if ( in_vehicle==3 ){ // vehcles are numbere 1,2,3 , BE CAREFUL!!     
	body[2].torque_drv.vector[0] =  vpar*19999999.0*body[2].axis_1.vector[0] ;
 	body[2].torque_drv.vector[1] =  vpar*19999999.0*body[2].axis_1.vector[1] ;
	body[2].torque_drv.vector[2] =  vpar*19999999.0*body[2].axis_1.vector[2] ;
	} // Manouveur airplane in flight.



    if( steerang> -pi/5.0 ){
	if( leng_vect3(body[in_vehicle-1].vel) < 900.0 ){ // car goes slower than 9 [m/sec]
	steerang = steerang - 0.012*pi ;      
	alpha.x = -0.012*pi ; //rotate by a quite small angle, and with "steerang" keep tack of how much total rotation was achieved!.
	}
	else {  // meke steering a bit slower but more precise to prevent turning updside-down
	steerang = steerang - 0.004*pi ;      
	alpha.x = -0.004*pi ; //rotate by a quite small angle, and with "steerang" keep tack of how much total rotation was achieved!.
	}


	//build rotation matrix for that particular case.
	R1.matrix[0][0] =  cos(alpha.x) ; R1.matrix[0][1] = 0.0 ; R1.matrix[0][2] =  sin(alpha.x) ;
	R1.matrix[1][0] =  0.0          ; R1.matrix[1][1] = 1.0 ; R1.matrix[1][2] =  0.0          ;
	R1.matrix[2][0] = -sin(alpha.x) ; R1.matrix[2][1] = 0.0 ; R1.matrix[2][2] =  cos(alpha.x) ;

//aux_vect = mat3x3_vect( R1, aux_vect );
//rotate effectively the originals.

//===DEAACTIVATED BECAUSE THS IS HERE (_TRUCK VERSION) iS PHYSICALY SIMULATED====

	wheel[0 + 4*(in_vehicle-1)].axis_orig = mat3x3_vect( R1, wheel[0 + 4*(in_vehicle-1)].axis_orig ) ;
	wheel[0 + 4*(in_vehicle-1)].vx_origin = mat3x3_3xn(  R1, wheel[0 + 4*(in_vehicle-1)].vx_origin ) ;


	wheel[3 + 4*(in_vehicle-1)].axis_orig = mat3x3_vect( R1, wheel[3 + 4*(in_vehicle-1)].axis_orig ) ;
	wheel[3 + 4*(in_vehicle-1)].vx_origin = mat3x3_3xn(  R1, wheel[3 + 4*(in_vehicle-1)].vx_origin ) ;

// printf("STEERED LX... \n ") ; 
	}
  } // end if (steerang z < ...) consition.

}
/*============================================================================*/









//=====================interactivity function using GLUT:=================================
//=========================================================================================
void rtinteractivityfunc(unsigned char input, int x, int y) {  // real time interactivity keypress receiver funciton.
// printf("ENTERED RTINTERACTIVITY FUNCTION KEYPRESS DETECTED!/////// \n");


/*========_TRUCK PECULIARITY!!!=====*/
/*NEEDED FOR COMPUTING EXTERNAL FORCES LSO WIHT IMPULSES (ACC = (V_NOW-v_BEFORE)/DT)*/
 //for( j= 0 ; j< nPOLY ; j++ ){
 //body[0].L_pre = body[0].L ;

 //body[0].vel_pre = body[0].vel ;
 //}
/*=================================*/

      // exit when ESC is pressed.
      if ( input== 27 /* codice ASCII del tasto ESC */ || input == 'q' ) {
      printf("QUIT BY USER. ") ;     
     
      SDL_Quit(); // secure exiting. 
      exit(1);     
      }





// regenerate car's original shape.

      if ( input == '0' ) {

double store_3xn_MAIN_CAR[3][ngon] ;
float auxxv[3*ngon] ;
int nelem = 0 ;

      printf("CAR REGENERATED.\n") ;
	nelem = check_vector_elements( "cars_data/car_vertexs_1.txt" ) ;
		read_vector( "cars_data/car_vertexs_1.txt", auxxv, nelem ) ; //read file and values in the auxxv array. 



/* feed into 'the' array used for this..... */
   for( j = 0 ; j < nelem/3 ; j++ ){
	for( i = 0 ; i < 3 ; i++ ){
	store_3xn_MAIN_CAR[i][j] = auxxv[ j*3 + i ] ;
	}
   }

   

//copy data in the body[].vx_s.  structure: 
for(i = 0 ; i < ngon ; i++ ){
body[0].vx_origin.matrix[0][i] = 1.0*store_3xn_MAIN_CAR[0][i] ;
body[0].vx_origin.matrix[1][i] = 1.0*store_3xn_MAIN_CAR[1][i] ;
body[0].vx_origin.matrix[2][i] = 1.0*store_3xn_MAIN_CAR[2][i] ;

}

//here one should calculate che CM... but it's a fuss to copy this procedure here.....
/* Calc CM of body 0 and set vx_origin vectors so that the [0,0] be the real CM of each body. 
Then also che CM will be moved back so that there is no change in realtive positions of podies... */

double CM[3][nPOLY] ;
double NUM[3] = { 0.0, 0.0, 0.0 } , DEN[3] = { 0.0, 0.0 , 0.0 } ;
int nu = 0 ;

 for( j = 0 ; j < 3 ; j++ ){
 
   for( i = 0 ; i < ngon ; i++ ){  /* calc numerator */
   NUM[j] = NUM[j] + body[nu].vx_mass.matrix[0][i]*body[nu].vx_origin.matrix[j][i] ;
   }
   for( i = 0 ; i < ngon ; i++ ){  /* calc denominator and assign the result oft he division */
   DEN[j] = DEN[j] + body[nu].vx_mass.matrix[0][i] ;             
   }
   
 CM[j][nu] = NUM[j]/DEN[j] ;
 }


//-------------PART 2 -------------------------
     for(i = 0; i < 3 ; i++){
            for( j = 0 ; j < ngon ; j++) {
            body[nu].vx_origin.matrix[i][j] = body[nu].vx_origin.matrix[i][j] - CM[i][nu] ;    
	    }
      body[nu].pos.vector[i] = body[nu].pos.vector[i] + CM[i][nu] ; // done. OK:	    
      }
// SEEM OK. SEEMS. ADD A FLASH OF PARTICLES TO INDICATE THAT SOME BIG CHNGE TO CAR CHASSIS HAS JUST HAPPENED:
j = 0 ;
for( i = 0 ; i < 27 ; i++) {
add_particles( body[j].pos.vector[0] +  body[j].vx_s.matrix[0][i]  , 
	       body[j].pos.vector[1] +  body[j].vx_s.matrix[1][i]  , 
	       body[j].pos.vector[2] +  body[j].vx_s.matrix[2][i]  , 

	0.0 , 
	0.0 , 
	0.0 , dft,  1  ) ;
}

}

	

	if( input == ' ' /* space */ ||  input == 'p' ){
		if( in_vehicle == 0  ){   // FROM NOW ON , SMILZO's POSITION iS THAT OF CARBODY 's CM.
		float x, y, z, di_1, di_2, di_3 ; 
		x = body[0].pos.vector[0]-smilzo_x ; // distance of Smilzo from main car .
		y = body[0].pos.vector[1]-smilzo_y ;
		z = body[0].pos.vector[2]-smilzo_z ;
		di_1 = sqrt( x*x + y*y + z*z  ) ;
		
		x = body[1].pos.vector[0]-smilzo_x ; // distanceof smilzo from airplane (body 3)
		y = body[1].pos.vector[1]-smilzo_y ;
		z = body[1].pos.vector[2]-smilzo_z ; 
		di_2 = sqrt( x*x + y*y + z*z  ) ;
		
		x = body[2].pos.vector[0]-smilzo_x ; // distanceof smilzo from airplane (body 3)
		y = body[2].pos.vector[1]-smilzo_y ;
		z = body[2].pos.vector[2]-smilzo_z ; 
		di_3 = sqrt( x*x + y*y + z*z  ) ;
		
		// with more than 3 vehicles, do it with sorting... .
		   if(  ( di_1 < di_2 && di_1 < di_3 ) && di_1 < 300 /* must be at less than 2 menters from car's Center of Mass */ ){ 
		  // if Smilzo is closer to the main car, get in that by assigning in_vehicle == 1
		   in_vehicle = 1 ; // get in vehicle
		   }
		   else if( ( di_2 < di_1 && di_2 < di_3 ) && di_2 < 500   ){ 
		   in_vehicle = 2 ;
		   } 
		   else if( ( di_3 < di_1 && di_3 < di_2 ) && di_3 < 500   ){
		   in_vehicle = 3 ;
		   } 

		
		if( in_vehicle > 0 ){ // of course be careful to when to apply hits... hit if Smilzo got in some vehicle... . 
		body[ in_vehicle-1 ].vxFs.matrix[1][7] = body[in_vehicle-1].vxFs.matrix[1][7] - 5000000000.0 ; 
		}
		
		}
		else if( in_vehicle > 0  ){
		in_vehicle = 0 ; // get out of vehicle
		// follow_mode_switch = 1 ;
		
		/* THIS NOT.
		cam_target_dir = cam_target_dir2 ;
		cam_horiz_ref = cam_horiz_ref2 ;
		cam_up_vector = cam_up_vector2 ;
		*/
		
		smilzo_x = smilzo_x + 140.0*cam_horiz_ref2.vector[0] ;
		smilzo_z = smilzo_z + 140.0*cam_horiz_ref2.vector[2] ;

		body[0].vxFs.matrix[1][7] = body[0].vxFs.matrix[1][7] + 2000000000.0 ; 
		}
 
	}




	
	

	if ( input == 's'  ){      
	wheel[0].stopped = 1 ;
	wheel[2].stopped = 1 ;
	}

//==END PART RELEVANT ONLY TO IRONSMILZO NAD NOT CTRUCK3D.==



		if( input == 'w'  &&  in_vehicle == 0 ){
		
			if( follow_mode_switch == 1 ){
			smilzo_x = smilzo_x + 30.0*cam_target_dir.vector[0] ;
			smilzo_z = smilzo_z + 30.0*cam_target_dir.vector[2] ;	
			}
			else if( follow_mode_switch == 3 ){
			smilzo_x = smilzo_x + 10.0*cam_target_dir2.vector[0] ;
			smilzo_z = smilzo_z + 10.0*cam_target_dir2.vector[2] ;	
			}

	
		}

		if( input == 'z'  &&  in_vehicle == 0 ){  // DO IT AS THE xFORWARD ONE!!!
		smilzo_x = smilzo_x - 10.0*cam_target_dir.vector[0] ;
		smilzo_z = smilzo_z - 10.0*cam_target_dir.vector[2] ;	
		}




	if( input == 'w'  &&  in_vehicle > 0 ){
	gas = 1 ;
	}


      
   





    if (input == 'a' && in_vehicle > 0  ){   
  s_left = 1 ;
    } // END end of if- steer_the_truck.


    if (input == 'd' &&   in_vehicle > 0   ){            
	s_right = 1 ; 

    }// END end of if- steer_the_truck.
    
    
      
    if (input == 'c' || ( in_vehicle == 0 && input == 'd' ) ){
      alphaCam = -0.05 ;
      

	if( follow_mode_switch == 1 ){
	cam_theta = cam_theta + 0.1 ;

/*
//row 1:  
	D_CAM.matrix[0][0] = 0 ; 
	D_CAM.matrix[0][1] = -cam_up_vector.vector[2]; 
	D_CAM.matrix[0][2] =  cam_up_vector.vector[1] ;
//row 2:
	D_CAM.matrix[1][0] =  cam_up_vector.vector[2] ; 
	D_CAM.matrix[1][1] =   0 ; 
	D_CAM.matrix[1][2] =  -cam_up_vector.vector[0] ;
//row 3:
	D_CAM.matrix[2][0] = -cam_up_vector.vector[1] ; 
	D_CAM.matrix[2][1] =   cam_up_vector.vector[0]; 
	D_CAM.matrix[2][2] =   0 ;
*/

	}
	else if ( follow_mode_switch == 3 ){

	
		
	
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_up_vector2.vector[2]; 
D_CAM.matrix[0][2] =  cam_up_vector2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =  cam_up_vector2.vector[2] ; 
D_CAM.matrix[1][1] =  0.0 ; 
D_CAM.matrix[1][2] =  -cam_up_vector2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] = -cam_up_vector2.vector[1] ; 
D_CAM.matrix[2][1] =  cam_up_vector2.vector[0]; 
D_CAM.matrix[2][2] =  0.0 ;

}

//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( alphaCam ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( alphaCam )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!




if( follow_mode_switch == 1 ){
/*  cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
  cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
  cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; */
}
else if(  follow_mode_switch == 3  ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}


            
      }
      






    if (input == 'v' || ( in_vehicle == 0 && input == 'a' ) ){
      
          alphaCam = 0.05 ;
      
      
   	if( follow_mode_switch == 1 ){
	cam_theta = cam_theta - 0.1 ;
	}
	else if ( follow_mode_switch == 3 ){

	
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_up_vector2.vector[2]; 
D_CAM.matrix[0][2] =  cam_up_vector2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =  cam_up_vector2.vector[2] ; 
D_CAM.matrix[1][1] =  0.0 ; 
D_CAM.matrix[1][2] =  -cam_up_vector2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] = -cam_up_vector2.vector[1] ; 
D_CAM.matrix[2][1] =  cam_up_vector2.vector[0]; 
D_CAM.matrix[2][2] =  0.0 ;

}

//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( alphaCam ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( alphaCam )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!



if(  follow_mode_switch == 3  ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}

      
   }  
   
   
   
   
   
    if (input == 'r'){
            
      beta = -0.03 ;
                      

        if (follow_mode_switch == 1 ){
	cam_fi = cam_fi - 0.1 ;
	}
	else if (follow_mode_switch == 3 ){
               
		
             //row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_horiz_ref2.vector[2] ; 
D_CAM.matrix[0][2] =  cam_horiz_ref2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_horiz_ref2.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_horiz_ref2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_horiz_ref2.vector[1] ; 
D_CAM.matrix[2][1] =   cam_horiz_ref2.vector[0] ; 
D_CAM.matrix[2][2] =   0.0 ;

}


//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( beta ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( beta )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!

if ( follow_mode_switch == 1 ){
cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 
}
else if ( follow_mode_switch == 3 ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}

	
    }
      
  





    if (input == 'f'){
    beta = 0.03 ;
       
                            
    if (follow_mode_switch == 1 ){
    cam_fi = cam_fi + 0.1 ;
    }
    else if (follow_mode_switch == 3 ){
//row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_horiz_ref2.vector[2] ; 
D_CAM.matrix[0][2] =  cam_horiz_ref2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_horiz_ref2.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_horiz_ref2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_horiz_ref2.vector[1] ; 
D_CAM.matrix[2][1] =   cam_horiz_ref2.vector[0] ; 
D_CAM.matrix[2][2] =   0.0 ;
    }


//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( beta ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( beta )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!

if ( follow_mode_switch == 1 ){
cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 
}
else if ( follow_mode_switch == 3 ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}

             
    } 
      





    if (input == ','){
            
      beta = -0.03 ;
                      

     if (follow_mode_switch == 1 ){

             //row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_target_dir.vector[2]; 
D_CAM.matrix[0][2] =  cam_target_dir.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_target_dir.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_target_dir.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_target_dir.vector[1] ; 
D_CAM.matrix[2][1] =   cam_target_dir.vector[0]; 
D_CAM.matrix[2][2] =   0.0 ;
}
else if (follow_mode_switch == 3 ){
               	
             //row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_target_dir2.vector[2] ; 
D_CAM.matrix[0][2] =  cam_target_dir2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_target_dir2.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_target_dir2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_target_dir2.vector[1] ; 
D_CAM.matrix[2][1] =   cam_target_dir2.vector[0] ; 
D_CAM.matrix[2][2] =   0.0 ;

}


//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( beta ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( beta )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!
    
if ( follow_mode_switch == 1 ){
cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 
}
else if ( follow_mode_switch == 3 ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}


	
    }


    if (input == '-'){
            
      beta = 0.03 ;
                      

     if (follow_mode_switch == 1 ){

             //row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_target_dir.vector[2]; 
D_CAM.matrix[0][2] =  cam_target_dir.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_target_dir.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_target_dir.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_target_dir.vector[1] ; 
D_CAM.matrix[2][1] =   cam_target_dir.vector[0]; 
D_CAM.matrix[2][2] =   0.0 ;
}
else if (follow_mode_switch == 3 ){
               	
             //row 1:
D_CAM.matrix[0][0] =  0.0 ; 
D_CAM.matrix[0][1] = -cam_target_dir2.vector[2] ; 
D_CAM.matrix[0][2] =  cam_target_dir2.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =   cam_target_dir2.vector[2] ; 
D_CAM.matrix[1][1] =   0.0 ; 
D_CAM.matrix[1][2] =  -cam_target_dir2.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_target_dir2.vector[1] ; 
D_CAM.matrix[2][1] =   cam_target_dir2.vector[0] ; 
D_CAM.matrix[2][2] =   0.0 ;

}


//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( beta ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1.0-cos( beta )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!
    
if ( follow_mode_switch == 1 ){
cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 
}
else if ( follow_mode_switch == 3 ){
cam_target_dir2 = mat3x3_vect( R_VAR_CAM, cam_target_dir2 ) ;     
cam_up_vector2 =  mat3x3_vect( R_VAR_CAM, cam_up_vector2 )  ;    
cam_horiz_ref2 =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref2 )  ; 
}


	
    }



      
      
    if (input == '1' /* &&  ds>150 */ ){        
    ds = ds - 50 ;
    
        if( follow_mode_switch == 3 ){
        displace_x = displace_x - 5.0 ; 
        }
    
    //  distLR = distLR - 0.2 ; //a bit diminist also eyesdist because in case of close zooms speace effect non optimal  
    }
    
    if (input == '2' /* &&  ds<1500 */ ){
      ds = ds + 50 ;
      
        if(follow_mode_switch == 3 ){
        displace_x = displace_x + 5.0 ; 
        }
      
   // distLR = distLR + 0.2 ; //augment a bit eyesdist because it optimises spatial effect avouding the 'far mountains seem plane' effect.
    }

    if (input == '3'  ){        
        if(follow_mode_switch == 3 ){
        displace_z = displace_z - 5.0 ; 
        }  
    }
    if (input == '4'  ){      
        if(follow_mode_switch == 3 ){
        displace_z = displace_z + 5.0 ; 
        }
     }
	 if (input == '7'  ){        
        if(follow_mode_switch == 3 ){
        displace_y = displace_y - 5.0 ; 
        }  
    }
    if (input == '8'  ){      
        if(follow_mode_switch == 3 ){
        displace_y = displace_y + 5.0 ; 
        }
     }



if ( input == 'l' ){

if ( LagrangeArticulatedBodies == 1 ){
LagrangeArticulatedBodies = 0 ; // LEAVE TRUCK TRAILER... FC NOT APPLIED ANYORE!!
}
else {
LagrangeArticulatedBodies = 1 ; // REATTACH.
}
//dft = 2.0*dft ; // AUGMENT SIZE OF TIMESTEP BETWEEN SIM CYCLES ...REDUCE PRECISION
//best_dt_ms = best_dt_ms*3.0 ; //REDUCE WAITING
// draw_at_cycle = 1 ; // DRAW AT EVERY SIM CYCLE...
}

if( input == '5' && best_dt_ms > 5.0 ){

best_dt_ms = best_dt_ms - 5.0 ;
}

if( input == '6' && best_dt_ms < 100.0 ){
best_dt_ms = best_dt_ms + 5.0 ;
}

if( input == 'y' ){
dft = 0.015 ; // optimal simulation step time.
}


if (input == 'm'){
     woption = woption - 1;
     if (woption < 1){   /* avoid also textured representation: triangle number limitation not into this version. */
     woption = 6 ; //if it reaches 3, than goes back to 1;
     }
}


if (input == 'i'){

long int j,i ;
float bigvect[90000] ;


Uint8  red, green, blue ;
Uint32 color_to_convert ;	
SDL_Surface *sdl_image ;


     sdl_image = SDL_LoadBMP("hmap_300x300.bmp") ;

	if (sdl_image != NULL) {
	printf("file 'hmap_300x300.bmp' found\n" ) ;
	
	printf("ROUTINE CHECK: this MUST be 300... correct? ==> %i\n", sdl_image->h  );
	SDL_Delay(100);
	

	/*---------feed into 'the' array used for this.....---------*/
	for( j = 0 ; j < 300 ; j++ ){      // vertical
		for( i = 0 ; i < 300 ; i++ ){ // horizontal
		color_to_convert = getpixel( sdl_image, i, j ) ;
		SDL_GetRGB( color_to_convert, sdl_image->format, &red, &green, &blue ) ;
                      
		if( green == 0 && blue == 0 ){
		mg.shmap[299-j][i] = ( ( (float) red )/256.0 ) *10.0 ; // we use only the red component. 
		}
		else if( green > 0 && blue == 0 ){		
		mg.shmap[299-j][i] = ( 0.88 + ( (float) green )/256.0 ) *10.0 ; // we use only the green component. , and add a maximum... 1.0 + you know.... ;		
		}
		
		// printf("pixel : [%d,%d,%d]\n",red,green,blue);
		}
	}
	/*----------------------------------------------------------*/
	//Release the surface
	SDL_FreeSurface( sdl_image ) ;
	}
 
 

/* feed into 'the' array used for this..... */
   for( j = 0 ; j < 300 ; j++ ){
   gg.shmap[j][0] = 0.0 ; 
	for( i = 0 ; i < 300 ; i++ ){
	// mg.shmap[j][i] = bigvect[ j*300 + i ] ;
	gg.shmap[j/10+1][i/10+1] = mg.shmap[j][i]/10.0 ;

	gg.shmap[0][i] = 0.0 ; 
	stunts.map[j][i] = 0 ; // set NO STRUNCTURES case because when one goes out from the 30x30 region, there will find segfaults probably.
	}
   }

/* == NOW THE COLOR MAP ... we don't want dull, mono-chrome world.== */

sdl_image = SDL_LoadBMP("col_300x300.bmp") ;

	if ( sdl_image != NULL ) {
	printf("file 'col_300x300.bmp' found\n" ) ;
	
	printf("ROUTINE CHECK: this MUST be 300... correct? ==> %i\n", sdl_image->h  );
	SDL_Delay(100);
	

	/*---------feed into 'the' array used for this.....---------*/
	for( j = 0 ; j < 300 ; j++ ){      // vertical
		for( i = 0 ; i < 300 ; i++ ){ // horizontal
		color_to_convert = getpixel( sdl_image, i, j ) ;
		SDL_GetRGB( color_to_convert, sdl_image->format, &red, &green, &blue ) ;
                      
		mg.scol[299-j][i][0] = red  /256.0 ;
		mg.scol[299-j][i][1] = green/256.0 ;
		mg.scol[299-j][i][2] = blue /256.0 ;

		// printf("pixel : [%d,%d,%d]\n",red,green,blue);
		}
	}
/*----------------------------------------------------------*/
	//Release the surface
	SDL_FreeSurface(sdl_image);
	}




/* map of structures, which ones at which point of the standard grid. */
printf("STUNT STRUCTURE DISTRIBUTION FILE WILL BE READ IN NOW...\n");
read_vector( "stunts_30x30.txt", bigvect, 9000 ) ; //read file and values in the auxxv array. 
printf("SEEMS IT HAS BEEN DONE CORRECTLY...\n");

// feed into 'the' array used for this..... 
   for( j = 0 ; j < 30 ; j++ ){
	for( i = 0 ; i < 30 ; i++ ){
	stunts.map[j][i] = (int) bigvect[ j*30 + i ] ;
	}
   }
printf("GAME DATA READ IN AND USED CORRECTLY\n");

}



/* gravity (classical) control: */
if (input == '9' && g < 1800.0 ){ 
g = g - 50 ;
}
if (input == '8' && g <= 0 ){ 
g = g + 50 ;
}



/*DEV TESTING STUFF: */
if (input == 't'){ 
fovv = fovv + 0.05 ;
	if( fovv > 1.0 ){
	fovv = 0.2 ;
	}

/*
testindex++ ;
     if ( testindex > ngon  ){
     testindex = 0 ;
     }
*/
}


/*DEV TESTING STUFF: */
if (input == '.'){ 
test_tri++ ;
     if ( test_tri > SUPER_TRI-1  ){
     test_tri = 0 ;
     }
}


 if (input == 'o'){

     follow_mode_switch = follow_mode_switch + 1 ;
     if ( follow_mode_switch == 2 ){
     follow_mode_switch = follow_mode_switch + 1 ;
     }
     if ( follow_mode_switch > 3 ){
     follow_mode_switch = 1 ;
     }
 } //change view mode's index....      




    if (input == 'u'){
    // body[0].vxFs.matrix[1][0] = body[0].vxFs.matrix[1][0] + 1000000000.0 ;     
    // printf("-->DEVELOPER AREA: Y(UP) :FORCE APPLIED TO TEST-VERTEX\n") ; 

    body[in_vehicle-1].R             = body[in_vehicle-1].I ; // rientation is turned to that standard (initial one)
    body[in_vehicle-1].pos.vector[1] = body[in_vehicle-1].pos.vector[1] + 100.0 ; // raise CM position a bit... .	
    }
    if (input == 'h'){
    body[0].vxFs.matrix[0][0] = body[0].vxFs.matrix[0][0] + 10000000000.0 ;
    printf("-->DEVELOPER AREA:  X(SIDE) :FORCE APPLIED TO TEST-VERTEX\n"); }

    if (input == 'j'){
    body[0].vxFs.matrix[2][0] = body[0].vxFs.matrix[2][0] + 10000000000.0 ;
    printf("-->DEVELOPER AREA:  Z(SIDE) :FORCE APPLIED TO TEST-VERTEX\n"); }


	if (input == 'k'){
	Pforce = 0 ;
	}
	if (input == 'e'){
	Pforce = Pforce + 112233300.0  ;
	}

} //end of real time interactivity keypress receiver funciton.













/* NOT USED */
/*=============================replicate a pattern in a map, in which only 1 corner was shaped... good for big terrains ===============*/
void replicate_map_pattern( int x_nrep, int y_nrep,float **inpattern, int x_patt, int y_patt ){

long int nu, k, i, j ;
float tmppattern[100][100] ; /* largest secure value for static memory allocation */

i = x_patt ;
j = y_patt ;


k  = x_nrep ; 
nu = y_nrep ;

 /*make a copy of the part of original , used as pattern*/
 for(j = 0 ; j < y_patt ; j++ ){
	for( i = 0 ; i < x_patt  ; i++ ){
	tmppattern[j][i] = inpattern[j][i] ;
	}
 } 


 /*not map_side but number of squares at side OF midmap!! */
 for(nu = 0 ; nu < y_nrep ; nu++ ){
    for (k=0 ; k < x_nrep ; k++ ){	

	for(j = 0 ; j < y_patt ; j++ ){
	    for( i = 0 ; i < x_patt  ; i++ ){	  
     inpattern[ y_patt*nu + j ][ x_patt*k + i ] =  tmppattern[j][i]  ;
            }
	}


    }
 }


}
/*====================================================================================================================*/















void init_simulator(void)
{
int j, i, k, nu, ku ;




for(j = 0 ; j < 300 ; j++ ){
    for( i = 0 ; i < 300  ; i++ ){
    mg.shmap[j][i] = ((float) j )*((float) j)/3000.0 ;
    }
}



for(j = 0 ; j < 300 ; j++ ){
    for( i = 0 ; i < 300  ; i++ ){
    tree_map[j][i] = 0 ;
    tree_map[10*(j/10)][10*(i/10)] = 1 ; // a tree is there... .   
    }
}

srand(12345678) ;
for(j = 0 ; j < 1500 ; j++ ){
k  = (long int) 300*((float) rand() )/( (float) RAND_MAX ) ;
ku = (long int) 300*((float) rand() )/( (float) RAND_MAX ) ;


    tree_map[ k ][ ku ] = 2 ; // a tree is there... .

}
 

/*=========|Copy the hpa sample to a bigger, reepeating asways th seme sample as if it were a texture|=========*/

printf("map done.\n\n\n");


/* STRUCTURES: HUSES AND STUNT FACILITIES, set parameters/variables */
float cubevertexs[8][3] = { 
{ -1.0 , -1.0 , -1.0  },  
{  1.0 , -1.0 , -1.0  },
{  1.0 , -1.0 ,  1.0  },
{ -1.0 , -1.0 ,  1.0  },

{ -1.0 ,  1.0 , -1.0  },  
{  1.0 ,  1.0 , -1.0  },
{  1.0 ,  1.0 ,  1.0  },
{ -1.0 ,  1.0 ,  1.0  }
} ;

int cubefaces[6][4] = {
{ 0 ,1 ,2, 3 },
{ 4, 5, 6, 7 },
{ 0, 1, 5, 4 },

{ 1, 2, 6, 5 },
{ 2, 3, 7, 6 },
{ 3, 0, 4, 7 }
} ;

for( k = 0 ; k < stunts.nbtype ; k++ ){
stunts.building[k].ngonn = 4 ; /* how many vertexes has a face? 3 or 4... */ 
}

stunts.nbtype = NBTYPE ; // CRUCIAL TO INITIALIZE IT.

stunts.Lx[0] = 300.0 ;
stunts.Ly[0] = 600.0 ;
stunts.Lz[0] = 300.0 ;

stunts.Lx[1] = 1200.0 ;
stunts.Ly[1] = 600.0 ;
stunts.Lz[1] = 300.0 ;

stunts.Lx[2] = 1300.0 ;
stunts.Ly[2] = 150.0 ;
stunts.Lz[2] = 600.0 ;

stunts.Lx[3] = 1300.0 ;
stunts.Ly[3] = 150.0 ;
stunts.Lz[3] = 600.0 ;

stunts.Lx[4] = 1250.0 ;
stunts.Ly[4] = 150.0 ;
stunts.Lz[4] = 600.0 ;


for( i = 0 ; i < 8 ; i++ ){
	for( k = 0 ; k < stunts.nbtype ; k++ ){
	stunts.building[k].vertexes[i][0] = stunts.Lx[k]*cubevertexs[i][0] ;
	stunts.building[k].vertexes[i][1] = stunts.Ly[k]*cubevertexs[i][1] ;
	stunts.building[k].vertexes[i][2] = stunts.Lz[k]*cubevertexs[i][2] ;

	stunts.poscorrect_allowed[k] = 0 ; 

	stunts.frc[k] = 0.1 ;
	}
}

for( i = 0 ; i < 6 ; i++ ){
	for( k = 0 ; k < stunts.nbtype ; k++ ){ /* CAREFUL HERE!!! KINDS OF 'BOXES', TUBE AND HIGHWAY IS NOT COUNTED!!! */
stunts.building[k].polygons[i][0] = cubefaces[i][0] ;
stunts.building[k].polygons[i][1] = cubefaces[i][1] ;
stunts.building[k].polygons[i][2] = cubefaces[i][2] ;
stunts.building[k].polygons[i][3] = cubefaces[i][3] ;
	}
}


/* define axes startng from 2 spherical coordinates or 3 using the 3rd extra prameter */

for( k = 0 ; k < stunts.nbtype ; k++ ){ /* CAREFUL HERE!!! KINDS OF 'BOXES', TUBE AND HIGHWAY IS NOT COUNTED!!! */
stunts.building[k].th  = 0.0 ;
stunts.building[k].fi  = 0.0 ;
stunts.building[k].psi = 0.0 ;

stunts.building[k].Xc[0] = 1.0 ;
stunts.building[k].Xc[1] = 0.0 ;
stunts.building[k].Xc[2] = 0.0 ;

stunts.building[k].Yc[0] = 0.0 ;
stunts.building[k].Yc[1] = 1.0 ;
stunts.building[k].Yc[2] = 0.0 ;

stunts.building[k].Zc[0] = 0.0 ;
stunts.building[k].Zc[1] = 0.0 ;
stunts.building[k].Zc[2] = 1.0 ;
}

/* building type 0, 1, -->2 THIS ONE <-- change axes... rotate it to be used as a climb-up structure */
// orient_3axes( stunts.building[1].Xc, stunts.building[1].Yc , stunts.building[1].Zc,  0.0, 0.9, 0.0  ) ;

stunts.th[2] = 0.4 ; 
stunts.fi[2] = 0.0 ; // 0 --> is aligned on x ... Jump ALONG X AXIS ONLY, that's it.

stunts.th[3] =-0.4 ; 
stunts.fi[3] = 0.0 ; // 0 --> is aligned on x ... Jump ALONG X AXIS ONLY, that's it.


for( k = 0 ; k < stunts.nbtype ; k++ ){

float th = stunts.th[k] , fi = stunts.fi[k] ;

//R:
stunts.building[k].Zc[0] = -(cos(th)*sin(fi) ) ; //Yc = -( )  
stunts.building[k].Zc[1] = -(sin(th)*sin(fi) ) ;  
stunts.building[k].Zc[2] = -(        cos(fi) ) ;  

//P:
stunts.building[k].Yc[0] =  (-sin(th) ) ;        //Zc
stunts.building[k].Yc[1] =  ( cos(th) ) ; 
stunts.building[k].Yc[2] =  ( 0.0     ) ; 

//Q:
stunts.building[k].Xc[0] =  (-cos(th)*cos(fi) ) ;  // Xc
stunts.building[k].Xc[1] =  (-sin(th)*cos(fi) ) ;
stunts.building[k].Xc[2] =  (         sin(fi) ) ; 

}
/*----------------------------------------*/
stunts.frc[2] = 0.0 ; // trampolino type 1 is totaly frictionless.
stunts.frc[3] = 0.0 ; // trampolino type 2 is totaly frictionless.

stunts.poscorrect_allowed[0] = 1 ;  // position correction allowed only on some types of parallelepiped-shaped houses, where it's secure.
stunts.poscorrect_allowed[1] = 1 ; 
stunts.poscorrect_allowed[4] = 1 ; 



//SET VIRTUAL CAMERA ORIENTATION PARAMETERS - THREE SPECIAL VERSORS EACH ALIGNED WITH AN AXIS of OpenGL....
//put the elements... UP is 1.0 , the rest is put automaticallu 0.0 .
//DISTANCE IS IMPORTANT and is used after!!! IF A FOCUS-BASED REPRESENTATION!!

cam_target_dir.vector[0] = 1.0  ; 
cam_target_dir.vector[1] = 0.0  ;
cam_target_dir.vector[2] = 0.0  ;
   
   cam_up_vector.vector[0] = 0.0 ; 
   cam_up_vector.vector[1] = 1.0 ;
   cam_up_vector.vector[2] = 0.0 ;
   
   cam_horiz_ref.vector[0] = 0.0 ;
   cam_horiz_ref.vector[1] = 0.0 ;
   cam_horiz_ref.vector[2] = 1.0 ;

standard_up_dir.vector[0] = 0   ;
standard_up_dir.vector[1] = 1.0 ;
standard_up_dir.vector[2] = 0   ;



//for te internal, or fist person view modes. MUST BE RIGOROUSLY THE SEME AS THE OTHER!!!
cam_target_dir2.vector[0] = 1.0  ; 
cam_target_dir2.vector[1] = 0.0  ;
cam_target_dir2.vector[2] = 0.0  ;
   
   cam_up_vector2.vector[0] = 0.0 ; 
   cam_up_vector2.vector[1] = 1.0 ;
   cam_up_vector2.vector[2] = 0.0 ;
   
   cam_horiz_ref2.vector[0] = 0.0 ;
   cam_horiz_ref2.vector[1] = 0.0 ;
   cam_horiz_ref2.vector[2] = 1.0 ;





/* trianglulize only one, than copy... even if hmap changes, it's tianglulation is the seme. */


gg.map_size = 300 ;
gg.GPunit = 2500.0 ;




mg.map_size = 300 ;
mg.GPunit = 250.0 ;


// triangulize_subterrain( &mg, 11, 11 , hmap_gen ) ;
// triangulize_terrain_wsm( &mg, hmap_gen, 10 ) ; // deactivated PORCATA!!!


// triangulize_subterrain( &mg, 100, 100 , mg.shmap /* here it's obligatory to put it's own */ ) ; // AVOINDING THIS SHIT:... WORK IN PROGRESS.

for(j = 0 ; j < 100 ; j++ ){
    for( i = 0 ; i < 100  ; i++ ){
	big_texR[j][i] = 1.0 ; // default texture generation... .
	big_texG[j][i] = 1.0 ; // default texture generation... .
	big_texB[j][i] = 1.0 ;
    }
}








//Truck data (polyhedra with mass, 'solid'):
//Truck data (polyhedra with mass, 'solid'):
//Truck data (polyhedra with mass, 'solid'):
//setup seme mass for each vertex, of each polyhedron(standard value, mod manually if needed) :
for(j = 0 ; j < nPOLY ; j++ ){ // WARNING! ONLY FIRST 2( tractor-car and trailer) are auto-set, the rest is custom!!BARRELS AND SO ON...
      for( i = 0 ; i < ngon ; i++ ){
      body[j].vx_mass.matrix[0][i] = 4400.0 ;   //grams!!! RAISE IT A BIT!! 20 KG per vetex is ok.ORIG 20000.0   
      }
}


//INITIALISE MASS: CALCULATE TOTAL MASS AUTOMATICALLY:
for(nu = 0 ; nu < nPOLY ; nu++) {
    for(i = 0 ; i < ngon ; i++){  
    body[nu].MASS.x = body[nu].MASS.x +  body[nu].vx_mass.matrix[0][i]  ;
    }
}

// SET INITIAL POSIITONS OF POLYS: 

// THIS IS ON THE X AXIS: AXIS ALONG WHICH CARS SHOULD HAVE THEIR ALIGMNENT... HEAD-->BACK ;
  
body[0].pos.vector[0] = 902*GPunit  ;
body[1].pos.vector[0] = 59*GPunit ; //set initial X-position.


body[0].pos.vector[1] = 220   ;
body[1].pos.vector[1] = 200   ; //set initial Y-position.


body[0].pos.vector[2] = 79*mg.GPunit ;
body[1].pos.vector[2] = 68*GPunit ; //set initial Z-position. ('profundity'-enter screen).


// do the remaining bodies (if there are...).
for(nu = 2 ; nu < nPOLY ; nu++) {
body[nu].pos.vector[0] = 89*mg.GPunit ;
body[nu].pos.vector[1] = 9000.0 ; //[cm]
body[nu].pos.vector[2] = 103*mg.GPunit ;
printf("OTHER VEHICLES BEING LOADED...\n\n");
}

ku = 0 ;
k=2; 

//--------------------------------the 2 particular points, figure out which---------------------------
 i = 0 ; 
wheel[ku].vx_s.matrix[0][i] =  0.0 ; //ngon-1 cause one vertex must be put manually at center.
wheel[ku].vx_s.matrix[1][i] =  0.0 ; 
wheel[ku].vx_s.matrix[2][i] =  7.0 ;


 i = 1 ;

wheel[ku].vx_s.matrix[0][i] =  0.0 ; //ngon-1 cause one vertex must be put manually at center.
wheel[ku].vx_s.matrix[1][i] =  0.0 ; 
wheel[ku].vx_s.matrix[2][i] = -7.0 ;
//--------------------------------------------------------------------------    



//====SECURE RESETTING....======
for (i=2; i < ngon ; i++){          
wheel[ku].vx_s.matrix[0][i] = 1.0 ; //ngon-1 cause one vertex must be put manually at center.
wheel[ku].vx_s.matrix[1][i] = 1.0 ; 
wheel[ku].vx_s.matrix[2][i] = 1.0 ;
}
//==============================





 




ku = 0 ; // CRUCIAL!!! TO SAY WHICH ONE WE ARE DEFINING!!!
for (i=2; i < ngon_min ; i++){      // DEFINE WHEEL SHAPE.

wheel[ku].vx_s.matrix[0][i] = diam*cos( (i-2)*(2*2*pi/(ngon_min-2)) ) ; //ngon-1 cause one vertex must be put manually at center.
wheel[ku].vx_s.matrix[1][i] = diam*sin( (i-2)*(2*2*pi/(ngon_min-2)) ) ; 
wheel[ku].vx_s.matrix[2][i] = 11.0 ;

        if( i > (ngon_min-2)/2 ){ 
        wheel[ku].vx_s.matrix[2][i] = -11.0 ;
	}  // other side of 'wheel'.
   }

wheel[ku].vx_s.n = ngon ;






//copy the first wheel's vertex_definition to all wheels.
for(ku = 0 ; ku < NPILLOW  ; ku++ ){

wheel[ku].vx_s.n = ngon ;

wheel[ku].vx_s      =  wheel[0].vx_s ;   
wheel[ku].vx_origin =  wheel[0].vx_s ; 

wheel[ku].vx_origin.n = ngon ; 
wheel[ku].stopped = 0 ;
}






//put required vertexes manually!!!: fine-tune manually:
//TRUCK'S MAIN CAR:
//rest is auto-assigned zero [ 0 0 0 ].



//this is ok, needs not be read from external txt file.
double store_3xn_TRAIL_CAR[3][ngon] = 
{{-80,  180.0,  180.0, -10.0, -50, - 0, -50, -50, -50, 180, 180, -10, -10, -50,  -0, -50,  -10,  160,  160,  -10,    0 , -50  },
 { 6 ,  -20.0,  50.0 ,  50.0,  10, -20,  36,  36,  10, -20,  50,  50, -20,  36,  36,  50,  -20,  -20,  -20,  -20,  -20 , -20  },
 {-0 ,  -40.0,  -40.0, -40.0, -40, -40, -40, -40,  40,  40,  40,  40,  40,  40,  40,  40,  -50,  -50,   50,   50,  -40 ,  40  } 
} ;




/*===================VERTEXES FROM TXT FILE========================*/
long int nelem = 0 ;

char file_title[32] /* = "cars_data/car_vertexs_2.txt" */ ;  


/*
nelem = check_vector_elements( "cars_data/car_vertexs_1.txt" ) ;
float auxxv[3*ngon] ;
read_vector( "cars_data/car_vertexs_1.txt", auxxv, nelem ) ; //read file and values in the auxxv array. 
*/

float auxxv[4*ngon] ;
/* feed into 'the' array used for this..... */
for( k = 0 ; k < nPOLY ; k++ ){

//-----------------  
sprintf( file_title, "cars_data/car_vertexs_%i.txt", k+1 ); // CONVER k to norma int !!!!! FUCK!!
printf("VEHICLE NUMBER %s\n\n",file_title );

nelem = check_vector_elements( file_title ) ;

read_vector( file_title, auxxv, nelem ) ; //read file and values in the auxxv array. 
//---------------

   for( j = 0 ; j < sel_ngon[k] ; j++ ){
	for( i = 0 ; i < 3 ; i++ ){
	body[k].vx_s.matrix[i][j] = auxxv[ j*3 + i ] ;
	
	  if( k == 2 ){ // JUST TEMPORARILY... UN-AESTHETIC SOLUTION... MAGIC NUMBRS ARE NOT GOOD IN PROGRAMMING!
	  body[k].vx_s.matrix[i][j] = 1.5*auxxv[ j*3 + i ] ;
	  }
	
	}
   }


// read in the traignulation vector/ array. 
sprintf( file_title, "cars_data/car_triangul_%i.txt", k+1 ); // CONVER k to norma int !!!!! FUCK!!
printf("triangulation: VEHICLE NUMBER %s\n\n",file_title );

nelem = check_vector_elements( file_title ) ;
read_vector( file_title, auxxv, nelem ) ; //read file and values in the auxxv array. 
//---------------
/* feed into 'the' array used for this..... */
   for( j = 0 ; j < nelem/3 ; j++ ){
	for( i = 0 ; i < 3 ; i++ ){
	body[k].tri[j][i] = auxxv[ j*3 + i ] ;
	}
   }


printf("TRYING TO IMPORT TEXTURE ID AND ACCOMODATION CONFIGURATION FOR EACH FACE\n") ;
		/* CONVENTION: TEXTURE_ID_NUMBER | texture_coordinate_index_1   ""index_2   ""index_3 */

FILE *FilePtr ;		

		sprintf( file_title, "cars_data/car_facetexord_%i.txt", k+1 ) ; // CONVERT k to norma int !!!!! FUCK!!
		FilePtr = fopen( file_title, "r" ) ;
					  
			 /* feed into 'the' array used for this..... */
			for( j = 0 ; j < nelem/3 ; j++ ){
			printf("line %i of text file...\n", j ) ; 
			fscanf( FilePtr,"%4i | %4i %4i %4i\n", &body[k].face_texid[j], &body[k].face_texord[j][0], &body[k].face_texord[j][1], &body[k].face_texord[j][2] ) ;
			}
		fclose(FilePtr)	;	

}


 /*nelem = check_vector_elements( "cars_data/car_triangul_1.txt" ) ;
 read_vector( "cars_data/car_triangul_1.txt", auxxv, nelem ) ; //read file and values in the auxxv array. 

// feed into 'the' array used for this..... 
   for( j = 0 ; j < SUPER_TRI ; j++ ){
	for( i = 0 ; i < 3 ; i++ ){
	car_tri[j][i] = (int) auxxv[ j*3 + i ] ;
	}
   }
*/
// printf("ERROR HERE???\n\n\n");
// THIS IS SUPERFLUOUS.... DELETE IT!
 nelem = check_vector_elements( "cars_data/car_tricolor_1.txt" ) ;
 printf("CHECK HOW MANY!! =%li== AROUND 100 MUST BE OR IT IS ERROR....!!!\n\n\n",nelem);
 
 waitdt_ms(100) ;
                   read_vector( "cars_data/car_tricolor_1.txt", auxxv, nelem /*SECURE*/ ) ; //read file and values in the auxxv array. 

/* feed into 'the' array used for this..... */
   for( j = 0 ; j < SUPER_TRI ; j++ ){
	for( i = 0 ; i < 3 ; i++ ){
	car_tricolor[j][i] = auxxv[ j*3 + i ] ;
	}
   }





/*=================END==VERTEXES FROM TXT FILE====================*/




//TRAILER SHAPE copy data in the body[].vx_s.  structure: 
for(i = 0 ; i < ngon ; i++ ){
body[1].vx_s.matrix[0][i] = 3.0*store_3xn_TRAIL_CAR[0][i] ;
body[1].vx_s.matrix[1][i] = 3.0*store_3xn_TRAIL_CAR[1][i] ;
body[1].vx_s.matrix[2][i] = 3.0*store_3xn_TRAIL_CAR[2][i] ;

}


for( j = 0 ; j < nPOLY ; j++ ){
	for( i = 0 ; i < ngon ; i++ ){
	body[j].imp_resist.matrix[0][i] = std_imp_resist ; // load default.of course it 'should' be different for a car and a tank or airplane....
	}
}



//copy this into the "body" structure: because vx[][][] is originally
//aimed to be used in the  display()  function, to make it easier to read.
for( nu = 0 ; nu<nPOLY; nu++ ){
     for (i = 0; i <3 ; i++) {
         for (j = 0 ; j < ngon ; j++) {
         body[nu].vx_origin.matrix[i][j] = body[nu].vx_s.matrix[i][j] ; 
         }
     }
body[nu].vx_origin.n = sel_ngon[nu] ;   /*how many comlumns of matrcix...*/   
}


//********************PROVVISORY**********************
body[2].axis1_orig.vector[0] = 1.0 ;
body[2].axis1_orig.vector[1] = 0.0 ;
body[2].axis1_orig.vector[2] = 0.0 ;

body[2].axis2_orig.vector[0] = 0.0 ;
body[2].axis2_orig.vector[1] = 1.0 ;
body[2].axis2_orig.vector[2] = 0.0 ;

body[2].axis3_orig.vector[0] = 0.0 ;
body[2].axis3_orig.vector[1] = 0.0 ;
body[2].axis3_orig.vector[2] = 1.0 ;
//******************END PROVVISORY PART***************


/* Calc CM of each body and set vx_origin vectors so that the [0,0] be the real CM of each body. 
Then also che CM will be moved back so that there is no change in realtive positions of podies... */

double CM[3][nPOLY] ;

for( nu = 0 ; nu < nPOLY; nu++ ){

double NUM[3] = { 0.0, 0.0, 0.0 } , DEN[3] = { 0.0, 0.0 , 0.0 } ;

 for( j = 0 ; j < 3 ; j++ ){
 
   for( i = 0 ; i < ngon ; i++ ){  /* calc numerator */
   NUM[j] = NUM[j] + body[nu].vx_mass.matrix[0][i]*body[nu].vx_origin.matrix[j][i] ;
   }
   for( i = 0 ; i < ngon ; i++ ){  /* calc denominator and assign the result oft he division */
   DEN[j] = DEN[j] + body[nu].vx_mass.matrix[0][i] ;             
   }
   
 CM[j][nu] = NUM[j]/DEN[j] ;
 }

}


for( nu = 0 ; nu < nPOLY; nu++ ){
     for(i = 0; i < 3 ; i++){
            for( j = 0 ; j < ngon ; j++) {
            body[nu].vx_origin.matrix[i][j] = body[nu].vx_origin.matrix[i][j] - CM[i][nu] ;    
	    }
      body[nu].pos.vector[i] = body[nu].pos.vector[i] + CM[i][nu] ;	    
      }
}





//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:
v_spring.vector[0] =  0.0 ;
v_spring.vector[1] = -1.0 ;
v_spring.vector[2] =  0.0 ;

down_dir.vector[0] =  0.0 ;
down_dir.vector[1] = -1.0 ;
down_dir.vector[2] =  0.0 ;


//tyre guidance: we consider the tyre's ideal rotation axis (perpendiculat to the 'disk'), because that's the 'normal vector'....



//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:
//VIRTUAL SPRING VERSOR  _Simplex version only.:


//just introduce it here, test, it: otherwise it's in the interactivity part...:
//machenic axis of tyre 1(of course thsi sxis changes due to crawling and due to steering, find it analytically then:
/*
s_vector1.vector[0] = body[1].vx_s.matrix[0][0] ;  //extract vector from vector-collection matrix.
s_vector1.vector[1] = body[1].vx_s.matrix[1][0] ;
s_vector1.vector[2] = body[1].vx_s.matrix[2][0] ;

s_vector2.vector[0] = body[1].vx_s.matrix[0][1] ;  //extract vector from vector-collection matrix.
s_vector2.vector[1] = body[1].vx_s.matrix[1][1] ;
s_vector2.vector[2] = body[1].vx_s.matrix[2][1] ;

//just be careful to preserve the order of vertex1- vertex2, whenever used.
body[1].reartyre_axis_ori = vector_sum( s_vector1,  pscv(s_vector2, -1.0) );
*/


for( i = 0 ; i < 4 ; i++ ){

  if( i == 0 || i == 1 ){
  s = -1 ;
  }
  
//body[i].reartyre_axis_ori.vector[0] =   0.0 ;  
//body[i].reartyre_axis_ori.vector[1] =   0.0 ;  
//body[i].reartyre_axis_ori.vector[2] = s*1.0 ;  


// ==========_TRUCK PECULIARITY ==========.
wheel[i].axis_orig.vector[0] =   0.0 ;
wheel[i].axis_orig.vector[1] =   0.0 ;
wheel[i].axis_orig.vector[2] = s*1.0 ;

wheel[i+4].axis_orig.vector[0] =   0.0 ;
wheel[i+4].axis_orig.vector[1] =   0.0 ;
wheel[i+4].axis_orig.vector[2] = s*1.0 ;

wheel[i+8].axis_orig.vector[0] =   0.0 ;
wheel[i+8].axis_orig.vector[1] =   0.0 ;
wheel[i+8].axis_orig.vector[2] = s*1.0 ;

wheel[i].axis     = mat3x3_vect( body[0].R, wheel[i  ].axis_orig ) ;
wheel[i + 4].axis = mat3x3_vect( body[1].R, wheel[i+4].axis_orig ) ; //copy to remaining 4 tyres, in seme order... for the trailer... .
wheel[i + 8].axis = mat3x3_vect( body[2].R, wheel[i+8].axis_orig ) ; //copy to remaining 4 tyres, in seme order... for the trailer... .
//============================================


s = 1 ;

//body[i].reartyre_axis = mat3x3_vect( body[i].R, body[i].reartyre_axis_ori ) ;

//wheel[i-1].axis = mat3x3_vect( body[i].R, wheel[i-1].axis_orig ) ;
//wheel[i-1 + 4].axis = mat3x3_vect( body[i].R, wheel[i-1].axis_orig ) ;


}

//OK in the _Simplex version too. head- tyres and rear- tyres.






for (j=0; j<nPOLY ; j++){
//initialise rotation axis:(unit-lenght!!!!!!)
body[j].rotaxis.vector[0] = 1.0 ;
body[j].rotaxis.vector[1] = 0.0 ;
body[j].rotaxis.vector[2] = 0.0 ;

body[j].vang.x = 0.0 ; //just initialise, but let it so: = 1.

//set identity matrix (IMPORTANT!!!! CHECK ALWAYS IN CASE OF TROUBLES!!):
body[j].I.matrix[0][0] = 1.0 ;  //remaining elements are automatically set to 0.  
body[j].I.matrix[1][1] = 1.0 ;  //eventually check, put zeros manually.
body[j].I.matrix[2][2] = 1.0 ;  //ones on diagonals....

//set inertia tensor and it's inverse.
body[j].TI = make_inertia_tensor( body[j].vx_origin , body[j].vx_mass , ngon ) ;  //remaining elements are automatically set to 0.  

//set inverse of intertia tensor caculated automatically by the inv(A_matrix) function.
body[j].TIinv =  inv( body[j].TI ) ; 


//set initial configuration of the R matrix: the do-nothing configuration 
//(poly was not rotated yet): Identity matrix.
body[j].R = body[j].I ;

body[j].ww = pscv( body[j].rotaxis, body[j].vang.x ) ;

body[j].L = mat3x3_vect( body[j].TI , body[j].ww )   ;
}




//set initial Truck view:
       //row 1:
D_CAM.matrix[0][0] = 0 ; 
D_CAM.matrix[0][1] = -standard_up_dir.vector[2]; 
D_CAM.matrix[0][2] =  standard_up_dir.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =  standard_up_dir.vector[2] ; 
D_CAM.matrix[1][1] =   0 ; 
D_CAM.matrix[1][2] =  -standard_up_dir.vector[0] ;
//row 3:
D_CAM.matrix[2][0] = -standard_up_dir.vector[1] ; 
D_CAM.matrix[2][1] =   standard_up_dir.vector[0]; 
D_CAM.matrix[2][2] =   0 ;

//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( alphaCam ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1-cos( alphaCam )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!
  cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
  cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
  cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 




//VERTICAL ELEVATION VIEW:
D_CAM.matrix[0][0] = 0 ; 
D_CAM.matrix[0][1] = -cam_horiz_ref.vector[2]; 
D_CAM.matrix[0][2] =  cam_horiz_ref.vector[1] ;
//row 2:
D_CAM.matrix[1][0] =  cam_horiz_ref.vector[2] ; 
D_CAM.matrix[1][1] =   0 ; 
D_CAM.matrix[1][2] =  -cam_horiz_ref.vector[0] ;
//row 3:
D_CAM.matrix[2][0] =  -cam_horiz_ref.vector[1] ; 
D_CAM.matrix[2][1] =   cam_horiz_ref.vector[0]; 
D_CAM.matrix[2][2] =   0 ;

//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R_VAR - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
R_VAR_CAM = 
mat3x3_sum(
           mat3x3_sum( 
                      body[0].I ,
                      pscm33( D_CAM, sin( beta ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(D_CAM, D_CAM ),
                  1-cos( beta )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
//update the camera orientation vectors!!!
  cam_target_dir = mat3x3_vect( R_VAR_CAM, cam_target_dir ) ;     
  cam_up_vector =  mat3x3_vect( R_VAR_CAM, cam_up_vector )  ;    
  cam_horiz_ref =  mat3x3_vect( R_VAR_CAM, cam_horiz_ref )  ; 





//calculate spring natural lenghts:
//calculate spring natural lenghts:
//calculate spring natural lenghts:

/*
for (j=0; j< nsprings; j++) {
    
int indexPOLY[2]    = {springvx[j][0] ,  springvx[j][2] } ;
int indexVERTEX[2]  = {springvx[j][1] ,  springvx[j][3] } ;

row  = indexVERTEX[0] ;
col  = indexPOLY[0]   ;
row2 = indexVERTEX[1] ;
col2 = indexPOLY[1]   ;

dist = sqrt( pow( (body[col].vx_s.matrix[0][row] + body[col].pos.vector[0] - body[col2].vx_s.matrix[0][row2] - body[col2].pos.vector[0]) ,2) 
          +  pow( (body[col].vx_s.matrix[1][row] + body[col].pos.vector[1] - body[col2].vx_s.matrix[1][row2] - body[col2].pos.vector[1]) ,2)   
          +  pow( (body[col].vx_s.matrix[2][row] + body[col].pos.vector[2] - body[col2].vx_s.matrix[2][row2] - body[col2].pos.vector[2]) ,2) ) ;

Lo[j] = dist ;   
}
*/

for (j=0; j<nPOLY ; j++){ // SAFE reset of variables.
body[j].acc_drv.vector[0] = 0.0 ;
body[j].acc_drv.vector[1] = 0.0 ;
body[j].acc_drv.vector[2] = 0.0 ;
 
body[j].torque_drv.vector[0] = 0.0 ;
body[j].torque_drv.vector[1] = 0.0 ;
body[j].torque_drv.vector[2] = 0.0 ;
}

rtinteractivityfunc('i',2,3) ; // READ GAME-DATA , height-map and color-map and so on, red them in... .
rtinteractivityfunc('l',2,3) ; // leave TRAILER.



} //end of simulator initialiser function.











//a   single simualtion cycle as a function.
//a   single simualtion cycle as a function.
//a   single simualtion cycle as a function.
//a   single simualtion cycle as a function.
void mainw(void)   //a   single simualtion cycle as a function.
{
//SIMUALATION CYCLES:
//SIMUALTIN CYCLES:
//SIMUALTIN CYCLES:
// printf("ENTERED MAINW()\n");
static int tot_cyclesdone = 0 ;

// PUT BELOW WHEN display() IS CALLED!! !! waitdt_ms(best_dt_ms) ; /* PAUSE BETWEEN CYCLES.*/

// process_carhandling_inputs() ; // called elswhere... thought this way it was more clear structually.

draw_cycle++ ;
counter++ ;
tot_cyclesdone++ ;


//=======_TRUCK PECULIARITY!! =========
//RESET TO [0,0,0] the total CM acceleration fo each body.

for (j = 0; j<nPOLY; j++){           //do the provedure for each POLYGON.
    
body[j].acc_tot.vector[0]    = 0.0 ; 
body[j].acc_tot.vector[1]    = 0.0 ; 
body[j].acc_tot.vector[2]    = 0.0 ;

body[j].torque_tot.vector[0]    = 0.0 ; 
body[j].torque_tot.vector[1]    = 0.0 ; 
body[j].torque_tot.vector[2]    = 0.0 ;

body[j].vel_pre = body[j].vel ;  //store the velocity vector from fefore collision! It's needed to calculate virtual acceleration if needed!!

body[j].L_pre = body[j].L ;      
}
//==================================================




//rebounce from walls enclosing terrain - PROCEDURES 
//rebounce from walls enclosing terrain - PROCEDURES
//rebounce from walls enclosing terrain - PROCEDURES
// for (j = 0; j<nPOLY; j++){           //do the provedure for each POLYGON.

for (j = 0; j< nPOLY - 1 /* LAST BODY NOT !!! */ ; j++){                
	for (i = 0 ; i < sel_ngon[j] ; i++ ) {    //n.b. i<ngon+1 to pick last vx too.

          if (   (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) <= 0   ||  (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) <= 0 
             ||  (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) >= mg.GPunit*(xlimit-2) || (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) >= mg.GPunit*(ylimit-2)  
             ){  

                 if( (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) < 0 ){  // X wall
                 s_nloc.vector[0]  =  1.0  ;
                 s_nloc.vector[1]  =  0.0  ;   
                 s_nloc.vector[2]  =  0.0  ;   
                 
                 s_vector0.vector[0] = 0.0 - ( body[j].pos.vector[0] + body[j].vx_s.matrix[0][i] ) ;
                 s_vector0.vector[1] = 0.0 ;
                 s_vector0.vector[2] = 0.0 ;
                 } 
                 if( (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) <= 0 ){ // Z wall
                 s_nloc.vector[0]  =  0.0  ;
                 s_nloc.vector[1]  =  0.0  ;   
                 s_nloc.vector[2]  =  1.0  ;   
                 
                 s_vector0.vector[0] = 0.0 ;
                 s_vector0.vector[1] = 0.0 ;
                 s_vector0.vector[2] = 0.0 - ( body[j].pos.vector[2] + body[j].vx_s.matrix[2][i] ) ;                                                                                      
                 }

                 if( (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) >= mg.GPunit*(xlimit-2) ){
                 s_nloc.vector[0]  = -1.0  ;
                 s_nloc.vector[1]  =  0.0  ;   
                 s_nloc.vector[2]  =  0.0  ;  
                 
                 s_vector0.vector[0] = mg.GPunit*(xlimit-2 ) - ( body[j].pos.vector[0] + body[j].vx_s.matrix[0][i] ) ;
                 s_vector0.vector[1] = 0.0 ;
                 s_vector0.vector[2] = 0.0 ;
                                        
                 }
                 if( (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) >= mg.GPunit*(ylimit-2 )  ){
                 s_nloc.vector[0]  =  0.0  ;
                 s_nloc.vector[1]  =  0.0  ;   
                 s_nloc.vector[2]  = -1.0  ;  
                 
                 s_vector0.vector[0] = 0.0 ; // USED AL LAST FOR POS CORRECT.
                 s_vector0.vector[1] = 0.0 ;
                 s_vector0.vector[2] = mg.GPunit*(ylimit-2) - ( body[j].pos.vector[2] + body[j].vx_s.matrix[2][i] ) ;    
                 
                 }
	
                                  
                    
                  
                    s_vector1.vector[0] = body[j].vx_s.matrix[0][i] ;  //extract vector from vector-collection matrix.
                    s_vector1.vector[1] = body[j].vx_s.matrix[1][i] ;
                    s_vector1.vector[2] = body[j].vx_s.matrix[2][i] ;


                     //CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
                     //FORMULA NORMSPEED. 
                     body[j].vvertex = vector_sum( 
                     body[j].vel, cross( body[j].ww,  s_vector1 )
                             ) ;
                      //END FORMULA to calculate "vvertex".
                      
                     vnorm = dot3_st( s_nloc , body[j].vvertex )  ; //the output is a float  anyway: 'vnorm' is a float, just as is. 

                           if (vnorm < 0 ) {
                           //REBOUNCE PART:                  
       
                           UP   = -(1.0+e)*vnorm  ;
                           DOWN = 1.0/body[j].MASS.x + dot3_st(  cross(s_vector1, s_nloc ) , mat3x3_vect( body[j].TIworInv, cross(s_vector1, s_nloc ) ) ) ;
       
                           je = UP/DOWN ;
   

//================= deformation: STILL TO DO BETTER... =====================

if( LagrangeArticulatedBodies == 0  && je > 21000000.0  ){
	
//	if( je > 70000000.0 ){
//	je =     70000000.0 ;
//	}

deform_poly( &s_nloc, je, &body[j], i ) ;
je = 21000000.0 ;
add_particles( body[j].pos.vector[0] +  body[j].vx_s.matrix[0][i]  , 
	       body[j].pos.vector[1] +  body[j].vx_s.matrix[1][i]  , 
	       body[j].pos.vector[2] +  body[j].vx_s.matrix[2][i]  , 

	body[j].vvertex.vector[0], 
	/* body[j].vvertex.vector[1] */ 50.0 , 
	body[j].vvertex.vector[2], dft,  1  ) ;


}
//=================================DEFORMATION END===========================


   
                           //update linear and angular vel.
                            body[j].vel.vector[0] = body[j].vel.vector[0] + (je/body[j].MASS.x)*s_nloc.vector[0] ;
                            body[j].vel.vector[1] = body[j].vel.vector[1] + (je/body[j].MASS.x)*s_nloc.vector[1] ;
                            body[j].vel.vector[2] = body[j].vel.vector[2] + (je/body[j].MASS.x)*s_nloc.vector[2] ;
       
    


//=====FOR VINCLAR DYNAMICS=========== 
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
body[j].acc_tot    = pscv( vector_sum( body[j].vel, pscv( body[j].vel_pre, -1.0 ) ) , 1.0/dft )  ;			    
//====================================			    




//extract vector from vector-collection matrix of vertexes: 'j' number of bolyhedron. 'i' number of one of it's vertexes.
aux_vect.vector[0] = body[j].vx_s.matrix[0][i] ;
aux_vect.vector[1] = body[j].vx_s.matrix[1][i] ;
aux_vect.vector[2] = body[j].vx_s.matrix[2][i] ;

//rebounce contribution:
body[j].ww = vector_sum( body[j].ww ,  mat3x3_vect( body[j].TIworInv, cross( aux_vect, pscv( s_nloc  ,je) )  ) ); 


//update also the angular momentum, since ww chenged: then also angular momentum changes (obvious).
body[j].L = mat3x3_vect( body[j].TIwor , body[j].ww )   ;  


//==FOR===VINCULAR DYNAMICS!=====
//calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
body[j].torque_tot    = pscv( vector_sum( body[j].L, pscv( body[j].L_pre, -1.0 ) ) , 1.0/dft )  ;	
//================================







//recalc separately vang and rotation-axis versor.
body[j].vang.x = leng_vect3( body[j].ww ) ;

body[j].rotaxis.vector[0] = body[j].ww.vector[0] /body[j].vang.x  ;
body[j].rotaxis.vector[1] = body[j].ww.vector[1] /body[j].vang.x  ;
body[j].rotaxis.vector[2] = body[j].ww.vector[2] /body[j].vang.x  ;


//DEACTIVATE TO TEST:
//POS CORRECT AFTER REBOUNCE:TRUCK BACK TO TOUCH POINT, REGUARDLESS OF SMALL PHYSICAL SURREALISM.                             
//now displacement vector was entered before, apply correction: 		     
	//	if( LagrangeArticulatedBodies == 0 ){  // with constraint vincular dynamics, do not make position corrections becaause it shits up the vertex concidence conditions, worsning precision.              	                                                                   
       body[j].pos = vector_sum( body[j].pos, pscv( s_vector0, 1.0 ) );  //try harder correction if necessaru, add some plus value...       
	//	}
       }
    }
  }   //end of vertex check scroll.
}     //end of individual POLYGONs scroll.











      




double RR = 1250.0 ;
int susp_hight_set[NPILLOW] ; 


for( i = 0 ; i < NPILLOW ; i++ ){ // set it 0 for all, the default situation.
susp_hight_set[i] = 0 ;
}


Xi =  body[in_vehicle-1].pos.vector[0]/gg.GPunit ;  // ok it should bedone for all 3 bodies but it's better todo itonly for the vehicle being used...
Yi =  body[in_vehicle-1].pos.vector[2]/gg.GPunit ;

if( stunts.map[Xi][Yi] == 1 ){ // in that region in whih car is, there's a big tube.... 
//TUBE REBOUNCE PROCEDURES.
//TUBE REBOUNCE PROCEDURES.
//TUBE REBOUNCE PROCEDURES.

printf("in  TUBE\n\n\n\n\n") ;

int pc = 0 ;
int mach = 0 ;
int ku ;


for (j = 0; j < 1; j++ ){           //do the provedure for each POLYHEDRON.
      for (i = 0 ; i <  sel_ngon[j] ; i++ ){    //n.b. i<ngon+1 to pick last vx too.

//vertex-by-vertex of course: one vertex at a time!	


//============================================================================================================================
//READ BELOW: Typical only of CTruck3D_Simplex and _Truck ... only the '- _Simplex' and '_Truck' version !!!  REMEMBER THAT WE ARE SIMULATING PHYSICALLY JUST 1 BODY (2 for double pendulum --> truck )!!!
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	

  for( ku = 0 ; ku < NPILLOW ; ku++ ){
     if( pillowvx[ku][0]  == j && pillowvx[ku][1] == i  ){
     mach = 1 ;  
     }
  }

float dis, disCM ;
dis   = sqrt( pow( (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i] - RR - gg.GPunit*gg.shmap[Xi][Yi] ),2) 
	    + pow( (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i] - RR - Yi*gg.GPunit ),2) ) ;


disCM = sqrt( pow( (body[j].pos.vector[1] - RR - gg.GPunit*gg.shmap[Xi][Yi] ),2) 
	    + pow( (body[j].pos.vector[2] - RR - Yi*gg.GPunit ),2) ) ;


  if( mach == 1 ){  

  h_vxvs[pc] = ( -dis + RR ) ;  //is negative!check equation members always! very normal plane equation explicied to height (here y is the height...). 
	if( h_vxvs[pc] < 1.0*l_vsp &&   h_vxvs[pc] > -diam /* POSITIVE and a little more than MAX virtualSPRING LENGHT, an extern variable */ ){
	susp_hight_set[pc] = 1 ;
	}


  pc++ ;  
  mach = 0 ;
  }

//===========================================================================================================================



//IF VERTEX IS UNDER LEVEL...
       if ( (dis  > RR  &&  disCM < RR) ||   (dis < RR  &&  disCM > RR)  ) {
	 

// SHOULD BE DONE WITH SIN,COS... so it's excact. 
double alph, x_aux, y_aux ;
x_aux = ( body[j].pos.vector[1] + body[j].vx_s.matrix[1][i] - RR - gg.GPunit*gg.shmap[Xi][Yi]  )/dis ;  // dividing by dis, this way is useless anyway.
y_aux = ( body[j].pos.vector[2] + body[j].vx_s.matrix[2][i] - RR - Yi*gg.GPunit )/dis ; 

alph = atan2 ( x_aux, y_aux ) ;

s_nloc.vector[0] = 0.0 ; 
s_nloc.vector[1] = - sin(alph) ;
s_nloc.vector[2] = - cos(alph) ;

norm_vxvs[pc][0] = s_nloc.vector[0] ; 
norm_vxvs[pc][1] = s_nloc.vector[1]; 
norm_vxvs[pc][2] = s_nloc.vector[2] ;


if ( dis < RR  &&  disCM > RR ){
s_nloc.vector[0] = 0.0 ; 
s_nloc.vector[1] = + sin(alph) ;
s_nloc.vector[2] = + cos(alph) ;
} 

if( leng_vect3( s_nloc ) > 1.0 ){
printf("fatal physics error \n") ;
getchar() ;
}


//	if( j == 0 || j == 1 ){   //only if it's the main body-polyhedron, apply the original formula.


	s_vector1.vector[0] = body[j].vx_s.matrix[0][i] ;  //extract vector from vector-collection matrix.
	s_vector1.vector[1] = body[j].vx_s.matrix[1][i] ;
	s_vector1.vector[2] = body[j].vx_s.matrix[2][i] ;

	//CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
	//FORMULA NORMSPEED. 
	body[j].vvertex = vector_sum( 
			    body[j].vel, cross( body[j].ww,  s_vector1 )
				    ) ;
				    
				    
        //here the friction normal... hard for the terrain triangle is inclined(general case)... we must combine the two infos: normal and vel vector....
	//combine this two infos to get: how much of the speed of the vertex is arallel to the surface of the triangle it is touching?
	//copy velocity vector of vertex into an auxiliary vector to work with easily.
	aux_vect.vector[0] = body[j].vvertex.vector[0] ;
	aux_vect.vector[1] = body[j].vvertex.vector[1] ; 
	aux_vect.vector[2] = body[j].vvertex.vector[2] ;			     			     			     
	//END FORMULA to calculate "vvertex".


	//since the gound is the 'fix' reference system to measure relative velocities end positions, with it we can establish objectively: goes or not. 
	if ( leng_vect3(aux_vect) > 0.1 ){        
	s_nTloc =  cross(s_nloc, cross(s_nloc, aux_vect ) )  ;       //vector measuring the parto of motion parallel-to-surface: 3D....
	s_nTloc =  pscv(s_nTloc, -1.0 ) ;                                                  //invert sense: friction opposes motion's direction!
	} 
	else{ 
	s_nTloc.vector[0] = 0.0 ;
	s_nTloc.vector[1] = 0.0 ;
	s_nTloc.vector[2] = 0.0 ;
	}


	 vnorm = dot3_st( s_nloc , body[j].vvertex )  ; //the output is a float  anyway: 'vnorm' is a float, just as is. 				    
	
	
	
	     if (vnorm < 0 ) {
       //REBOUNCE PART:                  
       
     
       
             //apply original formula only to the main body... tyres' polyhedron is only virtual, since it's effect is transmitted back to main body.
	 
	         UP   = -(1 + e )*vnorm  ;
                DOWN = 1/body[j].MASS.x + dot3_st(  cross(s_vector1, s_nloc ) , mat3x3_vect( body[j].TIworInv, cross(s_vector1, s_nloc ) ) ) ;
       
                je = UP/DOWN ;


//================= deformation: STILL TO DO BETTER... =====================

if( LagrangeArticulatedBodies == 0  && je > 11000000.0  ){ // RIGHT VALUE? MUST LOOK REALISTIC
	
//	if( je > 70000000.0 ){
//	je =     70000000.0 ;
//	}

deform_poly( &s_nloc, je, &body[j], i ) ;
je = 11000000.0 ;
add_particles( body[j].pos.vector[0] +  body[j].vx_s.matrix[0][i]  , 
	       body[j].pos.vector[1] +  body[j].vx_s.matrix[1][i]  , 
	       body[j].pos.vector[2] +  body[j].vx_s.matrix[2][i]  , 

	body[j].vvertex.vector[0], 
	body[j].vvertex.vector[1], 
	body[j].vvertex.vector[2], dft,  1  ) ;
}
//=================================DEFORMATION END=============================================



		//FRICTION PART:       
		//FRICTION PART:       

		if ( fabs(  pow( body[j].vvertex.vector[0],2 ) + pow( body[j].vvertex.vector[2],2 ) ) > 0.1 ) {  //see if parellely to ground there is relative motion.
		s = 1; 
		} 
		else{
		s = 0 ;
		} //don't play w too small numbers,may cause /0 and INF.
     
	 
	 
       vnorm = s*dot3_st(s_nTloc, body[j].vvertex) ;   //we overwrite it, since it's been already used for what it was aimed.
       UPf   = -(0.0 + fr_gro )*vnorm       ;     //careful with adaptation: here, the max restitution is 1.0.  

       DOWNf = 1/body[j].MASS.x    +  dot3_st(  cross(s_vector1, s_nTloc ) , mat3x3_vect( body[j].TIworInv, cross(s_vector1, s_nTloc ) ) )  ;
 
       jf = UPf/DOWNf           ;
       
	// how much 'statical'  friction? 
	if ( fabs(jf) > 120000.0 ){ //CHECK VALUE!!! if too much, it becomes dynamic friction and substantially we have lost control over the car!! 
	jf = (500*jf)/fabs(jf) ;   
	}
 
//*********TEEEEEEEEEEEEEST**********
jf = 0.0 ; // WARNING TEST TEST ASSUME IT'S METAL NO FRICTION.
//***********************************
	 

       //update linear and angular vel.
       body[j].vel.vector[0] = body[j].vel.vector[0] + (je/body[j].MASS.x)*s_nloc.vector[0] + (s*jf/body[j].MASS.x)*s_nTloc.vector[0] ;
       body[j].vel.vector[1] = body[j].vel.vector[1] + (je/body[j].MASS.x)*s_nloc.vector[1] + (s*jf/body[j].MASS.x)*s_nTloc.vector[1] ;
       body[j].vel.vector[2] = body[j].vel.vector[2] + (je/body[j].MASS.x)*s_nloc.vector[2] + (s*jf/body[j].MASS.x)*s_nTloc.vector[2] ;
                       

      //===FOR VINCULAR DYNAMICS!!=======
      //calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
      body[j].acc_tot    = pscv( vector_sum( body[j].vel, pscv( body[j].vel_pre, -1.0 ) ) , 1.0/dft )  ;
      //==========================

      //extract vector from vector-collection matrix of vertexes: 'j' number of bolyhedron. 'i' number of one of it's vertexes.
      aux_vect.vector[0] = body[j].vx_s.matrix[0][i] ;
      aux_vect.vector[1] = body[j].vx_s.matrix[1][i] ;
      aux_vect.vector[2] = body[j].vx_s.matrix[2][i] ;
      
      
      //rebounce contribution:
      body[j].ww = vector_sum( body[j].ww ,  mat3x3_vect( body[j].TIworInv, cross( aux_vect, pscv( s_nloc  ,je) )  ) ); 
      //friction contribution during ground-touch.To simply add to prevoous result (rebounce part alone).Only the  pscv()  values change!!!
      body[j].ww = vector_sum( body[j].ww ,  mat3x3_vect( body[j].TIworInv, cross( aux_vect, pscv( s_nTloc ,jf) )  ) ) ; 


      //update also the angular momentum, since ww chenged: then also angular momentum changes (obvious).
      body[j].L = mat3x3_vect( body[j].TIwor , body[j].ww )   ;  



	//========FOR VINCULAR DYNAMICS!============
	//calc virtual acceleration undergone in the discreet dt simulaiton cycle time.      
	body[j].torque_tot    = pscv( vector_sum( body[j].L, pscv( body[j].L_pre, -1.0 ) ) , 1.0/dft )  ;
	//==========================================



      //recalc separately vang and rotation-axis versor.
      body[j].vang.x = leng_vect3( body[j].ww ) ;

	  if(body[j].vang.x > 0.0000001  ){
	  body[j].rotaxis.vector[0] = body[j].ww.vector[0] /body[j].vang.x  ;
	  body[j].rotaxis.vector[1] = body[j].ww.vector[1] /body[j].vang.x  ;
	  body[j].rotaxis.vector[2] = body[j].ww.vector[2] /body[j].vang.x  ;
	  }
	  else{
	  body[j].rotaxis.vector[0] = 0.0  ;
	  body[j].rotaxis.vector[1] = 0.0  ;
	  body[j].rotaxis.vector[2] = 0.0  ;
	  }
                           
 




//DEACTIVATE TO TEST:
//POS CORRECT AFTER REBOUNCE:TRUCK BACK TO TOUCH POINT, REGUARDLESS OF SMALL PHYSICAL SURREALISM.       
//now fine-tune, since correction must be done along the normal, for fewer error.

/*
if( body[j].pos.vector[1] +  body[j].vx_s.matrix[1][i] < RR +  (gg.GPunit*gg.shmap[Xi+1][Yi] + gg.GPunit*gg.shmap[Yi][Xi+1])/2.0  ){ // if collisions happens in the lower half of the tube.
disth =   dis-RR  ;		     
}
else{ // if collision happens in the upper half of the tube 
disth = -(dis-RR) ;
}

s_vector0.vector[0] = 0.0   ; 
s_vector0.vector[1] = disth ; 
s_vector0.vector[2] = 0.0   ;

disth = dot3_st(s_vector0, s_nloc );
aux_vect = pscv(s_nloc, disth);		     

body[j].pos = vector_sum( body[j].pos, aux_vect );  //try harder correction if necessaru, add some plus value...
*/
		     
       //TO TEST OF FOR PRO BLEMS, PUT: disth= 0.0 ; 	                                                        
       	           }  // vnorm < 0 condition....
	
				    
//	}
	
    }
  }   //end of vertex check scroll.
}     //end of individual POLYGONs scroll.

}
else if( (k=stunts.map[Xi][Yi]) > 1  ||  (k=stunts.map[Xi][Yi])< 0 ){ // in that region in whih car is, there's a big BOX/house.... 

//BOX REBOUNCE PROCEDURES.
//BOX REBOUNCE PROCEDURES.
//BOX REBOUNCE PROCEDURES.

// printf("in  BOX? TEST PROCEDURE WILL BE DONE NOW\n") ;

int pc = 0 ;
int mach = 0 ;
int ku ;
float x1, y1, z1, avect[3] ;
float center_height= 0 ;

	
	/*
	if( k > 1 ){
	center_height = mg.GPunit*mg.shmap[10*Xi][10*Yi] ; 
	k = k - 2 ; // 0 is reserved for nothing, 1 for TUBE... so. 
	}
	else if ( k < 0 ){
	center_height = -k*1000 ; 
	k = NBTYPE-1 ;	
	}
	*/

	if( k > 1 ){
	center_height = mg.GPunit*mg.shmap[10*Xi][10*Yi] ; 
	k = k - 2 ; // 0 is reserved for nothing, 1 for TUBE... so. 
	}
	else if ( k < 0 ){
		if( k > -10 ){
		center_height = -k*1000.0 ; 
		k = NBTYPE-3 ; // trampolino type 1.	
		}
		else if(k < -10 && k > -20){
		center_height = -k*1000.0 -10000.0  ; 
		k = NBTYPE-2 ; // trampoino type 2 
		}
		else{
		center_height = -k*1000.0 -20000.0 ;
		k = NBTYPE-1 ; // highway
		}
	}




for (j = 0; j < nPOLY ; j++ ){           //do the procedure for each POLYHEDRON.
      for (i = 0 ; i <  sel_ngon[j] ; i++ ){    //n.b. i<ngon+1 to pick last vx too.

//vertex-by-vertex of course: one vertex at a time!	


	avect[0] =  body[j].pos.vector[0] + body[j].vx_s.matrix[0][i] - (Xi+0.5)*gg.GPunit ;
	avect[1] =  body[j].pos.vector[1] + body[j].vx_s.matrix[1][i] - center_height ;
	avect[2] =  body[j].pos.vector[2] + body[j].vx_s.matrix[2][i] - (Yi+0.5)*gg.GPunit ;

	x1 = avect[0]*stunts.building[k].Xc[0] + avect[1]*stunts.building[k].Xc[1] + avect[2]*stunts.building[k].Xc[2]; 
	y1 = avect[0]*stunts.building[k].Yc[0] + avect[1]*stunts.building[k].Yc[1] + avect[2]*stunts.building[k].Yc[2];
	z1 = avect[0]*stunts.building[k].Zc[0] + avect[1]*stunts.building[k].Zc[1] + avect[2]*stunts.building[k].Zc[2];   



//============================================================================================================================
//READ BELOW: Typical only of CTruck3D_Simplex and _Truck ... only the '- _Simplex' and '_Truck' version !!!  REMEMBER THAT WE ARE SIMULATING PHYSICALLY JUST 1 BODY (2 for double pendulum --> truck )!!!
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
// if( ( j == 0  && i < 4 ) ){  //take 0,1,2,3... the first 4(or set if mere are needed. normal cars have 4 wheels usually... ).

  for( ku = 0 ; ku < NPILLOW ; ku++ ){
     if( pillowvx[ku][0]  == j && pillowvx[ku][1] == i  ){
     mach = 1 ;  
     }
  }



  if( mach == 1 ){  
	 if(   fabs( x1 ) <  stunts.Lx[k]
	    && fabs( z1 ) <  stunts.Lz[k]
	     ){ // THE POINT TO WHICH AMMORTYZER IS ATTACHED is withing region of box... 
	// must consider also case in whit it's accidentally head-down... the pice we mean... .
	h_vxvs[pc] = y1  - stunts.Ly[k] ;  //is negative!check equation members always! very normal plane equation explicied to height (here y is the height...). 

		if( h_vxvs[pc] < l_vsp /*TO TEST...*/ &&    h_vxvs[pc] > -diam /* ONLY POSITIVE */ ){
        	susp_hight_set[pc] = 1 ; /* TO DO ONLY WHEN IT's INSIDE SOMETHING!!! */ 
	

	/* now 'record' the normal-vector of the surfac above which the wheel-supporting vertex is... here only on-box case is considered- side-touch is not implemented. */
		norm_vxvs[pc][0] = stunts.building[k].Yc[0] ; 
		norm_vxvs[pc][1] = stunts.building[k].Yc[1] ; 
		norm_vxvs[pc][2] = stunts.building[k].Yc[2] ;
		}

	}

  pc++ ; // it is upgraded here since it max comes to NPILLOW since all maches may max be as much as NPILLOW
  mach = 0 ;
     
  }

//===========================================================================================================================



//IF VERTEX IS WITHING THE BOX'S VOLUME the VERTEX must stay within, not just the CM
       if ( 
      fabs( y1 ) < stunts.Ly[k] && 
      fabs( x1 ) < stunts.Lx[k] 
   && fabs( z1 ) < stunts.Lz[k]        ) {
	 

	 
	 
                     
if(        ( disth=fabs( y1 - stunts.Ly[k] ) ) < 20.0 ){
s_nloc.vector[0] = stunts.building[k].Yc[0] ; 
s_nloc.vector[1] = stunts.building[k].Yc[1] ;
s_nloc.vector[2] = stunts.building[k].Yc[2] ;
}
else if(        ( disth=fabs( y1 + stunts.Ly[k] ) ) < 20.0 ){
s_nloc.vector[0] = -stunts.building[k].Yc[0] ; 
s_nloc.vector[1] = -stunts.building[k].Yc[1] ;
s_nloc.vector[2] = -stunts.building[k].Yc[2] ;
}
else if(   ( disth=fabs( x1 + stunts.Lx[k] ) ) < 20.0 ){ // X hit from closer to X = 0 ;
s_nloc.vector[0] =-stunts.building[k].Xc[0] ; 
s_nloc.vector[1] =-stunts.building[k].Xc[1] ; 
s_nloc.vector[2] =-stunts.building[k].Xc[2] ;
// printf("HIT HOUSE AT X SIDE \n\n\n\n\n");
}
else if(   ( disth=fabs( x1 - stunts.Lx[k] ) ) < 20.0 ){ // the side opposite to the one condered just above.
s_nloc.vector[0] = stunts.building[k].Xc[0] ; 
s_nloc.vector[1] = stunts.building[k].Xc[1] ;
s_nloc.vector[2] = stunts.building[k].Xc[2] ;
}
else if(   ( disth=fabs( z1 + stunts.Lz[k] ) ) < 20.0 ){  // Z hit from closer to Z = 0 ;
s_nloc.vector[0] =-stunts.building[k].Zc[0] ; 
s_nloc.vector[1] =-stunts.building[k].Zc[1] ;
s_nloc.vector[2] =-stunts.building[k].Zc[2] ;
}
else if(   ( disth=fabs( z1 - stunts.Lz[k] ) ) < 20.0 ){
s_nloc.vector[0] = stunts.building[k].Zc[0] ; 
s_nloc.vector[1] = stunts.building[k].Zc[1] ;
s_nloc.vector[2] = stunts.building[k].Zc[2] ;
}

 


/*check is normvel < 0 and eventually calculated and assigns new velocities and so.*/ 
body_rebounce( &body[j], 
 body[j].vx_s.matrix[0][i], body[j].vx_s.matrix[1][i], body[j].vx_s.matrix[2][i],   
 s_nloc.vector[0]         , s_nloc.vector[1]         , s_nloc.vector[2],i, e, stunts.frc[k] ) ;



	//DEACTIVATE TO TEST:
	//POS CORRECT AFTER REBOUNCE:TRUCK BACK TO TOUCH POINT, REGUARDLESS OF SMALL PHYSICAL SURREALISM.       
	//now fine-tune, since correction must be done along the normal, for fewer error.

	if( stunts.poscorrect_allowed[k] == 1 ) { 
	aux_vect = pscv(s_nloc, disth);		     
	body[j].pos = vector_sum( body[j].pos, aux_vect );  //try harder correction if necessaru, add some plus value...
	}		     
        //TO TEST OF FOR PROBLEMS, PUT: disth= 0.0 ; 	                                                        
   	
    }
  }   //end of vertex check scroll.
}     //end of individual POLYGONs scroll.

} // end of IF at beginning 

/*======================================================================*/








//GROUND REBOUNCE PROCEDURES.fine-terrain "mg."
//GROUND REBOUNCE PROCEDURES.
//GROUND REBOUNCE PROCEDURES.

int pc = 0 ;
int mach = 0 ;
int ku ;



//parameters appearing in the equation of 3D plane... .
	for (j = 0; j < nPOLY; j++ ){           //do the provedure for each POLYGON.
		for (i = 0 ; i <  sel_ngon[j] ; i++ ){    //n.b. i<ngon+1 to pick last vx too.

		double apl, bpl, cpl, dpl, Xtri, Ytri, Ztri, Zf, dist_fp1, dist_fp2 ;



//vertex-by-vertex of course: one vertex at a time!	
//find which triangle is the vertex touching....
//excact pos.
// ABSOLUTE VALUE IS ONLY A SECURITY MEASURE!!!!! AND TRICKY TERRAIN. MIRRORING STRAIGHT.
Xf = (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i])/mg.GPunit ;
Zf = (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i])/mg.GPunit ;


//index of which square's region it is within. 
Xi = floor( Xf ) ;  //x axis (in/out-screen)
Yi = floor( Zf ) ;  //z axis (right/left-of-screen)


/*a cautional correction to avoi SegmentationFault: SECURE. */
if( Xi < 0 || Xi > 300 ){  /* if it accidentally becomes negative, put it zero but nuder that there is no terrain!! */
//Xi = 0 ;
continue ;
}
if( Yi < 0 || Yi > 300 ){  /* if it accidentally becomes negative, put it zero but nuder that there is no terrain!! */
//Yi = 0 ;
continue ;
}


dist_fp1 = sqrt( pow( Xf- Xi   ,2 )  + pow( Zf- Yi   ,2 ) ) ;
dist_fp2 = sqrt( pow( Xf-(Xi+1),2 )  + pow( Zf-(Yi+1),2 ) ) ;

     if ( dist_fp1 < dist_fp2  ){  //careful if negativ or positive the Z axis... in fact.
     col = 0 ; //lower triangle region.
     //printf("ON TRI_0... \n\n");
     }      
     else{    
     col = 1 ;
     //printf("ON TRI_1... \n\n");
     }


/*==========FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
// cross product method.

// ===THIS IS TRIANLGE 1 , BUT WE MUST ALSO IMPLEMENT THAT IT SEES IF TRI_1 OR TRI_2
//vect1.component-by component.
if ( col == 0 ){
s_vector0.vector[0] = 1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = mg.shmap[Xi+1][Yi] - mg.shmap[Xi][Yi] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = mg.shmap[Xi][Yi+1] - mg.shmap[Xi][Yi] ;
s_vector1.vector[2] = 1.0 ;
}
else if ( col == 1 ){
s_vector0.vector[0] = -1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = mg.shmap[Xi][Yi+1] - mg.shmap[Xi+1][Yi+1] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = mg.shmap[Xi+1][Yi] - mg.shmap[Xi+1][Yi+1] ;
s_vector1.vector[2] = -1.0 ;

}

s_nloc = cross( s_vector0 , s_vector1 ) ;

/*------------calculate apl, bpl and cpl on the fly---------------------- */
/* use cross_product method. */

  //put equation parameters.
apl = s_nloc.vector[0]  ;
bpl = s_nloc.vector[1]  ;
cpl = s_nloc.vector[2]  ;
dpl = 0 ; //this is still to calculate... it's not = 1  usually.


s_nloc.vector[0] = s_nloc.vector[0]/leng_vect3(s_nloc) ;
s_nloc.vector[1] = s_nloc.vector[1]/leng_vect3(s_nloc) ;
s_nloc.vector[2] = s_nloc.vector[2]/leng_vect3(s_nloc) ;







//look if verse is good... not always; must check if the y of the normal is positive... easy. if negative, invert vector.
if ( s_nloc.vector[1] < 0.0 ){
s_nloc.vector[0] = -s_nloc.vector[0] ;
s_nloc.vector[1] = -s_nloc.vector[1] ;
s_nloc.vector[2] = -s_nloc.vector[2] ;
}

/* be VERY CAREFUL becaus to find, we must use a point common to both triangles (col == 0 or col == 1): or make 2 cases... .  */
Xtri = (double) (Xi+1)*mg.GPunit ;
Ytri = (double) mg.GPunit*mg.shmap[Xi+1][Yi] ;
Ztri = (double) Yi*mg.GPunit ;

//now finally calculate dpl , the 'd' of the   ax + by + cz + d = 0   plane equation. 
dpl = -apl*Xtri - bpl*Ytri - cpl*Ztri ;
/*---------------------------------------------------------*/

//============================================================================================================================
//READ BELOW: Typical only of CTruck3D_Simplex and _Truck ... only the '- _Simplex' and '_Truck' version !!!  REMEMBER THAT WE ARE SIMULATING PHYSICALLY JUST 1 BODY (2 for double pendulum --> truck )!!!
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
// if( ( j == 0  && i < 4 ) /* || ( j == 1 && (i == 16 || i ==17 || i == 18 || i == 19) ) */ ){  //take 0,1,2,3... the first 4(or set if mere are needed. normal cars have 4 wheels usually... ).

  for( ku = 0 ; ku < NPILLOW ; ku++ ){
     if( pillowvx[ku][0]  == j && pillowvx[ku][1] == i  ){
     mach = 1 ;  
     }
  }

  if( mach == 1 &&  susp_hight_set[pc] == 0 /* CAFERUL WITH THIS!!!! */  ){  

h_vxvs[pc] =  (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) -(
-(          
(apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) + //(ax +
 cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + // cx +
 dpl)/bpl  
 ) 
) ;  //is negative!check equation members always! very normal plane equation explicied to height (here y is the height...). 

/* now 'record' the normal-vector of the triangle above which the wheel-supporting vertex s */
norm_vxvs[pc][0] = s_nloc.vector[0] ; 
norm_vxvs[pc][1] = s_nloc.vector[1] ; 
norm_vxvs[pc][2] = s_nloc.vector[2] ; 

  pc++ ;
  mach = 0 ;
  }

//===========================================================================================================================



//IF VERTEX IS UNDER GORUND LEVEL...
  //   if ( (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) < 0.0 ){ 
       if ( ( (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) < -( //is negative!chenck equation members always!!
	                                                             (apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) + //(ax +
	                                                              cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + // cx +
	                                                              dpl)/bpl                                               // d )/b
	                                                           )
	    ) 
	    ) {
	 

	 
/*check is normvel < 0 and eventually calculated and assigns new velocities and so.*/ 
body_rebounce( &body[j], 
 body[j].vx_s.matrix[0][i], body[j].vx_s.matrix[1][i], body[j].vx_s.matrix[2][i],   
 s_nloc.vector[0]         , s_nloc.vector[1]         , s_nloc.vector[2],i, e, 1.0 ) ;


//DEACTIVATE TO TEST:
//POS CORRECT AFTER REBOUNCE:TRUCK BACK TO TOUCH POINT, REGUARDLESS OF SMALL PHYSICAL SURREALISM.       
       disth =   ( -(apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) +
	             cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + 
                     dpl)/bpl)                                               - (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i] )  ;

//now fine-tune, since correction must be done along the normal, for fewer error.		     
s_vector0.vector[0] = 0.0   ; 
s_vector0.vector[1] = disth ; 
s_vector0.vector[2] = 0.0   ;

disth = dot3_st(s_vector0, s_nloc );
aux_vect = pscv(s_nloc, disth);		     
		     
       //TO TEST OF FOR PRO BLEMS, PUT: disth= 0.0 ; 	                                                        
       		// if( LagrangeArticulatedBodies == 0 ){  /* with constraint vincular dynamics, do not make position corrections becaause it shits up the vertex concidence conditions, worsning precision. */                   
       body[j].pos = vector_sum( body[j].pos, aux_vect );  //try harder correction if necessaru, add some plus value...
       		
    }
  }   //end of vertex check scroll.
}     //end of individual POLYGONs scroll.









//******BIG TERRAIN*******GROUND REBOUNCE PROCEDURES. FAR-terrain "gg."
//************************GROUND REBOUNCE PROCEDURES.
//************************GROUND REBOUNCE PROCEDURES.

//parameters appearing in the equation of 3D plane... .
	for (j = 0; j < nPOLY; j++ ){           //do the provedure for each POLYGON.
		for (i = 0 ; i <  sel_ngon[j] ; i++ ){    //n.b. i<ngon+1 to pick last vx too.

		double apl, bpl, cpl, dpl, Xtri, Ytri, Ztri, Zf, dist_fp1, dist_fp2 ;



//vertex-by-vertex of course: one vertex at a time!	
//find which triangle is the vertex touching....
//excact pos.
// ABSOLUTE VALUE IS ONLY A SECURITY MEASURE!!!!! AND TRICKY TERRAIN. MIRRORING STRAIGHT.
Xf = (body[j].pos.vector[0] + body[j].vx_s.matrix[0][i])/gg.GPunit ;
Zf = (body[j].pos.vector[2] + body[j].vx_s.matrix[2][i])/gg.GPunit ;


//index of which square's region it is within. 
Xi = floor( Xf ) ;  //x axis (in/out-screen)
Yi = floor( Zf ) ;  //z axis (right/left-of-screen)


/*a cautional correction to avoi SegmentationFault: SECURE. */
if( Xi < 30 || Xi > 300 ){  /* if it accidentally becomes negative, put it zero but nuder that there is no terrain!! */
//Xi = 0 ;
continue ;
}
if( Yi < 30 || Yi > 300 ){  /* if it accidentally becomes negative, put it zero but nuder that there is no terrain!! */
//Yi = 0 ;
continue ;
}


dist_fp1 = sqrt( pow( Xf- Xi   ,2 )  + pow( Zf- Yi   ,2 ) ) ;
dist_fp2 = sqrt( pow( Xf-(Xi+1),2 )  + pow( Zf-(Yi+1),2 ) ) ;

     if ( dist_fp1 < dist_fp2  ){  //careful if negativ or positive the Z axis... in fact.
     col = 0 ; //lower triangle region.
     //printf("ON TRI_0... \n\n");
     }      
     else{    
     col = 1 ;
     //printf("ON TRI_1... \n\n");
     }


/*==========FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
// cross product method.

// ===THIS IS TRIANLGE 1 , BUT WE MUST ALSO IMPLEMENT THAT IT SEES IF TRI_1 OR TRI_2
//vect1.component-by component.
if ( col == 0 ){
s_vector0.vector[0] = 1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = gg.shmap[Xi+1][Yi] - gg.shmap[Xi][Yi] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = gg.shmap[Xi][Yi+1] - gg.shmap[Xi][Yi] ;
s_vector1.vector[2] = 1.0 ;
}
else if ( col == 1 ){
s_vector0.vector[0] = -1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = gg.shmap[Xi][Yi+1] - gg.shmap[Xi+1][Yi+1] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = gg.shmap[Xi+1][Yi] - gg.shmap[Xi+1][Yi+1] ;
s_vector1.vector[2] = -1.0 ;

}

s_nloc = cross( s_vector0 , s_vector1 ) ;

/*------------calculate apl, bpl and cpl on the fly---------------------- */
/* use cross_product method. */

  //put equation parameters.
apl = s_nloc.vector[0]  ;
bpl = s_nloc.vector[1]  ;
cpl = s_nloc.vector[2]  ;
dpl = 0 ; //this is still to calculate... it's not = 1  usually.


s_nloc.vector[0] = s_nloc.vector[0]/leng_vect3(s_nloc) ;
s_nloc.vector[1] = s_nloc.vector[1]/leng_vect3(s_nloc) ;
s_nloc.vector[2] = s_nloc.vector[2]/leng_vect3(s_nloc) ;

//look if verse is good... not always; must check if the y of the normal is positive... easy. if negative, invert vector.
if ( s_nloc.vector[1] < 0.0 ){
s_nloc.vector[0] = -s_nloc.vector[0] ;
s_nloc.vector[1] = -s_nloc.vector[1] ;
s_nloc.vector[2] = -s_nloc.vector[2] ;
}

/* be VERY CAREFUL becaus to find, we must use a point common to both triangles (col == 0 or col == 1): or make 2 cases... .  */
Xtri = (double) (Xi+1)*gg.GPunit ;
Ytri = (double) gg.GPunit*gg.shmap[Xi+1][Yi] ;
Ztri = (double) Yi*gg.GPunit ;

//now finally calculate dpl , the 'd' of the   ax + by + cz + d = 0   plane equation. 
dpl = -apl*Xtri - bpl*Ytri - cpl*Ztri ;
/*---------------------------------------------------------*/

//============================================================================================================================
//READ BELOW: Typical only of CTruck3D_Simplex and _Truck ... only the '- _Simplex' and '_Truck' version !!!  REMEMBER THAT WE ARE SIMULATING PHYSICALLY JUST 1 BODY (2 for double pendulum --> truck )!!!
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
//register height under the first 4(or as many as there were fixed... ) vertices.	
// if( ( j == 0  && i < 4 ) /* || ( j == 1 && (i == 16 || i ==17 || i == 18 || i == 19) ) */ ){  //take 0,1,2,3... the first 4(or set if mere are needed. normal cars have 4 wheels usually... ).


  for( ku = 0 ; ku < NPILLOW ; ku++ ){
     if( pillowvx[ku][0]  == j && pillowvx[ku][1] == i  ){
     mach = 1 ;  
     }
  }

  if( mach == 1 &&  susp_hight_set[pc] == 0   ){ // CAREFUL WITH THIS PART HERE!!  

h_vxvs[pc] =  (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) -(
-(          
(apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) + //(ax +
 cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + // cx +
 dpl)/bpl  
 ) 
) ;  //is negative!check equation members always! very normal plane equation explicied to height (here y is the height...). 

// now 'record' the normal-vector of the triangle above which the wheel-supporting vertex s 
norm_vxvs[pc][0] = s_nloc.vector[0] ; 
norm_vxvs[pc][1] = s_nloc.vector[1] ; 
norm_vxvs[pc][2] = s_nloc.vector[2] ; 

  pc++ ;
  mach = 0 ;
  }

//===========================================================================================================================



//IF VERTEX IS UNDER GORUND LEVEL...
  //   if ( (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) < 0.0 ){ 
       if ( ( (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i]) < -( //is negative!chenck equation members always!!
	                                                             (apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) + //(ax +
	                                                              cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + // cx +
	                                                              dpl)/bpl                                               // d )/b
	                                                           )
	    ) 
	    ) {
	 

	 
/*check is normvel < 0 and eventually calculated and assigns new velocities and so.*/ 
body_rebounce( &body[j], 
 body[j].vx_s.matrix[0][i], body[j].vx_s.matrix[1][i], body[j].vx_s.matrix[2][i],   
 s_nloc.vector[0]         , s_nloc.vector[1]         , s_nloc.vector[2],i, e, 1.0 ) ;


//DEACTIVATE TO TEST:
//POS CORRECT AFTER REBOUNCE:TRUCK BACK TO TOUCH POINT, REGUARDLESS OF SMALL PHYSICAL SURREALISM.       
       disth =   ( -(apl*(body[j].pos.vector[0] + body[j].vx_s.matrix[0][i]) +
	             cpl*(body[j].pos.vector[2] + body[j].vx_s.matrix[2][i]) + 
                     dpl)/bpl)                                               - (body[j].pos.vector[1] + body[j].vx_s.matrix[1][i] )  ;

//now fine-tune, since correction must be done along the normal, for fewer error.		     
s_vector0.vector[0] = 0.0   ; 
s_vector0.vector[1] = disth ; 
s_vector0.vector[2] = 0.0   ;

disth = dot3_st(s_vector0, s_nloc );
aux_vect = pscv(s_nloc, disth);		     
		     
       //TO TEST OF FOR PRO BLEMS, PUT: disth= 0.0 ; 	                                                        
       // if( LagrangeArticulatedBodies == 0 ){  /* with constraint vincular dynamics, do not make position corrections becaause it shits up the vertex concidence conditions, worsning precision. */                   
       body[j].pos = vector_sum( body[j].pos, aux_vect );  //try harder correction if necessaru, add some plus value...
       		
    }
  }   //end of vertex check scroll.
}     //end of individual POLYGONs scroll.













Lo[0] = 0.0 ; // USED ONY IN THIS CONTEXT.... (NOT USED ANYMORE)... . 

smilzo_y = say_terrain_height( &mg , smilzo_x, smilzo_z ) ; // set IronSmilzo's height. TO CORRECT



if( in_vehicle == 0 ){ // if smilzo is out o vehicle 0 , turn breakes on (parking mode).
wheel[0].stopped = 1 ;
wheel[2].stopped = 1 ; 
}


//============================================================================================================================
//Approximated car&wheels physical system simulation.
//Approximated car&tyres physical system simulation.
//Approximated car&tyres physical system simulation.
	for( i = 0 ; i < NPILLOW ; i++ ){
	 // l_c = (body[0].pos.vector[1] + body[0].vx_s.matrix[1][i]) ;
	// l_c = dot3_st( v_spring_curr, down_dir ) ; 
	l_c = dot3_st( v_spring_curr[ pillowvx[i][0] ], down_dir ) ; 

	//printf("current lenght:  %f\n",l_c) ;
	l_c = fabs(l_c) ; //take ONLY MODULUS because v_spring_curr tanke into account the direction already!! WARNING CHECK IT!!
	if( susp_hight_set[i] == 0  ){
	l_c = h_vxvs[i]/l_c ; //reuse it... sorry for little aesteticism.Rect Triangles Theorem applied....
	}
	else {
	l_c = h_vxvs[i] ;
	}
//printf("current lenght:  %f\n",l_c);
	     if( l_c < l_vsp && l_c > 0 && v_spring_curr[ pillowvx[i][0] ].vector[1] <= 0  ){  //if current lenght is minor than natural lenght....
      
		springF = -(( l_vsp - l_c )*k_vspring[i] ) ;
      
		j = pillowvx[i][0] ; // THIS SEEMS ABSOLYTELY NECESSARY...  HTERE ARE 3 BODIES... EACH OF WHICH HAS 4 WHEELS... .
		
Xi = floor( (body[pillowvx[i][0]].pos.vector[0] + body[j].vx_s.matrix[0][ pillowvx[i][1] ])/mg.GPunit) ; // why body[j] ?? IT IS WRONG CERTAINLY!!
Yi = floor( (body[pillowvx[i][0]].pos.vector[2] + body[j].vx_s.matrix[2][ pillowvx[i][1] ])/mg.GPunit) ;
    
     //------------------------------------------------------------------ 
     /* now take it only proportionally to how much spring is perpendicular to ground... to avoid exagerated side dragging. */
    // k = testpoint_pindex[i] ;
     s_nloc.vector[0]  =  norm_vxvs[i][0]  ;
     s_nloc.vector[1]  =  norm_vxvs[i][1]  ;   //auxiliary data transfer
     s_nloc.vector[2]  =  norm_vxvs[i][2]  ;   //auxiliary data transfer

     springF = springF*fabs(dot3_st( v_spring_curr[ pillowvx[i][0] ]  , s_nloc ) );
     //-------------------------------------------------------------------
     
     
     
     
      
	//END 1 VELOCITY:
	s_vector0 = pscv( body[ pillowvx[i][0]  ].rotaxis, body[ pillowvx[i][0]  ].vang.x );

	s_vector1.vector[0] = body[  pillowvx[i][0]  ].vx_s.matrix[0][  pillowvx[i][1]  ] ;  //extract vector from vector-collection matrix.
	s_vector1.vector[1] = body[  pillowvx[i][0]  ].vx_s.matrix[1][  pillowvx[i][1]  ] ;
	s_vector1.vector[2] = body[  pillowvx[i][0]  ].vx_s.matrix[2][  pillowvx[i][1]  ] ;

      //CROSS PRODUCT for inst linear speed of vertex due to body's rotation:
      aux_vect = cross( s_vector0, s_vector1 ) ;
      //pass result element-by element automatically.
      vvertexE1 = vector_sum( body[  pillowvx[i][0]  ].vel, aux_vect ) ; 
      
      
      
      aux_vect.vector[0] = v_spring_curr[  pillowvx[i][0]  ].vector[0] ;
      aux_vect.vector[1] = v_spring_curr[  pillowvx[i][0]  ].vector[1] ;
      aux_vect.vector[2] = v_spring_curr[  pillowvx[i][0]  ].vector[2] ;

      //RELATIVE VELS: always E1- E2 - order must be always the seme!!!
        mod = dot3_st(vvertexE1, aux_vect)  ; 
	//printf("%f\n",mod) ;
      
      
      
      
      double sign ;
      cost = 83000000.0 ;
      if( fabs(mod) > 0.0){

      sign = -mod/fabs(mod) ;
      }else{
      sign = 0.0 ;
      }

      body[  pillowvx[i][0] ].vxFs.matrix[0][  pillowvx[i][1] ]   =    body[  pillowvx[i][0] ].vxFs.matrix[0][  pillowvx[i][1] ] + springF*v_spring_curr[  pillowvx[i][0]  ].vector[0] + sign*cost*v_spring_curr[  pillowvx[i][0]  ].vector[0] ;  
      body[  pillowvx[i][0] ].vxFs.matrix[1][  pillowvx[i][1] ]   =    body[  pillowvx[i][0] ].vxFs.matrix[1][  pillowvx[i][1] ] + springF*v_spring_curr[ pillowvx[i][0]  ].vector[1] + sign*cost*v_spring_curr[  pillowvx[i][0]  ].vector[1] ; 
      body[  pillowvx[i][0] ].vxFs.matrix[2][  pillowvx[i][1] ]   =    body[  pillowvx[i][0] ].vxFs.matrix[2][  pillowvx[i][1] ] + springF*v_spring_curr[ pillowvx[i][0]  ].vector[2] + sign*cost*v_spring_curr[  pillowvx[i][0]  ].vector[2] ; 


// END SUSTEINING FORCE (LIKE A FLOATING-BOAT, SORRY FOR BAD ENGLISH )




        
 
        //now the guidance given by virtual tyre through friction and rotation: COLLISION USED. IN THIS MODEL , THE CONTACT WIHT GROUND IS UNIQUELY COLLISIONAL.
        s_vector1.vector[0] =  body[  pillowvx[i][0]   ].vx_s.matrix[0][  pillowvx[i][1] ]  + (l_c)*v_spring_curr[  pillowvx[i][0] ].vector[0] ;  //extract vector going form main body's center to tyre j-1 's vertex i.
	s_vector1.vector[1] =  body[  pillowvx[i][0]   ].vx_s.matrix[1][  pillowvx[i][1] ]  + (l_c)*v_spring_curr[  pillowvx[i][0] ].vector[1] ;  // OK.
	s_vector1.vector[2] =  body[  pillowvx[i][0]   ].vx_s.matrix[2][  pillowvx[i][1] ]  + (l_c)*v_spring_curr[  pillowvx[i][0] ].vector[2] ;

	//VIRTUAL TYRE TOUCHPOINT's WORLD-POSITION IS: ( s_vector1 + body[0].pos ) .
	/*===============calculate within which ground triangle it stays, in ordert o dermine normalvector if it touches eventually===================*/
	


/*==========================*/	
	s_nloc.vector[0]  = norm_vxvs[i][0]  ;
	s_nloc.vector[1]  = norm_vxvs[i][1]  ;   //auxiliary data transfer
	s_nloc.vector[2]  = norm_vxvs[i][2]  ;   //auxiliary data transfer
/*==========================*/	
        
	/*============================================================================================================================================*/	
	


	
	//CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
	//FORMULA NORMSPEED ADAPTED to tyre _Simplex version only: take angular velocity vector of main body and virtual vertex body1CM-tyrevertex and cavulate. 
	body[  pillowvx[i][0]  ].vvertex = vector_sum( 
			    body[  pillowvx[i][0]  ].vel, cross( body[  pillowvx[i][0]  ].ww,  s_vector1 )
				    ) ;

				    
	
	
	
	
	//SPRING-PERPENDICULAR IMPULSE PART:
	//SPRING-PERPENDICULAR IMPULSE PART:
	

// NEW VAR
	s_nloc = pscv( cross( wheel[ i ].axis, v_spring_curr[  pillowvx[i][0]  ] ) ,
		      dot3_st( s_nloc, cross( wheel[i].axis, v_spring_curr[  pillowvx[i][0]  ] ) ) 
		     ) ; 


        
        //normal component part: WE SIMUALTE THE PRESENCE OF A RIGID AXIS VINCULATING THE MOTION OF THE TYRE TO BE ALONG 1 LINE.
        vnorm = dot3_st( s_nloc , body[ pillowvx[i][0] ].vvertex ) ;  //  (absolute lenght) - (parallelpart) = (perpendicularpart) .
        
        if ( vnorm < 0 ){
	  
          UP   = -(1+0)*vnorm  ; /* e = 0.0 in this case... ABSOLUTELY because of how this physical model works!! */
	  DOWN = 1.0/body[  pillowvx[i][0]  ].MASS.x + dot3_st(  cross( s_vector1, s_nloc ) , mat3x3_vect( body[  pillowvx[i][0]  ].TIworInv, cross( s_vector1, s_nloc ) ) ) ;         
	  je = UP/DOWN ;
	 // printf("JE : %f\n\n",je) ; 
	  je = 0.0 ;    // TEST TEST TEST TEST IF CAN'T GET IT TO WORK PROPERLY, LET IT BE....
	}         	 
	else{
	  je = 0.0 ;  
	}
		
	
	
	
	// FRICTION/TYRE GUIDANCE PART as to _SImplex model.:	    
	// FRICTION/TYRE GUIDANCE PART as to _SImplex model.:       
	// FRICTION/TYRE GUIDANCE PART as to _SImplex model.:    
        
        
        //the part of velocity of vertex PARALLEL TO TYRE AXIS - pointing outside car's main body (BODY 1).
	//SELECTING MOTION COMPONENTS. 

// PREV OK = .
//	aux_vect = pscv( body[i+1].reartyre_axis , dot3_st( body[  pillowvx[i][0]  ].vvertex , body[i+1].reartyre_axis	) ) ;     


//NEW VARIABLE
	if( wheel[i].stopped == 0  ){	
	aux_vect = pscv( wheel[i].axis , dot3_st( body[  pillowvx[i][0]  ].vvertex , wheel[i].axis	) ) ;  

// some friction there is always even when breakes are not active:
	aux_vect.vector[0] = aux_vect.vector[0] + 0.005*body[  pillowvx[i][0]  ].vvertex.vector[0]  ;
	aux_vect.vector[1] = aux_vect.vector[1] + 0.005*body[  pillowvx[i][0]  ].vvertex.vector[1]  ;
	aux_vect.vector[2] = aux_vect.vector[2] + 0.005*body[  pillowvx[i][0]  ].vvertex.vector[2]  ;

   
	}
	else{  // standrd friction, not selective in any direction.
	aux_vect = body[  pillowvx[i][0]  ].vvertex  ;
	}

	    if ( fabs(  pow( aux_vect.vector[0],2 ) + pow( aux_vect.vector[2],2 ) ) > 0.03 ) {  //see if parellely to ground there is some relative motion.
	    s = 1; 
	    } 
	    else{
	    s = 0 ;
	    } //don't play w too small numbers,may cause /0 and INF.
     

        //restore the original normal vector....
/*======== WORK IN PROGRESS =======*/
	s_nloc.vector[0]  =  norm_vxvs[i][0]   ;
	s_nloc.vector[1]  =  norm_vxvs[i][1]  ;   //auxiliary data transfer
	s_nloc.vector[2]  =  norm_vxvs[i][2]   ;   //auxiliary data transfer
/*=================================*/        
	 
	 //MODIFIED!!!_Simplex 's peculiarity!!! CHECK CAREFULLY WARNING !!
	 
	  //since the gound is the 'fix' reference system to measure relative velocities end positions, with it we can establish objectively: goes or not. 
	  //but correct to _Simplex version according to tyree model chosen.
	  if ( leng_vect3(aux_vect) > 0.01 ){        
	  s_nTloc =  cross(s_nloc, cross( s_nloc, aux_vect ) )  ;       //vector measuring the parto of motion parallel-to-surface: 3D....
	  s_nTloc =  pscv(s_nTloc, -1.0 ) ;  	  	  
	  } 
	  else{ 
	  s_nTloc.vector[0] = 0.0 ;
	  s_nTloc.vector[1] = 0.0 ;
	  s_nTloc.vector[2] = 0.0 ;
	  } 





       vnorm = s*dot3_st( s_nTloc, aux_vect ) ;   //we overwrite it, since it's been already used for what it was aimed.
// smilzo_y = say_terrain_height( &mg , smilzo_x, smilzo_z ) ; // set IronSmilzo's height.

       UPf   = -(0.0 + fr)*vnorm       ;          //careful with adaptation: here, the max restitution is 1.0.  

       DOWNf = 1.0/body[  pillowvx[i][0]  ].MASS.x    +  dot3_st(  cross( s_vector1, s_nTloc ) , mat3x3_vect( body[  pillowvx[i][0]  ].TIworInv, cross(s_vector1, s_nTloc ) ) )  ;
 
       jf = UPf/DOWNf  ;


 // printf("\n GUIDANCE LATERAL  IMPULSE (jf) =  %3f \n\n " ,jf );


//the more green component in ground color, the more friction.

	if ( fabs(jf) > mg.scol[Xi][Yi][1]*320000.0 ){ // if too much, it becomes dynamic friction and substantially we have lost control over the car!!
       
add_particles( body[ pillowvx[i][0] ].pos.vector[0] + s_vector1.vector[0] , 
	       body[ pillowvx[i][0] ].pos.vector[1] + s_vector1.vector[1] , 
	       body[ pillowvx[i][0] ].pos.vector[2] + s_vector1.vector[2] , 
	aux_vect.vector[0], 
	/* aux_vect.vector[1]*/ 190.0, 
	aux_vect.vector[2], dft,  1  ) ;


	jf = (10000*jf)/fabs(jf) ;   
	}
       
       // jf= 0.0 ;  //TEST TEST TEST TEST
        	 
       //update linear and angular vel: ALL GOES TO BODY 1 !!! REMEMBRE THAT THIS IS THE _SIMPLEX VERSIONWHICH USES AN APPLROXIMATE CAR PHYSICS MODEL.
       body[  pillowvx[i][0]  ].vel.vector[0] = body[  pillowvx[i][0]  ].vel.vector[0] + (je/body[  pillowvx[i][0]  ].MASS.x)*s_nloc.vector[0] + (s*jf/body[   pillowvx[i][0]  ].MASS.x)*s_nTloc.vector[0] ;
       body[  pillowvx[i][0]  ].vel.vector[1] = body[  pillowvx[i][0]  ].vel.vector[1] + (je/body[  pillowvx[i][0]  ].MASS.x)*s_nloc.vector[1] + (s*jf/body[   pillowvx[i][0] ].MASS.x)*s_nTloc.vector[1] ;
       body[  pillowvx[i][0]  ].vel.vector[2] = body[  pillowvx[i][0]  ].vel.vector[2] + (je/body[  pillowvx[i][0]  ].MASS.x)*s_nloc.vector[2] + (s*jf/body[   pillowvx[i][0] ].MASS.x)*s_nTloc.vector[2] ;
   

	//===QUESTIONS FOR VINCULAR DYNAMICS.....???============                    
       //calc virtual acceleration undeegone in the discreet dt simulaiton cycle time.      
       body[  pillowvx[i][0]  ].acc_tot    = pscv( vector_sum( body[  pillowvx[i][0]  ].vel, pscv( body[  pillowvx[i][0]  ].vel_pre, -1.0 ) ) , 1.0/dft )  ; //this is an ACCELERATION!!
	//================I DEACTIVATED IT FOR NOW...========================

       //extract vector: this is the RADIUS going form polyheron's CM to the vertex which has touched ground or on which some impulse is excerted!! 
       aux_vect.vector[0] = body[  pillowvx[i][0]  ].vx_s.matrix[0][  pillowvx[i][1]  ]  + (l_c )*v_spring_curr[  pillowvx[i][0]  ].vector[0] ;  //TEST
       aux_vect.vector[1] = body[  pillowvx[i][0]  ].vx_s.matrix[1][  pillowvx[i][1]  ]  + (l_c )*v_spring_curr[  pillowvx[i][0]  ].vector[1] ;  //TEST
       aux_vect.vector[2] = body[  pillowvx[i][0]  ].vx_s.matrix[2][  pillowvx[i][1]  ]  + (l_c )*v_spring_curr[  pillowvx[i][0]  ].vector[2] ;  //TEST: see if  l_c alone  or (lc + diam)....
            
            
       
       //FIRST THE 'FRICTIONAL' PART WHICH DOES THE FACT THAT TYRE DOESNT LET GO PERPENDICULARLY TO IT'S ROTATION AXIS!! NO TOWARDS 'PLATE'.
       //friction contribution during ground-touch.To simply add to previous result (rebounce part alone).Only the  pscv()  values change!!!
       //HERE THE vector s_nTloc already is directed along tyre_axis vector!!! be careful!!
       body[  pillowvx[i][0]  ].ww = vector_sum( body[  pillowvx[i][0]  ].ww ,  mat3x3_vect( body[  pillowvx[i][0]  ].TIworInv, cross( aux_vect, pscv( s_nTloc ,jf) )  ) ) ; 

                        
       
       
       //ok taking the parti perpendicular to v_spring_curr but it must be made effective eliminating the perpenducular parto from s_nloc itself!!             
//PREV OK==:
     /*  s_nloc = pscv( cross( body[i+1].reartyre_axis, v_spring_curr[  pillowvx[i][0]  ] ) ,
		      dot3_st( s_nloc, cross( body[i+1].reartyre_axis, v_spring_curr[  pillowvx[i][0]  ] ) ) 
		     ) ; 
       */
       

// NEW VER:
	 s_nloc = pscv( cross( wheel[i].axis, v_spring_curr[  pillowvx[i][0]  ] ) ,
		      dot3_st( s_nloc, cross( wheel[i].axis, v_spring_curr[  pillowvx[i][0]  ] ) ) 
		     ) ; 


       //rebounce contribution IN THIS CASE ONLY THE PERTO OF J perpendicular to v_spring_curr  vector!!! _Simplex version's perculiarity :
       body[  pillowvx[i][0]  ].ww = vector_sum( body[  pillowvx[i][0]  ].ww ,  mat3x3_vect( body[  pillowvx[i][0]  ].TIworInv, cross( aux_vect, pscv( s_nloc  ,je) )  ) ) ; 
       
       //update also the angular momentum, since ww chenged: then also angular momentum changes (obvious).
       body[  pillowvx[i][0]  ].L = mat3x3_vect( body[  pillowvx[i][0]  ].TIwor , body[  pillowvx[i][0]  ].ww )   ;  



	//====???====FOR VINCULAR DYNAMICS!============
	//calc virtual acceleration undergone in the discreet dt simulaiton cycle time.      HERE WITH body[0] only!!!!
	body[  pillowvx[i][0]  ].torque_tot    = pscv( vector_sum( body[  pillowvx[i][0]  ].L, pscv( body[  pillowvx[i][0]  ].L_pre, -1.0 ) ) , 1.0/dft )  ; // this is a (torque) FORCE
	//==========================================



       //recalc separately vang and rotation-axis versor.
       body[  pillowvx[i][0]  ].vang.x = leng_vect3( body[  pillowvx[i][0]  ].ww ) ;

	if(body[  pillowvx[i][0]  ].vang.x > 0.0000001  ){
	body[  pillowvx[i][0]  ].rotaxis.vector[0] = body[  pillowvx[i][0] ].ww.vector[0] /body[  pillowvx[i][0] ].vang.x  ;
	body[  pillowvx[i][0]  ].rotaxis.vector[1] = body[  pillowvx[i][0] ].ww.vector[1] /body[  pillowvx[i][0] ].vang.x  ;
	body[  pillowvx[i][0]  ].rotaxis.vector[2] = body[  pillowvx[i][0] ].ww.vector[2] /body[  pillowvx[i][0] ].vang.x  ;
	}
	else{
	body[  pillowvx[i][0] ].rotaxis.vector[0] = 0.0  ;
	body[  pillowvx[i][0] ].rotaxis.vector[1] = 0.0  ;
	body[  pillowvx[i][0] ].rotaxis.vector[2] = 0.0  ;
	//==================================================================================================================
	} 	          

     }


//    } // inferiority to 4 
} //END i -scroll
//=========================================================================================================================





// BREAKS ON OF OFF ? ... we reset here....  .


wheel[0].stopped = 0 ; // by default, tyres are not breaked/stopped .
//wheel[1].stopped = 0 ; 
wheel[2].stopped = 0 ; // by default, tyres are not breaked/stopped .
//wheel[3].stopped = 0 ; 





//***********NOT needed for dynamics, it' only in this game..PROVVISORY..*****************
double vlat ;

vlat = body[2].axis_3.vector[0]*body[2].vel.vector[0] 
     + body[2].axis_3.vector[1]*body[2].vel.vector[1] 
     + body[2].axis_3.vector[2]*body[2].vel.vector[2] ;  /* dot product explicited directly: clean work. */

vperp = body[2].axis_2.vector[0]*body[2].vel.vector[0] 
      + body[2].axis_2.vector[1]*body[2].vel.vector[1] 
      + body[2].axis_2.vector[2]*body[2].vel.vector[2] ;  /* dot product explicited directly: clean work. */

vpar  = body[2].axis_1.vector[0]*body[2].vel.vector[0] 
      + body[2].axis_1.vector[1]*body[2].vel.vector[1] 
      + body[2].axis_1.vector[2]*body[2].vel.vector[2] ;

// effect (IN A VERY RUDIMENTAL CONCEPTION OF AERODYNAMICS, NOT SCIENTIFIC AT ALL) of air friction on the motion of Center of Mass directly.

body[2].acc_drv.vector[0] += -k_visc*vperp*body[2].axis_2.vector[0] -k_visc2*vlat*body[2].axis_3.vector[0] - 100.8*vpar*body[2].axis_1.vector[0] + Pforce*body[2].axis_1.vector[0] ;  
body[2].acc_drv.vector[1] += -k_visc*vperp*body[2].axis_2.vector[1] -k_visc2*vlat*body[2].axis_3.vector[1] - 100.8*vpar*body[2].axis_1.vector[1] + Pforce*body[2].axis_1.vector[1] ; 
body[2].acc_drv.vector[2] += -k_visc*vperp*body[2].axis_2.vector[2] -k_visc2*vlat*body[2].axis_3.vector[2] - 100.8*vpar*body[2].axis_1.vector[2] + Pforce*body[2].axis_1.vector[2] ; 

// seme for the rotational motion. ANOTHER CONSTANT OF FRICTION NEEDED!!!

body[2].torque_drv.vector[0] += -vpar*k_visc_rot*body[2].ww.vector[0]  ; // when plane is slow, this effect is minor, when fast it's strong. when at rest, inperceptible.   
body[2].torque_drv.vector[1] += -vpar*k_visc_rot*body[2].ww.vector[1]  ; 
body[2].torque_drv.vector[2] += -vpar*k_visc_rot*body[2].ww.vector[2]  ; 


//***********************END OF PROVVISORY PART*******************************************







//EFFECT OF FORCES CALCS: ACCELERATION AND ANGULARE ACCELERATION
//EFFECT OF FORCES CALCS: ACCELERATION AND ANGULARE ACCELERATION
//EFFECT OF FORCES CALCS: ACCELERATION AND ANGULARE ACCELERATION
for ( j=0 ;j<nPOLY;j++){
     /*
       body[j].F_tcm.vector[0] =  0.0 ;  // prepare variable.
       body[j].F_tcm.vector[1] =  0.0 ;
       body[j].F_tcm.vector[2] =  0.0 ;

       body[j].torque.vector[0] = 0.0 ;  // prepare variable.
       body[j].torque.vector[1] = 0.0 ;
       body[j].torque.vector[2] = 0.0 ;
    */

       body[j].F_tcm.vector[0] =  body[j].acc_drv.vector[0] ;  // prepare variable.
       body[j].F_tcm.vector[1] =  body[j].acc_drv.vector[1] ;
       body[j].F_tcm.vector[2] =  body[j].acc_drv.vector[2] ;

       body[j].torque.vector[0] = body[j].torque_drv.vector[0] ;  // prepare variable.
       body[j].torque.vector[1] = body[j].torque_drv.vector[1] ;
       body[j].torque.vector[2] = body[j].torque_drv.vector[2] ;


          for (i = 0 ; i < sel_ngon[j] ; i++ ){          
          aux_vect.vector[0]  =   body[j].vx_s.matrix[0][i]  ;  //extract vertex-position-vector from matrix(3xn storer).
          aux_vect.vector[1]  =   body[j].vx_s.matrix[1][i]  ;  //extract vertex-position-vector from matrix(3xn storer).
          aux_vect.vector[2]  =   body[j].vx_s.matrix[2][i]  ;  //extract vertex-position-vector from matrix(3xn storer).

       
              s_vector0.vector[0] = body[j].vxFs.matrix[0][i]   ;
              s_vector0.vector[1] = body[j].vxFs.matrix[1][i]   ;
              s_vector0.vector[2] = body[j].vxFs.matrix[2][i]   ;

          //TORQUE(TOTAL, ONE FOR EACH POLYHEDRON):
          //sum all perp components, see proof of formula.
          body[j].torque  = vector_sum( body[j].torque, cross( aux_vect, s_vector0 ) )   ;   

          body[j].F_tcm.vector[0] = body[j].F_tcm.vector[0] + body[j].vxFs.matrix[0][i]  ;
          body[j].F_tcm.vector[1] = body[j].F_tcm.vector[1] + body[j].vxFs.matrix[1][i]  ;
          body[j].F_tcm.vector[2] = body[j].F_tcm.vector[2] + body[j].vxFs.matrix[2][i]  ;

          } //end for-each -vertex sum: Got totals, go on....

body[j].acc.vector[0] = body[j].F_tcm.vector[0]/body[j].MASS.x ;  //acc is NON-INTERTIAL!!!
body[j].acc.vector[1] = body[j].F_tcm.vector[1]/body[j].MASS.x + g ;  //acc iS NON-INERTIAL!!!
body[j].acc.vector[2] = body[j].F_tcm.vector[2]/body[j].MASS.x ;  //acc iS NON-INERTIAL!!!


  //==FOR VINCULAR DYNAMICS!===========
  /* to the torque add the eventualy nonzero virtual torque undergone during collision with wall or ground */
	 // body[j].torque_tot = body[j].torque ;
        body[j].torque_tot  = vector_sum( body[j].torque, body[j].torque_tot )   ;
         //===============================


    // THIS IS CORRECT IN FORCE VERCTORS - not ONLY CONTEXT!!!
	body[j].acc_tot  = vector_sum( body[j].acc_tot  ,  body[j].acc  )  ;
    //=====================================

}

// body[0].torque_tot  = vector_sum( body[0].torque_tot, body[0].torque_drv )   ; // total torque excerted on body by external forces .
// body[0].acc_tot  = vector_sum( body[0].acc_tot  ,  body[0].acc_drv  )  ;       // total force (of acc??) excerted on body by external forces.







//VINCULAR DYNAMICS EQUATION PART:
//VINCULAR DYNAMICS EQUATION PART:
//VINCULAR DYNAMICS EQUATION PART:
if ( LagrangeArticulatedBodies == 1){


//the body-pair joint handling: dont'mix them 'cause it don't work!!
//for( k = 0 ; k < narms ; k = k + 1 ){
for( k = 0 ; k < narms ; k = k + 1 ){  // IF WE HAD 1 JOINT, AND CONSEQUENTLy 1 PAIR OF BODIES, WE HAD JUST k = 0 ... .

col  = armvx[k][0] ;
row  = armvx[k][1] ;
col2 = armvx[k][2] ;
row2 = armvx[k][3] ;

//printf("\nCHECK!!! --->> faults??  %d \n", k ) ;

//NOW FIND fc OF EQUATION AND CALCULATE THE EFFECT OF TAT FORCE VECTOR PAIR ON BODY A AND B:
//NOW FIND fc OF EQUATION AND CALCULATE THE EFFECT OF TAT FORCE VECTOR PAIR ON BODY A AND B:
//NOW FIND fc OF EQUATION AND CALCULATE THE EFFECT OF TAT FORCE VECTOR PAIR ON BODY A AND B:

// PREVIOUS FORCES ARE STILL THERE!!.
	     
//NOW FIND fc, AND PUT IT POSITIVE AND NEGATIVE AT THE RIGHT VERTICES, AND RECALCULATE CHANGES, WITH ALL-ZERO EXCEPT THOSE 2 or few more.
//which is body A? col = 0  ; which vertex of it? row = 21 ;
//which is body B? col2 = 2 ; which vertex of it? row2 = 1 ;


//MAKE SPECIAL DIAGONAL MATRIX STORING MASS.
Ma = pscm33( body[0].I, body[col ].MASS.x ) ;
Mb = pscm33( body[0].I, body[col2].MASS.x ) ;

//MAKE VERTEX POSITION VECTOR(1 SINGLE VECTOR).
ra.vector[0] = body[col ].vx_s.matrix[0][row ] ;
ra.vector[1] = body[col ].vx_s.matrix[1][row ] ;
ra.vector[2] = body[col ].vx_s.matrix[2][row ] ;

rb.vector[0] = body[col2].vx_s.matrix[0][row2] ;
rb.vector[1] = body[col2].vx_s.matrix[1][row2] ;
rb.vector[2] = body[col2].vx_s.matrix[2][row2] ;


Aa = mat3x3_sum( inv(Ma), pscm33( mat3x3_mult( mat3x3_mult( skew(ra), body[col ].TIworInv ), skew(ra) ) , -1.0 )   );
Ab = mat3x3_sum( inv(Mb), pscm33( mat3x3_mult( mat3x3_mult( skew(rb), body[col2].TIworInv ), skew(rb) ) , -1.0 )   );


//the VECTOR stroring all known things, which alltogather is a vector.
//body A: THIS FORMULAS MUST BE ADAPTED TO DISCREET CONTEXT!!!!!

//s_vector0 = mat3x3_vect( inv(Ma), pscv(body[col ].acc_tot, body[col ].MASS.x ) )   ; //part 1 F = m*a , vectorially of course, when F vector i needed.;
//s_vector1 = cross( body[col ].ww , cross( body[col ].ww , ra ) ) ; //part2


//==ADAPTED...==========|part 1| & |part 2|====================.
//s_vector0 = body[col ].acc   ; //part 1:WORKS FOR 1 JOINT. contribution by total force on CM: (linear) acceleration of CM. ADAPTED FOR ONLY-FORCES-ON-RIGIDBODY, when F vector is needed.;

s_vector0 = body[col ].acc_tot   ; //part 1: MORE JOINTS. contribution by total force on CM: (linear) acceleration of CM. ADAPTED FOR ONLY-FORCES-ON-RIGIDBODY, when F vector is needed.;

s_vector1 = cross( body[col ].ww , cross( body[col ].ww , ra ) ) ; //part2: force deriving form the iniertial rotation: centripetal acc.
//=============================================================.



//==ADAPTED:==split a bit.... ==|part 3|==.      in original formula it was: body[col ].L   eith L_pre it worked correctly...
aux_vect = pscv( mat3x3_vect( body[col ].TIworInv, cross( body[col ].ww ,body[col ].L ) ) , -1.0 ) ;  //virtual force deriving from inertial rotation.
s_vector2 = mat3x3_vect( body[col ].TIworInv, body[col ].torque_tot ) ; //the external torque's contribution: angular acceleration.
s_vector2 = vector_sum( s_vector2 , aux_vect ) ;  //sum up previous 2 components.

s_vector2 = cross( s_vector2 , ra ) ; //taking into account the lenght of the radius. use again using (obvious)precedence rule of C variable assignments!!


//summing up |part | 1,2,3.
ba = vector_sum( vector_sum( s_vector0, s_vector1 ) , s_vector2  ) ;



//==body B==:

//ORIGINAL FORMULAS: WRONG IN DESCREET CONTEXT!!!
//s_vector0 = mat3x3_vect( inv(Mb), pscv( body[col2].acc_tot, body[col2].MASS.x ) ) ; //part 1
//s_vector1 = cross( body[col2].ww , cross( body[col2].ww , rb ) ); //part 2


//ADAPTED FORMULAS: ==|part 1 & 2|==
//s_vector0 = body[col2].acc ; // |part 1| : acceleration (linear) of the CM. ORIGINAL WORKED FOR 1 JOINT

s_vector0 = body[col2].acc_tot ; // |part 1| : acceleration (linear) of the CM. MORE JOINTS.
s_vector1 = cross( body[col2].ww , cross( body[col2].ww , rb ) ) ; // |part 2|: virtual force deriving form the inertial rotation of the rigidbody, which causes centripetal acc of the extremity point.



//this here is a bit long, needs some split-up.ORIGNAL FORMULAS

//this here is a bit long, needs some split-up. ==|part 3|==: we split up the part, the final sum is the last s_vector2 .
//                                           in original formula it was: body[col ].L  with L_pre worked correctly...   
aux_vect = pscv( mat3x3_vect(body[col2].TIworInv, cross( body[col2].ww , body[col2].L ) ) , -1.0 ) ;
s_vector2 = mat3x3_vect( body[col2].TIworInv, body[col2].torque_tot ) ; //the external torque's contribution: angular acceleration.
s_vector2 = vector_sum( s_vector2, aux_vect ) ; //part3
s_vector2 = cross( s_vector2 , rb ) ; //use again using (obvious)precedence rule of C variable assignments!!


//summing up |part 1,2,3|
bb = vector_sum( vector_sum( s_vector0, s_vector1 ) , s_vector2  ) ;



//make Aa the sum Aa + Ab !!! CAREFUL!!!
//make Aa the sum Aa + Ab !!! CAREFUL!!!
//in multibody general version, we wouldd have more A matrices... We would store them as A[2]... an array of matrices.
//and the A to solve will be a new A[6][6] or A[9][9] maintained specifically to this purpose.
Aa = mat3x3_sum(Aa, Ab) ;
//make ba the sum bb - ba !!! CAREFUL!!!
// in the multibody version we would have a b vector which is bigger, made stucking up some ba_1 and ba_2 (2 b vectors tor 3 bodies),
//and the final b vector will be stored as a hypothetical b[6].
ba = vector_sum( bb, pscv( ba, -1.0 ) ) ;

//In the general 3-and-more body generalization we'll have a fc[2] at least, and we will solve linearsystem not with inverse matrix method.
//we'll also have not an Aa 3x3 matrix but a 6x6 big matrix, or 9x9 or even bigger.
fc = mat3x3_vect( inv(Aa), ba ) ;



//NOW SIMPLY APPLY   FOUND FORCES TO THE RIGHT VERTEXES...FIRST AND LAST BODY ARE THREATED APART!!
//ONLY 2 BODIES HERE!!!


//FIRST AND LAST BODY OF CHAIN: with 2 bodies, they are body A and body B, simply.

//fc_1 to first body (==body A==).

//k = 0 ;  //WHICH PAIR?? IMAGINE THIS: IF TERE IS ONLY 1 PAIR, WE HAVE k = 0 .

//vertex a:
//col  = armvx[k][0] ;  //BODY 
//row  = armvx[k][1] ;  //VERTEX OF THAT BODY

//col2 = armvx[k][2] ;
//row2 = armvx[k][3] ;



//THE APPLICATION OF THE FOUND FORCES CAN BE DECTIVATED, FOR TESTIN'  PURPOSES .
if( LagrangeArticulatedBodies == 1  ){
//PUT fc Force into the Force vector per vertex register, but add it to the already existing ones!!!!
body[col ].vxFs.matrix[0][row ] = body[col ].vxFs.matrix[0][row ] + fc.vector[0] ;
body[col ].vxFs.matrix[1][row ] = body[col ].vxFs.matrix[1][row ] + fc.vector[1] ;
body[col ].vxFs.matrix[2][row ] = body[col ].vxFs.matrix[2][row ] + fc.vector[2] ;


body[col2].vxFs.matrix[0][row2] = body[col2].vxFs.matrix[0][row2] - fc.vector[0] ;
body[col2].vxFs.matrix[1][row2] = body[col2].vxFs.matrix[1][row2] - fc.vector[1] ;
body[col2].vxFs.matrix[2][row2] = body[col2].vxFs.matrix[2][row2] - fc.vector[2] ;

}

}  // END APPLY FOR EACH RIGID ARM .

//END: fc clculated and applied... you can park the truck!
//END: fc clculated and applied... you can park the truck!
//END: fc clculated and applied... you can park the truck!






//EFFECT OF FORCES CALCS, WITH Fc ADDED: ACCELERATION AND ANGULARE ACCELERATION
//EFFECT OF FORCES CALCS, AGAIN: ACCELERATION AND ANGULARE ACCELERATION
//EFFECT OF FORCES CALCS, AGAIN: ACCELERATION AND ANGULARE ACCELERATION
for ( j=0 ;j<nPOLY;j++){

 /*      body[j].F_tcm.vector[0] =  0.0 ;  // prepare variable.
       body[j].F_tcm.vector[1] =  0.0 ;
       body[j].F_tcm.vector[2] =  0.0 ;

       body[j].torque.vector[0] = 0.0 ;  // prepare variable.
       body[j].torque.vector[1] = 0.0 ;
       body[j].torque.vector[2] = 0.0 ;
*/

       body[j].F_tcm.vector[0] =  body[j].acc_drv.vector[0] ;  // prepare variable.
       body[j].F_tcm.vector[1] =  body[j].acc_drv.vector[1] ;
       body[j].F_tcm.vector[2] =  body[j].acc_drv.vector[2] ;

       body[j].torque.vector[0] = body[j].torque_drv.vector[0] ;  // prepare variable.
       body[j].torque.vector[1] = body[j].torque_drv.vector[1] ;
       body[j].torque.vector[2] = body[j].torque_drv.vector[2] ;



          for (i = 0 ; i < ngon_min ; i++ ){          
          aux_vect.vector[0]  =   body[j].vx_s.matrix[0][i]  ;  //extract vertex-position-vector from matrix(3xn storer).
          aux_vect.vector[1]  =   body[j].vx_s.matrix[1][i]  ;  //extract vertex-position-vector from matrix(3xn storer).
          aux_vect.vector[2]  =   body[j].vx_s.matrix[2][i]  ;  //extract vertex-position-vector from matrix(3xn storer).

       
              s_vector0.vector[0] = body[j].vxFs.matrix[0][i]   ;
              s_vector0.vector[1] = body[j].vxFs.matrix[1][i]   ;
              s_vector0.vector[2] = body[j].vxFs.matrix[2][i]   ;

          //TORQUE(TOTAL, ONE FOR EACH POLYHEDRON):
          //sum all perp components, see proof of formula.
          body[j].torque  = vector_sum( body[j].torque, cross( aux_vect, s_vector0 ) )   ;   

          body[j].F_tcm.vector[0] = body[j].F_tcm.vector[0] + body[j].vxFs.matrix[0][i]  ;
          body[j].F_tcm.vector[1] = body[j].F_tcm.vector[1] + body[j].vxFs.matrix[1][i]  ;
          body[j].F_tcm.vector[2] = body[j].F_tcm.vector[2] + body[j].vxFs.matrix[2][i]  ;

          } //end for-each -vertex sum: Got totals, go on....


body[j].acc.vector[0] = body[j].F_tcm.vector[0]/body[j].MASS.x ;  //acc is NON-INTERTIAL!!!
body[j].acc.vector[1] = body[j].F_tcm.vector[1]/body[j].MASS.x + g ;  //acc iS NON-INERTIAL!!!
body[j].acc.vector[2] = body[j].F_tcm.vector[2]/body[j].MASS.x ;  //acc iS NON-INERTIAL!!!

}


} //END OF CONDITION if LagrangeArticulatedBodies == 1 ....




for (j=0;j<nPOLY;j++){  //do update for all POLYGONs.

//if only polyhedron rebounce functionality is requested, deactivate this. 
//ANGACC IS NON-INERTIAL!!!

//caculate the advnce in L (angular momentum) produced by the torque vector in dft timestep.
body[j].L_advance.vector[0] = body[j].torque.vector[0]*dft ; //component x.
body[j].L_advance.vector[1] = body[j].torque.vector[1]*dft ; //component y (height in this original openGL version).
body[j].L_advance.vector[2] = body[j].torque.vector[2]*dft ; //component z.



//add advance gained, to L vector.
body[j].L = vector_sum( body[j].L ,   body[j].L_advance ) ;  //L prev + L_advance gained now. 

//ANGULAR MOMENTUM PART(DEACTIVATE IF ONLY-REBOUNCE FUNCITONALITIES ARE REQUESTED:
body[j].ww  = mat3x3_vect( body[j].TIworInv, body[j].L );

  //====MESSO ALL INIZIO DI MAINW() x DINAMICS VINCOLARE!!!!========
// store original velocity before updating it: this serves for numerical integration. 
//body[j].vel_pre.vector[0] = body[j].vel.vector[0] ;
//body[j].vel_pre.vector[1] = body[j].vel.vector[1] ;
//body[j].vel_pre.vector[2] = body[j].vel.vector[2] ;
//===============================================    


//LINEAR ACCELERATION'S EFFECT ON LINEAR VELOCITY - VELOCITY OF CM OF POLYHEDRON.
body[j].vel.vector[0] = body[j].vel.vector[0] + body[j].acc.vector[0]*dft  ;    //INERTIAL!!!
body[j].vel.vector[1] = body[j].vel.vector[1] + body[j].acc.vector[1]*dft  ;    //INERTIAL!!
body[j].vel.vector[2] = body[j].vel.vector[2] + body[j].acc.vector[2]*dft  ;    //INERTIAL!!

}





//UPDATE POSITION, AND ORIENTATION:
for (j=0;j<nPOLY;j++){  //do update for all POLYGONs.


//CORRECT DISCREET INTEGRATION MODE
body[j].pos.vector[0] =  body[j].pos.vector[0]  + body[j].vel_pre.vector[0]*dft + ( body[j].acc.vector[0]*pow(dft,2.0) )/2.0 ;
body[j].pos.vector[1] =  body[j].pos.vector[1]  + body[j].vel_pre.vector[1]*dft + ( body[j].acc.vector[1]*pow(dft,2.0) )/2.0 ;
body[j].pos.vector[2] =  body[j].pos.vector[2]  + body[j].vel_pre.vector[2]*dft + ( body[j].acc.vector[2]*pow(dft,2.0) )/2.0 ;




/* correct formula for numerical integration of orientation. axis of rotation is the previously calculated rotaxis that's it. */
/* symbolically informally is:  theta_total_change_in_orientation = TIworInv( L_pre*dt + torque*(dt^2)/2.0 ) */
body[j].alpha.x = leng_vect3(
                  mat3x3_vect( 
                              body[j].TIworInv, vector_sum ( 
                                                            pscv( body[j].L_pre, dft ) , 
							    pscv( 
							          body[j].torque, 
								  (dft*dft)/2.0 ) 
						           ) 
                              ) 
                              ) ;
 






//recalc separately vang and rotation-axis versor.
body[j].vang.x = leng_vect3( body[j].ww ) ;

      //caferul to normalise when it almost-zero!!! It becomes absurd, stay careful!- conditions.
      if(body[j].vang.x > 0.0000001  ){
        body[j].rotaxis.vector[0] = body[j].ww.vector[0] /body[j].vang.x  ;
        body[j].rotaxis.vector[1] = body[j].ww.vector[1] /body[j].vang.x  ;
        body[j].rotaxis.vector[2] = body[j].ww.vector[2] /body[j].vang.x  ;
      }
      else{
      body[j].rotaxis.vector[0] = 0.0 ;
      body[j].rotaxis.vector[1] = 0.0 ;
      body[j].rotaxis.vector[2] = 0.0 ;
      }
      

 //body[j].alpha.x = (body[j].vang.x)*dft ;

 //counter = counter + 1 ;
}                                                                                          
//END EFFECT OF FORCES CALCS
//END EFFECT OF FORCES CALCS
//END EFFECT OF FORCES CALCS



//ALL FORCES TO ZERO, BE SURE. DONE AFTER DISPLAY FUNCTOIN!! - WE WANT TO PLOT FORCE VECTORS... 
/*
for (j=0; j<nPOLY; j++ ){ 
      for (i=0; i<ngon; i++ ){
        body[j].vxFs.matrix[0][i] = 0.0 ;
        body[j].vxFs.matrix[1][i] = 0.0 ;
        body[j].vxFs.matrix[2][i] = 0.0 ;        
      }
} //END ALL FORCES TO ZERO.
*/






//BODYs VERTEX ROTATION PROCEDURES HERE:
//BODYs VERTEX ROTATION PROCEDURES HERE:
//BODYs VERTEX ROTATION PROCEDURES HERE:
for (j=0;j<nPOLY;j++) {

//row 1:
 body[j].D.matrix[0][0] = 0 ; 
body[j].D.matrix[0][1] = -body[j].rotaxis.vector[2]; 
body[j].D.matrix[0][2] =  body[j].rotaxis.vector[1] ;
//row 2:
 body[j].D.matrix[1][0] =  body[j].rotaxis.vector[2] ; 
body[j].D.matrix[1][1] =   0 ; 
body[j].D.matrix[1][2] =  -body[j].rotaxis.vector[0] ;
//row 3:
 body[j].D.matrix[2][0] =  -body[j].rotaxis.vector[1] ; 
body[j].D.matrix[2][1] =    body[j].rotaxis.vector[0]; 
body[j].D.matrix[2][2] =   0 ;

//CAREFUL TO INITIALISE AND HAVE COIRRECTLY SE TTHE IDENTITY MATRIX!!!!! OTHERWISE POLYHEDRA 'DISAPPEAR BECAUSE OF MATH ERROR -->> /0 kind'

//put updated  elements in it for 3D!!!

//make R1 - the excact Rotaion Matrix, rotating around the 'axisversor' vector.
body[j].R1 = 
mat3x3_sum(
           mat3x3_sum( 
                      body[j].I ,
                      pscm33( body[j].D, sin( body[j].alpha.x ) )
                      )
                      ,
           pscm33(
                  mat3x3_mult(body[j].D, body[j].D ),
                  1-cos( body[j].alpha.x )
                 )    
           ) ;


//sum up effect to previous orientation: R' = R1(the trasformer matrix)*R.
body[j].R = mat3x3_mult( body[j].R1, body[j].R ) ;   

}






/*Small modification for this _Simplex version of CTruck3D. All 'tyres' follow the orientation of the Polyhedron1. Theseese are virtual polyhedra, 
and theese are not physically simulated. */


/*
for (j=2;j<nPOLY;j++) {
body[j].R = body[0].R ; //overwrite,.... 


l_c = dot3_st( v_spring_curr[0], down_dir ) ;  //WARNING : it's the seme for all tyres beloging to the seme body!!!
//printf("current lenght DRAWING:  %3f\n",l_c ) ;
l_c = h_vxvs[j-1]/l_c ; //reuse it... sorry for little aesteticism.Rect Triangles Theorem applied....
l_crec[j-1] = l_c ; // BAD SOLUTIN!! store this number because it is neede in the interactivity function to decide whether acc can be done or not! 

// TOUCH POINT MUST BE AT lc from the stanrting vertex... so diameter is fully virtual parameter. in fact this is an approxiimated physical mode. 
    if( fabs(l_c) <= l_vsp && v_spring_curr[0].vector[1] <= 0 ){
    body[j].pos.vector[0] =  body[0].pos.vector[0]  + body[0].vx_s.matrix[0][j-1]  + (l_c - diam )*v_spring_curr[0].vector[0]  ;
    body[j].pos.vector[1] =  body[0].pos.vector[1]  + body[0].vx_s.matrix[1][j-1]  + (l_c - diam )*v_spring_curr[0].vector[1]  ;
    body[j].pos.vector[2] =  body[0].pos.vector[2]  + body[0].vx_s.matrix[2][j-1]  + (l_c - diam )*v_spring_curr[0].vector[2]  ;
    }
    else{
    body[j].pos.vector[0] =  body[0].pos.vector[0]  + body[0].vx_s.matrix[0][j-1]  + ( l_vsp - diam)*v_spring_curr[0].vector[0]  ;
    body[j].pos.vector[1] =  body[0].pos.vector[1]  + body[0].vx_s.matrix[1][j-1]  + ( l_vsp - diam)*v_spring_curr[0].vector[1]  ;
    body[j].pos.vector[2] =  body[0].pos.vector[2]  + body[0].vx_s.matrix[2][j-1]  + ( l_vsp - diam)*v_spring_curr[0].vector[2]  ;
    }


}

  for( i = 4 ; i < NPILLOW ; i++ ){
//l_crec[i] = 50.0 ;

  }
*/


//UPDATE wolrd-IntertiaTensor and its inverse.
//UPDATE wolrd-IntertiaTensor and its inverse.
//UPDATE wolrd-IntertiaTensor and its inverse.
for ( j=0; j<nPOLY ; j++ ) {
body[j].TIwor =    mat3x3_mult( mat3x3_mult( body[j].R, body[j].TI   ) , transpose33(body[j].R )  ) ;
body[j].TIworInv = mat3x3_mult( mat3x3_mult(body[j].R, body[j].TIinv ) , transpose33(body[j].R )  ) ;
}






//APPLY REORIENTAITON PROCEDURE:
//APPLY REORIENTAITON PROCEDURE:
//APPLY REORIENTAITON PROCEDURE:
//for(  j=0; j<nPOLY ; j++  ){
// body[j].vx_s = mat3x3_3xn( body[j].I, body[j].vx_origin) ; // NOT WORK... ??? VERY STRANGE...

// body[j].vx_s = body[j].vx_origin ;

// }

reorient_polyhedra() ;  // ALL-TOGATHER ROTATION FUNCTION; UPDATE ORIENTATION OF POLYS.

//**********PROVVISORY... NOT NEEDED FOR CORRET OPERATON***********
/* update axis_1 ,axis_2, and axis_3  which represent visually and geometrically the body's orientation. */
body[2].axis_1 = mat3x3_vect( body[2].R, body[2].axis1_orig ) ;
body[2].axis_2 = mat3x3_vect( body[2].R, body[2].axis2_orig ) ;
body[2].axis_3 = mat3x3_vect( body[2].R, body[2].axis3_orig ) ;
// Pforce = 0.0 ; //SOLVED BETTER.... gas give in only when 'w' or aroow UP is "being pressed".

//***********************END ROVVISORY*****************************


//BODY ROT PROC END. 
//BODY ROT PROC END. 
//BODY ROT PROC END. 
for ( j=0; j<nPOLY ; j++ ) {
v_spring_curr[j]         = mat3x3_vect( body[j].R, v_spring) ;  // MAIN CAR vive to the virtual spring versor the seme orientation as that of tha Polyhedron 1 - the 'car' .
}

//v_spring_curr[1]         = mat3x3_vect( body[1].R, v_spring) ; //TRAILER 
//reorient the axis of the tyre: used to select parto of friction perpendicular to tyre's disk(GUIDANCE).


for( i = 1 ; i < 5 ; i++ ){

  if( i == 1 || i == 2 ){
  s = -1 ;
  }
  
s = 1 ;

//body[i].reartyre_axis = mat3x3_vect( body[0].R, body[i].reartyre_axis_ori ) ;
// wheel[i-1].axis = mat3x3_vect( body[0].R, wheel[i-1].axis_orig ) ;

}


//===============================================================================================
for ( k=0 ; k < NPILLOW ; k++){  //get right vqriable number then.....  
    //============calculate it for each one! ==========================
  //but it depends on which one!!!!
  l_c = dot3_st( v_spring_curr[  pillowvx[k][0]  ], down_dir ) ;  //WARNING : it's the seme for all tyres beloging to the seme body!!!
  //printf("current lenght DRAWING:  %3f\n",l_c ) ;
  l_c = h_vxvs[k]/fabs(l_c) ; //reuse it... sorry for little aesteticism.Rect Triangles Theorem applied....


l_crec[k] = l_c ;


    if( l_c >= l_vsp){
    l_c = l_vsp ; 
    }

  //==================================================================
  

//extract vector going form main body's center to tyre j-1 's vertex i.
    s_vector1.vector[0] = body[ pillowvx[k][0] ].pos.vector[0] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[0][ pillowvx[k][1] ]  
+ (l_c - diam )*v_spring_curr[  pillowvx[k][0]  ].vector[0] ;  

    s_vector1.vector[1] = body[ pillowvx[k][0] ].pos.vector[1] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[1][ pillowvx[k][1] ]  
+ (l_c - diam )*v_spring_curr[  pillowvx[k][0]  ].vector[1] ;

    s_vector1.vector[2] = body[ pillowvx[k][0] ].pos.vector[2] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[2][ pillowvx[k][1] ]  
+ (l_c - diam )*v_spring_curr[  pillowvx[k][0]  ].vector[2] ;


wheel[k].pos = s_vector1 ;
wheel[k].R   = body[  pillowvx[k][0]  ].R ; //seme orientation as the body tho which virtual wheel belongs. 

wheel[k].vx_s = mat3x3_3xn(  wheel[k].R, wheel[k].vx_origin ) ;
wheel[k].axis = mat3x3_vect( wheel[k].R, wheel[k].axis_orig ) ;

}




//====================================_TRUCK subversion peculiarity ====================================
if ( LagrangeArticulatedBodies == 1 &&  counter%5 == 0  ){
// POSITION AND RELATIVE VELOCITY CORRECTION FOR TRAILER; TO AVOID SLOW SEPARATION OF THE 2 VERTICES OF THE JOINT.
// POSITION (EASY TO UNDERSTAND)
aux_vect.vector[0] = -(  ( body[1].pos.vector[0] + body[1].vx_s.matrix[0][ armvx[0][3]  ]  ) 
-  ( body[0].pos.vector[0] + body[0].vx_s.matrix[0][ armvx[0][1] ] )  
 ) ;
 
aux_vect.vector[1] = -(  ( body[1].pos.vector[1] + body[1].vx_s.matrix[1][ armvx[0][3]  ]  ) 
-  ( body[0].pos.vector[1] + body[0].vx_s.matrix[1][ armvx[0][1] ] )  
 ) ;
 
aux_vect.vector[2] = -(  ( body[1].pos.vector[2] + body[1].vx_s.matrix[2][ armvx[0][3] ]  ) 
-  ( body[0].pos.vector[2] + body[0].vx_s.matrix[2][ armvx[0][1] ] )  
 ) ;
 
body[1].pos = vector_sum ( body[1].pos, aux_vect ) ; // IT's A SUBTRACTION!! x(-1) DONE BEFORE!!




// VELOCITY, MORE DELICATE TO UNDERSTAND.


//TRAILER

 	s_vector2.vector[0] = body[1].vx_s.matrix[0][ armvx[0][3] ] ;  //extract vector from vector-collection matrix.
	s_vector2.vector[1] = body[1].vx_s.matrix[1][ armvx[0][3] ] ;
	s_vector2.vector[2] = body[1].vx_s.matrix[2][ armvx[0][3] ] ;

	//CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
	//FORMULA NORMSPEED. 
	body[1].vvertex = vector_sum( 
			    body[1].vel, cross( body[1].ww,  s_vector2 )
				    ) ;


//TRACTOR CAR
	s_vector1.vector[0] = body[0].vx_s.matrix[0][ armvx[0][1] ] ;  //extract vector from vector-collection matrix.
	s_vector1.vector[1] = body[0].vx_s.matrix[1][ armvx[0][1] ] ;
	s_vector1.vector[2] = body[0].vx_s.matrix[2][ armvx[0][1] ] ;

	//CALCULATE: velvector + cross(vang*axisversor, vertex_pos_vector_in_non-rotating-body_coordinates);
	//FORMULA NORMSPEED. 
	body[0].vvertex = vector_sum( 
			    body[0].vel, cross( body[0].ww,  s_vector1 )
				    ) ;


// now the difference....
aux_vect.vector[0] =   -( body[1].vvertex.vector[0] - body[0].vvertex.vector[0]  )  ;
aux_vect.vector[1] =   -( body[1].vvertex.vector[1] - body[0].vvertex.vector[1]  )  ;
aux_vect.vector[2] =   -( body[1].vvertex.vector[2] - body[0].vvertex.vector[2]  )  ;
 
//apply a correctiopn only if the relative vel accumulated is enough 'disastrous'.... 
if( leng_vect3( aux_vect ) > 1.0 ){
body[1].vel = vector_sum ( body[1].vel, aux_vect ) ; // IT's A SUBTRACTION!! x(-1) DONE BEFORE!!
}

}
//========================================================================================







//DISPLAY ENVIRONMENT AND POLYGONS IN IT, WITH STYLE DEFINED IN DISPLAY FINCTION:
//DISPLAY ENVIRONMENT AND POLYGONS IN IT, WITH STYLE DEFINED IN DISPLAY FINCTION:
//DISPLAY ENVIRONMENT AND POLYGONS IN IT, WITH STYLE DEFINED IN DISPLAY FINCTION:



// printf("orientation of Truck: \n %3f, %3f, %3f \n %3f, %3f, %3f \n %3f, %3f, %3f \n", body[0].R.matrix[0][0], body[0].R.matrix[0][1], body[0].R.matrix[0][2] ,body[0].R.matrix[1][0], body[0].R.matrix[1][1], body[0].R.matrix[1][2], body[0].R.matrix[2][0], body[0].R.matrix[2][1], body[0].R.matrix[2][2] );
// printf("cycle: %d ;", counter) ;

/* only for test... 
printf("X: ")  ;
printf("%3f", body[0].pos.vector[0]) ;
printf(" Y: ")  ;
printf("%3f", body[0].pos.vector[1]) ;
printf(" Z: ")  ;
printf("%3f \n", body[0].pos.vector[2]) ;
*/

//DISPLAY POSITION(variable) OF POINT, WITH openGL call:  
//copy data in adequate-sized array, picking positions form the 'body' struct.

/*
     for(j= 0; j<nPOLY ; j++){ 
			       auxpos[0][j] = body[j].pos.vector[0] ;
                               auxpos[1][j] = body[j].pos.vector[1] ;
                               auxpos[2][j] = body[j].pos.vector[2] ; 
     }
*/

if( in_vehicle > 0 ){ // REPLICA OR NOT????
smilzo_x = body[in_vehicle-1].pos.vector[0]  ;  //this is because orientation problems, simplify as much a spossible. correct head pos after!!
smilzo_y = body[in_vehicle-1].pos.vector[1]  ;   
smilzo_z = body[in_vehicle-1].pos.vector[2]  ;   
}

if ( follow_mode_switch == 1  ){
//PUT HERE WHAT TO DO IN ORDER TO ACHIEVE GOOD FOLLOW CAM MODE.....

  
/*
  THIS PUT AT I-OUT VEHICLE ACTION..... BUT IF SO COPY ALL THE OTHER REFERENCES!!!
	 cam_target_dir.vector[0] =   ;
	 cam_target_dir.vector[1] =  cam_target_dir2.vector[1] ;
	 cam_target_dir.vector[2] =  cam_target_dir2.vector[2] ;
*/
	 
//===this in every case: THE orientation, period.===


//done with ortientation stuff, do posiitoning.....
   cam_pos.vector[0] = smilzo_x -       ds*cam_target_dir.vector[0] ;   
   cam_pos.vector[1] = smilzo_y -       ds*cam_target_dir.vector[1] ;                 
   cam_pos.vector[2] = smilzo_z -       ds*cam_target_dir.vector[2] ;



      
   //COPY STRUCT ELEMENTS TO FLOAT ARRAYS TO PASS TO THE DISPLAY() FUNCTION.
   RES_cam_pos[0] = cam_pos.vector[0] ;  
   RES_cam_pos[1] = cam_pos.vector[1] ;
   RES_cam_pos[2] = cam_pos.vector[2] ;

  // RES_cam_target_dir[0] = cam_target_dir.vector[0] ;
  // RES_cam_target_dir[1] = cam_target_dir.vector[1] ;
  // RES_cam_target_dir[2] = cam_target_dir.vector[2] ;

   RES_cam_target_dir[0] = smilzo_x ;
   RES_cam_target_dir[1] = smilzo_y ;
   RES_cam_target_dir[2] = smilzo_z ;


   
 }
else if ( follow_mode_switch == 3 ) { 
  
//now re-calc the camera position.
   cam_pos.vector[0] = smilzo_x   ;   
   cam_pos.vector[1] = smilzo_y + 170.0  ;                 
   cam_pos.vector[2] = smilzo_z   ;


	// printf("VIS 3 SELECTED: FIX INTERNAL CAMERA VIEW.\n") ;
	if( in_vehicle == 0 ){  // STANDARD

//===this in every case: THE orientation, period.===


	}
	else if( in_vehicle == 1 ){  //if in vehicle, do this.....

/*
displace_x = 0.0 ; //SEEMS PERFECTLY OK. 
displace_y = 0.0 ;
displace_z = 0.0 ;
*/



// USE AUXILIARS!!!! NOT cam_target_dir2!! 
s_vector0.vector[0] = 1.0 ; // CAM_DIR
s_vector0.vector[1] = 0.0 ;
s_vector0.vector[2] = 0.0 ;

s_vector1.vector[0] = 0.0 ;
s_vector1.vector[1] = 1.0 ;
s_vector1.vector[2] = 0.0 ; // CAM_UP VECTOR 

s_vector2.vector[0]  = 0.0 ;
s_vector2.vector[1]  = 0.0 ; // CAM_HOR REF VECTOR
s_vector2.vector[2]  = 1.0 ;



	 s_vector0 = mat3x3_vect( body[0].R, s_vector0 ) ;     
	 s_vector1 = mat3x3_vect( body[0].R, s_vector1 ) ;     
	 s_vector2 = mat3x3_vect( body[0].R, s_vector2 ) ;     


	cam_pos.vector[0] = smilzo_x   ;   
	cam_pos.vector[1] = smilzo_y   ;                 
	cam_pos.vector[2] = smilzo_z   ;


//-----------------------------
 /* HERE BE CAREFUL TO ADD!!!!!! ADD YES BUT IN cam_target:dir's DIRECTION!!! CONSIDER ORIGINAL TRUCK-POLYHERDON!!! */

   /* FOR EXAMPLE THIS CAUSES A PARALLEL DISPOSAL on X!!! VERY CAREFUL!!!!!!!! */
   cam_pos.vector[0] = cam_pos.vector[0] +  displace_x*s_vector0.vector[0] ;   
   cam_pos.vector[1] = cam_pos.vector[1] +  displace_x*s_vector0.vector[1] ;           
   cam_pos.vector[2] = cam_pos.vector[2] +  displace_x*s_vector0.vector[2] ;
   
   /* FOR EXAMPLE THIS CAUSES A PARALLEL DISPOSAL on Y!!! VERY CAREFUL!!!!!!!! */
   cam_pos.vector[0] = cam_pos.vector[0] +  displace_y*s_vector1.vector[0] ;   
   cam_pos.vector[1] = cam_pos.vector[1] +  displace_y*s_vector1.vector[1] ;                 
   cam_pos.vector[2] = cam_pos.vector[2] +  displace_y*s_vector1.vector[2] ;
   
   /* FOR EXAMPLE THIS CAUSES A PARALLEL DISPOSAL on Z!!! VERY CAREFUL!!!!!!!! */
   cam_pos.vector[0] = cam_pos.vector[0] +  displace_z*s_vector2.vector[0] ;   
   cam_pos.vector[1] = cam_pos.vector[1] +  displace_z*s_vector2.vector[1] ;                 
   cam_pos.vector[2] = cam_pos.vector[2] +  displace_z*s_vector2.vector[2] ;
//-------------------------


cam_target_dir2 = mat3x3_vect( mat3x3_mult( R_VAR_CAM, body[0].R1 ), cam_target_dir2 ) ; 
cam_horiz_ref2 = mat3x3_vect( mat3x3_mult( R_VAR_CAM, body[0].R1 ), cam_horiz_ref2 ) ; 
cam_up_vector2 = mat3x3_vect( mat3x3_mult( R_VAR_CAM, body[0].R1 ), cam_up_vector2 ) ; 

R_VAR_CAM = body[0].I ; //reset it to identity.

	}



   RES_cam_pos[0] = cam_pos.vector[0] ;  
   RES_cam_pos[1] = cam_pos.vector[1] ;
   RES_cam_pos[2] = cam_pos.vector[2] ;
   
   RES_cam_target_dir[0] = cam_target_dir2.vector[0] ;
   RES_cam_target_dir[1] = cam_target_dir2.vector[1] ;
   RES_cam_target_dir[2] = cam_target_dir2.vector[2] ;
  
}





	if ( draw_cycle == draw_at_cycle ){
	draw_cycle = 0 ;
	display( alphaCam, beta, woption, RES_cam_pos, RES_cam_target_dir, RES_cam_up_vector, RES_cam_horiz_ref ) ;
	waitdt_ms(best_dt_ms) ; /* PAUSE BETWEEN CYCLES.*/ 
	}

          //ALL FORCES TO ZERO, BE SURE.
               for (j=0; j<nPOLY; j++ ){ 
                   for (i=0; i < sel_ngon[j] ; i++ ){
                     body[j].vxFs.matrix[0][i] = 0.0 ;
                     body[j].vxFs.matrix[1][i] = 0.0 ;
                     body[j].vxFs.matrix[2][i] = 0.0 ;        
                   }
               } //END ALL FORCES TO ZERO.

for(j=0 ; j < nPOLY ; j++ ){
body[j].acc_drv.vector[0] = 0.0 ;
body[j].acc_drv.vector[1] = 0.0 ;
body[j].acc_drv.vector[2] = 0.0 ;
 
body[j].torque_drv.vector[0] = 0.0 ;
body[j].torque_drv.vector[1] = 0.0 ;
body[j].torque_drv.vector[2] = 0.0 ;
}

} 
//END MAINW function.
//END MAINW function.
//END MAINW function.





//MINSC FUNCTIONS FOLLOW: math funcitons included from vcalc.h ;



//REORIENTATION MATRIX MULT TAKES vx as is, AND REORIENTS POLYs:
//      a1[2][j] -- left matrix
//      a2[2][2] -- right matrix
//      a3[2][j] -- answer matrix
//perform matrix multiplication for quick transform (rotation);
//void reorient_polyhedra(float m1[3][3][nPOLY],float m2[3][ngon][nPOLY]){

void reorient_polyhedra(void){
//check with I matrix if problems arise.

for (nu = 0; nu<nPOLY ; nu++) { 
       for(i = 0; i < 3; i++)    {
           for( j = 0; j < ngon; j++) {  /* DON'T TOUCH NGON HERE!! */
           sum = 0 ;
               for( k = 0; k < 3; k++) {
           //OrientationMatrix(3x3)*OriginalPolihedronVertexStoreMatrix(3x100...or even more).
           sum = sum + body[nu].R.matrix[i][k]*body[nu].vx_origin.matrix[k][j];                     
                   }
                   am[i][j][nu] = sum ;
//u can test....
//printf("%3f  %3f  %3f \n ", body[nu].I.matrix[i][0],  body[nu].I.matrix[i][1],  body[nu].I.matrix[i][2] );
//getchar();
               }
           }
       } //n polys.
//update m3, the result matrix:           
for (nu=0 ; nu < nPOLY ;nu++){ 
    for (i=0; i <3 ; i++) {
         for (j=0 ; j<ngon ; j++) {                        
             body[nu].vx_s.matrix[i][j] = am[i][j][nu] ;
            }
       }
   } 
} //END end  reorient_polyhedra()  function         









struct mat_3x3  make_inertia_tensor( struct mat_3xn  in_matrix_vx, struct mat_3xn  in_matrix_massvx, int n_vertexs   ){

//be very careful to assign storage space correctly!!!! ohterwise it brigs to 0 all elements!!!  
#define ne 100  
int i, j, k ;  
struct mat_3x3  result_matrix ;
double Ixxe[ne], Iyye[ne] , Izze[ne] ; /* those  'principal moments of inertia'.... */
double Ixye[ne], Ixze[ne] , Iyze[ne] ; /* those  'products of inertia'....          */
double Ixx=0, Iyy=0, Izz=0 ;   /* the total principal moments of inertia to put into the diagonals of the 3x3 tensor matrix. */
double Ixy=0, Ixz=0, Iyz=0 ;   /* these are automatically set = 0, that's important.... */


    //compute the elemets of the final tensor matrix:
    for( i = 0 ; i < n_vertexs ; i++ ){
      //those 'principal moments of inertia'...:
       Ixxe[i] = in_matrix_massvx.matrix[0][i]*( pow(in_matrix_vx.matrix[1][i],2 ) + pow(in_matrix_vx.matrix[2][i],2 )  );  //yz
       Iyye[i] = in_matrix_massvx.matrix[0][i]*( pow(in_matrix_vx.matrix[0][i],2 ) + pow(in_matrix_vx.matrix[2][i],2 )  );  //xz
       Izze[i] = in_matrix_massvx.matrix[0][i]*( pow(in_matrix_vx.matrix[0][i],2 ) + pow(in_matrix_vx.matrix[1][i],2 )  );  //xy
      //those 'products of inertia'...:
       Ixye[i] = in_matrix_massvx.matrix[0][i]*( in_matrix_vx.matrix[0][i]*in_matrix_vx.matrix[1][i] );
       Ixze[i] = in_matrix_massvx.matrix[0][i]*( in_matrix_vx.matrix[0][i]*in_matrix_vx.matrix[2][i] );
       Iyze[i] = in_matrix_massvx.matrix[0][i]*( in_matrix_vx.matrix[1][i]*in_matrix_vx.matrix[2][i] );
    }

    //sum up:
    for( k = 0 ; k < n_vertexs ; k++){
    Ixx = Ixx + Ixxe[k] ;
    Iyy = Iyy + Iyye[k] ;
    Izz = Izz + Izze[k] ;

    Ixy = Ixy + Ixye[k] ;
    Ixz = Ixz + Ixze[k] ;
    Iyz = Iyz + Iyze[k] ;
    }


//put principal moments of inertia into the diagonals of the result matrix:
result_matrix.matrix[0][0] = Ixx ;
result_matrix.matrix[1][1] = Iyy ;
result_matrix.matrix[2][2] = Izz ;

//put inertia products in result_matrix tensor:
result_matrix.matrix[0][1] = -Ixy  ; 
result_matrix.matrix[1][0] = -Ixy  ;

result_matrix.matrix[0][2] = -Ixz  ; 
result_matrix.matrix[2][0] = -Ixz  ;

result_matrix.matrix[1][2] = -Iyz  ; 
result_matrix.matrix[2][1] = -Iyz  ;




//printf("FINAL INVERSE TO CHECK: \n");
   for(i=0;i<3;i++){
  //        printf(" \n");
          for(j=0;j<3;j++){                         
    //    printf("%3f  ",result_matrix.matrix[i][j]);               
          }
   }

return result_matrix ; 
}







void deform_poly( struct vect_data  *hit_versor,  double jea, struct struct_body *inb, int ind ) {

	float d_before , d_after , sign = 1.0 ;
        struct vect_data auv ;

	auv = mat3x3_vect( inb[0].R , hit_versor[0] ) ;


	d_before = pow( 
	pow( inb[0].vx_origin.matrix[0][ind],2) + 
	pow( inb[0].vx_origin.matrix[1][ind],2) + 
	pow( inb[0].vx_origin.matrix[2][ind],2) , 0.5 ) ;

	d_after = 
	pow( 
	pow( inb[0].vx_origin.matrix[0][ind]   + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[0] ,2 ) + 
	pow( inb[0].vx_origin.matrix[1][ind]   + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[1] ,2 ) + 
	pow( inb[0].vx_origin.matrix[2][ind]   + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[2] ,2 ) , 0.5 ) ;


		if( d_before < d_after   ){
		sign = -1.0 ;
		}

		inb[0].vx_origin.matrix[0][ind] = inb[0].vx_origin.matrix[0][ind] + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[0] ; 
		inb[0].vx_origin.matrix[1][ind] = inb[0].vx_origin.matrix[1][ind] + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[1] ;
		inb[0].vx_origin.matrix[2][ind] = inb[0].vx_origin.matrix[2][ind] + (1.0/inb[0].imp_resist.matrix[0][ind])*sign*jea*auv.vector[2] ;

	inb[0].imp_resist.matrix[0][ind] =  1.0*( inb[0].imp_resist.matrix[0][ind] ) + ( jea/100.0 )  ; 

}


 



//TITLE TEXT PART 1.
//TITLE TEXT PART 1.
//TITLE TEXT PART 1.
typedef enum {
   MODE_BITMAP,
   MODE_STROKE
} mode_type;
static mode_type mode;
int font_index;

    
   char *bitmap_font_names[5] = 
   {  "C_STUNTS",    
      "by Simon_Hasur",
      "(c)2011|OpenSource-->GPLv3 licence ",
      "vehicle physics simulation",
      "[OpenGL graphics]" } ;

char long_msg[10][50] = {
			"Hotkey quickreference",
			"_____________________", 
			"MOVE: | w=a=z=d     |",
			"CAM:  | c=v=r=f=,=- |",
			"INTERN CAM POS: 3,4, 7,0",
			"VIEW: | o |POLIG: m |",
			"LIFT: | u=h=j       |",
			"ZOOM: | 1,2         |",
			"TRAIL OFF:| l (ell) |",
			"BREAK:| s           |"

			} ;








     



/*TEXTURE PROBES*/
/*TEXTURE PROBES*/
/*TEXTURE PROBES*/
/*TEXTURE PROBES*/
/*	Create checkerboard texture	*/
#define	checkImageWidth  16
#define	checkImageHeight 16
static GLubyte checkImage[checkImageHeight][checkImageWidth][4];


static GLubyte graffiti[16][32][4] ;

#ifdef GL_VERSION_1_1
static GLuint texName;
#endif

//TEXTURE OF GROUND PIECE, SET MANUALLY.

int Suck_my_Truck[8][128] = {
{ 0,0,1,1,0,0,0,1,1,0,0,1,1,1,1,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }, 
{ 0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
{ 1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,1,1,0,0 },
{ 1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0 },
{ 1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,1,1,1,1,0,0,0,1,0,1,0,0,0,1,1,1,0,0,1,0,0,0,1,0,1,1,1,0,0 },
{ 1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0 },
{ 0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,0 },
{ 0,0,1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,1,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,0,1 },
           	};


float   Rgtxt8x8[16][16] ;			    

float   Ggtxt8x8[16][16] = {{ 200 ,240, 40, 40 , 30 ,40,45,30, 40 ,40,40, 40,30,20,70,30 }, 
                            { 14  ,240, 20, 40 , 240 ,40,40,280, 40 ,40,20,160,40 ,40,60,80 },
                            { 140 ,14 , 20, 40 , 240 ,40,40,80, 40 ,40,20,60,40 ,40,60,80 },
                            { 14  ,140, 21, 40 , 231 ,30, 1,60, 60 ,70,21,80,21 ,70, 31,60 },
                            { 140 ,140, 40, 41 , 230 ,10,60,180, 150 ,40,50,21,50 ,10,60,80 },
                            { 14  ,100, 40, 240,230 ,30,10,30, 40 ,50,40,40,110 ,30,10,230 },
                            { 14  ,50 , 40, 240,210 ,30,10,30, 40 ,150,40,40,110 ,30,10,30 },
                            { 120 ,20 , 31, 30 ,30 ,120,210,30, 20 ,120,131,30,40 ,220,10,30 },
                            { 14  ,120, 40, 40 ,30,20,170,130, 40 ,140,40, 40,30,20,70,30 }, 
                            { 140 ,140, 40, 40 ,40 ,40,60,80, 140 ,40,20,60,40 ,40,60,80 },
                            { 14  ,140, 20, 60 ,40 ,40,60,80, 140 ,40,20,60,40 ,40,60,80 },
                            { 16  ,170, 21, 80 ,21 ,70, 1,160, 160 ,70,21,80,21 ,70, 1,60 },
                            { 150 ,140, 50, 21 ,50 ,10,60,180, 150 ,40,50,21,50 ,10,60,80 },
                            { 14  ,150, 40, 40 ,10 ,30,10,130, 140 ,50,40,40,10 ,80,10,30 },
                            { 140 ,150, 40, 40 ,10 ,30,10,130, 140 ,50,10,10,10 ,30,10,30 },
                            { 12  ,20 , 31, 30 ,40 ,20,10,30, 120 ,20,31,30,40 ,20,10,83 }};


float   Bgtxt8x8[16][16] = {{ 23 ,43,56, 25,47,69,45,30, 40 ,40,40, 40,30,20,70,30 }, 
                            { 65 ,2,0,40,20 ,40,40,20, 40 ,40,20,160,40 ,40,60,80 },
                            { 34 ,13,20,40,20 ,40,40,80, 40 ,0,20,60,40 ,40,60,80 },
                            { 45 ,0,21,40,21 ,30, 1,60, 60 ,0,21,80,21 ,70, 1,60 },
                            { 34 ,0,40,41,30 ,10,60,10, 150 ,0,50,21,50 ,0,0,80 },
                            { 23 ,0,40,20,20 ,30,10,30, 40 ,0,40,40,110 ,0,0,230 },
                            { 12 ,10,40,20,20 ,30,10,30, 40 ,0,0,0,0 ,30,10,30 },
                            { 12 ,10,31,30,30 ,10,20,30, 20 ,10,31,3,40 ,20,10,30 },
                            { 56 ,10,40, 40,30,20,10,130, 40 ,10,40, 40,30,20,70,30 }, 
                            { 23 ,10,40,40,40 ,40,60,80, 140 ,40,20,60,40 ,40,60,80 },
                            { 89 ,10,20,0,40 ,40,60,80, 140 ,40,20,60,40 ,40,60,80 },
                            { 12 ,10,21,0,21 ,70, 1,10, 160 ,70,21,80,21 ,70, 1,60 },
                            { 34 ,10,50,21,50 ,10,60,10, 50 ,40,50,21,50 ,10,60,80 },
                            { 5 ,10,40,40,10 ,30,10,10, 10 ,50,40,40,10 ,80,10,30 },
                            { 189 ,10,40,40,10 ,30,10,10, 10 ,50,10,10,10 ,30,10,30 },
                            { 100 ,20,31,30,40 ,20,10,30, 10 ,20,31,30,40 ,20,10,83 }};



void myinit(void)
{
  mode = MODE_BITMAP;  //specific command to render fonts to display text.
  glClearColor( 0.9, 0.9, 1.0, 0.0); /* sky-color background */
  
  glShadeModel (GL_SMOOTH) ;

   glEnable (GL_BLEND);
   glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
   
  // glBlendFunc (GL_ONE, GL_ONE );

  
  //ACTIVATE DEPTH TEsT FOR 'HIDDEN SURFACE REMOVAL'.

  glEnable(GL_DEPTH_TEST);						// Enables Depth Testing

  
  glClearDepth(1.0f);							// Depth Buffer standard value Setup
  glDepthFunc(GL_LESS);						// The Type Of Depth Test To Do
  glDepthRange(0.0,1.0);
  

/* SET SOME GL OPTIONS FOR LEAST PRECISION, SINCE THIS IS NOT A GRAPHICS PROGRAM... WE NEED COMPUTER POWER FOR PHYSICS CALCS MORE */
  glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);			// Fastest - less expensive - Perspective Calculations
  glHint( GL_POLYGON_SMOOTH_HINT, GL_FASTEST);			// Fastest - less expensive - Perspective Calculations
  glHint( GL_FOG_HINT, GL_FASTEST);	
  glHint( GL_LINE_SMOOTH_HINT, GL_FASTEST);	



  glEnable(GL_FOG) ;
  float FogCol[3]={0.7f,0.7f,0.7f}; // Define a nice light grey
  glFogfv(GL_FOG_COLOR,FogCol);     // Set the fog color
  
  glFogi(GL_FOG_MODE, GL_LINEAR); // Note the 'i' after glFog - the GL_LINEAR constant is an integer.

/*
  glFogf(GL_FOG_START, 5100.0f);
  glFogf(GL_FOG_END, 5200.0f);
  glFogf(GL_FOG_DENSITY, 0.0005f);
*/

  glFogf(GL_FOG_START, 1400.0f);
  glFogf(GL_FOG_END, 80200.0f);
  glFogf(GL_FOG_DENSITY, 0.005f);


  glMatrixMode(GL_PROJECTION);      /* In World coordinates: */
  glLoadIdentity();                         /* glOrtho : position the "clipping rectangle" */
  glOrtho( -B/2, B/2, -B/2, B/2, 1, -10);   /* at -B/2, its right edge at +B/2, its bottom */
  glMatrixMode(GL_MODELVIEW);       /* edge at -B/2 and its top edge at +B/2 */


init_simulator() ; 


//HERE JUST SET THE FIX PARAMETER (3) TO 255(the standard value) neede for RGBA color definition.

srand( clock() );
    for (i = 0; i < checkImageHeight; i++) {
      for (j = 0; j < checkImageWidth; j++) {
	
         checkImage[i][j][0] = (GLubyte) 0 ;
         checkImage[i][j][1] = (GLubyte) 0 ;
         checkImage[i][j][2] = (GLubyte) 0 ;
         checkImage[i][j][3] = (GLubyte) 0 ;


   float gaussian = 0 , color, color_poly ;
   
	for( k = 0 ; k < 8 ; k++ ){
	gaussian = gaussian +  ((float) rand() )/( (float) RAND_MAX ) ; 
	}
       gaussian = fabs(gaussian/8.0) ; 
      // printf("gauss: %f\n", gaussian ); // only for test...


color = 150.0 + 199.0*gaussian ; 
if( color > 255 ){
color = 255.0 ; 
}

color_poly = 100.0 + 299.0*gaussian ; 
if( color_poly > 255 ){
color_poly = 255.0 ; 
}




       Rgtxt8x8[i][j] = color ; 
       Ggtxt8x8[i][j] = color ; 
       Bgtxt8x8[i][j] = color_poly ; 		
      }
   }
   
   
	//HERE COPY THE RIGHT RGB VALUES FORM THE MATRIX TRIPLET RGB.   
   
	for (i = 0; i < checkImageHeight; i++) {
	      for (j = 0; j < checkImageWidth; j++) {
        	 checkImage[i][j][0] = (GLubyte) Rgtxt8x8[i][j] ;
		 checkImage[i][j][1] = (GLubyte) Ggtxt8x8[i][j] ;  // would be Ggtxt...
		 checkImage[i][j][2] = (GLubyte) Bgtxt8x8[i][j] ;  // would be Bgtxt...
	      }
	}




in_vehicle = 1 ;
best_dt_ms = 10.0 ; // very importanto to fix. it... fine-tuning is done manually by user with beys 5 and 6 .
}

















void add_tree( float x, float y , float z, int  type_n ){


int i, j, txtres = 16 ;
float colevid[3] = { 0.1, 0.5, 1.0 } ;

if ( type_n == 2 ){
txtres = 32 ;

colevid[0] = 0.5 ;
colevid[1] = 0.6 ;
}

float treetxt[32][16] = {   
			{ -0.9, -0.9,  -0.9,  0.9, 0.91, -0.9,  0.93 , 0.94, 0.95, 0.96,  -0.9, 0.98, -0.9, 0.99, -0.9, -0.9  }, 
			{ -0.9, -0.9,  -0.9, -0.9, 0.90, 0.95,  -0.9 , -0.9, 0.90, 0.99,  -0.9, 0.95, 0.99, 0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.8, -0.9, 0.90, -0.9,  0.98 , 0.95, 0.90, 0.99,  0.98, -0.9, -0.9, -0.9, 0.95, -0.8  },
			{ -0.9, -0.8,  0.94, 0.99, -0.9, 0.99,  -0.9 , 0.96, 0.99, 0.97,  0.90, 0.95, 0.98, 0.95, 0.90, -0.9  },
			{ 0.90, -0.9,  0.98, 0.95, -0.9, 0.95,  0.98 , -0.9, 0.90, -0.9,  0.98, 0.95, 0.99, -0.9, -0.9, 0.95  },
			{ -0.8, 0.89,  -0.9, 0.94, -0.9, 0.99,  -0.9 , 0.94, 0.95, 0.99,  0.97, -0.9, -0.9, 0.99, 0.97, 0.94  }, 
			{ 0.90, 0.85,  0.98, 0.95, 0.80, 0.85,  0.98 , 0.95, 0.80, -0.9,  0.98, -0.9, 0.99, -0.9, 0.94, -0.9  },
			{ 0.95, -0.9,  -0.8, 0.94,  0.8, -0.8,  0.97 , 0.94, 0.95, 0.99,  -0.9, 0.94, 0.95, 0.99, 0.97, -0.9  }, 
			{ -0.9, -0.9,  0.99, -0.9, 0.80, 0.95,  0.98 , 0.95, -0.9, 0.95,  0.98, 0.95, 0.95, 0.98, 0.95, -0.8  },
			{ 0.90, 0.95,  0.98, 0.95, 0.90, 0.95,  0.98 ,  0.9, 0.90, 0.95,  -0.9, 0.95, -0.9, 0.97, 0.94, 0.95  },
			{ 0.91, 0.96,  0.99, -0.9, -0.9, -0.9,  0.98 , 0.95, 0.80, 0.95,  0.98, 0.95, 0.95, 0.98, 0.95, -0.8  },
			{ -0.9, 0.95,  0.98, -0.9, 0.90, 0.95,  0.98 , 0.95, -0.9,  0.9,  -0.9, 0.95, 0.99, 0.97, -0.9, 0.95  },
			{ 0.94, 0.95,  0.98, 0.95, 0.94,  0.9,  0.98 , 0.92, -0.9, 0.95,  0.88, -0.9, 0.89, -0.9, 0.94, 0.95  },
			{ -0.9, -0.9,  0.98, 0.95, -0.9, 0.95,  0.98 , 0.95, 0.90, 0.95,  0.98, 0.95, 0.99, 0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, 0.95, 0.90, -0.9,  0.98 , 0.95, -0.9, 0.95,  0.98, 0.95, 0.99, -0.9, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9, -0.9, -0.9,  0.98 , 0.95, -0.9, -0.9,  -0.9, -0.9, -0.9, -0.9, -0.9, -0.8  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.91, -0.9,  -0.93,-0.94,-0.95,-0.96,  -0.9,-0.98,-0.99,-0.99, -0.9, -0.9  }, 
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, -0.9,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, -0.9,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, -0.9,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9,-0.90, -0.9,  -0.9 , -0.9,-0.90, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9,-0.90, -0.8,  -0.9 , -0.9,-0.90, -0.9,   0.9, 0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9, 0.90,  0.9,  -0.9 , -0.9,-0.90, 0.99,   0.9,-0.95, 0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90,  0.9,  -0.9 , -0.9, 0.90, 0.99,   0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9, -0.9,-0.90,  0.9,  -0.9 , -0.9, -0.9, 0.98,   0.8,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9, 0.90, -0.9,   0.8 ,  0.9,  0.9, 0.99,  -0.9,-0.95,-0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9, 0.90,  0.9,  -0.9 ,  0.9, 0.90, -0.9,   0.7,-0.95, 0.99,-0.97, -0.9, -0.9  },
			{ -0.9, -0.9,  -0.9,  0.9,-0.90,  0.9,  -0.9 ,  0.8, 0.70, 0.99,  -0.9, 0.91, 0.99,-0.97, -0.9, -0.9  }
		
		} ;


   for( j = 0 ; j < 16 ; j++ ){
	for( i = 0 ; i < 16 ; i++ ){

	  if( treetxt[ (txtres-1)-j][i] >= 0.0  ){
	
	
	  glColor3f( fabs( treetxt[ (txtres-1) - j][i])*colevid[0] , fabs( treetxt[ (txtres-1) -j][i])*colevid[1] , 0.0 ) ; 

	  glBegin( GL_QUADS ) ;
	  glVertex3f( x + 10.0*i     - 80.0, y + 10.0*j     , z ) ;
	  glVertex3f( x + 10.0*(i-1) - 80.0, y + 10.0*j     , z ) ;
	  glVertex3f( x + 10.0*(i-1) - 80.0, y + 10.0*(j-1) , z ) ;
	  glVertex3f( x + 10.0*i     - 80.0, y + 10.0*(j-1) , z ) ;

	  glEnd() ;

		
glColor3f( fabs(treetxt[txtres-j][i])*colevid[0]*1.1 , fabs(treetxt[txtres-j][i])*colevid[1]*0.7 , 0.0 ) ; 

	  glBegin( GL_QUADS ) ;
	  glVertex3f( x , y + 10.0*j     , z + 10.0*i     - 80.0 ) ;
	  glVertex3f( x , y + 10.0*j     , z + 10.0*(i-1) - 80.0 ) ;
	  glVertex3f( x , y + 10.0*(j-1) , z + 10.0*(i-1) - 80.0 ) ;
	  glVertex3f( x , y + 10.0*(j-1) , z + 10.0*i     - 80.0 ) ;
	
	  glEnd() ;
	

	  }

	}
   }

glFlush() ;

}





void add_particles( float x, float y, float z, float vx, float vy, float vz, float dft,  int do_add ){
 
static int n = 0 ;
static float poss[500][3] ;
static float vels[500][3] ;
static int life[500] ;

int i , k ;

if( do_add == 1 ){

// position new projectile in catesian space - the scenario, essentially.
poss[n][0] = x ;
poss[n][1] = y ;
poss[n][2] = z ;

vels[n][0] = vx ;
vels[n][1] = vy ;
vels[n][2] = vz ;

// life[n] = 1 ; // do not set to 0 because it mekes start the explosion cycle.
	life[n] = -55 ; 
n++ ;
}

glEnable(GL_BLEND);




// update positions.
for( i = 0 ; i < n ; i++ ){

//if( life[i] > 0 ){ // normal life cycle ( goes ahead )

vels[i][1] = vels[i][1] - 111.0*dft ;  // GRAVITY ACCELERATION


poss[i][0] =  poss[i][0] + vels[i][0]*dft ;
poss[i][1] =  poss[i][1] + vels[i][1]*dft ;
poss[i][2] =  poss[i][2] + vels[i][2]*dft ;
//}
//else if( life[i] < 0 ){  // expanding smoke cycle


	for( k = 0 ; k < 5 ; k++ ){


// color = fabs( rand() )/RAND_MAX ;

glPointSize( 2 ) ;


	glColor4f( 0.7 , 0.7 , 0.7, 0.3 ) ; 
	glBegin( GL_TRIANGLES  ) ;  
	glVertex3f( poss[i][0] - 5.0 -  2.0*(life[i]+55.0)*cos( 0.8*( (double) k) )  ,
		    poss[i][1] , 
		    poss[i][2] + 0.5*(life[i]+55.0)*sin( 0.8*( (double) k) ) ) ; 

	glVertex3f( poss[i][0] + 5.0 + 2.0*(life[i]+55.0)*cos( 0.8*( (double) k) )  ,
		    poss[i][1] , 
		    poss[i][2] + 1.0*(life[i]+55.0)*sin( 0.8*( (double) k) ) ) ;

	glVertex3f( poss[i][0]  ,
		    poss[i][1] - 191.0*dft +  5.0 -  2.0*(life[i]+55.0)*cos( 0.8*( (double) k) ) , 
		    poss[i][2] - 1.5*(life[i]+55.0)*sin( 0.8*( (double) k) ) ) ;

	glEnd();


glColor3f( 8.0 , 8.0 , 8.0 ) ; 
	glBegin( GL_POINTS  ) ;  
	glVertex3f( poss[i][0] +  0.7*(life[i]+55.0)*cos( 0.8*( (double) k) )  ,
		    poss[i][1] - 191.0*dft, 
		    poss[i][2] +  0.7*(life[i]+55.0)*sin( 0.8*( (double) k) ) ) ; 

glEnd() ;


	}

glFlush() ;
// glDisable(GL_BLEND) ;

// }



life[i]++ ; // works for lifecycle and explosion cycle too. 



//	if( life[i] > 45 || 
// ( proof = check_grcollision( poss[i][0] ,  poss[i][1],  poss[i][2] , &mg ) )>= 0 ){
 
//		if ( life[i] > 45 ){
//		life[i] = -40 ; // start explosion cycle.
//		}
//		else if( proof >= 0 && life[i] < 45 && life[i] > 0  ){
 //		life[i] = -40 ;
//		poss[i][1] = poss[i][1] + 50.0 ;
//		}
//	}
  




       /* 
	if( proof > 0 ){
 
		if ( life[i] > 45 ){
		life[i] = -40 ; // start explosion cycle.
		}
		else if( proof >= 0 && life[i] < 45 && life[i] > 0  ){
 		life[i] = -40 ;
		poss[i][1] = poss[i][1] + 50.0 ;
		}
	}
*/


	    if( life[i] >= 0 ){	
                n-- ;
		for( k = 1 ; k < n ; k++ ){
		poss[k-1][0] =  poss[k][0]  ;
		poss[k-1][1] =  poss[k][1]  ;
		poss[k-1][2] =  poss[k][2]  ;

		vels[k-1][0] = vels[k][0] ;
		vels[k-1][1] = vels[k][1] ;
		vels[k-1][2] = vels[k][2] ;

		life[k-1] = life[k] ;
	        } // END for
	
            } // END if
       
    }

}







void display( float pitch , float head_in, int opt,
	     float IN_cam_pos[3], float IN_cam_target_dir[3], float IN_cam_up_vector[3], float IN_cam_horiz_ref[3] )
{ 
double apl, bpl, cpl, dpl, Xtri, Ytri, Ztri ;

//  glClearColor( 0.0, 0.0, 0.0, 0.0); /* black background, *required* by all geometric representations: only real-looking scenario uses different one. */
  
static int texture_generated = 0 ; /* at first call of this function, a 32x32 texture sample will be generated */

  // static float txt[32][32][3] ;
  
  /*	Create texture	*/
/* maximal vlues... IF POSSIBLE DON'T EXPLOIT MAXIMUMS. */
#define	txtWidth  64
#define	txtHeight 64

int txtRES = 64 ; // A REASONAMBLE TEXTURE RESOUTION
 
//static GLubyte checkImage[txtHeight][txtWidth][4];


static GLubyte txt1[txtHeight][txtWidth][3] ;

#ifdef GL_VERSION_1_1
static GLuint texName ;
#endif
  
  int j, i,k ;

  
  if( texture_generated == 0  ){
  texture_generated = 1 ;  // don't repeat this code block anymore.
    
    for( j = 0 ; j < txtHeight ; j++ ){
      for( i = 0 ; i < txtWidth ; i++ ){
	   for( k = 0 ; k < 3 ; k++ ){
	   txt1[j][i][k] = (GLubyte) 0.5*255.0 + (double) 255.0*rand() / (double) RAND_MAX ;
	   
	   }
      }
    }
    
    //=================GROUND TEXTURE PERSONALISED...=====================
   // texture_size = TEXRES ;
//float bigvect[10000], bigvect2[10000], bigvect3[10000] ;
//int image[10000][3]; // first number here is 1024 pixels in my image, 3 is for RGB values

/* WE USE SDL LIBRARY's Bitmap image file reading routine so... this is not used anymore because proved rather unreliable.
FILE *streamIn;
 char byte ; 
*/

int texn = 1 ;


while ( texn > 0 ){
char filename[20] ;
SDL_Surface *image;	//This pointer will reference our bitmap.

int bytes_per_color, imhe ; 
Uint8  red, green, blue ;
Uint32 color_to_convert ;	

bytes_per_color = COLDEPTH/8 ;
	

sprintf( filename, "textures/texture_%i.bmp", texn ) ;
printf( "TRYING TO OPEN FILE: %s", filename ) ;  
 

 
//little example:  image = SDL_LoadBMP("image.bmp") ; 
image = SDL_LoadBMP(filename) ;


imhe = txtWidth ;
	if (image != NULL) {
		printf("bitmap found: %s\n", filename );
	
	
   imhe = image->h ;
   txtRES = imhe ; // set TEXTURE RESOLUTION txt must be SQUARE!!!
   
printf("bitmap RES: %i\n", imhe );
SDL_Delay(100);
	

/*---------feed into 'the' array used for this.....---------*/
   for( j = 0 ; j < txtRES ; j++ ){      // vertical
	for( i = 0 ; i < txtRES ; i++ ){ // horizontal
	color_to_convert = getpixel( image, i, j ) ;
	SDL_GetRGB( color_to_convert, image->format, &red, &green, &blue );
                      
	txt1[j][i][0] = (GLubyte) red   ;
	txt1[j][i][1] = (GLubyte) green ;
	txt1[j][i][2] = (GLubyte) blue  ;

/* A GOOD TEST TO SEE IF TEXTURE DISPLAY ITSELF WORKS CORRECT... 
txt1[j][i][0] = (GLubyte) i  ;
txt1[j][i][1] = (GLubyte) j  ;
txt1[j][i][2] = (GLubyte) i  ;
*/

// printf("pixel : [%d,%d,%d]\n",red,green,blue);
	}
   }
/*----------------------------------------------------------*/
//Release the surface
SDL_FreeSurface(image);



texName = texn ;

//---------| TEXTURE PROCESSING |-----THIS PART MUST BE EXECUTED ONLY ONCE!!! OTHEERWISE IT SILENTLY OVERLOADS MEMORY AT EACH CALL-----------


glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

#ifdef GL_VERSION_1_1
   glGenTextures(1, &texName);
#endif

texid[texn-1] = texName ; // [texn-1] because startd fron 1, be careful

glBindTexture(GL_TEXTURE_2D, texid[texn-1] ) ;  // [texn-1] because startd fron 1, be careful


//#ifdef GL_VERSION_1_1
//   glGenTextures(1, &texName);
//#endif
   

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,  GL_NEAREST  /* GL_LINEAR  */ ) ; // what OpgnGL should do when texture is magnified GL_NEAREST: non-smoothed texture | GL_LINEAR: smoothed  
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST ) ;  // ...when texture is miniaturized because far; GL_NEAREST: non-smoothed tecture 
#ifdef GL_VERSION_1_1
   /* glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB4, txtRES, txtRES, 
                0, GL_RGB, GL_UNSIGNED_BYTE, txt1 ); */
		
 gluBuild2DMipmaps( GL_TEXTURE_2D,  GL_RGB4, txtRES, txtRES, GL_RGB, GL_UNSIGNED_BYTE, txt1  ) ;	
#else
 /*  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB4, txtRES, txtRES, 
                0, GL_RGB, GL_UNSIGNED_BYTE, txt1 ); */
 gluBuild2DMipmaps( GL_TEXTURE_2D,  GL_RGB4, txtRES, txtRES, GL_RGB, GL_UNSIGNED_BYTE, txt1  ) ;
#endif

   glEnable(GL_TEXTURE_2D);                        
   glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, /*GL_COMBINE*/ GL_DECAL ); // the GL_DECAL option draws texture as is: no color mixing thigs. GL_MODULATE lets mixing.

//   glTexEnvf(GL_TEXTURE_ENV, GL_COMBINE_ALPHA, GL_BLEND) ; //THIS WAS ACTIVE AND WORKED; BUT NOW CHANGE IN STRATEDY FOR TEXTURES.

#ifdef GL_VERSION_1_1
   glBindTexture(GL_TEXTURE_2D, texName);
#endif
//--------------------------| END OF TEXTURE LOAD PROCESSING |-------------------------------

texn++ ; // augment count... next texture 
textures_available  = texn ; // at left is extern... you know... .
 }
 else {
 printf("File opening error ocurred. Using random generated texture.\n");
printf("SDL_GetError() notify: %s\n", SDL_GetError());

 texn = -1 ; // cause exiting from while loop.
 }


  }
}    
    
    
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );   /* clear the window */      


/*
  glFogi(GL_FOG_MODE, GL_LINEAR); // Note the 'i' after glFog - the GL_LINEAR constant is an integer.

  glFogf(GL_FOG_START, 1400.0f);
  glFogf(GL_FOG_END, 68200.0f);
  glFogf(GL_FOG_DENSITY, 0.005f);
*/


//how many vertices for terrain to plot.
//  long int tquantity = 2*(xlimit-2)*(ylimit-2) ; // this i ugly... use extern structs...
//long int nind = 3*tquantity ;
long int col ;


//=====UPDATE AXES of the 3 axes of virtualcamera's reference... =============

float Px, Py, Pz ;
float Qx, Qy, Qz, axis_1[3], axis_2[3], axis_3[3] ;

float theta = cam_theta ; // use those extern variables... ;
float fi    = cam_fi    ; 
float psi   = cam_psi   ;
//R:
	axis_1[0] = cos(theta)*sin(fi) ;  
	axis_1[2] = sin(theta)*sin(fi) ; 
	axis_1[1] =            cos(fi) ;  

//P:
	axis_2[0] = -sin(theta)  ;
	axis_2[2] =  cos(theta)  ;
	axis_2[1] =  0.0 ; 

//Q:
	axis_3[0] =  -cos(theta)*cos(fi) ;
	axis_3[2] =  -sin(theta)*cos(fi) ;
	axis_3[1] =              sin(fi) ; 


Px = axis_2[0] ;
Py = axis_2[1] ;
Pz = axis_2[2] ;

Qx = axis_3[0] ;
Qy = axis_3[1] ;
Qz = axis_3[2] ;

// then P and Q must be rotated... by angle "psi" (q[5])

Px =  cos(psi)*axis_2[0] + sin(psi)*axis_3[0] ;
Py =  cos(psi)*axis_2[1] + sin(psi)*axis_3[1] ;
Pz =  cos(psi)*axis_2[2] + sin(psi)*axis_3[2] ;

Qx = -sin(psi)*axis_2[0] + cos(psi)*axis_3[0] ;
Qy = -sin(psi)*axis_2[1] + cos(psi)*axis_3[1] ;
Qz = -sin(psi)*axis_2[2] + cos(psi)*axis_3[2] ;

//OK.
//OK. 
//=====================END OF AXES REORIENTATION DONE=================================================



cam_target_dir.vector[0] = axis_1[0] ;
cam_target_dir.vector[1] = axis_1[1] ;
cam_target_dir.vector[2] = axis_1[2] ;






//==??????TO DO BETTER??????==SET UP VIRTUAL CAMERA's POSITION AND ORIENTATION.========
float F[3];
F[0] = IN_cam_target_dir[0] ; 
F[1] = IN_cam_target_dir[2] ;

F[2] = IN_cam_target_dir[1] ; //provisory... after completion it will be ordered x,y,z ;

float head = IN_cam_pos[1] ;
float C[2] = { IN_cam_pos[0],IN_cam_pos[2] } ;



//stereo vision support:
float cosbeta       ;  
float sinbeta       ;


cosbeta = (F[0]-C[0])/ sqrt( pow( (F[0]-C[0]),2 )+ pow( (F[1]-C[1]),2 )  ) ;
sinbeta = (F[1]-C[1])/ sqrt( pow( (F[0]-C[0]),2 )+ pow( (F[1]-C[1]),2 )  ) ;
float R[2] = {C[0] + distLR*sinbeta, C[1] - distLR*cosbeta } ;
 //===========????????????????TO REMOVE!!!DO BETTER WITH SPHERICAL COORDINATES===============




if (opt == 1  || opt == 7 ){  // wireframe display is selected: WITH TECHNICAL DATA : NORMAL VECTORS, TRIANGLE IN WHICH VERTEXCES STAY, ECC..
glEnable(GL_DEPTH_TEST);
glDisable(GL_LIGHTING);
glDisable(GL_FOG);

  glClearColor( 1.0, 1.0, 1.0, 0.0); /* black background, *required* by all geometric representations: only real-looking scenario uses different one. */
  




//SINGLE IMAGE:
glLoadIdentity();
  gluPerspective(0.4,1.0,1.0,1.3) ;
  glViewport(0, 0, A, B);
  //gluLookAt(R[0],head,R[1],F[0],F[2],F[1],0,1,0);

  
/* set up point of view... */  
   if ( follow_mode_switch == 3 ){
   // printf("SUPER CAMMING MAN!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");  
   gluLookAt(
          cam_pos.vector[0], 
	  cam_pos.vector[1], 
	  cam_pos.vector[2], 
          
	  cam_pos.vector[0] + cam_target_dir.vector[0], 
	  cam_pos.vector[1] + cam_target_dir.vector[1], 
	  cam_pos.vector[2] + cam_target_dir.vector[2],

          cam_up_vector.vector[0], 
	  cam_up_vector.vector[1], 
	  cam_up_vector.vector[2]
         ) ;
   }
   if( follow_mode_switch != 3 ){
     
     gluLookAt(R[0],head,R[1],F[0],F[2],F[1],0,1,0) ;
   }
  
  

  
//L image AXES.
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 

   glLineWidth(2);
// X -axis:
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 1.0, 0.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(1000.0, 0.0 , 0.0 );
glEnd()   ;

// Y -axis.      

glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 1.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 1000.0 , 0.0 );
glEnd()   ;

// Z -axis.      
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 0.0 , 1.0 );
	       
        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 0.0 , 1000.0 );
glEnd()   ;            



//end of axes plot.           






   glLineWidth(1);

for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=0 ; i<(ngon_min/2) ; i++ ){

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     j = col/2 ;
   
   glBegin(GL_LINE_LOOP)    ;
      glColor3f ( (i+5)*0.02, (i+5)*0.02, (i+5)*0.02) ;

        glVertex3f ( wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
);

	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );

        glVertex3f (
		     wheel[k ].vx_s.matrix[0][i+j] + wheel[k].pos.vector[0], 
		     wheel[k ].vx_s.matrix[1][i+j] + wheel[k].pos.vector[1], 
		     wheel[k ].vx_s.matrix[2][i+j] + wheel[k].pos.vector[2] 
 );
        glVertex3f (  
		     wheel[ k].vx_s.matrix[0][i+j-1] + wheel[k].pos.vector[0], 
		     wheel[ k].vx_s.matrix[1][i+j-1] + wheel[k].pos.vector[1], 
		     wheel[ k].vx_s.matrix[2][i+j-1] + wheel[k].pos.vector[2] 
  );

    glEnd() ;        
    }
}

for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=0 ; i<(ngon_min/2) ; i++ ){

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     j = col/2 ;
   
   glBegin( GL_LINE_LOOP )    ;
      glColor3f ( (i+5)*0.02, (i+5)*0.02, (i+5)*0.02) ;

        glVertex3f ( wheel[ k ].vx_s.matrix[0][0] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][0] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][0] + wheel[k].pos.vector[2] 
);

	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
 );

	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );


    glEnd() ;        
    }
}








//MAIN ( _Simplex version!! ) POLYHEDRON REPRESENTING VEHICLE.
for (k=0; k<1; k++){
   for (i=0 ; i<(ngon-1) ; i++ ){
            
//TEST PROJECTION TO GROUND- WHERE VERTEXES WOULD TOUCH TRISURF GROUND.


//vertex-by-vertex of course: one vertex at a time!	
//find which triangle is the vertex touching....
//excact pos.

//CHENGED TO MG
Xf = (body[k].pos.vector[0] + body[k].vx_s.matrix[0][i])/mg.GPunit ;
Yf = (body[k].pos.vector[2] + body[k].vx_s.matrix[2][i])/mg.GPunit ;

//index of which square's region it is within. 
Xi = floor( (body[k].pos.vector[0] + body[k].vx_s.matrix[0][i])/mg.GPunit ) ;  //x axis (in/out-screen)
Yi = floor( (body[k].pos.vector[2] + body[k].vx_s.matrix[2][i])/mg.GPunit ) ;  //z axis (right/left-of-screen)

/*secure checks because Xi < 0 cannot be, neither an Xi too big to stay within number of real casels.*/

//reusing Xi and Yi...:
     if ( Yf < Xf + (Yi-Xi)  ){  //careful if negativ or positive the Z axis... in fact.
     col = 0 ; //lower triangle region.
       
     }
     else if ( Yf >= Xf + (Yi-Xi)  ){
     col = 1 ; //upper triangle region.
       
     }






//INDIVIDUAL TRIANGLE CHECK: DO THEY COINCIDE?
if( col == 0 ){

  glBegin(GL_TRIANGLES) ;          
      glColor3f( 0.0 , 1.0 , 0.0 );           
        glVertex3f( mg.GPunit*Xi     , mg.GPunit*mg.shmap[Xi  ][Yi  ] ,     Yi*mg.GPunit  );
        glVertex3f( mg.GPunit*(Xi+1) , mg.GPunit*mg.shmap[Xi+1][Yi  ] ,     Yi*mg.GPunit );
        glVertex3f( mg.GPunit*Xi     , mg.GPunit*mg.shmap[Xi  ][Yi+1] , (Yi+1)*mg.GPunit );
  glEnd()   ;
//printf("VERTEX CHECK: %3f vertex", vertex[ tris[ row ][0] ][0]);
//getchar();
}
else if( col == 1 ){

  glBegin(GL_TRIANGLES) ;          
      glColor3f( 0.0 , 0.0 , 1.0 );           
        glVertex3f( mg.GPunit*Xi         , mg.GPunit*mg.shmap[Xi  ][Yi+1]  , (Yi+1)*mg.GPunit  );
        glVertex3f( mg.GPunit*(Xi+1)     , mg.GPunit*mg.shmap[Xi+1][Yi  ]  ,     Yi*mg.GPunit );
        glVertex3f( mg.GPunit*(Xi+1)     , mg.GPunit*mg.shmap[Xi+1][Yi+1]  , (Yi+1)*mg.GPunit );
  glEnd()   ;
//printf("VERTEX CHECK: %3f vertex", vertex[ tris[ row ][0] ][0]);
//getchar();
}



/*==========DRAW A FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
/*==========DRAW A FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
/*==========DRAW A FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
// cross product method.

//vect1.component-by component.

//vect1.component-by component.
if ( col == 0 ){
s_vector0.vector[0] = 1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = mg.shmap[Xi+1][Yi] - mg.shmap[Xi][Yi] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = mg.shmap[Xi][Yi+1] - mg.shmap[Xi][Yi] ;
s_vector1.vector[2] = 1.0 ;
}
else if ( col == 1  ){

s_vector0.vector[0] = -1.0 ; //pick from the on-purpose triangle storer....
s_vector0.vector[1] = mg.shmap[Xi][Yi+1] - mg.shmap[Xi+1][Yi+1] ;
s_vector0.vector[2] = 0.0 ;


s_vector1.vector[0] = 0.0 ; //pick from the on-purpose triangle storer....
s_vector1.vector[1] = mg.shmap[Xi+1][Yi] - mg.shmap[Xi+1][Yi+1] ;
s_vector1.vector[2] = -1.0 ;


}

s_nloc = cross( s_vector0 , s_vector1 ) ;

  //put equation parameters.
apl = s_nloc.vector[0]  ;
bpl = s_nloc.vector[1]  ;
cpl = s_nloc.vector[2]  ;
dpl = 0 ; //this is still to calculate... it's not = 1  usually.


s_nloc.vector[0] = s_nloc.vector[0]/leng_vect3(s_nloc) ;
s_nloc.vector[1] = s_nloc.vector[1]/leng_vect3(s_nloc) ;
s_nloc.vector[2] = s_nloc.vector[2]/leng_vect3(s_nloc) ;


//look if verse is good... not always; must check if the y of the normal is positive... easy. if negative, invert vector.
if ( s_nloc.vector[1] < 0.0 ){
s_nloc.vector[0] = -s_nloc.vector[0] ;
s_nloc.vector[1] = -s_nloc.vector[1] ;
s_nloc.vector[2] = -s_nloc.vector[2] ;
}

Xtri = (double) Xi*mg.GPunit ;
Ytri = (double) mg.GPunit*mg.shmap[Xi][Yi] ;
Ztri = (double) Yi*mg.GPunit ;

//now finally calculate dpl , the 'd' of the   ax + by + cz + d = 0   plane equation. 
dpl = -apl*Xtri - bpl*Ytri - cpl*Ztri ;
/*---------------------------------------------------------*/


glLineWidth(3);
  glBegin(GL_LINES) ;          
      glColor3f( 0.5 , 0.5 , 0.5 );      
	glVertex3f( mg.GPunit*Xi , mg.GPunit*mg.shmap[Xi][Yi] , Yi*mg.GPunit );        
	glVertex3f( mg.GPunit*Xi               + 60.0*s_nloc.vector[0]/leng_vect3(s_nloc) ,                   
		    mg.GPunit*mg.shmap[Xi][Yi] + 60.0*s_nloc.vector[1]/leng_vect3(s_nloc) , 
                    mg.GPunit*Yi               + 60.0*s_nloc.vector[2]/leng_vect3(s_nloc) );
           
       		   
         
  glEnd()   ;

/*OK */

//PLOT THEESE POINTS:
glPointSize(2);
 glBegin(GL_POINTS)    ;
   glColor3f ( 0.0, 0.0, 0.0 ) ;
/* projection of the car's vertices onto the ground surface. */

  glEnd();
/*OK */
   
/*==========DRAW A FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/
/*==========DRAW A FRESHLY CALCUALTED NORMAL VECTOR THERE!!!!!!===========================================*/


   }
}

glFlush();




//===========FOR VINCULAR DYNAMICS!===========
k = 0 ; // BODY A
glLineWidth(2); 

/*    PUT BACK WITH vx_s !!
glBegin(GL_LINES) ;      
       glColor3f( 0.0, 1.0 , 1.0);           
      
	glVertex3f ( vxs[0][ armvx[0][1] ][k] + X[0][k] , vxs[1][ armvx[0][1] ][k]  + X[1][k], vxs[2][ armvx[0][1] ][k] + X[2][k] ) ;
	glVertex3f ( vxs[0][ armvx[0][1] ][k] + X[0][k] + 0.000001*fc.vector[0], vxs[1][ armvx[0][1] ][k]  + X[1][k] + 0.000001*fc.vector[1] , vxs[2][ armvx[0][1] ][k] + X[2][k] + 0.000001*fc.vector[2] ) ;

glEnd() ;



k = 1 ; //BODY B
glBegin(GL_LINES) ;      
       glColor3f( 1.0, 0.0 , 0.0);           
      
	glVertex3f ( vxs[0][ armvx[0][3] ][k] + X[0][k] , vxs[1][ armvx[0][3] ][k]  + X[1][k], vxs[2][ armvx[0][3] ][k] + X[2][k] ) ;
	glVertex3f ( vxs[0][ armvx[0][3] ][k] + X[0][k] - 0.000001*fc.vector[0], vxs[1][ armvx[0][3] ][k]  + X[1][k] - 0.000001*fc.vector[1] , vxs[2][ armvx[0][3] ][k] + X[2][k] - 0.000001*fc.vector[2] ) ;

glEnd() ;
*/
//=================END VINCULAR DYNAMICS REPRESENTATON====





/* plot the hmap itself, to see if not things were lost during trianglulation and copy into vertex[NTRIANGLES][3] */


for( j = 0 ; j < mg.map_size ; j++ ){
	for(i = 0 ; i < mg.map_size ; i++ ){
	//PLOT THEESE POINTS:
	glPointSize(1);
	glBegin(GL_POINTS)    ;
	glColor3f ( 1.0, 0.0, 0.0) ;

	glVertex3f ( j*mg.GPunit , mg.shmap[j][i]*mg.GPunit - 1.0 , i*mg.GPunit ); 

	glEnd() ;

	

	}
}
 



//==============================================================================
// PLOT PARTICULAR VECTORS USED TO SIMUALATE: PARTICULAR TO CTRUCK_SIMPLEX 
//only the SIMPLEX VERSION IS LIKE THIS... .
for (k=1; k<2; k++){  //get right vqriable number then.....  

glLineWidth(1);
glBegin(GL_LINES)    ;

glColor3f ( 0.0, 1.0, 0.0 ) ;

glVertex3f ( body[k].pos.vector[0], 
             body[k].pos.vector[1],
             body[k].pos.vector[2] ) ;

glVertex3f (body[k].pos.vector[0] + 50.0*body[k].reartyre_axis.vector[0], 
            body[k].pos.vector[1] + 50.0*body[k].reartyre_axis.vector[1], 
            body[k].pos.vector[2] + 50.0*body[k].reartyre_axis.vector[2]) ;

glEnd()   ;
} //end of spring display part.
//==============================================================================




 /*==============================================================================================================*/

//POLYHEDRON REPRESENTING VEHICLE:
/*points... triangles must connect them ....*/
k = 0 ; /* do it for polyhedron 1 only.... */
glPointSize(5) ;
   for ( i = 0 ; i < ngon ; i++ ){       
    glBegin(GL_POINTS) ;
    glColor3f ( 1.0, 0.0, 0.0) ;
        // glVertex3f ( vxs[0][i][k] + X[0][k], vxs[1][i][k] + X[1][k], vxs[2][i][k]  +X[2][k] );    // PUT BACK WITH vx_s
        
    glEnd() ;        
    }



k = 1 ; /* do it for polyhedron 1 only.... */
glPointSize(10) ;

glColor3f ( 0.0, 0.0, 0.0) ;
glBegin(GL_POINTS) ;
        // glVertex3f (vxs[0][testindex][k] + X[0][k], vxs[1][testindex][k] + X[1][k], vxs[2][testindex][k]  +X[2][k] );  // PUT BACK WITH vx_s 
        
    glEnd() ;      
glPointSize(2) ;
printf("TEST INDEX: %d \n", testindex) ;





int ind_1, ind_2, ind_3 ; 
// TRIANGULATED MAIN CAR, BDOY 0 ,"BODY A".... 
j= 0 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i<SUPER_TRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/
glLineWidth(2);
  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;

  glColor3f (  0.1, 0.2, 0.1 ) ;
    glBegin(GL_LINE_LOOP) ;    
    
    
    
    glVertex3f (   body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
    
    
    
}


//TRIANGULATED ==TRAILER==> BODY[1].... 
j= 1 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.

   for ( i = 0 ; i<CARTRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

  ind_1 = tra_tri[i][0] ;
  ind_2 = tra_tri[i][1] ;
  ind_3 = tra_tri[i][2] ;
  
 
    glColor3f (  0.5, 0.0, 0.0 ) ;

    glBegin(GL_LINE_LOOP) ;  
    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
    
    }





/*================================================================================================*/


SDL_GL_SwapBuffers();


// glEnable(GL_DEPTH_TEST);
} //end of L-R picture display stereo mode. 
























/*##################################################################################*/
/*=============CTruck3D _Truck 's standard visualisation mode.===================== */
/*
NON TEXTURED FULL FLEDGED BUT MONOIMAGE, NOT STEREO 3D, for slow computers.
NON TEXTURED FULL FLEDGED BUT MONOIMAGE, NOT STEREO 3D, for slow computers.
NON TEXTURED FULL FLEDGED BUT MONOIMAGE, NOT STEREO 3D, for slow computers. 
*/

if ( opt == 6 || opt == 5 ){  

glClearColor( 0.0, 0.0, 0.0, 0.0); /* sky-color background */
glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );   /* clear the window ! otherwise background color remains that one set at beginnign  of display() function! */  

  
glDisable(GL_BLEND);
glEnable(GL_DEPTH_TEST) ; // CAREFUL!!! CAREFUL!!!

glEnable(GL_FOG);
glDisable(GL_TEXTURE_2D);



glLoadIdentity();

//DRAW CLOCK... BEFORE CALLING perspective TO GIVE A REFERENCE FOR PROPER GAME-SPEED/FRAMERATE
glLineWidth(1);
glColor3f( 0.0, 1.0 , 0.0); 
glBegin(GL_LINES) ;      
	glVertex3f ( 30.0*sin(  ( (double) counter)*dft*2.0*3.1415 ) + 70, 30.0*cos( counter*dft*2.0*3.1415 ) + 70.0 , 1.0 ) ;
	glVertex3f ( 70.0, 70.0 , 1.0 ) ;
glEnd() ;


glColor3f( 0.0, 1.0 , 0.0);
glBegin(GL_LINES) ;                              
	glVertex3f (  70.0, 30.0 + 70.0 , 1.0 ) ;
	glVertex3f (  70.0, 170.0 , 1.0 ) ;
glEnd() ;
//CLOCK DRAWN.


//title
glColor3f( 1.0, 1.0 , 1.0);

for( j =0 ; j < 8 ; j++ ){
	for( i =0 ; i < 120 ; i++ ){
	   if( Suck_my_Truck[7-j][i] > 0 ){ 
	   glBegin(GL_POINTS) ;
	   glVertex3f (  i - 180  ,j + 170, 1.0 ) ;
	   glEnd() ;
	   }

	}
}




gluPerspective( fovv, ((float)A )/((float)B ), 1.0, 2 ) ;

glViewport(0, 0, A, B);
/* single point of view: no stereo-3D... */








/* set up point of view... */  
   if ( follow_mode_switch == 3  ){


//   printf("SUPER CAMMING MAN!! %f  %f  %f\n, ",  cam_target_dir.vector[0] , cam_target_dir.vector[1],  cam_target_dir.vector[2] ) ;
  /*FPS view: */

   gluLookAt(
          
 	  cam_pos.vector[0], 
	  cam_pos.vector[1], 
	  cam_pos.vector[2], 
         
	  cam_pos.vector[0] + cam_target_dir2.vector[0], 
	  cam_pos.vector[1] + cam_target_dir2.vector[1], 
	  cam_pos.vector[2] + cam_target_dir2.vector[2],

          cam_up_vector2.vector[0], 
	  cam_up_vector2.vector[1], 
	  cam_up_vector2.vector[2]
         ) ;
   }
   else if( follow_mode_switch == 1   ){  

gluLookAt(

	  smilzo_x + ds*axis_1[0],  //from: target_posvector + dist*R_versor
	  smilzo_y + ds*axis_1[1], 
	  smilzo_z + ds*axis_1[2],

	  smilzo_x,   // to: target_posvector
	  smilzo_y, 
	  smilzo_z, 
          
	 
          Qx,    // this is the cam_up_vector, easy.
	  Qy, 
	  Qz
	) ;

   }






//====draw camera positioning and pointing frame reference====




 if ( follow_mode_switch == 1 ){
// 3rd person view mode:
glLineWidth(1);
 glColor3f( 1.0, 0.0 , 0.0 ) ;  
// cam target direction vector. POINTING vector
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_target_dir.vector[0], 
		    smilzo_y  +  70.0*cam_target_dir.vector[1], 
		    smilzo_z  +  70.0*cam_target_dir.vector[2] ) ;
glEnd()   ;

glColor3f( 0.0, 0.0 , 1.0 ) ;  

// camera hozizont refrence vector. HORIZONTAL REFRENCE
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_horiz_ref.vector[0], 
		    smilzo_y  +  70.0*cam_horiz_ref.vector[1], 
		    smilzo_z  +  70.0*cam_horiz_ref.vector[2] ) ;
glEnd()   ;




// CamUp vector.
glColor3f( 0.0, 1.0 , 0.0 ) ;  

glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_up_vector.vector[0], 
		    smilzo_y  +  70.0*cam_up_vector.vector[1], 
		    smilzo_z  +  70.0*cam_up_vector.vector[2] ) ;
glEnd()   ;
}
if ( follow_mode_switch == 3 ){ //first FIRST person view mode.

// 3rd person view mode:
glLineWidth(1);

 glColor3f( 1.0, 0.0 , 0.0 ) ;  
//cam target direction vector. POINTING vector
glBegin(GL_LINES) ;          
        glVertex3f( cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.
        glVertex3f( cam_pos.vector[0]  +  40.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  40.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  40.0*cam_target_dir2.vector[2] ) ;
glEnd()   ;

glColor3f( 0.0, 0.0 , 1.0 ) ;  

// camera hozizont refrence vector. HORIZONTAL REFRENCE
glBegin(GL_LINES) ;          
        glVertex3f( cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.
        glVertex3f( cam_pos.vector[0]  + 20.0*cam_target_dir2.vector[0] + 20.0*cam_horiz_ref2.vector[0], 
		    cam_pos.vector[1]  + 20.0*cam_target_dir2.vector[1]	+ 20.0*cam_horiz_ref2.vector[1], 
		    cam_pos.vector[2]  + 20.0*cam_target_dir2.vector[2] + 20.0*cam_horiz_ref2.vector[2] ) ;
glEnd()   ;




//CamUp vector.
glColor3f( 0.0, 1.0 , 0.0 ) ;  

glBegin(GL_LINES) ;          
        glVertex3f(
		    cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( cam_pos.vector[0] + 20.0*cam_target_dir2.vector[0]  +  20.0*cam_up_vector2.vector[0], 
		    cam_pos.vector[1] + 20.0*cam_target_dir2.vector[1]  +  20.0*cam_up_vector2.vector[1], 
		    cam_pos.vector[2] + 20.0*cam_target_dir2.vector[2]  +  20.0*cam_up_vector2.vector[2] ) ;
glEnd()   ;

}



//===========================================================



double RR = 1250.0, th ;







//L image AXES.
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 

   glLineWidth(2);
//X -axis:
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 1.0, 0.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f( 2000.0, 0.0 , 0.0 );
glEnd()   ;

//Y -axis.      

glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 1.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 2000.0 , 0.0 );
glEnd()   ;

//Z -axis.      
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 0.0 , 1.0 );
	       
        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 0.0 , 2000.0 );
glEnd()   ;            





glLineWidth(3) ;



glColor3f( 0.0, 1.0 , 0.0 ) ;
  
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y , smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x, smilzo_y + 170.0, smilzo_z ) ;
glEnd()   ;




 glColor3f( 0.0, 1.0 , 0.0 ) ;   
glBegin(GL_LINES) ;          
                

        glVertex3f( smilzo_x, smilzo_y + 130.0 , smilzo_z ) ; // ORIGO.
        glVertex3f(     smilzo_x         + 120.0*cam_target_dir2.vector[0], 
			smilzo_y + 130.0 + 120.0*cam_target_dir2.vector[1], 
			smilzo_z 	 + 120.0*cam_target_dir2.vector[2] ) ;
glEnd()   ;




glLineWidth(2) ;

//plot truck:

//POLYHEDRON REPRESENTING VEHICLE:
/* points as they are... triangles must connect them ....*/

k = 0 ; /* do it for polyhedron 1 only.... */

/*disactivated... a triangulation-editor should be made apart... even if in this seme game.  */

/*
k = 0 ;
glPointSize(8) ;
glBegin(GL_POINTS) ;
    glColor3f ( 1.0, 0.0, 0.0) ;
        glVertex3f (vxs[0][testindex][k] + X[0][k], vxs[1][testindex][k] + X[1][k], vxs[2][testindex][k]  +X[2][k] );   
        
    glEnd() ;      

printf("TEST INDEX: %d \n", testindex) ;


k = 2 ;
glPointSize(8) ;
glBegin(GL_POINTS) ;
    glColor3f ( 1.0, 0.0, 0.0) ;
        glVertex3f (vxs[0][testindex][k] + X[0][k], vxs[1][testindex][k] + X[1][k], vxs[2][testindex][k]  +X[2][k] );   
        
    glEnd() ;      

printf("TEST INDEX: %d \n", testindex) ;
*/

//*******************airplane stuff********************************************
glColor3f( 1.0, 0.0 , 0.0 ) ;  
// AUXILIAR  VECTORS FOR AIRPLANE: ITS IDEAL AXES. 
glBegin(GL_LINES) ;          
        glVertex3f( body[2].pos.vector[0], 
		    body[2].pos.vector[1], 
		    body[2].pos.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( body[2].pos.vector[0] + 600.0*body[2].axis_1.vector[0], 
		    body[2].pos.vector[1] + 600.0*body[2].axis_1.vector[1], 
		    body[2].pos.vector[2] + 600.0*body[2].axis_1.vector[2]  
		  ) ; // ORIGO.
glEnd()   ;

glColor3f( 0.0, 1.0 , 0.0 ) ;  
// AUXILIAR  VECTORS FOR AIRPLANE: ITS IDEAL AXES. 
glBegin(GL_LINES) ;          
        glVertex3f( body[2].pos.vector[0], 
		    body[2].pos.vector[1], 
		    body[2].pos.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( body[2].pos.vector[0] + 400.0*body[2].axis_2.vector[0], 
		    body[2].pos.vector[1] + 400.0*body[2].axis_2.vector[1], 
		    body[2].pos.vector[2] + 400.0*body[2].axis_2.vector[2]  
		  ) ; // ORIGO.
glEnd()   ;


glColor3f( 0.0, 0.0 , 1.0 ) ;  
// AUXILIAR  VECTORS FOR AIRPLANE: ITS IDEAL AXES. 
glBegin(GL_LINES) ;          
        glVertex3f( body[2].pos.vector[0], 
		    body[2].pos.vector[1], 
		    body[2].pos.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( body[2].pos.vector[0] + 800.0*body[2].axis_3.vector[0], 
		    body[2].pos.vector[1] + 800.0*body[2].axis_3.vector[1], 

		    body[2].pos.vector[2] + 800.0*body[2].axis_3.vector[2]  
		  ) ; // ORIGO.
glEnd()   ;


glColor3f( 1.0, 1.0 , 1.0 ) ;  
// AUXILIAR  VECTORS FOR AIRPLANE: ITS IDEAL AXES. 
glBegin(GL_LINES) ;          
        glVertex3f( body[2].pos.vector[0], 
		    body[2].pos.vector[1], 
		    body[2].pos.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( body[2].pos.vector[0] + 0.0001*body[2].acc_drv.vector[0], 
		    body[2].pos.vector[1] + 0.0001*body[2].acc_drv.vector[1], 
		    body[2].pos.vector[2] + 0.0001*body[2].acc_drv.vector[2]  
		  ) ; // ORIGO.
glEnd()   ;

glColor3f( 0.0, 1.0 , 1.0 ) ;  
// AUXILIAR  VECTORS FOR AIRPLANE: ITS IDEAL AXES. 
glBegin(GL_LINES) ;          
        glVertex3f( body[2].pos.vector[0], 
		    body[2].pos.vector[1], 
		    body[2].pos.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( body[2].pos.vector[0] + 0.0001*body[2].torque_drv.vector[0], 
		    body[2].pos.vector[1] + 0.0001*body[2].torque_drv.vector[1], 
		    body[2].pos.vector[2] + 0.0001*body[2].torque_drv.vector[2]  
		  ) ; // ORIGO.
glEnd()   ;
//************************end airplane extra****************************


   int yyi , xxi ;  //indexes....

//PLOT GROUND TRINGLES WITHO TEXTURE... ALREADY FINE-TRIANGULATED AND COLOURED WITH REPEATED TETURE PATTERN...THIS S THE BASE: BUT NOT ALL OF THEM , ONLY THE CLOSER TERRAIN PIECE!!!


// BIG GLOBA SHAPE: FAR RANGE....

   /* STILL TO REFINE A BIT... */
// if( woption == 6 ){

// index of which square's region it is within. 
   Xi = floor( smilzo_x/(gg.GPunit) ) ;  // x axis (in/out-screen)
   Yi = floor( smilzo_z/(gg.GPunit) ) ;  // z axis (right/left-of-screen)


        for( yyi = Yi-6 ;  yyi <  Yi + 6 ; yyi++ ){
           for( xxi = Xi -6 ; xxi < Xi + 6 ; xxi++ ){
/* THOSE WHICH ARE ALREADY DRAWN WITH FINE TRIANGULATION, ARE NOT DRAWN OF COURSE, OR ARE OVER-DRAWN... */
  /*  DONT CARE: PUT MIDTERRAIN HALF CENTIMETER LOWER ... ITS OK.... */
             
         if( xxi >= 0 && yyi >= 0 && xxi < gg.map_size && yyi < gg.map_size && !(xxi == Xi && yyi == Yi) ){        
       
       glColor3f( 0.2 , 0.4, 0.2 ) ;

      glBegin(GL_TRIANGLES) ;  
             glVertex3f(     xxi*gg.GPunit , gg.GPunit*gg.shmap[xxi][yyi]     -10.0,     yyi*gg.GPunit ) ;
             glVertex3f( (xxi+1)*gg.GPunit , gg.GPunit*gg.shmap[xxi+1][yyi]   -10.0,     yyi*gg.GPunit ) ;
             glVertex3f( (xxi)*gg.GPunit , gg.GPunit*gg.shmap[xxi][yyi+1] -10.0, (yyi+1)*gg.GPunit ) ;
    
      glEnd() ;

/* second triangle */
 glColor3f( 0.2 , 0.7, 0.2 ) ;

      glBegin(GL_TRIANGLES) ;  
             glVertex3f( (xxi+1)*gg.GPunit , gg.GPunit*gg.shmap[xxi+1][yyi+1] -10.0, (yyi+1)*gg.GPunit ) ;
             glVertex3f( (xxi+1)*gg.GPunit , gg.GPunit*gg.shmap[xxi+1][yyi]   -10.0,     yyi*gg.GPunit ) ;
             glVertex3f( (xxi)*gg.GPunit , gg.GPunit*gg.shmap[xxi][yyi+1] -10.0, (yyi+1)*gg.GPunit ) ;
    
      glEnd() ;

	    }

	
  }
}



// buildings... .
glLineWidth(2) ;


        for( yyi = Yi-5 ;  yyi <  Yi + 5 ; yyi++ ){
           for( xxi = Xi -5 ; xxi < Xi + 5 ; xxi++ ){
/* THOSE WHICH ARE ALREADY DRAWN WITH FINE TRIANGULATION, ARE NOT DRAWN OF COURSE, OR ARE OVER-DRAWN... */
  /*  DONT CARE: PUT MIDTERRAIN HALF CENTIMETER LOWER ... ITS OK.... */
             
         if( ( (k=stunts.map[xxi][yyi]) > 1 || (k=stunts.map[xxi][yyi])< 0 )  &&  xxi >= 0 && yyi >= 0 && xxi < 300 && yyi < 300  ){           

	int ind[4], ku ;
	float x1, y1, z1, x[8], y[8], z[8] ;
	float center_height= 0 ;

	

	if( k > 1 ){
	center_height = mg.GPunit*mg.shmap[10*xxi][10*yyi] ; 
	k = k - 2 ; // 0 is reserved for nothing, 1 for TUBE... so. 
	}
	else if ( k < 0 ){
		if( k > -10 ){
		center_height = -k*1000.0 ; 
		k = NBTYPE-3 ; // trampolino type 1.	
		}
		else if(k < -10 && k > -20){
		center_height = -k*1000.0 -10000.0  ; 
		k = NBTYPE-2 ; // trampoino type 2 
		}
		else{
		center_height = -k*1000.0 -20000.0 ;
		k = NBTYPE-1 ;
		}
	}

	for( ku = 0 ; ku < 8 ; ku++ ){
	x1 = stunts.building[k].vertexes[ ku ][0] ;
	y1 = stunts.building[k].vertexes[ ku ][1] ;
	z1 = stunts.building[k].vertexes[ ku ][2] ;


/* VERTICES OF BX ARE GIVEN WITH *IN* THE BOX AXES FRAME OF REFERENCE!!!!!!!**WARNING** */ 
	// find cordinate of points in the canonic reference frame... usual thing.
	x[ku] = x1*stunts.building[k].Xc[0] + y1*stunts.building[k].Yc[0]+ z1*stunts.building[k].Zc[0] ;
	y[ku] = x1*stunts.building[k].Xc[1] + y1*stunts.building[k].Yc[1]+ z1*stunts.building[k].Zc[1] ;
	z[ku] = x1*stunts.building[k].Xc[2] + y1*stunts.building[k].Yc[2]+ z1*stunts.building[k].Zc[2] ;       

	}




  	for( i = 0 ; i < 6 ; i++){
	ind[0]   = stunts.building[k].polygons[i][0] ;
	ind[1]   = stunts.building[k].polygons[i][1] ;
	ind[2]   = stunts.building[k].polygons[i][2] ;
	ind[3]   = stunts.building[k].polygons[i][3] ;

	 
       
       
       if( woption == 6 ){
	glEnable( GL_TEXTURE_2D ) ;
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /* GL_DECAL */ ); // the GL_DECAL option draws texture as is: no color mixing thigs. GL_MODULATE lets mixing.
	glBindTexture(GL_TEXTURE_2D, texid [ 3 ] ) ; // you know.... comment later.
       }  
	
	glColor3f( (i+2.0)/8.0 , (i+2.0)/8.0, (i+2)/16.0 ) ;
	
	glBegin(GL_QUADS) ;  
      
	glTexCoord2f( 1.0, 0.0 ) ;
             glVertex3f(
	x[ ind[0] ] + xxi*gg.GPunit + gg.GPunit/2.0,
        y[ ind[0] ] + center_height , 
        z[ ind[0] ] + yyi*gg.GPunit + gg.GPunit/2.0 ) ;

	glTexCoord2f( 1.0, 1.0 ) ;
             glVertex3f( 
	x[ ind[1] ] + xxi*gg.GPunit + gg.GPunit/2.0,
	y[ ind[1] ] + center_height , 
        z[ ind[1] ] + yyi*gg.GPunit + gg.GPunit/2.0) ;

	glTexCoord2f( 0.0, 1.0 ) ;
             glVertex3f( 
	x[ ind[2] ] + xxi*gg.GPunit + gg.GPunit/2.0, 
	y[ ind[2] ] + center_height , 
	z[ ind[2] ] + yyi*gg.GPunit + gg.GPunit/2.0 ) ;

	glTexCoord2f( 0.0, 0.0 ) ;
             glVertex3f(
	x[ ind[3] ] + xxi*gg.GPunit + gg.GPunit/2.0,
	y[ ind[3] ] + center_height , 
	z[ ind[3] ] + yyi*gg.GPunit + gg.GPunit/2.0 ) ;
      glEnd() ;

		}


glLineWidth(2);

glColor3f( 1.0, 0.0 , 0.0); 
glBegin(GL_LINES) ;

 glVertex3f( xxi*gg.GPunit + gg.GPunit/2.0, center_height, yyi*gg.GPunit + gg.GPunit/2.0 ) ;

 glVertex3f( 
	2000.0*stunts.building[k].Xc[0] + xxi*gg.GPunit + gg.GPunit/2.0, 
	2000.0*stunts.building[k].Xc[1] + center_height , 
        2000.0*stunts.building[k].Xc[2] + yyi*gg.GPunit + gg.GPunit/2.0) ;

glEnd() ;



glColor3f( 0.0, 1.0 , 0.0);
glBegin(GL_LINES) ; 
   glVertex3f( xxi*gg.GPunit + gg.GPunit/2.0, center_height, yyi*gg.GPunit + gg.GPunit/2.0 ) ;
   glVertex3f( 
	2000.0*stunts.building[k].Yc[0] +  xxi*gg.GPunit + gg.GPunit/2.0,
	2000.0*stunts.building[k].Yc[1] +  center_height ,
	2000.0*stunts.building[k].Yc[2] +  yyi*gg.GPunit + gg.GPunit/2.0  ) ;
glEnd() ;


glColor3f( 0.0, 0.0 , 1.0);
glBegin(GL_LINES) ; 
   glVertex3f( xxi*gg.GPunit + gg.GPunit/2.0, center_height, yyi*gg.GPunit + gg.GPunit/2.0 ) ;
   glVertex3f( 
	2000.0*stunts.building[k].Zc[0] + xxi*gg.GPunit + gg.GPunit/2.0, 
	2000.0*stunts.building[k].Zc[1] + center_height , 
	2000.0*stunts.building[k].Zc[2] + yyi*gg.GPunit + gg.GPunit/2.0 ) ;
glEnd() ;

	    }
	    else if( stunts.map[xxi][yyi] == 1  &&  xxi >= 0 && yyi >= 0 && xxi < 300 && yyi < 300  ){
/* DRAW STUNT TUBE */
glDisable( GL_TEXTURE_2D ) ;
glColor3f( 0.3, 0.3 , 0.3 ) ;

for( i = -1250 ; i < 1250 ; i = i + 250 ){ /* x... from -gg.GPunit/2.0  to +... */ 
	for ( th = 0 ; th < 2.0*pi ; th = th + 0.3 ){
glBegin(GL_LINES) ;          
        glVertex3f(
		    i              +  xxi*gg.GPunit + gg.GPunit/2.0, 
		    RR*sin(th)     + RR  + gg.GPunit*gg.shmap[xxi][yyi] , 
		    RR*cos(th)     +  yyi*gg.GPunit + gg.GPunit/2.0
		  ) ; // ORIGO.

        glVertex3f( i              +  xxi*gg.GPunit + gg.GPunit/2.0 , 
		    RR*sin(th+0.3) + RR  + gg.GPunit*gg.shmap[xxi][yyi] , 
		    RR*cos(th+0.3) +  yyi*gg.GPunit + gg.GPunit/2.0 ) ;
glEnd()   ;



/*other pieces of 'wire'.... THE LONGITUDDAL, STRAIGHT WIRINGS */
	glBegin(GL_LINES) ;          
        glVertex3f(
		   -1250.0              + xxi*gg.GPunit + gg.GPunit/2.0 , 
		    RR*sin(th) + RR     + gg.GPunit*gg.shmap[xxi][yyi]  , 
		    RR*cos(th)          + yyi*gg.GPunit + gg.GPunit/2.0
		  ) ; // ORIGO.

        glVertex3f( 1250.0              + xxi*gg.GPunit + gg.GPunit/2.0  , 
		    RR*sin(th) + RR     + gg.GPunit*gg.shmap[xxi][yyi]   , 
		    RR*cos(th)          + yyi*gg.GPunit + gg.GPunit/2.0 ) ;

	glEnd() ;

	}
}

	    }
	
  }
}


glFlush();













/* EXTRA AESTHETIC FEATURE: MEDIUM-SIZE TERRAIN AND BIGMAP IN BACKGROUND, ENOUGH FAR */

/* MEDIUM-SIZED terrain drawing */


// index of which square's region it is within. 
   Xi = floor( smilzo_x/(mg.GPunit) ) ;  // x axis (in/out-screen)
   Yi = floor( smilzo_z/(mg.GPunit) ) ;  // z axis (right/left-of-screen)


int howm = 9 ;  

mg.map_size = 300 ;

if(woption == 6){
glEnable( GL_TEXTURE_2D ) ;
glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /* GL_DECAL*/ ); // the GL_DECAL option draws texture as is: no color mixing thigs. GL_MODULATE lets mixing.
}

   /* STILL TO REFINE A BIT... */
        for( yyi = Yi - howm ;  yyi < Yi + howm  &&  yyi < mg.map_size; yyi++ ){
           for( xxi = Xi - howm ; xxi < Xi + howm  &&  xxi < mg.map_size ; xxi++ ){
/* THOSE WHICH ARE ALREADY DRAWN WITH FINE TRIANGULATION, ARE NOT DRAWN OF COURSE, OR ARE OVER-DRAWN... */
  
/*  DONT CARE: PUT MIDTERRAIN HALF CENTIMETER LOWER ... ITS OK.... */
            //   for( col = 0 ; col < 2 ; col++ ){  /* col = 0 ... col = 1 ... do it for both cases. */
        	
		 if( xxi >= 0 && yyi >= 0 ){        
      	
/* TRIANGLE 1 */
			
glColor3f(  mg.scol[xxi][yyi][0] , mg.scol[xxi][yyi][1],  mg.scol[xxi][yyi][2] ) ;

glBindTexture(GL_TEXTURE_2D, texid [ 0 ] ); // you know.... comment later.

	glBegin(GL_TRIANGLES) ;  
            glTexCoord2f(0.0, 0.0) ; glVertex3f( mg.GPunit*xxi     , mg.GPunit*mg.shmap[xxi][yyi]   ,  mg.GPunit*yyi       );
            glTexCoord2f(0.5, 0.0) ; glVertex3f( mg.GPunit*(xxi+1) , mg.GPunit*mg.shmap[xxi+1][yyi] ,  mg.GPunit*yyi       );
            glTexCoord2f(0.0, 0.5) ; glVertex3f( mg.GPunit*xxi     , mg.GPunit*mg.shmap[xxi][yyi+1] ,  mg.GPunit*(yyi+1)   );
	glEnd() ;



/* TRIANGLE 2 */
glColor3f(  mg.scol[xxi][yyi][0]+ 0.1 , mg.scol[xxi][yyi][1]+ 0.1,  mg.scol[xxi][yyi][2]+0.1 ) ;
	glBegin(GL_TRIANGLES) ;  
        glTexCoord2f(0.5, 0.0) ;     glVertex3f( mg.GPunit*(xxi+1) , mg.GPunit*mg.shmap[xxi+1][yyi  ] ,  mg.GPunit*yyi       );
        glTexCoord2f(0.0, 0.5) ;     glVertex3f( mg.GPunit*xxi     , mg.GPunit*mg.shmap[xxi  ][yyi+1] ,  mg.GPunit*(yyi+1)   );
        glTexCoord2f(0.5, 0.5) ;     glVertex3f( mg.GPunit*(xxi+1) , mg.GPunit*mg.shmap[xxi+1][yyi+1] ,  mg.GPunit*(yyi+1)   );
	glEnd() ;


		if( tree_map[xxi][yyi] == 1 || tree_map[xxi][yyi] == 2 ){ // here, at far sight, draw only base , small trees. thoe type 2 only for close range... .
		add_tree( xxi*mg.GPunit , mg.GPunit*mg.shmap[xxi][yyi] , yyi*mg.GPunit, tree_map[xxi][yyi] ) ;
		}

	    }
	
//	}
  }
  glFlush() ;
}

glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, /*GL_COMBINE*/ GL_DECAL ); // the GL_DECAL option draws texture as is: no color mixing thigs. GL_MODULATE lets mixing.




//glEnable(GL_DEPTH_TEST);


int ind_1, ind_2, ind_3 ; 


//==****DO NEVER DELETE THIS****========TESTNG====&MANUAL TRIANGULATION==============

/*j = 0 ;
i = test_tri ;
  ind_1 = car_tri[i][0] ;
  ind_2 = car_tri[i][1] ;
  ind_3 = car_tri[i][2] ;  


    glBegin(GL_TRIANGLES) ;
    glColor3f (  1.0, 1.0, 1.0 ) ;
        glVertex3f (vxs[0][ ind_1 ][j] + X[0][j], vxs[1][ind_1 ][j] + X[1][j], vxs[2][ind_1 ][j]  +X[2][j] );  
        glVertex3f (vxs[0][ ind_2 ][j] + X[0][j], vxs[1][ind_2 ][j] + X[1][j], vxs[2][ind_2 ][j]  +X[2][j] );
	glVertex3f (vxs[0][ ind_3 ][j] + X[0][j], vxs[1][ind_3 ][j] + X[1][j], vxs[2][ind_3 ][j]  +X[2][j] );

    glEnd() ;     

*/


// printf("TEST TRI_FACE: %d \n", test_tri ) ;




//COMMENT OUT THIS WHILE DOING TRUI TESTS FOR THE CAR!! SEGFAULT OTHERWISE
/*
j = 2 ;
i = test_tri ;
  ind_1 = tra_tri[i][0] ;
  ind_2 = tra_tri[i][1] ;
  ind_3 = tra_tri[i][2] ;  
    glBegin(GL_TRIANGLES) ;
    glColor3f (  1.0, 1.0, 1.0 ) ;
        
    glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		 body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		 body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
    
    
    glEnd() ;        
*/
//=========================================================================================================



if (woption == 5 ){
//TRIANGULATED.... 
glDisable(GL_TEXTURE_2D);                        //GL_DECAL
j= 0 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.

   for ( i = 0 ; i<SUPER_TRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;
  
  glColor3f (  car_tricolor[i][0], car_tricolor[i][1], car_tricolor[i][2] ) ;
  
    glBegin(GL_TRIANGLES) ;
      
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
  
    }




//TRIANGULATED ==TRAILER==> BODY[1].... 
j= 1 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.

   for ( i = 0 ; i < CARTRI ; i++ ){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

  ind_1 = tra_tri[i][0] ;
  ind_2 = tra_tri[i][1] ;
  ind_3 = tra_tri[i][2] ;
  
    
    glColor3f (  tra_tricolor[i][0], tra_tricolor[i][1], tra_tricolor[i][2] ) ;

    glBegin(GL_TRIANGLES) ;
      
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;  
    
    }
    
   
// **********AIRPLANE***********
j= 2 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i < 32 ; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;


 glColor3f( car_tricolor[i][0] , car_tricolor[i][1], car_tricolor[i][2] ) ;

    if( i == test_tri ){
    glColor3f (  1.0, 0.0, 1.0 ) ;
    printf("TEST TRI: %li \n",i);
    }
 
       glBegin(GL_TRIANGLES) ;
      
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
}
//***************************************
   
   
   j = 2 ; /* do it for polyhedron 3 only.... */
   glPointSize(5) ;
   for ( i = 0 ; i < 60 ; i++ ){      
     glColor3f ( 1.0, 1.0, 1.0) ;
    glBegin(GL_POINTS) ;
        glVertex3f ( body[j].vx_s.matrix[0][i] + body[j].pos.vector[0], 
		     body[j].vx_s.matrix[1][i] + body[j].pos.vector[1], 
		     body[j].vx_s.matrix[2][i] + body[j].pos.vector[2] );   
    glEnd() ; 
    glFlush() ;
    } 
   
}
else if (woption == 6 ){
int tqv1,tqv2,tqv3 ; // auxiliary var to lighten code readibility for humans. 

//TRIANGULATED ==TRAILER==> BODY[1].... 
j= 1 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.

glEnable(GL_TEXTURE_2D);                        //GL_DECAL
for ( i = 0 ; i<CARTRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

 glBindTexture(GL_TEXTURE_2D, texid [ body[j].face_texid[i] ] ); // you know.... comment later.

 glColor3f (  tra_tricolor[i][0], tra_tricolor[i][1], tra_tricolor[i][2] ) ;


  ind_1 = tra_tri[i][0] ;
  ind_2 = tra_tri[i][1] ;
  ind_3 = tra_tri[i][2] ;

    if( i != 1 && i != 11 ){  // leave free the sqare where the's going to be the graffity "Suck my Truck"

    
   
    tqv1 = body[j].face_texord[i][0] ; // read what it is near beginnig of code of this prog in comments
    tqv2 = body[j].face_texord[i][1] ;
    tqv3 = body[j].face_texord[i][2] ;
    
    glBegin(GL_TRIANGLES) ;
      glTexCoord2f( texcoord_x[tqv1], texcoord_y[tqv1]  ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
      glTexCoord2f( texcoord_x[tqv2], texcoord_y[tqv2] ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
      glTexCoord2f( texcoord_x[tqv3], texcoord_y[tqv3] ) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   

    glEnd() ;  
    
    }
          
}


j= 0 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i < SUPER_TRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

 glBindTexture(GL_TEXTURE_2D, texid [ body[j].face_texid[i] ] ); // you know.... comment later.

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;

 glColor3f( car_tricolor[i][0] , car_tricolor[i][1], car_tricolor[i][2] ) ;


    tqv1 = body[j].face_texord[i][0] ; // read what it is near beginnig of code of this prog in comments
    tqv2 = body[j].face_texord[i][1] ;
    tqv3 = body[j].face_texord[i][2] ;
 
      glBegin(GL_TRIANGLES) ;
      
      glTexCoord2f( texcoord_x[tqv1], texcoord_y[tqv1]  ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
      glTexCoord2f( texcoord_x[tqv2], texcoord_y[tqv2]  ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glTexCoord2f( texcoord_x[tqv3], texcoord_y[tqv3]  ) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   

      glEnd() ;  
      
}


// **********AIRPLANE***********
j= 2 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i < 32; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/
 // glBindTexture(GL_TEXTURE_2D, texid [ body[j].face_texid[i] ] ); // you know.... comment later.

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;


 glColor3f( car_tricolor[i][0] , car_tricolor[i][1], car_tricolor[i][2] ) ;

    tqv1 = body[j].face_texord[i][0] ; // read what it is near beginnig of code of this prog in comments
    tqv2 = body[j].face_texord[i][1] ;
    tqv3 = body[j].face_texord[i][2] ;
 
 
       glBegin(GL_TRIANGLES) ;
      glTexCoord2f( texcoord_x[tqv1], texcoord_y[tqv1]  ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
      glTexCoord2f( texcoord_x[tqv2], texcoord_y[tqv2]  ) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glTexCoord2f( texcoord_x[tqv3], texcoord_y[tqv3]  ) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
}
//***************************************


glDisable(GL_TEXTURE_2D); 
}  // of( woption == 6 )



// Simplified suspence virutal-springs plot .
for( i = 0 ; i < NPILLOW ; i++ ){

glBegin(GL_LINES) ;      
glColor3f( 0.0, 1.0 , 1.0);           
   
	glVertex3f (
    body[ pillowvx[i][0] ].pos.vector[0]  + body[  pillowvx[i][0] ].vx_s.matrix[0][  pillowvx[i][1] ]   ,
    body[ pillowvx[i][0] ].pos.vector[1]  + body[  pillowvx[i][0] ].vx_s.matrix[1][  pillowvx[i][1] ]   ,
    body[ pillowvx[i][0] ].pos.vector[2]  + body[  pillowvx[i][0] ].vx_s.matrix[2][  pillowvx[i][1] ] 
);

	glVertex3f (
    body[ pillowvx[i][0] ].pos.vector[0]  + body[  pillowvx[i][0] ].vx_s.matrix[0][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[0]  ,
    body[ pillowvx[i][0] ].pos.vector[1]  + body[  pillowvx[i][0] ].vx_s.matrix[1][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[1]  ,
    body[ pillowvx[i][0] ].pos.vector[2]  + body[  pillowvx[i][0] ].vx_s.matrix[2][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[2]  
 
);

glEnd() ;
}





	//===========FOR VINCULAR DYNAMICS!===========
	k = 0 ; // BODY A

	if( LagrangeArticulatedBodies == 1 ){
	k = 1 ; //BODY B
	glBegin(GL_LINES) ;      
	glColor3f( 1.0, 0.0 , 0.0);           
      
	glEnd() ;
	//=================END VINCULAR DYNAMICS REPRESENTATON====
	} 

glEnable(GL_TEXTURE_2D); 

glBindTexture(GL_TEXTURE_2D, texid [ 2 ] ); // you know.... comment later.


col = (int) ngon_min ; //importand forced conversion from character constant to int.
j = floor(col/2) ;
     
for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=2 ; i<(ngon_min/2) ; i++ ){
   
     glBindTexture(GL_TEXTURE_2D, texid [ 2 ] ); // you know.... comment later.
     
   glBegin(GL_QUADS)    ;
      glColor3f ( (i+5)*0.02, (i+5)*0.02, (i+5)*0.02) ;
glTexCoord2f(1.0, 0.0 ) ;
        glVertex3f ( wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
);
glTexCoord2f(1.0, 1.0 ) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );
glTexCoord2f( 0.0, 1.0 ) ;
        glVertex3f (
		     wheel[ k ].vx_s.matrix[0][i+j] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+j] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+j] + wheel[k].pos.vector[2] 
 );
glTexCoord2f( 0.0, 0.0 ) ;
        glVertex3f (  
		     wheel[ k ].vx_s.matrix[0][i+j-1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+j-1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+j-1] + wheel[k].pos.vector[2] 
  );

    glEnd() ;        
    }
}










glDisable(GL_TEXTURE_2D); 

j = col/2 ;

for ( k = 0 ; k < NPILLOW ; k++ ){
   for ( i = 0 ; i < (ngon_min/2) ; i++ ){

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     
   
	//glBindTexture(GL_TEXTURE_2D, texid [ 1 ] ); // you know.... comment later.
     
   glBegin(GL_TRIANGLES )    ;
      glColor3f ( (i+5)*0.05, (i+5)*0.05, (i+5)*0.05) ;

	// glTexCoord2f(0.0, 0.0) ;
        glVertex3f ( wheel[ k ].vx_s.matrix[0][0] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][0] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][0] + wheel[k].pos.vector[2] 
);

	// glTexCoord2f(1.0, 0.0) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
 );

	// glTexCoord2f(0.0, 1.0) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );

    glEnd() ;        
    
    glBegin(GL_TRIANGLES )    ;
      glColor3f ( (i+5)*0.05, (i+5)*0.05, (i+5)*0.05) ;

	// glTexCoord2f(0.0, 0.0) ;
        glVertex3f ( wheel[ k ].vx_s.matrix[0][1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][1] + wheel[k].pos.vector[2] 
);

	// glTexCoord2f(1.0, 0.0) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+j] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+j] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+j] + wheel[k].pos.vector[2] 
 );

	// glTexCoord2f(0.0, 1.0) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1+j] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1+j] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1+j] + wheel[k].pos.vector[2] 
 );


    glEnd() ;        
    }
}



   
 // if (opt == 6)  




//==============================================================================
/* PLOT PARTICULAR VECTORS USED TO SIMUALATE: PARTICULAR TO CTRUCK_SIMPLEX 
only the SIMPLEX VERSION IS LIKE THIS... . */

for (k=0; k<NPILLOW; k++){  //get right vqriable number then.....  

glLineWidth(1);
glBegin(GL_LINES)    ;

glColor3f ( 1.0, 1.0, 1.0 ) ;

glVertex3f ( wheel[k].pos.vector[0], 
             wheel[k].pos.vector[1],
             wheel[k].pos.vector[2] ) ;

glVertex3f ( wheel[k].pos.vector[0] + 50.0*wheel[k].axis.vector[0], 
             wheel[k].pos.vector[1] + 50.0*wheel[k].axis.vector[1], 
             wheel[k].pos.vector[2] + 50.0*wheel[k].axis.vector[2] ) ;

glEnd()   ;
} 

//end of spring display part.
//==============================================================================


//===============================================================================================
for (k=0; k<NPILLOW; k++){  //get right vqriable number then.....  
    //============calculate it for each one! ==========================
  //but it depends on which one!!!!
  l_c = dot3_st( v_spring_curr[  pillowvx[k][0]  ], down_dir ) ;  //WARNING : it's the seme for all tyres beloging to the seme body!!!
  //printf("current lenght DRAWING:  %3f\n",l_c ) ;
  l_c = h_vxvs[k]/fabs(l_c) ; //reuse it... sorry for little aesteticism.Rect Triangles Theorem applied....


    if( l_c >= l_vsp){
    l_c = l_vsp ; 
    }

  //==================================================================
  

//extract vector going form main body's center to tyre j-1 's vertex i.
    s_vector1.vector[0] = body[ pillowvx[k][0] ].pos.vector[0] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[0][ pillowvx[k][1] ]  
+ (l_c )*v_spring_curr[  pillowvx[k][0]  ].vector[0] ;  
    s_vector1.vector[1] = body[ pillowvx[k][0] ].pos.vector[1] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[1][ pillowvx[k][1] ]  
+ (l_c )*v_spring_curr[  pillowvx[k][0]  ].vector[1] ;
    s_vector1.vector[2] = body[ pillowvx[k][0] ].pos.vector[2] 
+ body[  pillowvx[k][0]  ].vx_s.matrix[2][ pillowvx[k][1] ]  
+ (l_c )*v_spring_curr[  pillowvx[k][0]  ].vector[2] ;


  
glLineWidth(1) ;
glBegin(GL_LINES) ;
glColor3f ( 1.0, 1.0, 1.0 ) ;

glVertex3f ( body[ pillowvx[k][0] ].pos.vector[0], 
             body[ pillowvx[k][0] ].pos.vector[1],
             body[ pillowvx[k][0] ].pos.vector[2] 
	) ;
glVertex3f ( s_vector1.vector[0], 
             s_vector1.vector[1], 
             s_vector1.vector[2] 
	) ;

glEnd() ;	
    

glFlush();
}
//===============================================================================================





// }

glFlush() ;


if (woption == 6 ){
add_particles( 1, 2, 3, 4, 5, 6 , dft , 0 ) ;
}

SDL_GL_SwapBuffers();


} //end of boh.














//TEXTURED FULL FLEDGED ONE SINGLE PICTURE.
//TEXTURED FULL FLEDGED.
//TEXTURED FULL FLEDGED.
//TEXTURED FULL FLEDGED.
//TEXTURED FULL FLEDGED.
if (opt == 8){  

  glDisable(GL_BLEND) ;
  glEnable(GL_FOG);
  glEnable(GL_DEPTH_TEST);

   


glClearColor( 0.3, 0.3, 0.3, 0.0); /* sky-color background */
glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );   /* clear the window ! otherwise background color remains that one set at beginnign  of display() function! */  


//plot truck:
glLoadIdentity();


//DRAW CLOCK...BEFORE CALLING Perspective TO GOVIE A REFERENCE FOR PROPER GAME-SPEED/FRAMERATE
glLineWidth(1);
glBegin(GL_LINES) ;      
	glColor3f( 0.0, 1.0 , 0.0) ;           
	glVertex3f ( 30.0*sin(  ( (double) counter)*dft*2.0*3.1415 ) + 170, 30.0*cos( counter*dft*2.0*3.1415 ) + 170.0 , 1.0 ) ;
	glVertex3f ( 170.0, 170.0 , 1.0 ) ;
glEnd() ;

glBegin(GL_LINES) ;      
	glColor3f( 0.0, 1.0, 0.0 ) ;                 
	glVertex3f (  170.0, 30.0 + 170.0 , 1.0 ) ;
	glVertex3f ( 170.0, 170.0 , 1.0 ) ;        
glEnd() ;
//CLOCK DRAWN.

glFlush() ;
//glDisable(GL_BLEND) ;


  gluPerspective(0.35,1.0, 1.0 , 2.0 ) ;
  glViewport(0, 0, A, B);



  

/* set up point of view... */  
   if ( follow_mode_switch == 3  ){


//   printf("SUPER CAMMING MAN!! %f  %f  %f\n, ",  cam_target_dir.vector[0] , cam_target_dir.vector[1],  cam_target_dir.vector[2] ) ;
  

   gluLookAt(
          
 	  cam_pos.vector[0], 
	  cam_pos.vector[1], 
	  cam_pos.vector[2], 
         
	  cam_pos.vector[0] + cam_target_dir2.vector[0], 
	  cam_pos.vector[1] + cam_target_dir2.vector[1], 
	  cam_pos.vector[2] + cam_target_dir2.vector[2],

          cam_up_vector2.vector[0], 
	  cam_up_vector2.vector[1], 
	  cam_up_vector2.vector[2]
         ) ;
   }
   else if( follow_mode_switch == 1   ){  

gluLookAt(
	  cam_pos.vector[0], 
	  cam_pos.vector[1], 
	  cam_pos.vector[2], 
          
	  cam_pos.vector[0] + cam_target_dir.vector[0], 
	  cam_pos.vector[1] + cam_target_dir.vector[1], 
	  cam_pos.vector[2] + cam_target_dir.vector[2],

          cam_up_vector.vector[0], 
	  cam_up_vector.vector[1], 
	  cam_up_vector.vector[2]
	) ;

   }





//L image AXES.
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 
//PLOT X-Y-Z AXES AS LONG LINES: 

   glLineWidth(2);
//X -axis:
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 1.0, 0.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(10000.0, 0.0 , 0.0 );
glEnd()   ;

//Y -axis.      

glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 1.0 , 0.0 );     

        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 10000.0 , 0.0 );
glEnd()   ;

//Z -axis.      
glBegin(GL_LINE_STRIP) ;          
               glColor3f( 0.0, 0.0 , 1.0 );
	       
        glVertex3f(0.0, 0.0 , 0.0 ); //ORIGO.
        glVertex3f(0.0, 0.0 , 10000.0 );
glEnd()   ;            






//=========DRAW SMILZO, THE HERO======================
glColor3f( 0.0, 1.0 , 0.0 ) ;
  
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y , smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x, smilzo_y + 170.0, smilzo_z ) ;
glEnd()   ;


 glColor3f( 0.0, 1.0 , 0.0 ) ;   
glBegin(GL_LINES) ;          
                

        glVertex3f( smilzo_x, smilzo_y + 130.0 , smilzo_z ) ; // ORIGO.
        glVertex3f(     smilzo_x         + 120.0*cam_target_dir2.vector[0], 
			smilzo_y + 130.0 + 120.0*cam_target_dir2.vector[1], 
			smilzo_z 	 + 120.0*cam_target_dir2.vector[2] ) ;
glEnd()   ;
//==========END DRAW SMILZO THE HERO==================




//====draw camera positioning and pointing frame reference====




 if ( follow_mode_switch == 1 ){
// 3rd person view mode:
glLineWidth(1);
 glColor3f( 1.0, 0.0 , 0.0 ) ;  
// cam target direction vector. POINTING vector
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_target_dir.vector[0], 
		    smilzo_y  +  70.0*cam_target_dir.vector[1], 
		    smilzo_z  +  70.0*cam_target_dir.vector[2] ) ;
glEnd()   ;

glColor3f( 0.0, 0.0 , 1.0 ) ;  

// camera hozizont refrence vector. HORIZONTAL REFRENCE
glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_horiz_ref.vector[0], 
		    smilzo_y  +  70.0*cam_horiz_ref.vector[1], 
		    smilzo_z  +  70.0*cam_horiz_ref.vector[2] ) ;
glEnd()   ;




// CamUp vector.
glColor3f( 0.0, 1.0 , 0.0 ) ;  

glBegin(GL_LINES) ;          
        glVertex3f( smilzo_x, smilzo_y, smilzo_z ) ; // ORIGO.
        glVertex3f( smilzo_x  +  70.0*cam_up_vector.vector[0], 
		    smilzo_y  +  70.0*cam_up_vector.vector[1], 
		    smilzo_z  +  70.0*cam_up_vector.vector[2] ) ;
glEnd()   ;
}
if ( follow_mode_switch == 3 ){ //first FIRST person view mode.

// 3rd person view mode:
glLineWidth(1);

 glColor3f( 1.0, 0.0 , 0.0 ) ;  
//cam target direction vector. POINTING vector
glBegin(GL_LINES) ;          
        glVertex3f( cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.
        glVertex3f( cam_pos.vector[0]  +  40.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  40.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  40.0*cam_target_dir2.vector[2] ) ;
glEnd()   ;

glColor3f( 0.0, 0.0 , 1.0 ) ;  

// camera hozizont refrence vector. HORIZONTAL REFRENCE
glBegin(GL_LINES) ;          
        glVertex3f( cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.
        glVertex3f( cam_pos.vector[0]  + 20.0*cam_target_dir2.vector[0] + 20.0*cam_horiz_ref2.vector[0], 
		    cam_pos.vector[1]  + 20.0*cam_target_dir2.vector[1]	+ 20.0*cam_horiz_ref2.vector[1], 
		    cam_pos.vector[2]  + 20.0*cam_target_dir2.vector[2] + 20.0*cam_horiz_ref2.vector[2] ) ;
glEnd()   ;




//CamUp vector.
glColor3f( 0.0, 1.0 , 0.0 ) ;  

glBegin(GL_LINES) ;          
        glVertex3f(
		    cam_pos.vector[0]  +  20.0*cam_target_dir2.vector[0], 
		    cam_pos.vector[1]  +  20.0*cam_target_dir2.vector[1], 
		    cam_pos.vector[2]  +  20.0*cam_target_dir2.vector[2] 
		  ) ; // ORIGO.

        glVertex3f( cam_pos.vector[0] + 20.0*cam_target_dir2.vector[0]  +  20.0*cam_up_vector2.vector[0], 
		    cam_pos.vector[1] + 20.0*cam_target_dir2.vector[1]  +  20.0*cam_up_vector2.vector[1], 
		    cam_pos.vector[2] + 20.0*cam_target_dir2.vector[2]  +  20.0*cam_up_vector2.vector[2] ) ;
glEnd()   ;

}



//===========================================================








//plot truck:
/*==============================================================================================================*/
//POLYHEDRON REPRESENTING VEHICLE:
/*points... triangles must connect them ....*/




/*
glPointSize(8) ;
glBegin(GL_POINTS) ;


    glColor3f ( i*1.0, i*1.0, i*1.0) ;
        glVertex3f (vxs[0][testindex][k] + X[0][k], vxs[1][testindex][k] + X[1][k], vxs[2][testindex][k]  +X[2][k] );   
        
    glEnd() ;      

printf("TEST INDEX: %d \n", testindex) ;
*/



k = 0 ; // do it for polyhedron 1 only....

int ind_1, ind_2, ind_3 ; 
//TRIANGULATED....



for( i = 0 ; i < NPILLOW ; i++ ){

glBegin(GL_LINES) ;      
glColor3f( 0.0, 1.0 , 1.0);           
   
   
	glVertex3f (

    body[ pillowvx[i][0] ].pos.vector[0]  + body[  pillowvx[i][0] ].vx_s.matrix[0][  pillowvx[i][1] ]   ,
    body[ pillowvx[i][0] ].pos.vector[1]  + body[  pillowvx[i][0] ].vx_s.matrix[1][  pillowvx[i][1] ]   ,
    body[ pillowvx[i][0] ].pos.vector[2]  + body[  pillowvx[i][0] ].vx_s.matrix[2][  pillowvx[i][1] ] 
 
);

   
	glVertex3f (

    body[ pillowvx[i][0] ].pos.vector[0]  + body[  pillowvx[i][0] ].vx_s.matrix[0][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[0]  ,
    body[ pillowvx[i][0] ].pos.vector[1]  + body[  pillowvx[i][0] ].vx_s.matrix[1][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[1]  ,
    body[ pillowvx[i][0] ].pos.vector[2]  + body[  pillowvx[i][0] ].vx_s.matrix[2][  pillowvx[i][1] ]  + (l_crec[i]  )*v_spring_curr[  pillowvx[i][0]  ].vector[2]  
 
);

glEnd() ;
}



//===========FOR VINCULAR DYNAMICS!===========

if( LagrangeArticulatedBodies == 1 ){

k = 0 ; // BODY A
glLineWidth(2); 
/* PUT BACK, BUT INSTEAD OF vxs, use vx_s array!!!
glBegin(GL_LINES) ;      
       glColor3f( 0.0, 1.0 , 1.0);           
      
	glVertex3f ( vxs[0][ armvx[0][1] ][k] + X[0][k] , vxs[1][ armvx[0][1] ][k]  + X[1][k], vxs[2][ armvx[0][1] ][k] + X[2][k] ) ;
	glVertex3f ( vxs[0][ armvx[0][1] ][k] + X[0][k] + 0.000001*fc.vector[0], vxs[1][ armvx[0][1] ][k]  + X[1][k] + 0.000001*fc.vector[1] , vxs[2][ armvx[0][1] ][k] + X[2][k] + 0.000001*fc.vector[2] ) ;

glEnd() ;



k = 1 ; //BODY B
glBegin(GL_LINES) ;      
       glColor3f( 1.0, 0.0 , 0.0);           
      
	glVertex3f ( vxs[0][ armvx[0][3] ][k] + X[0][k] , vxs[1][ armvx[0][3] ][k]  + X[1][k], vxs[2][ armvx[0][3] ][k] + X[2][k] ) ;
	glVertex3f ( vxs[0][ armvx[0][3] ][k] + X[0][k] - 0.000001*fc.vector[0], vxs[1][ armvx[0][3] ][k]  + X[1][k] - 0.000001*fc.vector[1] , vxs[2][ armvx[0][3] ][k] + X[2][k] - 0.000001*fc.vector[2] ) ;

glEnd() ;
*/
//=================END VINCULAR DYNAMICS REPRESENTATON====
}






// PLOT GROUND TRINGLES WITHOUT TEXTURE... THE BASE: BUT NOT ALL OF THEM , ONLY THE CLOSER TERRAIN PIECE!!!


 // index of which square's region it is within. 
   Xi = floor( smilzo_x/mg.GPunit ) ;  //x axis (in/out-screen)
   Yi = floor( smilzo_z/mg.GPunit ) ;  //z axis (right/left-of-screen)


   
     

 //index of which square's region it is within. 
   Xi = floor( smilzo_x/mg.GPunit ) ;  //x axis (in/out-screen)
   Yi = floor( smilzo_z/mg.GPunit ) ;  //z axis (right/left-of-screen)



//TRIANGULATED ==TRAILER==> BODY[1].... 
j= 1 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.



for ( i = 0 ; i<CARTRI; i++){

  glBindTexture(GL_TEXTURE_2D, texid [ body[j].face_texid[i] ] ); // you know.... comment later.
  
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

 glColor3f (  tra_tricolor[i][0], tra_tricolor[i][1], tra_tricolor[i][2] ) ;

  ind_1 = tra_tri[i][0] ;
  ind_2 = tra_tri[i][1] ;
  ind_3 = tra_tri[i][2] ;

    if( i != 1 && i != 11 ){  // leave free the sqare where the's going to be the graffity "Suck my Truck"

      glBegin(GL_TRIANGLES) ;
    
      glTexCoord2f(0.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
     
      glTexCoord2f(1.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      glTexCoord2f(1.0, 1.0) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   

    glEnd() ;  
    }
          
}





  
  


j= 0 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i < SUPER_TRI; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

 glBindTexture(GL_TEXTURE_2D, texid [ body[j].face_texid[i] ] ); // you know.... comment later.

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;


 glColor3f( car_tricolor[i][0] , car_tricolor[i][1], car_tricolor[i][2] ) ;

       glBegin(GL_TRIANGLES) ;
      // glTexCoord2f(0.0, 0.0) ; glVertex3f ( vxs[0][ ind_1 ][j] + X[0][j], vxs[1][ind_1 ][j] + X[1][j], vxs[2][ind_1 ][j]  +X[2][j] );   
      glTexCoord2f(0.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
      // glTexCoord2f(1.0, 0.0) ; glVertex3f ( vxs[0][ ind_2 ][j] + X[0][j], vxs[1][ind_2 ][j] + X[1][j], vxs[2][ind_2 ][j]  +X[2][j] );
      glTexCoord2f(1.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
					    
      // glTexCoord2f(1.0, 1.0) ; glVertex3f ( vxs[0][ ind_3 ][j] + X[0][j], vxs[1][ind_3 ][j] + X[1][j], vxs[2][ind_3 ][j]  +X[2][j] );
      glTexCoord2f(1.0, 1.0) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
}




// **********AIRPLANE***********
j= 2 ; //1 polyhedron only... distiguish it by using a letter but... in CTruck3D_Simplex, there is 1 'manually' triangulated polyhedron.
for ( i = 0 ; i < 32 ; i++){
/*indexes given in the 3xN_traingles  matrix: car_tri[3][NTRI]....*/

  ind_1 = body[j].tri[i][0] ;
  ind_2 = body[j].tri[i][1] ;
  ind_3 = body[j].tri[i][2] ;


 glColor3f( car_tricolor[i][0] , car_tricolor[i][1], car_tricolor[i][2] ) ;

       glBegin(GL_TRIANGLES) ;

      glTexCoord2f(0.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_1 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_1 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_1 ] + body[j].pos.vector[2] );   
      
      glTexCoord2f(1.0, 0.0) ; 
      glVertex3f ( body[j].vx_s.matrix[0][  ind_2 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_2 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_2 ] + body[j].pos.vector[2] );   
					    
      glTexCoord2f(1.0, 1.0) ;
      glVertex3f ( body[j].vx_s.matrix[0][  ind_3 ] + body[j].pos.vector[0], 
		   body[j].vx_s.matrix[1][  ind_3 ] + body[j].pos.vector[1], 
		   body[j].vx_s.matrix[2][  ind_3 ] + body[j].pos.vector[2] );   
	
    glEnd() ;
}
//***************************************



  

 
//==WHEELS========
//glEnable(GL_TEXTURE_2D) ;    

printf("SHOULD WORK...  \n" ) ;

for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=0 ; i<(ngon_min/2) ; i++ ){
glBindTexture(GL_TEXTURE_2D, texid [ 2 ] ); // you know.... comment later.

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     j = col/2 ;
   
   glBegin(GL_QUADS) ;
      glColor3f ( (i+5)*0.03, (i+5)*0.03, (i+5)*0.03) ;

glTexCoord2f(0.0, 0.0) ;

        glVertex3f ( wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
);

glTexCoord2f(1.0, 0.0) ;
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );

glTexCoord2f(1.0, 1.0) ;
        glVertex3f (
		     wheel[k ].vx_s.matrix[0][i+j] + wheel[k].pos.vector[0], 
		     wheel[k ].vx_s.matrix[1][i+j] + wheel[k].pos.vector[1], 
		     wheel[k ].vx_s.matrix[2][i+j] + wheel[k].pos.vector[2] 
 );

glTexCoord2f(0.0, 1.0) ;
        glVertex3f (  
		     wheel[ k].vx_s.matrix[0][i+j-1] + wheel[k].pos.vector[0], 
		     wheel[ k].vx_s.matrix[1][i+j-1] + wheel[k].pos.vector[1], 
		     wheel[ k].vx_s.matrix[2][i+j-1] + wheel[k].pos.vector[2] 
  );

    glEnd() ;        
    }
}







// glDisable(GL_TEXTURE_2D) ; // REMEMBER THIS!!!






for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=0 ; i<(ngon_min/2) ; i++ ){

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     j = col/2 ;
   
     glBindTexture(GL_TEXTURE_2D, texid [ 2 ] ); // you know.... comment later.
     
   glBegin(GL_TRIANGLES )    ;
      glColor3f ( (i+5)*0.03, (i+5)*0.03, (i+5)*0.03) ;

	glTexCoord2f(0.0, 0.0) ; 
        glVertex3f ( wheel[ k ].vx_s.matrix[0][0] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][0] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][0] + wheel[k].pos.vector[2] 
);

	glTexCoord2f(1.0, 0.0) ; 
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i] + wheel[k].pos.vector[2] 
 );

	glTexCoord2f(0.0, 1.0) ; 
	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1] + wheel[k].pos.vector[2] 
 );


    glEnd() ;        
    }
}






//other side of tyres.
for ( k = 0 ; k < NPILLOW ; k++ ){
   for (i=0 ; i<(ngon_min/2) ; i++ ){

     col = (int) ngon_min ; //importand forced conversion from character constant to int.
     j = col/2 ;
   
   glBegin(GL_TRIANGLES )    ;
      glColor3f ( (i+5)*0.03, (i+5)*0.03, (i+5)*0.03) ;


        glVertex3f ( wheel[ k ].vx_s.matrix[0][0+1] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][0+1] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][0+1] + wheel[k].pos.vector[2] 
);

	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+j] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+j] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+j] + wheel[k].pos.vector[2] 
 );

	glVertex3f ( 
		     wheel[ k ].vx_s.matrix[0][i+1+j] + wheel[k].pos.vector[0], 
		     wheel[ k ].vx_s.matrix[1][i+1+j] + wheel[k].pos.vector[1], 
		     wheel[ k ].vx_s.matrix[2][i+1+j] + wheel[k].pos.vector[2] 
 );


    glEnd() ;        
    }
}








add_particles( 1, 2, 3, 4, 5, 6 , dft , 0 ) ; //this after having disabled texture stuff!!if not, the colors may be affected.



SDL_GL_SwapBuffers();

}


} //END OF DISPLAY FUNCTION.
//=================================================================















// IF WANT TO UNDERSTAND ALL COLOR ANMD PIXEL INFO IN SDL, LOOK HERE: http://sdl.beuc.net/sdl.wiki/Pixel_Access
// SUPERSAFE TOOK IT FROM PROFESSIONAL SITE: 
Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to retrieve */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        return *p;
        break;

    case 2:
        return *(Uint16 *)p;
        break;

    case 3: /* don't care about this bullshit! */
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;
        break;

    case 4:
        return *(Uint32 *)p;
        break;

    default:
        return 0;       /* shouldn't happen, but avoids warnings */
    }
}



